/*man-start*********************************************************************



		Introduction to XSI Curses Interface



The X/Open Group has identified a strong need for a generic terminal

interface for applications that wish to be independent of terminal

hardware and connection method.



This interface should allow the attachment of character and

block-oriented terminals.  Furthermore, it should not put any

constraints on how the terminals are attached (e.g., Local Area

Networks, PADs on X.25, etc.). 



The curses library interfaces provides the user with a method of

updating screens with reasonable optimisation. 



The X/Open group has found it impossible to define a totally portable

set of curses interface routines that cover asynchronous, networked,

and synchronous terminals.  The functions are oriented towards locally

connected asynchronous terminals.  For such terminals, applications

conforming to this interface are portable.  The interface routines

curses may, however, also be used with synchronous and networked

terminals, provided the restrictions below are considered. 



These functions have been included been included in the X/Open

definition in the "optional" category.  This means that although they

are likely to appear on many X/Open compliant systems, they are not

guaranteed to be on all systems.  Where they are supported, they will

conform to the given definition. 





----------------------------------------------------------------------



	    Synchronous and Networked Asynchronous Terminals



These notes indicate to the application writer some considerations to

be borne in mind when driving synchronous, networked asynchronous

(NWA) or non-standard directly connected asynchronous terminals.



Such terminals are often used in a mainframe environment and

communicatie to the host in block mode.  That is, the user types

characters at the terminal then presses a special key to initiate

transmission of the characters to the host. 



Frequently, although it may be possible to send arbitrary sized blocks

to the host, it may not be possible or desireable to cause a character

to be transmitted with only a single keystroke. 



This can cause severe problems to an application wishing to make use

of single character input. 







OUTPUT



The curses package can be used in the normal way for all operations

pertaining to output to the terminal, with the possible exception that

on some terminals the refresh() routine may have to redraw the entire

screen contents in order to perform any update.



If it is additionally necessary to clear the screen before each such

operation, the result could be unacceptable. 





INPUT



Because of the nature of operation of synchronous (block-mode) and NWA

terminals, it may not be possible to support all or any of the curses

input functions.  In particular, the following points should be noted:



* Single-character input may not be possible.  It may be necessary to

  press a special key to cause all characters typed at the terminal to

  be transmitted to the host. 



* It may not be possibel to disable echo.  Character echo may be performed

  directly by the terminal.  On terminals that behave this way, any curses

  application that performs input should be aware that any characters

  type will appear on the screen wherever the cursor is positioned.

  This may not necessarily correspond to the position of the cursor in

  the window.





----------------------------------------------------------------------



		Data Types and the <curses.h> Header



The data types supported by curses are described in this section.



As the library supports a procedural interface to the data types,

actual structure contents are not described.  All curses data are

manipulated using the routines provided. 





THE <curses.h> HEADER



The <curses.h> header defines various constants and declares the data types

that are available to the application.





DATA TYPES



The following data types are declared:



	WINDOW*		pointer to screen representation

	SCREEN*		pointer to terminal descriptor

	bool		boolean data type

	chtype		representation of a character in a window



The actual WINDOW and SCREEN objects used to store information are

created by the corresponding routiens and a pointer to them is

provided.  All manipulation is through that pointer. 





CONSTANTS



The following constants are defined. 





GENERAL



	COLS		number of columns on terminal screen

	ERR		value returned on error condition

	FALSE		boolean false value

	LINES		number of lines on terminal screen

	OK		value returned on successful completion

	NULL		zero pointer value

	TRUE		boolean true value



VIDEO ATTRIBUTES



	A_BLINK		blinking

	A_BOLD		extra bright or bold

	A_DIM		half bright

	A_REVERSE	reverse video

	A_STANDOUT	terminal's best highlighting mode

	A_UNDERLINE	underlining

	A_ATTRIBUTES	bit-mask to extract attributes

	A_CHARTEXT	bit-mask to extract a character



Normally, attributres are a property of the character. 





INPUT VALUES



The following constants might be returned by getch() if keypad() has

been enabled.  Note that not all of these may be supported on a

particular terminal if the terminal does not transmit a unique code

when the key is pressed or the definition for the key is not present

in the underlying table of terminal capabilities. 



	KEY_BREAK	break key

	KEY_DOWN	the four arrow keys

	KEY_UP

	KEY_LEFT

	KEY_RIGHT

	KEY_HOME	home key (upward+left arrow)

	KEY_BACKSPACE	backspace

	KEY_F0		function keys; space for 64 keys is reserved

	KEY_F(n)	(KEY_F0+(n))

	KEY_DL		delete line

	KEY_IL		insert line

	KEY_DC		delete character

	KEY_IC		insert character

	KEY_EIC		exit insert character mode

	KEY_CLEAR	clear screen

	KEY_EOS		clear to end of screen

	KEY_EOL		clear to end of line

	KEY_SF		scroll 1 line forwards

	KEY_SR		scroll 1 line backwards (reverse)

	KEY_NPAGE	next page

	KEY_PPAGE	previous page

	KEY_STAB	set tab

	KEY_CTAB	clear tab

	KEY_CATAB	clear all tabs

	KEY_ENTER	enter or send

	KEY_SRESET	soft (partial) reset

	KEY_RESET	reset or hard reset

	KEY_PRINT	print or copy

	KEY_LL		home down or bottom (lower left)

	KEY_A1		upper left of virtual keypad

	KEY_A3		upper right of virtual keypad

	KEY_B2		centre of virtual keypad

	KEY_C1		lower left of virtual keypad

	KEY_C3		lower right of virtual keypad



The virtual keypad is arranged like this:



	A1	up	A3

	left	B2	right

	C1	down	C3



**man-end**********************************************************************/

