
------------------------------------------------------------
--        Name: Alden Dima
--      E-mail: dimaaa@seas.gwu.edu
--      School: The George Washington University
--              School of Engineering and Applied Science
--              Washington, D.C.
--       Class: CSci 298 - Independent Study
--     Project: Ada Curses Binding and Textual User Interface
--        File: adinicol.adb "adatui-init_color.adb"
--        Date: 12/24/95 
-- Description: One of many adatui subunit bodies, this file
--              implements a subprogram declared in the adatui
--              package.
--   Revisions: 5/31/96 - AAD - Rewrote Ada-Curses binding to
--              enhance portability and maintainability.  Made
--              necessary changes in AdaTUI/TUIDemo to
--              accomodate new binding.  Made minor changes
--              to correct a problem using access types with
--              unconstrained arrays discovered by GNAT 3.03.
--              Eliminated several unused variables.
------------------------------------------------------------

separate (AdaTUI)
procedure init_color is
   void : c.signed_int;
begin
   if pdcurses.has_colors /= pdcurses.FALSE then
      void := pdcurses.start_color;
      void := pdcurses.init_pair (1, pdcurses.COLOR_BLACK, pdcurses.COLOR_CYAN);   
      void := pdcurses.init_pair (2, pdcurses.COLOR_WHITE, pdcurses.COLOR_CYAN);   
      void := pdcurses.init_pair (3, pdcurses.COLOR_WHITE, pdcurses.COLOR_BLACK);
      void := pdcurses.init_pair (4, pdcurses.COLOR_WHITE, pdcurses.COLOR_CYAN); 
      void := pdcurses.init_pair (5, pdcurses.COLOR_WHITE, pdcurses.COLOR_BLACK);  
      void := pdcurses.init_pair (6, pdcurses.COLOR_WHITE, pdcurses.COLOR_BLUE);   
      void := pdcurses.init_pair (7, pdcurses.COLOR_WHITE, pdcurses.COLOR_CYAN);   
      void := pdcurses.init_pair (8, pdcurses.COLOR_BLACK, pdcurses.COLOR_CYAN);
      void := pdcurses.init_pair (9, pdcurses.COLOR_WHITE, pdcurses.COLOR_BLACK);
   end if;
end init_color;
