
------------------------------------------------------------
--        Name: Alden Dima
--      E-mail: dimaaa@seas.gwu.edu
--      School: The George Washington University
--              School of Engineering and Applied Science
--              Washington, D.C.
--       Class: CSci 298 - Independent Study
--     Project: Ada Curses Binding and Textual User Interface
--        File: adstamen.adb "adatui-start_menu.adb"
--        Date: 12/24/95 
-- Description: One of many adatui subunit bodies, this file
--              implements a subprogram declared in the adatui
--              package.
--   Revisions: 5/31/96 - AAD - Rewrote Ada-Curses binding to
--              enhance portability and maintainability.  Made
--              necessary changes in AdaTUI/TUIDemo to
--              accomodate new binding.  Made minor changes
--              to correct a problem using access types with
--              unconstrained arrays discovered by GNAT 3.03.
--              Eliminated several unused variables.
------------------------------------------------------------

separate (AdaTUI)
procedure start_menu ( 
   mp    : a_menu_t;
   title : string )
is
begin
   screen_window := pdcurses.initscr;
   in_pdcurses := TRUE;
   init_color;
   title_window  := pdcurses.subwin ( screen_window, th, bw,            0, 0 );
   main_window   := pdcurses.subwin ( screen_window, mh, bw,           th, 0 );
   body_window   := pdcurses.subwin ( screen_window, bh, bw,      th + mh, 0 );
   status_window := pdcurses.subwin ( screen_window, sh, bw, th + mh + bh, 0 );

   color_box (  
      window => title_window,
      color  => TITLECOLOR,
      hasbox => FALSE ); 

   color_box (  
      window => main_window,
      color  => MAINMENUCOLOR,
      hasbox => FALSE ); 

   color_box (  
      window => body_window,
      color  => BODYCOLOR,
      hasbox => FALSE ); 

   color_box (  
      window => status_window,
      color  => STATUSCOLOR,
      hasbox => FALSE ); 

   if title'length > 0 then
      title_message ( msg => title );
   end if;

   pdcurses.cbreak;
   pdcurses.noecho;
   hide_cursor;
   pdcurses.nodelay  ( body_window, pdcurses.TRUE );
   pdcurses.keypad   ( body_window, pdcurses.TRUE );
   pdcurses.scrollok ( body_window, pdcurses.TRUE );
   pdcurses.leaveok  ( screen_window, pdcurses.TRUE );
   pdcurses.leaveok  ( title_window, pdcurses.TRUE );
   pdcurses.leaveok  ( main_window, pdcurses.TRUE );
   pdcurses.leaveok  ( status_window, pdcurses.TRUE );
   main_menu ( mp => mp );
   clean_up;
end start_menu;
