-----------------------------------------------------------------------
--
--  File:        conikeys.ads
--  Description: DJGPP console I/O key codes
--  Rev:         0.2
--  Date:        03/01/97
--  Author:      Jerry van Dijk
--  Mail:        jerry@jvdsys.nextjk.stuyts.nl
--
--  Copyright (c) Jerry van Dijk, 1996, 1997
--  Forelstraat 211
--  2037 KV  HAARLEM
--  THE NETHERLANDS
--  tel int + 31 23 540 1052
--
--  Permission granted to use for any purpose, provided this copyright
--  remains attached and unmodified.
--
--  THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
--  IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
--  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
--
-----------------------------------------------------------------------

package Conio.Keys is

   -----------------
   -- ASCII Codes --
   -----------------

   K_NUL                : constant Character := Character'Val (16#00#);
   K_Control_A          : constant Character := Character'Val (16#01#);
   K_Control_B          : constant Character := Character'Val (16#02#);
   K_Control_C          : constant Character := Character'Val (16#03#);
   K_Control_D          : constant Character := Character'Val (16#04#);
   K_Control_E          : constant Character := Character'Val (16#05#);
   K_Control_F          : constant Character := Character'Val (16#06#);
   K_Control_G          : constant Character := Character'Val (16#07#);
   K_BackSpace          : constant Character := Character'Val (16#08#);
   K_Control_H          : constant Character := Character'Val (16#08#);
   K_Tab                : constant Character := Character'Val (16#09#);
   K_Control_I          : constant Character := Character'Val (16#09#);
   K_LineFeed           : constant Character := Character'Val (16#0A#);
   K_Control_J          : constant Character := Character'Val (16#0A#);
   K_Control_K          : constant Character := Character'Val (16#0B#);
   K_Control_L          : constant Character := Character'Val (16#0C#);
   K_Return             : constant Character := Character'Val (16#0D#);
   K_Control_M          : constant Character := Character'Val (16#0D#);
   K_Control_N          : constant Character := Character'Val (16#0E#);
   K_Control_O          : constant Character := Character'Val (16#0F#);
   K_Control_P          : constant Character := Character'Val (16#10#);
   K_Control_Q          : constant Character := Character'Val (16#11#);
   K_Control_R          : constant Character := Character'Val (16#12#);
   K_Control_S          : constant Character := Character'Val (16#13#);
   K_Control_T          : constant Character := Character'Val (16#14#);
   K_Control_U          : constant Character := Character'Val (16#15#);
   K_Control_V          : constant Character := Character'Val (16#16#);
   K_Control_W          : constant Character := Character'Val (16#17#);
   K_Control_X          : constant Character := Character'Val (16#18#);
   K_Control_Y          : constant Character := Character'Val (16#19#);
   K_Control_Z          : constant Character := Character'Val (16#1A#);
   K_Control_LBracket   : constant Character := Character'Val (16#1A#);
   K_Escape             : constant Character := Character'Val (16#1B#);
   K_Control_BackSlash  : constant Character := Character'Val (16#1C#);
   K_Control_RBracket   : constant Character := Character'Val (16#1D#);
   K_Control_Caret      : constant Character := Character'Val (16#1E#);
   K_Control_Underscore : constant Character := Character'Val (16#1F#);
   K_Space              : constant Character := Character'Val (16#20#);
   K_ExclamationPoint   : constant Character := Character'Val (16#21#);
   K_DoubleQuote        : constant Character := Character'Val (16#22#);
   K_Hash               : constant Character := Character'Val (16#23#);
   K_Dollar             : constant Character := Character'Val (16#24#);
   K_Percent            : constant Character := Character'Val (16#25#);
   K_Ampersand          : constant Character := Character'Val (16#26#);
   K_Quote              : constant Character := Character'Val (16#27#);
   K_LParen             : constant Character := Character'Val (16#28#);
   K_RParen             : constant Character := Character'Val (16#29#);
   K_Star               : constant Character := Character'Val (16#2A#);
   K_Plus               : constant Character := Character'Val (16#2B#);
   K_Comma              : constant Character := Character'Val (16#2C#);
   K_Dash               : constant Character := Character'Val (16#2D#);
   K_Period             : constant Character := Character'Val (16#2E#);
   K_Slash              : constant Character := Character'Val (16#2F#);
   K_Colon              : constant Character := Character'Val (16#3A#);
   K_SemiColon          : constant Character := Character'Val (16#3B#);
   K_LAngle             : constant Character := Character'Val (16#3C#);
   K_Equals             : constant Character := Character'Val (16#3D#);
   K_RAngle             : constant Character := Character'Val (16#3E#);
   K_QuestionMark       : constant Character := Character'Val (16#3F#);
   K_At                 : constant Character := Character'Val (16#40#);
   K_LBracket           : constant Character := Character'Val (16#5B#);
   K_BackSlash          : constant Character := Character'Val (16#5C#);
   K_RBracket           : constant Character := Character'Val (16#5D#);
   K_Caret              : constant Character := Character'Val (16#5E#);
   K_UnderScore         : constant Character := Character'Val (16#5F#);
   K_BackQuote          : constant Character := Character'Val (16#60#);
   K_LBrace             : constant Character := Character'Val (16#7B#);
   K_Pipe               : constant Character := Character'Val (16#7C#);
   K_RBrace             : constant Character := Character'Val (16#7D#);
   K_Tilde              : constant Character := Character'Val (16#7E#);
   K_Control_Backspace  : constant Character := Character'Val (16#7F#);

   ----------------------
   -- Extended PC keys --
   ----------------------

   K_Alt_Escape         : constant Character := Character'Val (16#01#);
   K_Control_At         : constant Character := Character'Val (16#03#);
   K_Alt_Backspace      : constant Character := Character'Val (16#0E#);
   K_BackTab            : constant Character := Character'Val (16#0F#);
   K_Alt_Q              : constant Character := Character'Val (16#10#);
   K_Alt_W              : constant Character := Character'Val (16#11#);
   K_Alt_E              : constant Character := Character'Val (16#12#);
   K_Alt_R              : constant Character := Character'Val (16#13#);
   K_Alt_T              : constant Character := Character'Val (16#14#);
   K_Alt_Y              : constant Character := Character'Val (16#15#);
   K_Alt_U              : constant Character := Character'Val (16#16#);
   K_Alt_I              : constant Character := Character'Val (16#17#);
   K_Alt_O              : constant Character := Character'Val (16#18#);
   K_Alt_P              : constant Character := Character'Val (16#19#);
   K_Alt_LBracket       : constant Character := Character'Val (16#1A#);
   K_Alt_RBracket       : constant Character := Character'Val (16#1B#);
   K_Alt_Return         : constant Character := Character'Val (16#1C#);
   K_Alt_A              : constant Character := Character'Val (16#1E#);
   K_Alt_S              : constant Character := Character'Val (16#1F#);
   K_Alt_D              : constant Character := Character'Val (16#20#);
   K_Alt_F              : constant Character := Character'Val (16#21#);
   K_Alt_G              : constant Character := Character'Val (16#22#);
   K_Alt_H              : constant Character := Character'Val (16#23#);
   K_Alt_J              : constant Character := Character'Val (16#24#);
   K_Alt_K              : constant Character := Character'Val (16#25#);
   K_Alt_L              : constant Character := Character'Val (16#26#);
   K_Alt_Semicolon      : constant Character := Character'Val (16#27#);
   K_Alt_Quote          : constant Character := Character'Val (16#28#);
   K_Alt_Backquote      : constant Character := Character'Val (16#29#);
   K_Alt_Backslash      : constant Character := Character'Val (16#2B#);
   K_Alt_Z              : constant Character := Character'Val (16#2C#);
   K_Alt_X              : constant Character := Character'Val (16#2D#);
   K_Alt_C              : constant Character := Character'Val (16#2E#);
   K_Alt_V              : constant Character := Character'Val (16#2F#);
   K_Alt_B              : constant Character := Character'Val (16#30#);
   K_Alt_N              : constant Character := Character'Val (16#31#);
   K_Alt_M              : constant Character := Character'Val (16#32#);
   K_Alt_Comma          : constant Character := Character'Val (16#33#);
   K_Alt_Period         : constant Character := Character'Val (16#34#);
   K_Alt_Slash          : constant Character := Character'Val (16#35#);
   K_Alt_KPStar         : constant Character := Character'Val (16#37#);
   K_F1                 : constant Character := Character'Val (16#3B#);
   K_F2                 : constant Character := Character'Val (16#3C#);
   K_F3                 : constant Character := Character'Val (16#3D#);
   K_F4                 : constant Character := Character'Val (16#3E#);
   K_F5                 : constant Character := Character'Val (16#3F#);
   K_F6                 : constant Character := Character'Val (16#40#);
   K_F7                 : constant Character := Character'Val (16#41#);
   K_F8                 : constant Character := Character'Val (16#42#);
   K_F9                 : constant Character := Character'Val (16#43#);
   K_F10                : constant Character := Character'Val (16#44#);
   K_Home               : constant Character := Character'Val (16#47#);
   K_Up                 : constant Character := Character'Val (16#48#);
   K_PageUp             : constant Character := Character'Val (16#49#);
   K_Alt_KPMinus        : constant Character := Character'Val (16#4A#);
   K_Left               : constant Character := Character'Val (16#4B#);
   K_Center             : constant Character := Character'Val (16#4C#);
   K_Right              : constant Character := Character'Val (16#4D#);
   K_Alt_KPPlus         : constant Character := Character'Val (16#4E#);
   K_End                : constant Character := Character'Val (16#4F#);
   K_Down               : constant Character := Character'Val (16#50#);
   K_PageDown           : constant Character := Character'Val (16#51#);
   K_Insert             : constant Character := Character'Val (16#52#);
   K_Delete             : constant Character := Character'Val (16#53#);
   K_Shift_F1           : constant Character := Character'Val (16#54#);
   K_Shift_F2           : constant Character := Character'Val (16#55#);
   K_Shift_F3           : constant Character := Character'Val (16#56#);
   K_Shift_F4           : constant Character := Character'Val (16#57#);
   K_Shift_F5           : constant Character := Character'Val (16#58#);
   K_Shift_F6           : constant Character := Character'Val (16#59#);
   K_Shift_F7           : constant Character := Character'Val (16#5A#);
   K_Shift_F8           : constant Character := Character'Val (16#5B#);
   K_Shift_F9           : constant Character := Character'Val (16#5C#);
   K_Shift_F10          : constant Character := Character'Val (16#5D#);
   K_Control_F1         : constant Character := Character'Val (16#5E#);
   K_Control_F2         : constant Character := Character'Val (16#5F#);
   K_Control_F3         : constant Character := Character'Val (16#60#);
   K_Control_F4         : constant Character := Character'Val (16#61#);
   K_Control_F5         : constant Character := Character'Val (16#62#);
   K_Control_F6         : constant Character := Character'Val (16#63#);
   K_Control_F7         : constant Character := Character'Val (16#64#);
   K_Control_F8         : constant Character := Character'Val (16#65#);
   K_Control_F9         : constant Character := Character'Val (16#66#);
   K_Control_F10        : constant Character := Character'Val (16#67#);
   K_Alt_F1             : constant Character := Character'Val (16#68#);
   K_Alt_F2             : constant Character := Character'Val (16#69#);
   K_Alt_F3             : constant Character := Character'Val (16#6A#);
   K_Alt_F4             : constant Character := Character'Val (16#6B#);
   K_Alt_F5             : constant Character := Character'Val (16#6C#);
   K_Alt_F6             : constant Character := Character'Val (16#6D#);
   K_Alt_F7             : constant Character := Character'Val (16#6E#);
   K_Alt_F8             : constant Character := Character'Val (16#6F#);
   K_Alt_F9             : constant Character := Character'Val (16#70#);
   K_Alt_F10            : constant Character := Character'Val (16#71#);
   K_Control_Left       : constant Character := Character'Val (16#73#);
   K_Control_Right      : constant Character := Character'Val (16#74#);
   K_Control_End        : constant Character := Character'Val (16#75#);
   K_Control_PageDown   : constant Character := Character'Val (16#76#);
   K_Control_Home       : constant Character := Character'Val (16#77#);
   K_Alt_1              : constant Character := Character'Val (16#78#);
   K_Alt_2              : constant Character := Character'Val (16#79#);
   K_Alt_3              : constant Character := Character'Val (16#7A#);
   K_Alt_4              : constant Character := Character'Val (16#7B#);
   K_Alt_5              : constant Character := Character'Val (16#7C#);
   K_Alt_6              : constant Character := Character'Val (16#7D#);
   K_Alt_7              : constant Character := Character'Val (16#7E#);
   K_Alt_8              : constant Character := Character'Val (16#7F#);
   K_Alt_9              : constant Character := Character'Val (16#80#);
   K_Alt_0              : constant Character := Character'Val (16#81#);
   K_Alt_Dash           : constant Character := Character'Val (16#82#);
   K_Alt_Equals         : constant Character := Character'Val (16#83#);
   K_Control_PageUp     : constant Character := Character'Val (16#84#);
   K_F11                : constant Character := Character'Val (16#85#);
   K_F12                : constant Character := Character'Val (16#86#);
   K_Shift_F11          : constant Character := Character'Val (16#87#);
   K_Shift_F12          : constant Character := Character'Val (16#88#);
   K_Control_F11        : constant Character := Character'Val (16#89#);
   K_Control_F12        : constant Character := Character'Val (16#8A#);
   K_Alt_F11            : constant Character := Character'Val (16#8B#);
   K_Alt_F12            : constant Character := Character'Val (16#8C#);
   K_Control_Up         : constant Character := Character'Val (16#8D#);
   K_Control_KPDash     : constant Character := Character'Val (16#8E#);
   K_Control_Center     : constant Character := Character'Val (16#8F#);
   K_Control_KPPlus     : constant Character := Character'Val (16#90#);
   K_Control_Down       : constant Character := Character'Val (16#91#);
   K_Control_Insert     : constant Character := Character'Val (16#92#);
   K_Control_Delete     : constant Character := Character'Val (16#93#);
   K_Control_KPSlash    : constant Character := Character'Val (16#95#);
   K_Control_KPStar     : constant Character := Character'Val (16#96#);
   K_Alt_EHome          : constant Character := Character'Val (16#97#);
   K_Alt_EUp            : constant Character := Character'Val (16#98#);
   K_Alt_EPageUp        : constant Character := Character'Val (16#99#);
   K_Alt_ELeft          : constant Character := Character'Val (16#9B#);
   K_Alt_ERight         : constant Character := Character'Val (16#9D#);
   K_Alt_EEnd           : constant Character := Character'Val (16#9F#);
   K_Alt_EDown          : constant Character := Character'Val (16#A0#);
   K_Alt_EPageDown      : constant Character := Character'Val (16#A1#);
   K_Alt_EInsert        : constant Character := Character'Val (16#A2#);
   K_Alt_EDelete        : constant Character := Character'Val (16#A3#);
   K_Alt_KPSlash        : constant Character := Character'Val (16#A4#);
   K_Alt_Tab            : constant Character := Character'Val (16#A5#);
   K_Alt_Enter          : constant Character := Character'Val (16#A6#);

end Conio.Keys;
