-----------------------------------------------------------------------
--
--  File:        display.adb
--  Description: HANGMAN display procedures
--  Rev:         0.2
--  Date:        03/01/97
--  Author:      Jerry van Dijk
--  Mail:        jerry@jvdsys.nextjk.stuyts.nl
--
--  Copyright (c) Jerry van Dijk, 1997
--  Forelstraat 211
--  2037 KV  HAARLEM
--  THE NETHERLANDS
--  tel int + 31 23 540 1052
--
--  Permission granted to use for any purpose, provided this copyright
--  remains attached and unmodified.
--
--  THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
--  IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
--  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
--
-----------------------------------------------------------------------
with Conio, Conio.Keys;
use  Conio, Conio.Keys;

package body Display is

   procedure Draw_Box (X1, Y1, X2, Y2 : in Positive) is

      procedure Draw_Line (X1, X2, Y : in Positive) is
      begin
         Gotoxy (X1, Y);
         for X in X1 .. X2 loop
            Putch ('');
         end loop;
      end Draw_Line;

      Procedure Draw_Column (Y1, Y2, X : in Positive) is
      begin
         for Y in Y1 .. Y2 loop
            Gotoxy (X, Y);
            Putch ('');
         end loop;
      end Draw_Column;

   begin
      Gotoxy (X1, Y1);
      Putch ('');
      Draw_Line (X1 + 1, X2 - 1, Y1);
      Putch ('');
      Gotoxy (X1, Y2);
      Putch ('');
      Draw_Line (X1 + 1, X2 - 1, Y2);
      Putch ('');
      Draw_Column (Y1 + 1, Y2 - 1, X1);
      Draw_Column (Y1 + 1, Y2 - 1, X2);
   end Draw_Box;

   procedure Prepare_Display is
   begin
      Textcolor (Yellow);
      Textbackground (Blue);
      Setcursortype (None);
      Clrscr;
      Cputs ("       " &
             "ͻ" &
             K_Return & K_Linefeed);
      Cputs ("                      " &
             "               " &
             K_Return & K_Linefeed);
      Cputs ("                      " &
             "                  " &
             K_Return & K_Linefeed);
      Cputs ("                " &
             "              " &
             K_Return & K_Linefeed);
      Cputs ("                      " &
             "                  " &
             K_Return & K_Linefeed);
      Cputs ("                       " &
             "                  " &
             K_Return & K_Linefeed);
      Cputs ("       " &
             "ͼ" &
             K_Return & K_Linefeed);
   end Prepare_Display;

   procedure Display_Statistics (Games   : in Natural;
                                 Guessed : in Natural;
                                 Words   : in Natural;
                                 Used    : in Natural) is
   begin
      Textcolor (Black);
      Draw_Box (8, 10, 53, 16);
      Gotoxy (23, 10);
      Cputs(" STATISTICS ");
      Textcolor (Cyan);
      Gotoxy (10, 12);
      Cputs ("Games played:  ");
      Textcolor (Light_Cyan);
      Cputs (Integer'Image(Games));
      Textcolor (Cyan);
      Gotoxy (10, 14);
      Cputs ("Words guessed: ");
      Textcolor (Light_Cyan);
      Cputs (Integer'Image(Guessed));
      Textcolor (Cyan);
      Gotoxy (36, 12);
      Cputs ("Total words: ");
      Textcolor (Light_Cyan);
      Cputs (Integer'Image(Words));
      Textcolor (Cyan);
      Gotoxy (36, 14);
      Cputs ("Words used:  ");
      Textcolor (Light_Cyan);
      Cputs (Integer'Image(Used));
   end Display_Statistics;

end Display;
