-----------------------------------------------------------------------
--
--  File:        screen.ads
--  Description: HANGMAN screen saving
--  Rev:         0.2
--  Date:        03/01/97
--  Author:      Jerry van Dijk
--  Mail:        jerry@jvdsys.nextjk.stuyts.nl
--
--  Copyright (c) Jerry van Dijk, 1997
--  Forelstraat 211
--  2037 KV  HAARLEM
--  THE NETHERLANDS
--  tel int + 31 23 540 1052
--
--  Permission granted to use for any purpose, provided this copyright
--  remains attached and unmodified.
--
--  THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
--  IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
--  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
--
-----------------------------------------------------------------------
with Conio;
use  Conio;

package Screen is

   type A_Screen is private;

   procedure Save (Screen : out A_Screen);
   procedure Restore (Screen : in A_Screen);

private

   type A_Screen is
      record
         Width    : X_Pos;
         Height   : Y_Pos;
         Cursor_X : X_Pos;
         Cursor_Y : Y_Pos;
         Buffer : Screen_Buffer (X_Pos'Range, Y_Pos'Range);
      end record;

end Screen;
