FUNCTION Hash_Division_Letter 
  (K: String; Capacity: Positive) RETURN Natural IS
------------------------------------------------------------------------
--| Division_Letter Hash Function
--| Assumes K is a string of lowercase letters; 
--| hash just sums the relative positions of the letters.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: February 1996                                     
------------------------------------------------------------------------

  Result: Natural := 0;
  a_pos : Natural := Character'Pos('a');

BEGIN -- Hash_Division_Letter

  FOR Count IN K'Range LOOP
    Result := Result + (Character'Pos(K(Count)) - a_pos);
  END LOOP;

  RETURN Result REM Capacity;

END Hash_Division_Letter;
