WITH Ada.Text_IO;
WITH Employees;
WITH Employees.IO;
PACKAGE BODY Database IS
------------------------------------------------------------------
--| Body of the abstract data object for a database
--| of employee records
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  -- declarations for the Employee database, TableType

  MaxData: CONSTANT Positive := 25;

  SUBTYPE CompanyIndex IS Natural RANGE 1..MaxData;
  SUBTYPE CompanyRange IS Natural RANGE 0..MaxData;
  TYPE DataArray IS ARRAY(CompanyIndex) OF Employees.Employee;

  TYPE TableType IS RECORD
    Data: DataArray;
    CurrentSize:    CompanyRange := 0;
  END RECORD;
  
  Company: TableType;

  PROCEDURE Initialize IS
  BEGIN -- Initialize
    Company.CurrentSize := 0;
  END Initialize;

  PROCEDURE Insert (E       : Employees.Employee;
                    Success : OUT Boolean) IS
  BEGIN -- Insert

    Success := True;

    -- First search database for E's ID; set Success false if found
    FOR Which IN 1..Company.CurrentSize LOOP
      IF Employees.RetrieveID(Company.Data(Which)) = 
         Employees.RetrieveID(E) THEN
        Success := False;
        RETURN;
      END IF;
    END LOOP;

    -- we didn't find a matching record, so we can insert this one
    Company.CurrentSize := Company.CurrentSize + 1;
    Company.Data(Company.CurrentSize) := E;

  END Insert;
     
  PROCEDURE Replace (E       : Employees.Employee;
                     Success : OUT Boolean) IS
  BEGIN -- stub
    Ada.Text_IO.Put(Item => "Replace is still under construction.");
    Ada.Text_IO.New_Line;
  END Replace;
     
  PROCEDURE Retrieve (ID      : IN  Employees.IDType;
                      E       : OUT Employees.Employee;
                      Success : OUT Boolean) IS
  BEGIN -- stub
    Ada.Text_IO.Put(Item => "Retrieve is still under construction.");
    Ada.Text_IO.New_Line;
  END Retrieve;
     
  PROCEDURE Delete (ID      : IN Employees.IDType;
                    Success : OUT Boolean) IS
  BEGIN -- stub
    Ada.Text_IO.Put(Item => "Delete is still under construction.");
    Ada.Text_IO.New_Line;
  END Delete;

  PROCEDURE Display IS
  BEGIN -- Display

    FOR Which IN 1..Company.CurrentSize LOOP
      Employees.IO.DisplayEmployee (Item => Company.Data(Which));
      Ada.Text_IO.New_Line;
    END LOOP;
    
  END Display;

END Database;
