WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
WITH Min_Max;
PROCEDURE Min_Max_Average_File IS
------------------------------------------------------------------
--| Finds and displays the minimum, maximum, and average
--| of a list of data items; the data items are read from a file.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  NumValues:    Positive;  -- input - the number of items to be averaged
  CurrentValue: Integer;   -- input - the next data item to be added   

  Smallest:     Integer;   -- output - minimum of the data values
  Largest:      Integer;   -- output - maximum of the data values
  Average:      Integer;   -- output - average of the data values

  Sum:          Integer;   -- program variable - the sum being accumulated   
  TestScores:   Ada.Text_IO.File_Type; 
                           -- program variable - names the input file

BEGIN  -- Min_Max_Average_File

  -- Open the file and associate it with the file variable name
  Ada.Text_IO.Open
    (File => TestScores, Mode => Ada.Text_IO.In_File, Name => "scores.dat");

  -- Read from the file the number of items to be averaged 
  Ada.Integer_Text_IO.Get(File => TestScores, Item => NumValues);  
  Ada.Text_IO.Put("The number of scores to be averaged is ");
  Ada.Integer_Text_IO.Put(Item => NumValues, Width => 1);  
  Ada.Text_IO.New_Line;

  -- Initialize program variables
  Smallest := Integer'Last;
  Largest := Integer'First;
  Sum := 0;

  -- Read each data item, log to the screen, add it to Sum, 
  -- and check if it is a new minimum or maximum
  FOR Count IN 1 .. NumValues LOOP
    Ada.Integer_Text_IO.Get(File => TestScores, Item => CurrentValue);  
    Ada.Text_IO.Put("Score number ");
    Ada.Integer_Text_IO.Put(Item => Count, Width => 1);  
    Ada.Text_IO.Put(" is ");
    Ada.Integer_Text_IO.Put(Item => CurrentValue, Width => 1);  
    Ada.Text_IO.New_Line;

    Sum := Sum + CurrentValue;
    Smallest := Min_Max.Minimum(Value1 => Smallest, Value2 => CurrentValue);
    Largest  := Min_Max.Maximum(Value1 => Largest,  Value2 => CurrentValue);
  END LOOP;

  -- compute the average; since Sum and NumValues are integers,
  -- the average is truncated, that is, the fractional part is discarded
  Average := Sum / NumValues;

  -- display the results
  Ada.Text_IO.Put(Item => "The Smallest is ");
  Ada.Integer_Text_IO.Put(Item => Smallest, Width => 1);  
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put(Item => "The Largest is ");
  Ada.Integer_Text_IO.Put(Item => Largest, Width => 1);  
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put(Item => "The Average is ");
  Ada.Integer_Text_IO.Put(Item => Average, Width => 1);  
  Ada.Text_IO.New_Line;

END Min_Max_Average_File;
