WITH Ada.Text_IO;
PROCEDURE Three_Days IS
------------------------------------------------------------------
--| Finds yesterday and tomorrow, given today
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  TYPE Days IS (Mon, Tue, Wed, Thu, Fri, Sat, Sun);
  PACKAGE Day_IO IS 
     NEW Ada.Text_IO.Enumeration_IO (Enum => Days);
 
  Yesterday : Days;
  Today     : Days;
  Tomorrow  : Days;
     
BEGIN -- Three_Days

  -- prompt user to enter a day abbreviation
  Ada.Text_IO.Put (Item => "Enter the first 3 letters of a day of the week > ");
  Day_IO.Get (Item => Today);
   
  -- find yesterday
  IF Today = Days'First THEN
    Yesterday := Days'Last;
  ELSE
    Yesterday := Days'Pred(Today);
  END IF;
 
  Ada.Text_IO.Put (Item => "Yesterday was ");
  Day_IO.Put (Item => Yesterday);
  Ada.Text_IO.New_Line;
   
  Ada.Text_IO.Put (Item => "Today is ");
  Day_IO.Put (Item => Today);
  Ada.Text_IO.New_Line;
   
  -- find tomorrow
  IF Today = Days'Last THEN
    Tomorrow := Days'First;
  ELSE
    Tomorrow := Days'Succ(Today);
  END IF;
   
  Ada.Text_IO.Put (Item => "Tomorrow is ");
  Day_IO.Put (Item => Tomorrow); 
  Ada.Text_IO.New_Line; 

END Three_Days;
 
