------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--           A D A . S T R I N G S . M A P S . C O N S T A N T S            --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.7 $                              --
--                                                                          --
-- This specification is adapted from the Ada Reference Manual for use with --
-- GNAT.  In accordance with the copyright of that document, you can freely --
-- copy and modify this specification,  provided that if you redistribute a --
-- modified version,  any changes that you have made are clearly indicated. --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Characters.Latin_1;

package Ada.Strings.Maps.Constants is
pragma Preelaborate (Constants);

   package L renames Ada.Characters.Latin_1;

   Control_Set           : constant Character_Set;
   Graphic_Set           : constant Character_Set;
   Letter_Set            : constant Character_Set;
   Lower_Set             : constant Character_Set;
   Upper_Set             : constant Character_Set;
   Basic_Set             : constant Character_Set;
   Decimal_Digit_Set     : constant Character_Set;
   Hexadecimal_Digit_Set : constant Character_Set;
   Alphanumeric_Set      : constant Character_Set;
   Special_Set           : constant Character_Set;
   ISO_646_Set           : constant Character_Set;

   Lower_Case_Map        : constant Character_Mapping;
   --  Maps to lower case for letters, else identity

   Upper_Case_Map        : constant Character_Mapping;
   --  Maps to upper case for letters, else identity

   Basic_Map             : constant Character_Mapping;
   --  Maps to basic letters for letters, else identity

private

   Control_Set               : constant Character_Set :=
     (L.NUL                  ..  L.US                  => True,
      L.DEL                  ..  L.APC                 => True,
      others                                           => False);

   Graphic_Set               : constant Character_Set :=
     (L.' '                  ..  L.'~'                 => True,
      L.No_Break_Space       ..  L.LC_Y_Diaeresis      => True,
      others                                           => False);

   Letter_Set                : constant Character_Set :=
     (L.'A'                  ..  L.'Z'                 => True,
      L.'a'                  ..  L.'z'                 => True,
      L.UC_A_Grave           ..  L.UC_O_Diaeresis      => True,
      L.UC_O_Oblique_Stroke  ..  L.LC_O_Diaeresis      => True,
      L.LC_O_Oblique_Stroke  ..  L.LC_Y_Diaeresis      => True,
      others                                           => False);

   Lower_Set                 : constant Character_Set :=
     (L.'a'                  ..  L.'z'                 => True,
      L.LC_German_Sharp_S    ..  L.LC_O_Diaeresis      => True,
      L.LC_O_Oblique_Stroke  ..  L.LC_Y_Diaeresis      => True,
      others                                           => False);

   Upper_Set                 : constant Character_Set :=
     (L.'A'                  ..  L.'Z'                 => True,
      L.UC_A_Grave           ..  L.UC_O_Diaeresis      => True,
      L.UC_O_Oblique_Stroke  ..  L.UC_Icelandic_Thorn  => True,
      others                                           => False);

   Basic_Set                 : constant Character_Set :=
     (L.'A'                  ..  L.'Z'                 => True,
      L.'a'                  ..  L.'z'                 => True,
      L.UC_AE_Diphthong      ..  L.UC_AE_Diphthong     => True,
      L.LC_AE_Diphthong      ..  L.LC_AE_Diphthong     => True,
      L.LC_German_Sharp_S    ..  L.LC_German_Sharp_S   => True,
      L.UC_Icelandic_Thorn   ..  L.UC_Icelandic_Thorn  => True,
      L.LC_Icelandic_Thorn   ..  L.LC_Icelandic_Thorn  => True,
      L.UC_Icelandic_Eth     ..  L.UC_Icelandic_Eth    => True,
      L.LC_Icelandic_Eth     ..  L.LC_Icelandic_Eth    => True,
      others                                           => False);

   Decimal_Digit_Set         : constant Character_Set :=
     (L.'0'                  ..  L.'9'                 => True,
      others                                           => False);

   Hexadecimal_Digit_Set     : constant Character_Set :=
     (L.'0'                  ..  L.'9'                 => True,
      L.'A'                  ..  L.'F'                 => True,
      L.'a'                  ..  L.'f'                 => True,
      others                                           => False);

   Alphanumeric_Set          : constant Character_Set :=
     (L.'0'                  ..  L.'9'                 => True,
      L.'A'                  ..  L.'Z'                 => True,
      L.'a'                  ..  L.'z'                 => True,
      L.UC_A_Grave           ..  L.UC_O_Diaeresis      => True,
      L.UC_O_Oblique_Stroke  ..  L.LC_O_Diaeresis      => True,
      L.LC_O_Oblique_Stroke  ..  L.LC_Y_Diaeresis      => True,
      others                                           => False);

   Special_Set               : constant Character_Set :=
     (L.' '                  ..  L.'/'                 => True,
      L.':'                  ..  L.'@'                 => True,
      L.'['                  ..  L.'`'                 => True,
      L.'{'                  ..  L.'~'                 => True,
      L.No_Break_Space       ..  L.Inverted_Question   => True,
      L.Multiplication_Sign  ..  L.Multiplication_Sign => True,
      L.Division_Sign        ..  L.Division_Sign       => True,
      others                                           => False);

   ISO_646_Set               : constant Character_Set :=
     (L.NUL                  ..  L.DEL                 => True,
      others                                           => False);

   Lower_Case_Map : constant Character_Mapping :=
     (L.NUL                         &  -- NUL                             0
      L.SOH                         &  -- SOH                             1
      L.STX                         &  -- STX                             2
      L.ETX                         &  -- ETX                             3
      L.EOT                         &  -- EOT                             4
      L.ENQ                         &  -- ENQ                             5
      L.ACK                         &  -- ACK                             6
      L.BEL                         &  -- BEL                             7
      L.BS                          &  -- BS                              8
      L.HT                          &  -- HT                              9
      L.LF                          &  -- LF                             10
      L.VT                          &  -- VT                             11
      L.FF                          &  -- FF                             12
      L.CR                          &  -- CR                             13
      L.SO                          &  -- SO                             14
      L.SI                          &  -- SI                             15
      L.DLE                         &  -- DLE                            16
      L.DC1                         &  -- DC1                            17
      L.DC2                         &  -- DC2                            18
      L.DC3                         &  -- DC3                            19
      L.DC4                         &  -- DC4                            20
      L.NAK                         &  -- NAK                            21
      L.SYN                         &  -- SYN                            22
      L.ETB                         &  -- ETB                            23
      L.CAN                         &  -- CAN                            24
      L.EM                          &  -- EM                             25
      L.SUB                         &  -- SUB                            26
      L.ESC                         &  -- ESC                            27
      L.FS                          &  -- FS                             28
      L.GS                          &  -- GS                             29
      L.RS                          &  -- RS                             30
      L.US                          &  -- US                             31
      L.' '                         &  -- ' '                            32
      L.'!'                         &  -- '!'                            33
      L.'"'                         &  -- '"'                            34
      L.'#'                         &  -- '#'                            35
      L.'$'                         &  -- '$'                            36
      L.'%'                         &  -- '%'                            37
      L.'&'                         &  -- '&'                            38
      L.'''                         &  -- '''                            39
      L.'('                         &  -- '('                            40
      L.')'                         &  -- ')'                            41
      L.'*'                         &  -- '*'                            42
      L.'+'                         &  -- '+'                            43
      L.','                         &  -- ','                            44
      L.'-'                         &  -- '-'                            45
      L.'.'                         &  -- '.'                            46
      L.'/'                         &  -- '/'                            47
      L.'0'                         &  -- '0'                            48
      L.'1'                         &  -- '1'                            49
      L.'2'                         &  -- '2'                            50
      L.'3'                         &  -- '3'                            51
      L.'4'                         &  -- '4'                            52
      L.'5'                         &  -- '5'                            53
      L.'6'                         &  -- '6'                            54
      L.'7'                         &  -- '7'                            55
      L.'8'                         &  -- '8'                            56
      L.'9'                         &  -- '9'                            57
      L.':'                         &  -- ':'                            58
      L.';'                         &  -- ';'                            59
      L.'<'                         &  -- '<'                            60
      L.'='                         &  -- '='                            61
      L.'>'                         &  -- '>'                            62
      L.'?'                         &  -- '?'                            63
      L.'@'                         &  -- '@'                            64
      L.'a'                         &  -- 'A'                            65
      L.'b'                         &  -- 'B'                            66
      L.'c'                         &  -- 'C'                            67
      L.'d'                         &  -- 'D'                            68
      L.'e'                         &  -- 'E'                            69
      L.'f'                         &  -- 'F'                            70
      L.'g'                         &  -- 'G'                            71
      L.'h'                         &  -- 'H'                            72
      L.'i'                         &  -- 'I'                            73
      L.'j'                         &  -- 'J'                            74
      L.'k'                         &  -- 'K'                            75
      L.'l'                         &  -- 'L'                            76
      L.'m'                         &  -- 'M'                            77
      L.'n'                         &  -- 'N'                            78
      L.'o'                         &  -- 'O'                            79
      L.'p'                         &  -- 'P'                            80
      L.'q'                         &  -- 'Q'                            81
      L.'r'                         &  -- 'R'                            82
      L.'s'                         &  -- 'S'                            83
      L.'t'                         &  -- 'T'                            84
      L.'u'                         &  -- 'U'                            85
      L.'v'                         &  -- 'V'                            86
      L.'w'                         &  -- 'W'                            87
      L.'x'                         &  -- 'X'                            88
      L.'y'                         &  -- 'Y'                            89
      L.'z'                         &  -- 'Z'                            90
      L.'['                         &  -- '['                            91
      L.'\'                         &  -- '\'                            92
      L.']'                         &  -- ']'                            93
      L.'^'                         &  -- '^'                            94
      L.'_'                         &  -- '_'                            95
      L.'`'                         &  -- '`'                            96
      L.'a'                         &  -- 'a'                            97
      L.'b'                         &  -- 'b'                            98
      L.'c'                         &  -- 'c'                            99
      L.'d'                         &  -- 'd'                           100
      L.'e'                         &  -- 'e'                           101
      L.'f'                         &  -- 'f'                           102
      L.'g'                         &  -- 'g'                           103
      L.'h'                         &  -- 'h'                           104
      L.'i'                         &  -- 'i'                           105
      L.'j'                         &  -- 'j'                           106
      L.'k'                         &  -- 'k'                           107
      L.'l'                         &  -- 'l'                           108
      L.'m'                         &  -- 'm'                           109
      L.'n'                         &  -- 'n'                           110
      L.'o'                         &  -- 'o'                           111
      L.'p'                         &  -- 'p'                           112
      L.'q'                         &  -- 'q'                           113
      L.'r'                         &  -- 'r'                           114
      L.'s'                         &  -- 's'                           115
      L.'t'                         &  -- 't'                           116
      L.'u'                         &  -- 'u'                           117
      L.'v'                         &  -- 'v'                           118
      L.'w'                         &  -- 'w'                           119
      L.'x'                         &  -- 'x'                           120
      L.'y'                         &  -- 'y'                           121
      L.'z'                         &  -- 'z'                           122
      L.'{'                         &  -- '{'                           123
      L.'|'                         &  -- '|'                           124
      L.'}'                         &  -- '}'                           125
      L.'~'                         &  -- '~'                           126
      L.DEL                         &  -- DEL                           127
      L.Reserved_128                &  -- Reserved_128                  128
      L.Reserved_129                &  -- Reserved_129                  129
      L.BPH                         &  -- BPH                           130
      L.NBH                         &  -- NBH                           131
      L.Reserved_132                &  -- Reserved_132                  132
      L.NEL                         &  -- NEL                           133
      L.SSA                         &  -- SSA                           134
      L.ESA                         &  -- ESA                           135
      L.HTS                         &  -- HTS                           136
      L.HTJ                         &  -- HTJ                           137
      L.VTS                         &  -- VTS                           138
      L.PLD                         &  -- PLD                           139
      L.PLU                         &  -- PLU                           140
      L.RI                          &  -- RI                            141
      L.SS2                         &  -- SS2                           142
      L.SS3                         &  -- SS3                           143
      L.DCS                         &  -- DCS                           144
      L.PU1                         &  -- PU1                           145
      L.PU2                         &  -- PU2                           146
      L.STS                         &  -- STS                           147
      L.CCH                         &  -- CCH                           148
      L.MW                          &  -- MW                            149
      L.SPA                         &  -- SPA                           150
      L.EPA                         &  -- EPA                           151
      L.SOS                         &  -- SOS                           152
      L.Reserved_153                &  -- Reserved_153                  153
      L.SCI                         &  -- SCI                           154
      L.CSI                         &  -- CSI                           155
      L.ST                          &  -- ST                            156
      L.OSC                         &  -- OSC                           157
      L.PM                          &  -- PM                            158
      L.APC                         &  -- APC                           159
      L.No_Break_Space              &  -- No_Break_Space                160
      L.Inverted_Exclamation        &  -- Inverted_Exclamation          161
      L.Cent_Sign                   &  -- Cent_Sign                     162
      L.Pound_Sign                  &  -- Pound_Sign                    163
      L.Currency_Sign               &  -- Currency_Sign                 164
      L.Yen_Sign                    &  -- Yen_Sign                      165
      L.Broken_Bar                  &  -- Broken_Bar                    166
      L.Section_Sign                &  -- Section_Sign                  167
      L.Diaeresis                   &  -- Diaeresis                     168
      L.Copyright_Sign              &  -- Copyright_Sign                169
      L.Feminine_Ordinal_Indicator  &  -- Feminine_Ordinal_Indicator    170
      L.Left_Angle_Quotation        &  -- Left_Angle_Quotation          171
      L.Not_Sign                    &  -- Not_Sign                      172
      L.Soft_Hyphen                 &  -- Soft_Hyphen                   173
      L.Registered_Trade_Mark_Sign  &  -- Registered_Trade_Mark_Sign    174
      L.Macron                      &  -- Macron                        175
      L.Degree_Sign                 &  -- Degree_Sign                   176
      L.Plus_Minus_Sign             &  -- Plus_Minus_Sign               177
      L.Superscript_Two             &  -- Superscript_Two               178
      L.Superscript_Three           &  -- Superscript_Three             179
      L.Acute                       &  -- Acute                         180
      L.Micro_Sign                  &  -- Micro_Sign                    181
      L.Pilcrow_Sign                &  -- Pilcrow_Sign                  182
      L.Middle_Dot                  &  -- Middle_Dot                    183
      L.Cedilla                     &  -- Cedilla                       184
      L.Superscript_One             &  -- Superscript_One               185
      L.Masculine_Ordinal_Indicator &  -- Masculine_Ordinal_Indicator   186
      L.Right_Angle_Quotation       &  -- Right_Angle_Quotation         187
      L.Fraction_One_Quarter        &  -- Fraction_One_Quarter          188
      L.Fraction_One_Half           &  -- Fraction_One_Half             189
      L.Fraction_Three_Quarters     &  -- Fraction_Three_Quarters       190
      L.Inverted_Question           &  -- Inverted_Question             191
      L.LC_A_Grave                  &  -- UC_A_Grave                    192
      L.LC_A_Acute                  &  -- UC_A_Acute                    193
      L.LC_A_Circumflex             &  -- UC_A_Circumflex               194
      L.LC_A_Tilde                  &  -- UC_A_Tilde                    195
      L.LC_A_Diaeresis              &  -- UC_A_Diaeresis                196
      L.LC_A_Ring                   &  -- UC_A_Ring                     197
      L.LC_AE_Diphthong             &  -- UC_AE_Diphthong               198
      L.LC_C_Cedilla                &  -- UC_C_Cedilla                  199
      L.LC_E_Grave                  &  -- UC_E_Grave                    200
      L.LC_E_Acute                  &  -- UC_E_Acute                    201
      L.LC_E_Circumflex             &  -- UC_E_Circumflex               202
      L.LC_E_Diaeresis              &  -- UC_E_Diaeresis                203
      L.LC_I_Grave                  &  -- UC_I_Grave                    204
      L.LC_I_Acute                  &  -- UC_I_Acute                    205
      L.LC_I_Circumflex             &  -- UC_I_Circumflex               206
      L.LC_I_Diaeresis              &  -- UC_I_Diaeresis                207
      L.LC_Icelandic_Eth            &  -- UC_Icelandic_Eth              208
      L.LC_N_Tilde                  &  -- UC_N_Tilde                    209
      L.LC_O_Grave                  &  -- UC_O_Grave                    210
      L.LC_O_Acute                  &  -- UC_O_Acute                    211
      L.LC_O_Circumflex             &  -- UC_O_Circumflex               212
      L.LC_O_Tilde                  &  -- UC_O_Tilde                    213
      L.LC_O_Diaeresis              &  -- UC_O_Diaeresis                214
      L.Multiplication_Sign         &  -- Multiplication_Sign           215
      L.LC_O_Oblique_Stroke         &  -- UC_O_Oblique_Stroke           216
      L.LC_U_Grave                  &  -- UC_U_Grave                    217
      L.LC_U_Acute                  &  -- UC_U_Acute                    218
      L.LC_U_Circumflex             &  -- UC_U_Circumflex               219
      L.LC_U_Diaeresis              &  -- UC_U_Diaeresis                220
      L.LC_Y_Acute                  &  -- UC_Y_Acute                    221
      L.LC_Icelandic_Thorn          &  -- UC_Icelandic_Thorn            222
      L.LC_German_Sharp_S           &  -- LC_German_Sharp_S             223
      L.LC_A_Grave                  &  -- LC_A_Grave                    224
      L.LC_A_Acute                  &  -- LC_A_Acute                    225
      L.LC_A_Circumflex             &  -- LC_A_Circumflex               226
      L.LC_A_Tilde                  &  -- LC_A_Tilde                    227
      L.LC_A_Diaeresis              &  -- LC_A_Diaeresis                228
      L.LC_A_Ring                   &  -- LC_A_Ring                     229
      L.LC_AE_Diphthong             &  -- LC_AE_Diphthong               230
      L.LC_C_Cedilla                &  -- LC_C_Cedilla                  231
      L.LC_E_Grave                  &  -- LC_E_Grave                    232
      L.LC_E_Acute                  &  -- LC_E_Acute                    233
      L.LC_E_Circumflex             &  -- LC_E_Circumflex               234
      L.LC_E_Diaeresis              &  -- LC_E_Diaeresis                235
      L.LC_I_Grave                  &  -- LC_I_Grave                    236
      L.LC_I_Acute                  &  -- LC_I_Acute                    237
      L.LC_I_Circumflex             &  -- LC_I_Circumflex               238
      L.LC_I_Diaeresis              &  -- LC_I_Diaeresis                239
      L.LC_Icelandic_Eth            &  -- LC_Icelandic_Eth              240
      L.LC_N_Tilde                  &  -- LC_N_Tilde                    241
      L.LC_O_Grave                  &  -- LC_O_Grave                    242
      L.LC_O_Acute                  &  -- LC_O_Acute                    243
      L.LC_O_Circumflex             &  -- LC_O_Circumflex               244
      L.LC_O_Tilde                  &  -- LC_O_Tilde                    245
      L.LC_O_Diaeresis              &  -- LC_O_Diaeresis                246
      L.Division_Sign               &  -- Division_Sign                 247
      L.LC_O_Oblique_Stroke         &  -- LC_O_Oblique_Stroke           248
      L.LC_U_Grave                  &  -- LC_U_Grave                    249
      L.LC_U_Acute                  &  -- LC_U_Acute                    250
      L.LC_U_Circumflex             &  -- LC_U_Circumflex               251
      L.LC_U_Diaeresis              &  -- LC_U_Diaeresis                252
      L.LC_Y_Acute                  &  -- LC_Y_Acute                    253
      L.LC_Icelandic_Thorn          &  -- LC_Icelandic_Thorn            254
      L.LC_Y_Diaeresis);               -- LC_Y_Diaeresis                255

   Upper_Case_Map : constant Character_Mapping :=
     (L.NUL                         &  -- NUL                             0
      L.SOH                         &  -- SOH                             1
      L.STX                         &  -- STX                             2
      L.ETX                         &  -- ETX                             3
      L.EOT                         &  -- EOT                             4
      L.ENQ                         &  -- ENQ                             5
      L.ACK                         &  -- ACK                             6
      L.BEL                         &  -- BEL                             7
      L.BS                          &  -- BS                              8
      L.HT                          &  -- HT                              9
      L.LF                          &  -- LF                             10
      L.VT                          &  -- VT                             11
      L.FF                          &  -- FF                             12
      L.CR                          &  -- CR                             13
      L.SO                          &  -- SO                             14
      L.SI                          &  -- SI                             15
      L.DLE                         &  -- DLE                            16
      L.DC1                         &  -- DC1                            17
      L.DC2                         &  -- DC2                            18
      L.DC3                         &  -- DC3                            19
      L.DC4                         &  -- DC4                            20
      L.NAK                         &  -- NAK                            21
      L.SYN                         &  -- SYN                            22
      L.ETB                         &  -- ETB                            23
      L.CAN                         &  -- CAN                            24
      L.EM                          &  -- EM                             25
      L.SUB                         &  -- SUB                            26
      L.ESC                         &  -- ESC                            27
      L.FS                          &  -- FS                             28
      L.GS                          &  -- GS                             29
      L.RS                          &  -- RS                             30
      L.US                          &  -- US                             31
      L.' '                         &  -- ' '                            32
      L.'!'                         &  -- '!'                            33
      L.'"'                         &  -- '"'                            34
      L.'#'                         &  -- '#'                            35
      L.'$'                         &  -- '$'                            36
      L.'%'                         &  -- '%'                            37
      L.'&'                         &  -- '&'                            38
      L.'''                         &  -- '''                            39
      L.'('                         &  -- '('                            40
      L.')'                         &  -- ')'                            41
      L.'*'                         &  -- '*'                            42
      L.'+'                         &  -- '+'                            43
      L.','                         &  -- ','                            44
      L.'-'                         &  -- '-'                            45
      L.'.'                         &  -- '.'                            46
      L.'/'                         &  -- '/'                            47
      L.'0'                         &  -- '0'                            48
      L.'1'                         &  -- '1'                            49
      L.'2'                         &  -- '2'                            50
      L.'3'                         &  -- '3'                            51
      L.'4'                         &  -- '4'                            52
      L.'5'                         &  -- '5'                            53
      L.'6'                         &  -- '6'                            54
      L.'7'                         &  -- '7'                            55
      L.'8'                         &  -- '8'                            56
      L.'9'                         &  -- '9'                            57
      L.':'                         &  -- ':'                            58
      L.';'                         &  -- ';'                            59
      L.'<'                         &  -- '<'                            60
      L.'='                         &  -- '='                            61
      L.'>'                         &  -- '>'                            62
      L.'?'                         &  -- '?'                            63
      L.'@'                         &  -- '@'                            64
      L.'A'                         &  -- 'A'                            65
      L.'B'                         &  -- 'B'                            66
      L.'C'                         &  -- 'C'                            67
      L.'D'                         &  -- 'D'                            68
      L.'E'                         &  -- 'E'                            69
      L.'F'                         &  -- 'F'                            70
      L.'G'                         &  -- 'G'                            71
      L.'H'                         &  -- 'H'                            72
      L.'I'                         &  -- 'I'                            73
      L.'J'                         &  -- 'J'                            74
      L.'K'                         &  -- 'K'                            75
      L.'L'                         &  -- 'L'                            76
      L.'M'                         &  -- 'M'                            77
      L.'N'                         &  -- 'N'                            78
      L.'O'                         &  -- 'O'                            79
      L.'P'                         &  -- 'P'                            80
      L.'Q'                         &  -- 'Q'                            81
      L.'R'                         &  -- 'R'                            82
      L.'S'                         &  -- 'S'                            83
      L.'T'                         &  -- 'T'                            84
      L.'U'                         &  -- 'U'                            85
      L.'V'                         &  -- 'V'                            86
      L.'W'                         &  -- 'W'                            87
      L.'X'                         &  -- 'X'                            88
      L.'Y'                         &  -- 'Y'                            89
      L.'Z'                         &  -- 'Z'                            90
      L.'['                         &  -- '['                            91
      L.'\'                         &  -- '\'                            92
      L.']'                         &  -- ']'                            93
      L.'^'                         &  -- '^'                            94
      L.'_'                         &  -- '_'                            95
      L.'`'                         &  -- '`'                            96
      L.'A'                         &  -- 'a'                            97
      L.'B'                         &  -- 'b'                            98
      L.'C'                         &  -- 'c'                            99
      L.'D'                         &  -- 'd'                           100
      L.'E'                         &  -- 'e'                           101
      L.'F'                         &  -- 'f'                           102
      L.'G'                         &  -- 'g'                           103
      L.'H'                         &  -- 'h'                           104
      L.'I'                         &  -- 'i'                           105
      L.'J'                         &  -- 'j'                           106
      L.'K'                         &  -- 'k'                           107
      L.'L'                         &  -- 'l'                           108
      L.'M'                         &  -- 'm'                           109
      L.'N'                         &  -- 'n'                           110
      L.'O'                         &  -- 'o'                           111
      L.'P'                         &  -- 'p'                           112
      L.'Q'                         &  -- 'q'                           113
      L.'R'                         &  -- 'r'                           114
      L.'S'                         &  -- 's'                           115
      L.'T'                         &  -- 't'                           116
      L.'U'                         &  -- 'u'                           117
      L.'V'                         &  -- 'v'                           118
      L.'W'                         &  -- 'w'                           119
      L.'X'                         &  -- 'x'                           120
      L.'Y'                         &  -- 'y'                           121
      L.'Z'                         &  -- 'z'                           122
      L.'{'                         &  -- '{'                           123
      L.'|'                         &  -- '|'                           124
      L.'}'                         &  -- '}'                           125
      L.'~'                         &  -- '~'                           126
      L.DEL                         &  -- DEL                           127
      L.Reserved_128                &  -- Reserved_128                  128
      L.Reserved_129                &  -- Reserved_129                  129
      L.BPH                         &  -- BPH                           130
      L.NBH                         &  -- NBH                           131
      L.Reserved_132                &  -- Reserved_132                  132
      L.NEL                         &  -- NEL                           133
      L.SSA                         &  -- SSA                           134
      L.ESA                         &  -- ESA                           135
      L.HTS                         &  -- HTS                           136
      L.HTJ                         &  -- HTJ                           137
      L.VTS                         &  -- VTS                           138
      L.PLD                         &  -- PLD                           139
      L.PLU                         &  -- PLU                           140
      L.RI                          &  -- RI                            141
      L.SS2                         &  -- SS2                           142
      L.SS3                         &  -- SS3                           143
      L.DCS                         &  -- DCS                           144
      L.PU1                         &  -- PU1                           145
      L.PU2                         &  -- PU2                           146
      L.STS                         &  -- STS                           147
      L.CCH                         &  -- CCH                           148
      L.MW                          &  -- MW                            149
      L.SPA                         &  -- SPA                           150
      L.EPA                         &  -- EPA                           151
      L.SOS                         &  -- SOS                           152
      L.Reserved_153                &  -- Reserved_153                  153
      L.SCI                         &  -- SCI                           154
      L.CSI                         &  -- CSI                           155
      L.ST                          &  -- ST                            156
      L.OSC                         &  -- OSC                           157
      L.PM                          &  -- PM                            158
      L.APC                         &  -- APC                           159
      L.No_Break_Space              &  -- No_Break_Space                160
      L.Inverted_Exclamation        &  -- Inverted_Exclamation          161
      L.Cent_Sign                   &  -- Cent_Sign                     162
      L.Pound_Sign                  &  -- Pound_Sign                    163
      L.Currency_Sign               &  -- Currency_Sign                 164
      L.Yen_Sign                    &  -- Yen_Sign                      165
      L.Broken_Bar                  &  -- Broken_Bar                    166
      L.Section_Sign                &  -- Section_Sign                  167
      L.Diaeresis                   &  -- Diaeresis                     168
      L.Copyright_Sign              &  -- Copyright_Sign                169
      L.Feminine_Ordinal_Indicator  &  -- Feminine_Ordinal_Indicator    170
      L.Left_Angle_Quotation        &  -- Left_Angle_Quotation          171
      L.Not_Sign                    &  -- Not_Sign                      172
      L.Soft_Hyphen                 &  -- Soft_Hyphen                   173
      L.Registered_Trade_Mark_Sign  &  -- Registered_Trade_Mark_Sign    174
      L.Macron                      &  -- Macron                        175
      L.Degree_Sign                 &  -- Degree_Sign                   176
      L.Plus_Minus_Sign             &  -- Plus_Minus_Sign               177
      L.Superscript_Two             &  -- Superscript_Two               178
      L.Superscript_Three           &  -- Superscript_Three             179
      L.Acute                       &  -- Acute                         180
      L.Micro_Sign                  &  -- Micro_Sign                    181
      L.Pilcrow_Sign                &  -- Pilcrow_Sign                  182
      L.Middle_Dot                  &  -- Middle_Dot                    183
      L.Cedilla                     &  -- Cedilla                       184
      L.Superscript_One             &  -- Superscript_One               185
      L.Masculine_Ordinal_Indicator &  -- Masculine_Ordinal_Indicator   186
      L.Right_Angle_Quotation       &  -- Right_Angle_Quotation         187
      L.Fraction_One_Quarter        &  -- Fraction_One_Quarter          188
      L.Fraction_One_Half           &  -- Fraction_One_Half             189
      L.Fraction_Three_Quarters     &  -- Fraction_Three_Quarters       190
      L.Inverted_Question           &  -- Inverted_Question             191
      L.UC_A_Grave                  &  -- UC_A_Grave                    192
      L.UC_A_Acute                  &  -- UC_A_Acute                    193
      L.UC_A_Circumflex             &  -- UC_A_Circumflex               194
      L.UC_A_Tilde                  &  -- UC_A_Tilde                    195
      L.UC_A_Diaeresis              &  -- UC_A_Diaeresis                196
      L.UC_A_Ring                   &  -- UC_A_Ring                     197
      L.UC_AE_Diphthong             &  -- UC_AE_Diphthong               198
      L.UC_C_Cedilla                &  -- UC_C_Cedilla                  199
      L.UC_E_Grave                  &  -- UC_E_Grave                    200
      L.UC_E_Acute                  &  -- UC_E_Acute                    201
      L.UC_E_Circumflex             &  -- UC_E_Circumflex               202
      L.UC_E_Diaeresis              &  -- UC_E_Diaeresis                203
      L.UC_I_Grave                  &  -- UC_I_Grave                    204
      L.UC_I_Acute                  &  -- UC_I_Acute                    205
      L.UC_I_Circumflex             &  -- UC_I_Circumflex               206
      L.UC_I_Diaeresis              &  -- UC_I_Diaeresis                207
      L.UC_Icelandic_Eth            &  -- UC_Icelandic_Eth              208
      L.UC_N_Tilde                  &  -- UC_N_Tilde                    209
      L.UC_O_Grave                  &  -- UC_O_Grave                    210
      L.UC_O_Acute                  &  -- UC_O_Acute                    211
      L.UC_O_Circumflex             &  -- UC_O_Circumflex               212
      L.UC_O_Tilde                  &  -- UC_O_Tilde                    213
      L.UC_O_Diaeresis              &  -- UC_O_Diaeresis                214
      L.Multiplication_Sign         &  -- Multiplication_Sign           215
      L.UC_O_Oblique_Stroke         &  -- UC_O_Oblique_Stroke           216
      L.UC_U_Grave                  &  -- UC_U_Grave                    217
      L.UC_U_Acute                  &  -- UC_U_Acute                    218
      L.UC_U_Circumflex             &  -- UC_U_Circumflex               219
      L.UC_U_Diaeresis              &  -- UC_U_Diaeresis                220
      L.UC_Y_Acute                  &  -- UC_Y_Acute                    221
      L.UC_Icelandic_Thorn          &  -- UC_Icelandic_Thorn            222
      L.LC_German_Sharp_S           &  -- LC_German_Sharp_S             223
      L.UC_A_Grave                  &  -- LC_A_Grave                    224
      L.UC_A_Acute                  &  -- LC_A_Acute                    225
      L.UC_A_Circumflex             &  -- LC_A_Circumflex               226
      L.UC_A_Tilde                  &  -- LC_A_Tilde                    227
      L.UC_A_Diaeresis              &  -- LC_A_Diaeresis                228
      L.UC_A_Ring                   &  -- LC_A_Ring                     229
      L.UC_AE_Diphthong             &  -- LC_AE_Diphthong               230
      L.UC_C_Cedilla                &  -- LC_C_Cedilla                  231
      L.UC_E_Grave                  &  -- LC_E_Grave                    232
      L.UC_E_Acute                  &  -- LC_E_Acute                    233
      L.UC_E_Circumflex             &  -- LC_E_Circumflex               234
      L.UC_E_Diaeresis              &  -- LC_E_Diaeresis                235
      L.UC_I_Grave                  &  -- LC_I_Grave                    236
      L.UC_I_Acute                  &  -- LC_I_Acute                    237
      L.UC_I_Circumflex             &  -- LC_I_Circumflex               238
      L.UC_I_Diaeresis              &  -- LC_I_Diaeresis                239
      L.UC_Icelandic_Eth            &  -- LC_Icelandic_Eth              240
      L.UC_N_Tilde                  &  -- LC_N_Tilde                    241
      L.UC_O_Grave                  &  -- LC_O_Grave                    242
      L.UC_O_Acute                  &  -- LC_O_Acute                    243
      L.UC_O_Circumflex             &  -- LC_O_Circumflex               244
      L.UC_O_Tilde                  &  -- LC_O_Tilde                    245
      L.UC_O_Diaeresis              &  -- LC_O_Diaeresis                246
      L.Division_Sign               &  -- Division_Sign                 247
      L.UC_O_Oblique_Stroke         &  -- LC_O_Oblique_Stroke           248
      L.UC_U_Grave                  &  -- LC_U_Grave                    249
      L.UC_U_Acute                  &  -- LC_U_Acute                    250
      L.UC_U_Circumflex             &  -- LC_U_Circumflex               251
      L.UC_U_Diaeresis              &  -- LC_U_Diaeresis                252
      L.UC_Y_Acute                  &  -- LC_Y_Acute                    253
      L.UC_Icelandic_Thorn          &  -- LC_Icelandic_Thorn            254
      L.LC_Y_Diaeresis);               -- LC_Y_Diaeresis                255

   Basic_Map : constant Character_Mapping :=
     (L.NUL                         &  -- NUL                             0
      L.SOH                         &  -- SOH                             1
      L.STX                         &  -- STX                             2
      L.ETX                         &  -- ETX                             3
      L.EOT                         &  -- EOT                             4
      L.ENQ                         &  -- ENQ                             5
      L.ACK                         &  -- ACK                             6
      L.BEL                         &  -- BEL                             7
      L.BS                          &  -- BS                              8
      L.HT                          &  -- HT                              9
      L.LF                          &  -- LF                             10
      L.VT                          &  -- VT                             11
      L.FF                          &  -- FF                             12
      L.CR                          &  -- CR                             13
      L.SO                          &  -- SO                             14
      L.SI                          &  -- SI                             15
      L.DLE                         &  -- DLE                            16
      L.DC1                         &  -- DC1                            17
      L.DC2                         &  -- DC2                            18
      L.DC3                         &  -- DC3                            19
      L.DC4                         &  -- DC4                            20
      L.NAK                         &  -- NAK                            21
      L.SYN                         &  -- SYN                            22
      L.ETB                         &  -- ETB                            23
      L.CAN                         &  -- CAN                            24
      L.EM                          &  -- EM                             25
      L.SUB                         &  -- SUB                            26
      L.ESC                         &  -- ESC                            27
      L.FS                          &  -- FS                             28
      L.GS                          &  -- GS                             29
      L.RS                          &  -- RS                             30
      L.US                          &  -- US                             31
      L.' '                         &  -- ' '                            32
      L.'!'                         &  -- '!'                            33
      L.'"'                         &  -- '"'                            34
      L.'#'                         &  -- '#'                            35
      L.'$'                         &  -- '$'                            36
      L.'%'                         &  -- '%'                            37
      L.'&'                         &  -- '&'                            38
      L.'''                         &  -- '''                            39
      L.'('                         &  -- '('                            40
      L.')'                         &  -- ')'                            41
      L.'*'                         &  -- '*'                            42
      L.'+'                         &  -- '+'                            43
      L.','                         &  -- ','                            44
      L.'-'                         &  -- '-'                            45
      L.'.'                         &  -- '.'                            46
      L.'/'                         &  -- '/'                            47
      L.'0'                         &  -- '0'                            48
      L.'1'                         &  -- '1'                            49
      L.'2'                         &  -- '2'                            50
      L.'3'                         &  -- '3'                            51
      L.'4'                         &  -- '4'                            52
      L.'5'                         &  -- '5'                            53
      L.'6'                         &  -- '6'                            54
      L.'7'                         &  -- '7'                            55
      L.'8'                         &  -- '8'                            56
      L.'9'                         &  -- '9'                            57
      L.':'                         &  -- ':'                            58
      L.';'                         &  -- ';'                            59
      L.'<'                         &  -- '<'                            60
      L.'='                         &  -- '='                            61
      L.'>'                         &  -- '>'                            62
      L.'?'                         &  -- '?'                            63
      L.'@'                         &  -- '@'                            64
      L.'A'                         &  -- 'A'                            65
      L.'B'                         &  -- 'B'                            66
      L.'C'                         &  -- 'C'                            67
      L.'D'                         &  -- 'D'                            68
      L.'E'                         &  -- 'E'                            69
      L.'F'                         &  -- 'F'                            70
      L.'G'                         &  -- 'G'                            71
      L.'H'                         &  -- 'H'                            72
      L.'I'                         &  -- 'I'                            73
      L.'J'                         &  -- 'J'                            74
      L.'K'                         &  -- 'K'                            75
      L.'L'                         &  -- 'L'                            76
      L.'M'                         &  -- 'M'                            77
      L.'N'                         &  -- 'N'                            78
      L.'O'                         &  -- 'O'                            79
      L.'P'                         &  -- 'P'                            80
      L.'Q'                         &  -- 'Q'                            81
      L.'R'                         &  -- 'R'                            82
      L.'S'                         &  -- 'S'                            83
      L.'T'                         &  -- 'T'                            84
      L.'U'                         &  -- 'U'                            85
      L.'V'                         &  -- 'V'                            86
      L.'W'                         &  -- 'W'                            87
      L.'X'                         &  -- 'X'                            88
      L.'Y'                         &  -- 'Y'                            89
      L.'Z'                         &  -- 'Z'                            90
      L.'['                         &  -- '['                            91
      L.'\'                         &  -- '\'                            92
      L.']'                         &  -- ']'                            93
      L.'^'                         &  -- '^'                            94
      L.'_'                         &  -- '_'                            95
      L.'`'                         &  -- '`'                            96
      L.'a'                         &  -- 'a'                            97
      L.'b'                         &  -- 'b'                            98
      L.'c'                         &  -- 'c'                            99
      L.'d'                         &  -- 'd'                           100
      L.'e'                         &  -- 'e'                           101
      L.'f'                         &  -- 'f'                           102
      L.'g'                         &  -- 'g'                           103
      L.'h'                         &  -- 'h'                           104
      L.'i'                         &  -- 'i'                           105
      L.'j'                         &  -- 'j'                           106
      L.'k'                         &  -- 'k'                           107
      L.'l'                         &  -- 'l'                           108
      L.'m'                         &  -- 'm'                           109
      L.'n'                         &  -- 'n'                           110
      L.'o'                         &  -- 'o'                           111
      L.'p'                         &  -- 'p'                           112
      L.'q'                         &  -- 'q'                           113
      L.'r'                         &  -- 'r'                           114
      L.'s'                         &  -- 's'                           115
      L.'t'                         &  -- 't'                           116
      L.'u'                         &  -- 'u'                           117
      L.'v'                         &  -- 'v'                           118
      L.'w'                         &  -- 'w'                           119
      L.'x'                         &  -- 'x'                           120
      L.'y'                         &  -- 'y'                           121
      L.'z'                         &  -- 'z'                           122
      L.'{'                         &  -- '{'                           123
      L.'|'                         &  -- '|'                           124
      L.'}'                         &  -- '}'                           125
      L.'~'                         &  -- '~'                           126
      L.DEL                         &  -- DEL                           127
      L.Reserved_128                &  -- Reserved_128                  128
      L.Reserved_129                &  -- Reserved_129                  129
      L.BPH                         &  -- BPH                           130
      L.NBH                         &  -- NBH                           131
      L.Reserved_132                &  -- Reserved_132                  132
      L.NEL                         &  -- NEL                           133
      L.SSA                         &  -- SSA                           134
      L.ESA                         &  -- ESA                           135
      L.HTS                         &  -- HTS                           136
      L.HTJ                         &  -- HTJ                           137
      L.VTS                         &  -- VTS                           138
      L.PLD                         &  -- PLD                           139
      L.PLU                         &  -- PLU                           140
      L.RI                          &  -- RI                            141
      L.SS2                         &  -- SS2                           142
      L.SS3                         &  -- SS3                           143
      L.DCS                         &  -- DCS                           144
      L.PU1                         &  -- PU1                           145
      L.PU2                         &  -- PU2                           146
      L.STS                         &  -- STS                           147
      L.CCH                         &  -- CCH                           148
      L.MW                          &  -- MW                            149
      L.SPA                         &  -- SPA                           150
      L.EPA                         &  -- EPA                           151
      L.SOS                         &  -- SOS                           152
      L.Reserved_153                &  -- Reserved_153                  153
      L.SCI                         &  -- SCI                           154
      L.CSI                         &  -- CSI                           155
      L.ST                          &  -- ST                            156
      L.OSC                         &  -- OSC                           157
      L.PM                          &  -- PM                            158
      L.APC                         &  -- APC                           159
      L.No_Break_Space              &  -- No_Break_Space                160
      L.Inverted_Exclamation        &  -- Inverted_Exclamation          161
      L.Cent_Sign                   &  -- Cent_Sign                     162
      L.Pound_Sign                  &  -- Pound_Sign                    163
      L.Currency_Sign               &  -- Currency_Sign                 164
      L.Yen_Sign                    &  -- Yen_Sign                      165
      L.Broken_Bar                  &  -- Broken_Bar                    166
      L.Section_Sign                &  -- Section_Sign                  167
      L.Diaeresis                   &  -- Diaeresis                     168
      L.Copyright_Sign              &  -- Copyright_Sign                169
      L.Feminine_Ordinal_Indicator  &  -- Feminine_Ordinal_Indicator    170
      L.Left_Angle_Quotation        &  -- Left_Angle_Quotation          171
      L.Not_Sign                    &  -- Not_Sign                      172
      L.Soft_Hyphen                 &  -- Soft_Hyphen                   173
      L.Registered_Trade_Mark_Sign  &  -- Registered_Trade_Mark_Sign    174
      L.Macron                      &  -- Macron                        175
      L.Degree_Sign                 &  -- Degree_Sign                   176
      L.Plus_Minus_Sign             &  -- Plus_Minus_Sign               177
      L.Superscript_Two             &  -- Superscript_Two               178
      L.Superscript_Three           &  -- Superscript_Three             179
      L.Acute                       &  -- Acute                         180
      L.Micro_Sign                  &  -- Micro_Sign                    181
      L.Pilcrow_Sign                &  -- Pilcrow_Sign                  182
      L.Middle_Dot                  &  -- Middle_Dot                    183
      L.Cedilla                     &  -- Cedilla                       184
      L.Superscript_One             &  -- Superscript_One               185
      L.Masculine_Ordinal_Indicator &  -- Masculine_Ordinal_Indicator   186
      L.Right_Angle_Quotation       &  -- Right_Angle_Quotation         187
      L.Fraction_One_Quarter        &  -- Fraction_One_Quarter          188
      L.Fraction_One_Half           &  -- Fraction_One_Half             189
      L.Fraction_Three_Quarters     &  -- Fraction_Three_Quarters       190
      L.Inverted_Question           &  -- Inverted_Question             191
      L.'A'                         &  -- UC_A_Grave                    192
      L.'A'                         &  -- UC_A_Acute                    193
      L.'A'                         &  -- UC_A_Circumflex               194
      L.'A'                         &  -- UC_A_Tilde                    195
      L.'A'                         &  -- UC_A_Diaeresis                196
      L.'A'                         &  -- UC_A_Ring                     197
      L.UC_AE_Diphthong             &  -- UC_AE_Diphthong               198
      L.'C'                         &  -- UC_C_Cedilla                  199
      L.'E'                         &  -- UC_E_Grave                    200
      L.'E'                         &  -- UC_E_Acute                    201
      L.'E'                         &  -- UC_E_Circumflex               202
      L.'E'                         &  -- UC_E_Diaeresis                203
      L.'I'                         &  -- UC_I_Grave                    204
      L.'I'                         &  -- UC_I_Acute                    205
      L.'I'                         &  -- UC_I_Circumflex               206
      L.'I'                         &  -- UC_I_Diaeresis                207
      L.UC_Icelandic_Eth            &  -- UC_Icelandic_Eth              208
      L.'N'                         &  -- UC_N_Tilde                    209
      L.'O'                         &  -- UC_O_Grave                    210
      L.'O'                         &  -- UC_O_Acute                    211
      L.'O'                         &  -- UC_O_Circumflex               212
      L.'O'                         &  -- UC_O_Tilde                    213
      L.'O'                         &  -- UC_O_Diaeresis                214
      L.Multiplication_Sign         &  -- Multiplication_Sign           215
      L.'O'                         &  -- UC_O_Oblique_Stroke           216
      L.'U'                         &  -- UC_U_Grave                    217
      L.'U'                         &  -- UC_U_Acute                    218
      L.'U'                         &  -- UC_U_Circumflex               219
      L.'U'                         &  -- UC_U_Diaeresis                220
      L.'Y'                         &  -- UC_Y_Acute                    221
      L.UC_Icelandic_Thorn          &  -- UC_Icelandic_Thorn            222
      L.LC_German_Sharp_S           &  -- LC_German_Sharp_S             223
      L.'a'                         &  -- LC_A_Grave                    224
      L.'a'                         &  -- LC_A_Acute                    225
      L.'a'                         &  -- LC_A_Circumflex               226
      L.'a'                         &  -- LC_A_Tilde                    227
      L.'a'                         &  -- LC_A_Diaeresis                228
      L.'a'                         &  -- LC_A_Ring                     229
      L.LC_AE_Diphthong             &  -- LC_AE_Diphthong               230
      L.'c'                         &  -- LC_C_Cedilla                  231
      L.'e'                         &  -- LC_E_Grave                    232
      L.'e'                         &  -- LC_E_Acute                    233
      L.'e'                         &  -- LC_E_Circumflex               234
      L.'e'                         &  -- LC_E_Diaeresis                235
      L.'i'                         &  -- LC_I_Grave                    236
      L.'i'                         &  -- LC_I_Acute                    237
      L.'i'                         &  -- LC_I_Circumflex               238
      L.'i'                         &  -- LC_I_Diaeresis                239
      L.LC_Icelandic_Eth            &  -- LC_Icelandic_Eth              240
      L.'n'                         &  -- LC_N_Tilde                    241
      L.'o'                         &  -- LC_O_Grave                    242
      L.'o'                         &  -- LC_O_Acute                    243
      L.'o'                         &  -- LC_O_Circumflex               244
      L.'o'                         &  -- LC_O_Tilde                    245
      L.'o'                         &  -- LC_O_Diaeresis                246
      L.Division_Sign               &  -- Division_Sign                 247
      L.'o'                         &  -- LC_O_Oblique_Stroke           248
      L.'u'                         &  -- LC_U_Grave                    249
      L.'u'                         &  -- LC_U_Acute                    250
      L.'u'                         &  -- LC_U_Circumflex               251
      L.'u'                         &  -- LC_U_Diaeresis                252
      L.'y'                         &  -- LC_Y_Acute                    253
      L.LC_Icelandic_Thorn          &  -- LC_Icelandic_Thorn            254
      L.'y');                          -- LC_Y_Diaeresis                255

end Ada.Strings.Maps.Constants;
