procedure display_menu (title:in string; options:in menus;
 choice:out alpha_numerics) is
left_column:constant:=15;
right_column:constant:=20;
prompt:constant string:=" ==> ";
 
type alpha_array is array(alpha_numerics) of boolean;
valid:boolean;
valid_option:alpha_array:=(others=>false);
 
procedure draw_menu(title:string;options:menus)is
begin
new_page;
new_line;
set_col(right_column);
put_line(title);
new_line;
for choice in alpha_numerics loop
if options(choice)/=empty_line then
valid_option(choice):=true;
set_col(left_column);
put(choice&" -- ");
put_line(options(choice));
end if;
end loop;
end draw_menu;
 
procedure get_response(valid:out boolean;choice:out alpha_numerics) is
buffer_size:constant:=20;
dummy:constant alpha_numerics:='X';
first_char:character;
buffer:string(1..buffer_size);
-- Notes
--
--
last:natural;
index:positive;
 
function upper_case(current_char:character)return character is
case_difference:constant:=16#20#;
begin
if current_char in 'a'..'z' then
return character'val (character'pos(current_char)-case_difference);
else
return current_char;
end if;
end upper_case;
 
begin -- get_response
 new_line;
set_col(left_column);
put(prompt);
get_line(buffer,last);
index:=positive'first;
loop
exit when((index>= lst) or else (buffer(index) in alpha_numerics));
index:=positive'succ(index);
end loop;
first_char:= upper_case(buffer(index));
if (first_char not in alpha_numerics) or
else(not valid_option(first_char)) then
valid:=false;
choice:=dummy;
elsevalid:=true;
 choice:=first_char;
end if;
end get_response;
 
procedure beep is
begin
put(ascii.bel);
end beep;
 
begin
loop
draw_menu(title,options);
get_response(valid,choice);
exit when valid;
beep;
end loop;
end display_menu;
 
