/************************************************************************/
/*    Procedure:	itime()						*/
/*    Purpose:		This routine is a rewrite of the itime routine  */
/*			in NYU AdaEd to allow for delays which are 	*/
/*			dependent on the machine clock cycle (pseudo	*/
/*			time), not real time				*/
/************************************************************************/

#include mon_ext.h

long itime()                             /*;itime*/
{
        long  itim;
        /* find elapsed seconds, convert to milliseconds, and add offset 
     *  for midnight corresponding to desired origin
     */
	if ( type_of_delay == 1 )
		start_time = 0;
        else
	{
        	clock_t time_now;
        	time_now = clock() * (long) ms_per_tick;
        	/* adjust for passing midnight if necessary */
        	if (time_now < start_time) time_now = time_now + 86400000L ;
        	itim =   (long) (time_now - start_time);
        	return itim + since_midnight;
	}
}
