;-------------------------------------------
;     From: Mark Anderson
;  Subject: Random # Generator

      DOSSEG
      .MODEL SMALL
      .STACK 1000h

      .DATA

wRandNum        dw ?
wMaxNum         dw 100h ;random numbers will be from 1 to 100h
rand16num       dw ?    ;16 bit random number.. produced by rand16
seeded          db 0    ;<>0 if random # generator already seeded

      .CODE

entpt:

main  proc near   ;dummy program.. just loops producing numbers
                  ;run in debugger only
      mov ax,@data
      mov ds,ax
@@:
      call rand   ;random number in wRandNum
      jmp @b

main  endp


rand  proc near   ;puts random number in wRandNum (1<=wRandNum<=wMaxNum)

      call rand16 ;16 bit random number in ax

      ;xor the number w/ the clock.  Not really necessary, but doesn't hurt.
      push ax
      call get_clock    ;another "random" number in ax
      pop dx
      xor ax,dx         ;ax even a bit more random

      ;size the random number
      xor dx,dx         ;msw of dividend = 0, lsw in ax
      mov cx,wMaxNum    ;divisor in cx
      mov wRandNum,cx   ;in case it's zero
      jcxz @f           ;don't divide by zero
      div cx            ;remainder in dx
      inc dx            ;so that min is 1, max is wMaxNum
      mov wRandNum,dx   ;save random number
@@:
      ret

rand endp


rand16  proc near      ;returns 16 bit random number in ax and in rand16num

      ;seed the generator if it's the 1st time thru
      cmp seeded,0
      jne @f
      call get_clock   ;seed in ax
      mov rand16num,ax ;save it
      mov seeded,1     ;set flag indicating that rand16 is seeded

@@:
      ;r(n+1) = (25173*r(n)+13849)mod 65536.. a magic formula.  See Knuth.
      mov ax,rand16num
      mov cx,25173      ;magic number
      mul cx            ;product in dx:ax
      add ax,13849      ;another magic number
      mov rand16num,ax  ;save new random number
      ret

rand16  endp


get_clock   proc near   ;returns "random" number in ax, based on clock

        xor ah,ah
        int 1ah         ;clock in cx:dx

        mov bx,dx
        xor bx,cx       ;part 1 of seed in bx

        mov cl,dl       ;rotate up to 15 bits
        and cl,0fh      ;mask top bits
        ror bx,cl       ;rotate part 1 of seed

        mov ah,02
        int 1ah         ;date/time in dx:cx

        mov ax,dx
        xor ax,cx
        mov cl,dh
        and cl,0fh      ;mask top bits
        ror ax,cl       ;rotate part 2 of seed

        xor ax,bx       ;xor parts 1 and 2 of seed
        ret

get_clock   endp

      end  entpt


