;------------------------------
; From: "John A. Slagel" <jas37876@uxa.cso.uiuc.edu>
;Subject: Fixed point sqrt anyone?

     Here is how I do it.  This is in Microsoft C inline assembler.
This just keeps iterating till it finds the root within 1 digit.  If
you want more speed, change the '2' to something higher, but that will
decrease accuracy.  This is fast!


#include <stdio.h>

int int_sqrt( int c )
{
        _asm {
        mov     cx, 1
        mov     bx, c
        jmp     skip_iterate

iterate:
        mov     ax, cx
        sub     ax, bx   ; AX = x - y
        cwd
        xor     ax, dx
        sub     ax, dx  ; AX = abs( AX )
        cmp     ax, 2   ; 2 is the allowed error * 2,
                        ; so we're getting within 1.
        jl      done    ; if abs(x-y) > 2 then goto done
skip_iterate:
        mov     ax, cx
        add     ax, bx
        shr     ax, 1
        mov     cx, ax   ; x = (x+y)/2
        cwd
        mov     ax, c
        idiv    cx
        mov     bx, ax   ; y = c / x
        jmp     iterate

done:
        mov     ax, cx
        add     ax, bx
        shr     ax, 1
        mov     c, ax
        }
        return c;
}

main()
{
        int i=32000, j, k;
        printf( "%d \n", int_sqrt( i ) );
        return 0;
}

