TITLE   Exec call test
PAGE    60,132

;  This program demonstrates shelling to DOS command processor
;  using the EXEC funtion.
;  Assemble, link and convert to a .COM file.
;  Program written by Brian M. Markey

; Toad Hall Tweak, 30 Jun 88
; - Accepts up to 125 chars at regular DOS command line.
; - If no DOS command line, defaults to COMMAND.COM shell
;       (EXIT to exit).
; - Otherwise execs any .COM, .EXE, .BAT file via COMMAND.COM,
;       returns Exec result as ERRORLEVEL.
; - tightened code in general.
; - still assumes COMMAND.COM is in C:\
; - no decent error trapping yet (e.g., insufficient memory,
;       file not found, etc.)
;
; David Kirschbaum
; Toad Hall
; kirsch@braggvax.ARPA
; [now kirschd@sesi.com  Boy, this is old code :-)]

CR      equ     0DH
LF      equ     0AH

CSeg    SEGMENT 'CODE'
        ASSUME  CS:CSeg,DS:CSeg,ES:CSeg

        org     2CH
envaddr dw      ?                               ;Environment address

        org     80H                             ;PSP cmd line [TH]
PSPcmdline      db      ?

        ORG     100H                            ; Program entry point
ExecTest:

        MOV     SP,OFFSET stack                 ; Set up local stack

        MOV     DX,OFFSET mess1                 ;'Before shell'
        MOV     AH,9                            ;display string
        INT     21H

        MOV     BX,OFFSET lastloc+15            ; BX := program size in
        MOV     CX,4                            ;  paragraphs
        SHR     BX,CL                           ;requested memory in paras

        MOV     ah,4AH                          ;TH  Deallocate unused memory
        INT     21H

        mov     ax,envaddr                      ;TH get environment addr
        MOV     parmblk,AX                      ;stuff in parameter block

        MOV     AX,CS                           ; Set segment registers
        MOV     parmblk+4,AX                    ;  in parameter block
        MOV     parmblk+8,AX                    ; to our Code Seg
        MOV     parmblk+12,AX

;TH move PSP command line into our own working buffer
        mov     si,offset PSPcmdline            ;point to PSP cmd line
        mov     di,offset comline               ;point to 
our own cmd line buff
        xor     ax,ax                           ;insure msb is clear
        cld                                     ;insure fwd
        lodsb                                   ;snarf cmd line length byte
        or      ax,ax                           ;anything there?
        je      NoCmd                           ; nope, use default
        mov     cx,ax                           ;into cx as a counter
;TH si now points to first char of PSP cmd line
        inc     ax                              ;+2 for '/C' already there
        inc     ax
        stosb                                   ;force working cmd line len
        inc     di                              ;bump past "/C"
        inc     di
        rep     movsb                           ;transfer cmd line
NoCmd:
;end of Toad Hall code

        MOV     DX,OFFSET filenam               ;DS:DX = program name
        MOV     BX,OFFSET parmblk               ;ES:BX = control block
        MOV     AX,4B00H                        ;service 0, exec

        PUSH    DS                              ; Save machine state
        PUSH    ES
        mov     savess,SS                       ;TH
        mov     savesp,SP                       ;TH
        INT     21H                             ; Shell to DOS

;TH seem to recall something about disabling interrupts
; before fiddling these registers, but can't remember just what!
; Seems to work ok, so will leave it be for now.

        MOV     SP,CS:savesp                    ; Restore machine state
        MOV     SS,CS:savess
        POP     ES
        POP     DS
        mov     bx,ax                           ;TH save any errors

        MOV     DX,OFFSET mess2                 ;'After shell'
        MOV     AH,9                            ;display string
        INT     21H

        mov     ax,bx                           ;TH restore any errors
        mov     ah,4CH                          ;TH terminate process
        int     21H

savess  DW      ?                               ; Holders for SS:SP
savesp  DW      ?

mess1   DB      'Before shell',CR,LF,'$'
mess2   DB      'After shell',CR,LF,'$'

filenam DB      'C:\COMMAND.COM',0              ; Assume COMMAND.COM on C:

        Even                                    ;TH for faster access?

parmblk DW      00                              ; Parameter block
        DW      OFFSET comline,00
        DW      5CH,00
        DW      6CH,00

;TH default is just COMMAND.COM
comline db      17                              ;TH default cmd length
        db      '/C C:\COMMAND.COM',CR          ;TH default: Exec COMMAND.COM

COMLEN  =       $ - offset comline              ;TH

        db      128-comlen DUP(0)               ;TH up to 128 bytes

        DB      128  DUP (?)                    ; Stack
stack   LABEL   BYTE

lastloc LABEL   BYTE                            ; End of program

CSeg    ENDS
        END     ExecTest

