;
; EMS system implemented by
;
; David Lindauer
;
; gclind01@ulkyvx.louisville.edu
;
; August, 1995 
;
; As part of the FREE-DOS project
;
;
; Checks.asm
;
; Function: Make sure the system is a 386, not in protected mode
;
; Code in this file is in the DISCARD segment so it can't be called
; once the program becomes a TSR or a DRIVER
;
	.386p
include segs.asi
include xmsctl.asi
include ems.asi

	public	checksys

seg386	SEGMENT
	extrn	xmsboot : PROC, grabEMSmem : PROC
seg386	ENDS

absdata	segment
	org	EMSINT*4
emsvect	dd	?
absdata	ends

DiscardSeg	segment
	assume	cs:dgroup,ds:dgroup
mnot386	db	"This program requires a 386 CPU",10,13,'$'
mnoxms	db	"XMS not available",10,13,'$'
mbadxms	db	"XMS version too low",10,13,'$'
mprotect db	"CPU is already in protected mode",10,13,'$'
mnoems	db	"EMS is already loaded",10,13,'$'
minstalled db	"emu86 installed",10,13,'$'
mdosv	db	"Dos version 3.10 required",10,13,'$'
mnoxmsmem db	"Can't allocate memory from XMS",10,13,'$'
not386:
	mov	dx,offset dgroup:mnot386
	jmp	short perr
noxms:
	mov	dx,offset dgroup:mnoxms
	jmp	short perr
noxmsmem:
	mov	dx,offset dgroup:mnoxmsmem
	jmp	short perr
xmstoolow:
	mov	dx,offset dgroup:mbadxms
	jmp	short perr
isprotected:
	mov	dx, offset dgroup:mprotect
	jmp	short perr
nodosv:	mov	dx,offset dgroup:mdosv
	jmp	short perr
noems:
	mov	dx,offset dgroup:mnoems
perr:
	mov	ah,9		; Function to draw a message
	int	21h		; Do it
	mov	ax,4c01h	; Function to exit with error
	int	21h		; Do it
;
; Check for 386, not protected mode
; Check for XMS 2.0 or better
; Check for EMS, it better not exist
;
	xmsbase = bp-4
checksys	proc
	mov	ah,30h			; Get DOS version
	int	21h			;
	cmp	al,3			; Must be 3.10 or greater
	jc	nodosv			;
	cmp	ah,10			;
	jc	nodosv			;
	push	es			;
	push	bp			;
	mov	bp,sp   		; BP = stack frame
	sub	sp,4   			; Make space for local vars
	call	get_cpu			; Get the CPU type
	cmp	ax,3			; Is it a 386 or better?
	jc	not386			; Nope, error
	smsw	ax			; Get CR0
	shr	ax,1            	; Check PE bit
	jc	isprotected		; Error if in protected mode
	mov	ax,XMSINSTALLCHECK	; Check for XMS installed
	int	MULTIPLEX		; By calling multiplex int
	cmp	al,XMSISINSTALLED	; See if installed
	jnz	short noxms    	; Nop, can't go on
	mov	ax,XMSGETHOOK		; Get base XMS vector
	int	MULTIPLEX
	mov	word ptr [xmsbase],bx  	; Save XMS base address for calling
	mov	word ptr [xmsbase+2],es	;
	mov	ax,XMS_VERSION		; Command to get XMS version
	call	dword ptr [xmsbase]	; Call XMS handler
	cmp	bh,MINXMSVERSION	; See if version high enough
	jc	xmstoolow		; Nope, error
	sub	ax,ax			; Get int seg
	mov	es,ax			;
	mov	ax,word ptr es:[emsvect]; See if any EMS vector
	or	ax,word ptr es:[emsvect+2];
	jz	getout			; Nope, passed all tests
	mov	ah,EMS_STATUS		; EMS Get Status command
	mov	al,0ffh			; AL = FF, if EMS exists it
					; will be changed
	int	EMSINT			; EMS trap
	inc	al
	jnz	noems
	call	xmsboot			; boot up XMS handler
	jc	noxmsmem                ; Quit if error
	call	GrabEMSMem		; Grab mem for EMS
	jc	noxmsmem		; Quit if error

getout:
	mov	dx,offset dgroup:minstalled     ; Tell them it's installed,
	mov	ah,9			; even though we haven't
	int	21h			; started the installation yet
	mov	sp,bp
	pop	bp
	pop	es
	ret
checksys	endp
;------------------------------------------------------------------------------
;
; Determine CPU type
;
; Returns:
;	AX = 1 -> 8086	(flags MSD always F)
;	AX = 2 -> 80286	(flags MSD always 0)
;	AX = 3 -> 80386	(flags MSD changable)
;
get_cpu	proc	near
	mov	bx,1		; assume 8086
	pushf			; save	original flags

	pop	ax
	push	ax		; AX = original flags
	and	ax,0FFFh	; clear bits 15..12
	push	ax
	popf
	pushf
	pop	ax		; AX = modified flags
	and	ax,0F000h	; clear 3 LSDs
	cmp	ax,0F000h	
	je	got_cpu_type

	inc	bx		; = 2 (try 286)
	pop	ax
	push	ax		; AX = original flags
	or	ax,0F000h	; try to set bits 15..12
	push	ax
	popf
	pushf
	pop	ax		; AX = modified flags
	and	ax,0F000h	; are any MSD bits set?
	jz	got_cpu_type	; if not, its a 286

	inc	bx		; if so, we have a 386 ( = 3)
got_cpu_type:
	popf			; restore original flags
	mov	ax,bx
	ret
get_cpu	endp
DiscardSeg	Ends
	end