 32nd order primitive polynomial modulo 2 random function.
 
  Every primitive polynomial modulo 2 of order `N' defines a recurrence
 relation for obtaining a new random bit from the `N' preceding ones. The
 recurrence relation is guarded to produce a sequence of maximal length,
 i.e. cycle through all possible sequences of `N' bits (except all zeros)
 before it repeats. Therefore one can seed the sequence with any initial
 bitpattern (except all zeros), and get 2^N-1 random bits before the
 sequence repeats.
 
  This RandBit function will return 22-1 (4,294,967,295) random bits 
 before it will repeat any sequence of 32bits.
 
  I chose to return the bits in CF, this aids in usage right after the CALL
 and doesn't destroy any general purpose regs.
 
  I would enjoy seeing any modifications made to this routine, especialy in 
 the area of optimization (size OR speed). I do know using BT to test for 
 bit31 is smaller than TEST, but it isn't faster (at least on 386's)
 
;--------------------------------------------------------------------------
; Coded by Joe Koss (Shades/2O3)
 
rbseed  dd 5a4b3c2dh   ; seeding it with the high resolution timer 
                       ; might be a good idea... *NOTE* Seed cannot be 0
 
proc    randbit                 ;                             386 timings
        push eax                ; 386+ required                    2
        mov eax, [cs:rbseed]    ; EAX = seed                       4
        test eax, 80000000h     ; is bit31 = [0] or [1] ?          2
        jz @@FALSE              ;                                 9/3
@@TRUE: xor eax, 57h            ; [1] XOR bits 6, 4, 2, 1, and 0   2
@@FALSE:rol eax, 1              ; [0] & [1] roll seed and set CF   3
        mov [cs:rbseed], eax    ; seed = EAX                       2
        pop eax                 ;                                  4
        ret                     ;                              
endp    randbit                 ;                        
                                ;                                    
;--------------------------------------------------------------------------
