; SEEPORTS.ASM

comment #

SEEPORTS.DOC

What is SEEPORTS?

        This simple program is a pop-up TSR that reports the current
settings of your serial ports ( baud rate, data bits, parity, etc ).
Since SEEPORTS is resident, it can be extremely useful if you are
debugging communications H/W or S/W, or if you are just curious
how your ports are getting set by such software. This TSR should
work fine with other well behaved TSRs, but you probably won't have
a reason to use it frequently (don't bother putting it in your
AUTOEXEC.BAT unless telecommunications is all you ever do).

        To load the program just type the name, such as

        C> SEEPORTS  <return>

The HOT-KEYs that pop up the status display are ALT-1 (for COM1),
or ALT-2 (for COM2). If you have only COM1, then the ALT-2 hot-key
is ignored.

        The status display is a simple one-line display at the very
top of the screen. It is self-explanatory. To remove the status line
and restore the original screen line, just press the same hot-key
again. You may also just let the status line scroll off the screen.

     This utility is FREE. If you have an need to see COM3 or COM4,
or just want to comment, you can reach the authors at
        PCCBBC P.O. Box 3501 Warrenton, Va. 22186.
#

cseg        segment
        assume cs:cseg,ds:cseg
        org 100h
start:
        jmp initialize

old_keyboard_io dd 0,0

        assume ds:nothing
new_keyboard_io         proc        far
        sti
        cmp        ah,0
        je        ksread
        jmp        old_keyboard_io
ksread:
        call        keyread
        iret
new_keyboard_io                endp

keyread                proc         near
        push        si
readchar:
        pushf
        call old_keyboard_io
        cmp        al,0
        je        extended
        jmp        readdone
extended:
        mov        si,offset keytab
nextext:
        cmp        byte ptr cs:[si],0
        je        readdone
        cmp        ah,cs:[si]
        je        startexpand
        add        si,3
        jmp        nextext
startexpand:
        add        si,1
        cmp        word ptr cs:[si],0
        je        readdone
        push        ax
        push        bx
        push        cx
        push        dx
        push         si
        push        di
        push        bp
        push        ds
        and     ah,1
        add        ah,ah
        mov        bl,ah
        mov        bh,04
        mov        ax,0000
        mov        ds,ax
        cmp     word ptr [bx],0
        je        skip
        mov        bl,49h
        mov        ax,0b800h
        cmp     byte ptr [bx],7
        jne        other1
        mov        ax,0b000h
other1: mov        cs:vaddr,ax
        call         word ptr cs:[si]
skip:        pop        ds
        pop        bp
        pop        di
        pop        si
        pop        dx
        pop        cx
        pop        bx
        pop        ax
readdone:
        pop        si
        ret
keyread                endp

keytab        db        120                ; alt-1
        dw        port1status
        db        121                ; alt-2
        dw        port2status
        db        0
        dw        0
toggle  db        0

        assume        cs:cseg,ds:cseg

port1status        proc near
        mov        bx,cs
        mov        ds,bx
        mov        dh,3
        call         portstatus
        ret
port1status        endp

port2status        proc near
        mov        bx,cs
        mov        ds,bx
        mov        dh,2
        call         portstatus
        ret
port2status        endp


portstatus        proc near
        push        bx
        call        getpos
        push        bx
        mov        bx,0
        call         setpos
doshow: cmp        toggle,dh        ; same as last hot key?
        jne        newinfo                ; no then skip
        call    restore98        ; else try to restore your data
        jnz        newinfo         ; unless screen has scrolled.
        mov        toggle,0        ; if restored, just clear hot-key toggle
        jmp        bye
newinfo:
        call        save98                ; captures if its your data
        mov        toggle,dh
        call         showcom
        call        showbaud
        call        showlen
        call        showstop
        call        showparity
bye:
        pop        bx
        call        setpos
        pop        bx
        ret
portstatus        endp

pad        db        98 dup(32)
signat        db        ' bits/char, '

save98        proc near
        push        ax
        push        bx
        push        es
        push        di
        mov        ax,vaddr
        mov        es,ax
        mov        di,36
        mov        bx,0
qchk:        mov        ah,es:[di]
        cmp        ah,signat[bx]
        jne        sok
        inc        di
        inc        di
        inc        bx
        cmp        bx,12
        jne        qchk
        jmp        sdone
sok:        mov        di,0
        mov        bx,0
sloop:        mov        ah,es:[di]
        mov        pad[bx],ah
        inc        bx
        inc        di
        cmp        bx,98    ; 98 bytes yet?
        jne        sloop
sdone:        pop        di
        pop        es
        pop        bx
        pop        ax
        ret
save98        endp


restore98        proc near
        push        ax
        push        bx
        push        es
        push        di
        mov        ax,vaddr
        mov        es,ax
        mov        di,36
        mov        bx,0
sigchk:        mov        ah,es:[di]
        cmp        ah,signat[bx]
        jne        rdone
        inc        di
        inc        di
        inc        bx
        cmp        bx,12
        jne        sigchk
        mov        di,0
        mov        bx,0
rloop:        mov        ah,pad[bx]
        mov        es:[di],ah
        inc        bx
        inc        di
        cmp        bx,98    ; 98 bytes yet?
        jne        rloop
rdone:        pop        di
        pop        es
        pop        bx
        pop        ax
        ret
restore98        endp


        dec        cx


com1        db        'COM1: ',0
com2        db        'COM2: ',0
comtab        dw        com1
        dw        com2
        dw        0


showcom                proc near
        push        bx
        push        dx
        push        si
        mov        bh,0
        mov        bl,3
        sub        bl,dh
        shl        bx,1
        mov        si,comtab[bx]
        call        dstring
        pop        si
        pop        dx
        pop        bx
        ret
showcom                endp

vaddr        dw        0000h
b110        db        ' 110 baud, ',0
b300        db        ' 300 baud, ',0
b1200        db        '1200 baud, ',0
b2400        db        '2400 baud, ',0
b4800        db        '4800 baud, ',0
b9600        db        '9600 baud, ',0

divtab        dw        1047
        dw        384
        dw        96
        dw        48
        dw        24
        dw        12
        dw        0

baudtab dw        b110
        dw        b300
        dw        b1200
        dw        b2400
        dw        b4800
        dw        b9600
        dw        0

showbaud        proc near
        push        di
        push        si
        push        bx
        call         getbaud
        mov        di,0
baudloop:
        cmp        divtab[di],0
        je        bldone
        cmp        bx,divtab[di]
        je        dbaud
        add        di,2
        jmp        baudloop
dbaud:
        mov        si,baudtab[di]
        call        dstring
bldone:
        pop        bx
        pop        si
        pop        di
        ret
showbaud        endp


getbaud                proc near
        push        ax
        push        dx
        mov        dl,0fbh
        in        al,dx
        push        ax
        or         al,80h
        out        dx,al
        mov        dl,0f8h
        in        al,dx
        mov        bl,al
        mov        dl,0f9h
        in         al,dx
        mov        bh,al
        pop        ax
        mov        dl,0fbh
        out        dx,al
        pop        dx
        pop        ax
        ret
getbaud        endp


char7        db        '7 bits/char, ',0
char8        db        '8 bits/char, ',0
chartab        dw        char7
        dw        char8
        dw         0

showlen        proc near
        push        ax
        push        bx
        push        si
        call        getlen
        shl        bx,1
        mov        si,chartab[bx]
        call        dstring
        pop        si
        pop        bx
        pop        ax
        ret
showlen        endp


getlen        proc near
        push        ax
        push        dx
        mov        dl,0fbh
        in         al,dx
        and        al,03h
        mov        bh,0
        mov         bl,al
        sub        bx,2
        pop        dx
        pop        ax
        ret
getlen        endp


stop1        db        '1 stop, ',0
stop2        db        '2 stop, ',0
stoptab        dw        stop1
        dw        stop2
        dw        0

showstop        proc near
        push        bx
        push        si
        call        getstop
        dec        bx
        shl        bx,1
        mov        si,stoptab[bx]
        call        dstring
        pop        si
        pop        bx
        ret
showstop        endp

getstop                proc        near
        push        ax
        push        dx
        mov        bx,1
        mov        dl,0fbh
        in        al,dx
        and        al,04h
        cmp        al,0
        je        gsdone
        inc        bx
gsdone:
        pop        dx
        pop        ax
        ret
getstop                endp

pnone        db        'no parity  ',0
podd        db        'odd parity ',0
peven        db        'even parity',0
partab        dw        pnone
        dw        podd
        dw        peven
        dw        0

showparity        proc        near
        push        bx
        push        si
        call        getparity
        shl        bx,1
        mov        si,partab[bx]
        call        dstring
        pop        si
        pop        bx
        ret
showparity        endp

getparity        proc        near
        push        ax
        push        cx
        push        dx
        mov        bx,0
        mov        dl,0fbh
        in        al,dx
        and        al,18h
        cmp        al,00h
        je        gpdone
        cmp        al,10h
        je        gpdone
        inc        bx
        cmp        al,18h
        jne        gpdone
        inc        bx
gpdone:
        pop        dx
        pop        cx
        pop        ax
        ret
getparity        endp


getpos        proc        near
        push        ax
        push        cx
        push        dx
        mov        ah,03h
        mov        bh,0
        int        10h
        mov        bx,dx
        pop        dx
        pop        cx
        pop        ax
        ret
getpos        endp

setpos        proc        near
        push        ax
        push        bx
        push        dx
        mov        ah,02h
        mov        dx,bx
        mov        bh,0
        int         10h
        pop        dx
        pop        bx
        pop        ax
        ret
setpos        endp


dstring        proc near
        push        si
        push        ax
        cmp        si,0
        je        dsdone
dloop:
        mov        al,[si]
        cmp        al,0
        je        dsdone
        call        dchar
        inc        si
        jmp        dloop
dsdone:
        pop        ax
        pop        si
        ret
dstring        endp


dchar        proc near
        push        ax
        push        bx
        mov        bh,1
        mov        ah,0eh
        int         10h
        pop        bx
        pop        ax
        ret
dchar        endp


; CODE BEGINS

initialize:
        assume        cs:cseg,ds:cseg
        mov        bx,cs
        mov        ds,bx
        mov        al,16h
        mov        ah,35h
        int         21h
        mov        word ptr cs:old_keyboard_io,bx
        mov        word ptr cs:old_keyboard_io[2],es
        mov        dx,offset cs:new_keyboard_io
        mov        al,16h
        mov        ah,25h
        int         21h
        mov        dx,offset initialize
        int         27h
cseg        ends
        end        start

