; Julian Schmidt                                          1:273/911

;Here's a program that will zoom a colored bar around the screen
; (changing colors occasionally).  It won't overwrite text that's already
; present on the screen.  So, do a dir/w or something to fill the screen
; with text, then run this program.
 
     .MODEL    SMALL
     .CODE
     ORG       100H
 Num         equ    40                ;Length of the colored bar.
 DelayTime   equ    6000              ;Slows things down...
 Program:

 ;First, check the current video display mode.  If it's not
 ;  mode 02h or 03h, terminate the program.

     mov    ah,0fh        ;Request Function 0Fh.
     int    10h           ;Bios's Get Current Display Mode.
     cmp    al,3          ;Is the system in mode 03h?
     je     OK            ;If so, start the program.
     cmp    al,2          ;Is it video (text) mode 02h?
     je     OK
     jmp    short   Exit  ;Non-supported video mode.

 ;Video refresh buffer segment address is b800h.
 ;Bits 4, 5, and 6 of the attribute byte control the
 ;  background color.  Background colors are as follows:
 ;  1 blue   2 green   3 cyan   4 red   5 magenta   6 brown

 OK:
     mov    ax,0b800h           ;segment address of video mem.
     mov    ds,ax               ;Set up my data segment.
     mov    bx,1                ;this points into video mem.
     mov    cx,80*25            ;CX is the loop counter.
     mov    ah,00000111b        ;This is white on black text.
 ClearLoop:       ;Sets every screen position to attribute 7.
     mov    byte ptr[bx],ah     ;Set the attribute byte.
     add    bx,2                ;Go to the next attribute byte.
     loop   ClearLoop           ;Loop through the 80*25 screen.

 ;Now, the entire screen should be white text/black background.

     mov    dh,23               ;DH will store the color.(23=blue)
 Cycle:
     mov    bx,1                ;Pointer into video memory.
     mov    cx,Num              ;This will be a loop counter.
 ColorLoop:
     mov    byte ptr[bx],dh     ;poke the attribute into video mem.
     add    bx,2                ;Point to next attrib. byte.
     loop   ColorLoop           ;Put the colored bar on screen.
 MoveBar:
     sub    bx,2*Num            ;Go to beginning of the bar.
     mov    byte ptr[bx],7      ;Change back to white on black.
     cmp    bx,4000             ;End of the screen?
     jae    NextColor
     add    bx,(2*Num)+2        ;Go to front of the bar.
     mov    byte ptr[bx],dh     ;Add a character to front of bar.
     mov    ah,01h              ;Request function 01h.
     int    16h                 ;Bios's Read Keyboard Character.
     jnz    Exit                ;If user pressed a key, quit...
     mov    cx,DelayTime
 Delay:     loop    Delay       ;Slow things down so bar is visible.
     jmp    short   MoveBar
 NextColor:
     add    dh,16               ;change to the 'next' color.
     cmp    dh,103              ;103 is the 'last' color I want to use.
     jle    Cycle               ;Start anew!
     mov    dh,23               ;Start back at blue!
     jmp    short   Cycle
 Exit:
     xor    ax,ax               ;Request function 00h.
     int    16h                 ;Clear Keyboard Buffer.
     mov    ax,4c00h
     int    21h                 ;Exit to DOS
     END    Program

