	page 60,132
        title   PUTS - A String + CR/LF Printing Procedure
        name    PUTS
comment 
        PUTS                                                    V1.00
==========================================================================
NAME
        PUTS - A String + CR/LF Printing Procedure

SYNOPSIS
        mov     ax, seg STRING          ; Only if STRING not in current DS
        mov     ds, ax                  ;  Segment
        mov     dx, offset STRING
        call    Puts

DESCRIPTION
        This procedure prints the passed ASCIIZ string, DS:DX, to stdout.
        Then adds a CR/LF pair so that the cursor is at the start of the
        next line on the screen.

CAUTIONS
        Must be an ASCIIZ string.

RETURNS
	Nothing

PROGRAMMING NOTES
        Assembled with Microsoft MASM 6.11d.  Written to link with any
        memory model.

REGISTER USAGE
        Small Data Memory Models:
        AX, BX, CX, DX and DI.

        Additional registers used in Large Data Memory Models:
        ES.  ES register is preserved.

MEMORY REQUIREMENTS
	(in bytes)     Tiny   Small  Compact   Medium	Large	Huge
        Code:            17     17       17       19      19     19
	_Data:		  0	 0	  0	   0	   0	  0
        Const:            2      2        2        2       2      2
	_BBS:		  0	 0	  0	   0	   0	  0
        Stack:            2      2        2        4       4      4

EXTERNAL LIBRARIES
        Print           Alib?

EXTERNAL PROCEDURES
	None

INTERRUPTS CALLED
	Int 21h Function 40h - Write File or Device

GLOBAL NAMES
        Puts            Procedure
        sCRLF           Data

AUTHOR
        Raymond Moon - 6 Oct 95
	Copyright (c) 1995, MoonWare
	ALL RIGHTS RESERVED

HISTORY
	Version	- Date		- Remarks
        1.00    -  6 Oct 95     - Orginal

==========================================================================
	 Comment End
	
;-----------------------------
;       Make the small memory model the default

ifndef	memmod
memmod	equ	<small>
endif

;-----------------------------
;       Include the processor, memory model, associate ES register with
;	DGROUP, and specify DOS segment order.

	include procesor.inc
%	.MODEL	memmod,FORTRAN
	assume	es:DGROUP

;-----------------------------
;       Include files

        include lib.inc

;=========================================================================
;	DATA
;=========================================================================
;       Declare any required data

	.CONST
        public sCRLF

sCRLF   db      10, 13

;=========================================================================
;	CODE
;=========================================================================
;       Start CODE segment and define PUTS procedure

	.CODE

Puts    proc

;----------------------------
;       Call PRINT to print string

        call    Print                   ; Call Print to dislay the passed
                                        ;  ASCIIZ string

;----------------------------
;       Print CRLF

        mov     ah, 40h                 ; Write File or Device
        mov     bx, 1                   ; BX = STDOUT
        mov     cx, sizeof sCRLF        ; CX = string length
        mov     dx, offset sCRLF        ; DX => sCRLF
        int     21h                     ; Call DOS

;----------------------------
;       Return.  Restoring AX register.

	ret				; Return

Puts    endp
	end
