
#include "stdio.h"
#include "term.h"

char progname[] = "termansi";

main()
	{
	register int c;

	while( !feof( stdin ))
		{
		c = getchar();
		switch( c )
			{
			case ESCAPE:
				getpc();
				break;
			case EOF:
				break;
			default:
				putchar( c );
				break;
			}
		}
	}

getpc()
	{
	register int c;

	c = getchar();
	switch( c )
		{
		case ROMAN:
			roman();
			break;
		case ITALIC:
			italic();
			break;
		case BOLD:
			bold();
			break;
		case HALFUP:
			halfup();
			break;
		case HALFDOWN:
			halfdown();
			break;
		default:
			fprintf( stderr, "%s:  unrecognized output escape sequence ESC-0x%x \n", progname, c );
			break;
		}
	}

roman()
	{
	printf( "\033[0m" );
	}

italic()
	{
	printf( "\033[4m" );
	}

bold()
	{
	printf( "\033[1m" );
	}

halfup()
	{
	}

halfdown()
	{
	}


