/***************************************************************

	ui_test.c       Test GR and UI

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023 
			Duke Station 
			Durham, NC  27706

			email: tcamp@hercules.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be 
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be 
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not 
	be used for illegal activities. 

***************************************************************/

/* #define  TEST_TW */

#include "stdio.h"
#ifdef	__STDC__
#include "malloc.h"
#else
extern char *malloc();
#define size_t int
#endif
#include "bw.h"
#include "gr.h"
#include "kb.h"
#include "dr.h"
#ifdef TEST_TW
#include "tw.h"
#endif
#include "ui.h"

#define TITLESIZE	64
#define MAXENTRIES      64

#define MM_ITEMS        12              /* items in main menu */

char bw_ebuf[ BW_EBUFSIZE ];

struct uiwindow *big_box, *little_box, *d_box;
struct menu_box m_box;
struct dir_ent *d_entries[ MAXENTRIES ];

char *d_titles[ MAXENTRIES ];

char *t_titles[] = {
   " Test Windows", 
   " Test Colors",
   " Test Styles", 
   " Dialog Box", 
   " Yes/No Box",
   " Alarm Box ",
   " Text File Selector",
   " Icon File Selector ",
   " Test Pixel Map ",
   " Test Rubberbanding ",
#ifdef TEST_TW
   " Test GR Text Window ",
#else
   " [UNAVAILABLE] ",
#endif
   " Exit from Test" };

char tbuf[ 128 ];
static char *buf;

main()
   {
   register int c, y;
   int x1, y1, item;
   
   /* Initialize the screen and keyboard */

   /* Initialize the toolkit */

   ui_init();
   if ( ui_grwind->initialized == FALSE )
      {
      printf( "The graphics system has not been initialized.\n" );
      return -1;
      }

   /* get memory for directory/menu arrays */

   for ( c = 0; c < MAXENTRIES; ++c )
      {
      if ( ( d_entries[ c ] =
         (struct dir_ent *) malloc( sizeof( struct dir_ent ))) == NULL )
         {
         gr_deinit();
         kb_deinit();
         fprintf( stderr, "Cannot allocate memory for directory structure %d \n", c );
         exit( 1 );
         }
      if ( ( d_titles[ c ] = malloc( TITLESIZE )) == NULL )
         {
         gr_deinit();
         kb_deinit();
         fprintf( stderr, "Cannot allocate memory for title array %d \n", c );
         exit( 1 );
         }
      }         

   /* Clear the screen */

   ui_setscreen( GR_HIDDEN );
   gr_cls( GR_HIDDEN );

#ifdef  OLD_DEBUG
   fprintf( stderr, "Ready to draw main box\n" );
   kb_rx();
#endif

   big_box = ui_window( 0, 0, ui_grwind->xmax, ui_grwind->ymax,
      TRUE, WHITE, BLACK,
      "A Test of the Bywater Graphical User Interface", FALSE, BLACK,
      FALSE, BLACK, WHITE, GRID, BUT_CLOSE | BUT_MOVE | BUT_RESIZE );

#ifdef  OLD_DEBUG
      fprintf( stderr, "Drew main box\n" );
      kb_rx();
#endif

#ifdef OLD_DEBUG
   sprintf( bw_ebuf, "imsize = %lx", gr_imsize( big_box->u_x1, big_box->u_y1,
      big_box->u_x2, big_box->u_y2 ) );
   bw_debug( bw_ebuf );
#endif

   /* initialize the clock */

/*        ui_clinit( big_box->u_x1, big_box->u_y1, BLACK, WHITE ); */

      /* blit to GR_PRIMARY and switch to primary screen */

      gr_blit( GR_HIDDEN, GR_PRIMARY, 0, 0, ui_grwind->xmax,
	 ui_grwind->ymax );
      ui_setscreen( GR_PRIMARY );
#ifdef  OLD_DEBUG
      kb_rx();
#endif

      x1 = ui_grwind->xmax / 20;
      y1 = ui_grwind->ymax / 10;

   /* main program loop, y == TRUE */

   y = TRUE;
   m_box.is_drawn = FALSE;
   while( y == TRUE )
      {

#ifdef  OLD_DEBUG
      bw_message( "Ready to activate list box" );
      kb_rx();
#endif

      /* clear the user area */

      ui_fbox( big_box->u_x1, big_box->u_y1, big_box->u_x2, big_box->u_y2,
	 BLACK, SOLID );
      ui_fbox( big_box->u_x1, big_box->u_y1, big_box->u_x2, big_box->u_y2,
	 WHITE, GRID );


      /* call the menu */

      m_box.is_drawn = FALSE;
      item = ui_list( MENU_SLIDERS,
	 x1 * 2, y1 * 4, x1 * 10, big_box->u_y2 - y1,
	 "Test Options", MM_ITEMS, t_titles, BLACK, WHITE, WHITE,
	 &m_box );

      /* save the screen before executing */

#ifdef OLD_DEBUG
      sprintf( bw_ebuf, "big_box = %08lx, x1 = %d", (long) big_box,
	 big_box->u_x1 );
      bw_debug( bw_ebuf );
      bw_message( " " );
#endif

      /* gr_save( GR_PRIMARY, TRUE, big_box->u_x1, big_box->u_y1,
	 big_box->u_x2, big_box->u_y2, buf ); */

      /* evaluate the item chosen */

      switch( item )
         {
         case 0:
            windows();
            break;
         case 1:
            colors();
            break;
         case 2:
            styles();
            break;
         case 3:
            dialog();
            break;
         case 4:
            yes_no();
            break;
         case 5:
            test_alarm();
            break;
         case 6:
            text_file();
            break;
         case 7:
            icon_file();
            break;
         case 8:
	    pixmap();
	    ui_wait();
            break;
         case 9:
            test_rband();
	    break;
	 case 10:
#ifdef TEST_TW
	    test_tw();
#endif
	    break;
         case TK_EXIT:
	 case 11:
            y = FALSE;
            break;
         }

      /* restore screen */

#ifdef OLD_DEBUG
      sprintf( bw_ebuf, "big_box = %08lx, x1 = %d", (long) big_box,
	 big_box->u_x1 );
      bw_debug( bw_ebuf );
      bw_message( " " );
#endif

      /* gr_save( GR_PRIMARY, FALSE, big_box->u_x1, big_box->u_y1,
	 big_box->u_x2, big_box->u_y2, buf ); */

      }

   /* Clear screen and restore prior state of computer */

   gr_cls( GR_PRIMARY );
   kb_deinit();
   gr_deinit();

   }

windows()
   {
   int x, y;

   x = ui_grwind->xmax / 20;
   y = ui_grwind->ymax / 10;
   little_box = ui_window( x * 2, y, x * 14, y * 7, 1, 1, 0,
      "A Full-Featured Window",
      1, 0, 1, 0, 1, 1, BUT_CLOSE | BUT_MOVE | BUT_RESIZE );

   ui_wait();

   /* Experiment:  title too long */

   little_box = ui_window( x * 2, y, x * 8, y * 5, TRUE, WHITE, BLACK,
      "A Full-Featured Window with a Rather Extremely Long Title",
      TRUE, BLACK, TRUE, BLACK, WHITE, SOLID, 0 );

   ui_wait();

   /* Write text to this window */

   ui_text( little_box->u_x1, little_box->u_y1,
      little_box->u_x2, little_box->u_y2, 
      29, 1, 0, 
      "This line of text has been written into this box utilizing the ui_text() function. We need to write a really long string to it\n" );

   ui_wait();

   }

colors()
   {
   register int c;
   int x, y;

   x = ui_grwind->xmax / 20;
   y = ui_grwind->ymax / 10;

   for ( c = 0; c < gr_colors; ++c )
      {
      sprintf( ui_tbuf, "This is color %d", c );
      little_box = ui_window( x * 2, y, x * 14, y * 6, TRUE, WHITE,
	 BLACK, ui_tbuf,
	 TRUE, BLACK, TRUE, BLACK, c, SOLID, 0 );
      ui_wait();
      }


   }

styles()
   {
   register int c;
   int x, y;

   x = ui_grwind->xmax / 20;
   y = ui_grwind->ymax / 10;

   for ( c = 0; c < 4; ++c )
      {
      sprintf( ui_tbuf, "This is style %d", c );
      little_box = ui_window( x * 2, y, x * 14, y * 6, TRUE, WHITE,
	 BLACK, ui_tbuf, TRUE, BLACK, TRUE, BLACK, WHITE, c, 0 );
      ui_wait();
      }

   }

dialog()
   {
   char d_buf[ 64 ];
   int x, y;

   x = ui_grwind->xmax / 20;
   y = ui_grwind->ymax / 10;

   ui_dial( x * 2, y, x * 14, y * 6, WHITE, BLACK, BLACK,
      TRUE, "A Test Dialog Box",
      "Please enter the name of your favorite saint \n(may be Orthodox or Catholic). No Anglicans accepted, or even Protestant or Evangelical Saints.  Thanks very much for your help.", 
      "Your saint:  ", d_buf, &d_box );
   sprintf( ui_tbuf, "Saint selected: %s ", d_buf );
   ui_wtitle( d_box, ui_tbuf );
   ui_wait();
   }

yes_no()
   {
   int x, y, r;

   x = ui_grwind->xmax / 20;
   y = ui_grwind->ymax / 10;

   r = ui_yn( x * 2, y, x * 14, y * 6, WHITE, BLACK, BLACK, TRUE,
      "Do you want $ 1,000,000.00 in cash?", "  NO  ", "  YES  ",
      &d_box );
   }

test_alarm()
   {
   int x, y, r;

   x = ui_grwind->xmax / 20;
   y = ui_grwind->ymax / 10;

   r = ui_alarm( x * 2, y, x * 14, y * 6, WHITE, BLACK, BLACK, TRUE,
      "An alarm box like this would be used in case of a serious program or system problem.",
      "  OK  ",
      &d_box );
   }

ui_poll()
   {
/*        ui_clock(); */
   }

bw_error( s )
   char *s;
   {
   char buf[ BW_EBUFSIZE ];

   sprintf( buf, "ERROR: %s   ", s );
   gr_text( GR_PRIMARY, 5, 5, buf, BLACK, WHITE );
   ui_wait();
   }

#ifdef  DEBUG
bw_debug( s )
   char *s;
   {
   char buf[ BW_EBUFSIZE ];

   sprintf( buf, "DEBUG: %s     ", s );
   gr_text( GR_PRIMARY, 5, 5, buf, BLACK, WHITE );
   ui_wait();
   }

#endif

bw_message( s )
   char *s;
   {
   char buf[ BW_EBUFSIZE ];

   sprintf( buf, "MESSAGE: %s   ", s );
   gr_text( GR_PRIMARY, 5, 5, buf, BLACK, WHITE );
   }

text_file()
   {
   static struct menu_box m_box;
   int x, y, item;
   register int c, test;

   x = ui_grwind->xmax / 20;
   y = ui_grwind->ymax / 10;

   m_box.is_drawn = FALSE;
   item = ui_ftext( x * 2, y * 2, x * 14, y * 7, dr_all, "File Selector Test",
      &m_box, d_titles, d_entries, MAXENTRIES, WHITE, BLACK, WHITE );

   if ( ( c != TK_ERROR ) && ( c != TK_EXIT ))
      {
      sprintf( ui_tbuf, "File selected: %s ",
         d_entries[ item ]->filename );
      ui_wtitle( m_box.window, ui_tbuf );
      ui_wait();
      }

   }

icon_file()
   {
   static struct menu_box m_box;
   int x, y, item;

   x = ui_grwind->xmax / 20;
   y = ui_grwind->ymax / 10;

   m_box.is_drawn = FALSE;
   item = ui_ficon( x * 3, y * 2, x * 13, y * 9, dr_all, "TEST: ui_ficon() ",
      &m_box, d_entries, MAXENTRIES, WHITE, BLACK, WHITE );

   if ( ( item != TK_ERROR ) && ( item != TK_EXIT ))
      {
      sprintf( ui_tbuf, "File selected: %s ",
	 d_entries[ item ]->filename );
      ui_wtitle( m_box.window, ui_tbuf );
      ui_wait();
      }

   }

pixmap()
   {
   static struct pbm_struct pmstruct;
   int x, y;

   x = ui_grwind->xmax / 20;
   y = ui_grwind->ymax / 10;

   ui_pbmread( "test.pbm", &pmstruct, WHITE, BLACK );

   ui_pbmshow( GR_PRIMARY, x * 2, y * 2, &pmstruct );

   }

test_rband()
   {
   static int x1, y1, x2, y2;
   
   /* fill the large area with grid */

   ui_fbox( big_box->u_x1, big_box->u_y1, big_box->u_x2, big_box->u_y2, BLACK, SOLID );
   ui_fbox( big_box->u_x1, big_box->u_y1, big_box->u_x2, big_box->u_y2, WHITE, GRID );

   /* get a rubber band rectangle */

   x1 = 20;
   x2 = 200;
   y1 = 20;
   y2 = 200;
   ui_rband( TRUE, &x1, &y1, &x2, &y2 );

   ui_fbox( x1, y1, x2, y2, BLACK, SOLID );
   ui_fbox( x1 + 1, y1 + 1, x2 - 1, y2 - 1, WHITE, SOLID );

   bw_message( "Box now received: press a key or click to move it: " );
   ui_wait();

   /* move it */

   ui_rband( FALSE, &x1, &y1, &x2, &y2 );

   ui_fbox( x1, y1, x2, y2, BLACK, SOLID );
   ui_fbox( x1 + 1, y1 + 1, x2 - 1, y2 - 1, WHITE, SOLID );

   /* wait */

   bw_message( " Box now moved; press a key or click for main menu" );
   ui_wait();
   
   }

#ifdef TEST_TW
test_tw()
   {
   int c;
   int x, y;
   struct ui_twstruct *uibw;

   x = ui_grwind->xmax / 20;
   y = ui_grwind->ymax / 10;

   uibw = ui_twinit( "Test Text Window",
	    x * 4, y * 6, 12, 52, 0, 0,
	    ui_grwind->xmax, ui_grwind->ymax );

   tw_cursor( TRUE );

   c = 0;
   while ( c != 0x1b )
      {
      c = kb_rx();
      tw_outc( c );
      }

   tw_cursor( FALSE );
   }

#endif

