/*
   Module:  terminat.c
   Date:    3/9/92
   Version: 1.0b
   Author:  Dave Lutz
   Email:   lutz@psych.rochester.edu
   Copyright: 1992 University of Rochester, Psychology Dept.

   Disclaimer:  This software is distributed free of charge.  As such, it
                comes with ABSOLUTELY NO WARRANTY.  The user of the software
                assumes ALL RISKS associated with its use.

                Your rights to modify and/or distribute this software are
                outlined in the file ADI7221.DOC.

   Purpose: This module provides the function used to terminate the program
            due to an error.

   Functions Provided:

        terminate

   Functions Required:

        closein
        closeout
*/

#include <stdio.h>
#include <stdlib.h>
#include "inout.h"


/*
   Function: terminate
   Purpose:  terminate the program after an error has occurred.

   Pre: exitcode is the code that should be supplied to the exit function.
        infilep is a pointer to a pointer to a PLTFILE. 
        *infilep either points to a PLTFILE that has been opened for reading 
        or is a NULL pointer.
        outfilep is a pointer to a pointer to a PLTFILE.
        *outfilep either points to a PLTFILE that has been opened for writing 
        or is a NULL pointer.
        message is a pointer to an ascii string indicating the type of error
        that occured.

   Post:  The string in message is printed to stderr.
          An attempt is made to close *infilep.
          An attempt is made to close *outfilep.
          The program is terminated with the code found in exitcode.
*/
void terminate (exitcode, infilep, outfilep, message)
   int exitcode;
   PLTFILE **infilep, **outfilep;
   char *message;
{
   (void) fprintf (stderr, "Fatal error: %s\n",message);
   (void) closein (infilep);
   (void) closeout (outfilep);
   exit (exitcode);
}
