/*
   Module: hpcodes.h
   Date:   3/9/92
   Version: 1.0b
   Author:  Dave Lutz
   Email:   lutz@psych.rochester.edu
   Copyright: 1992 University of Rochester, Psychology Dept.

   Disclaimer:  This software is distributed free of charge.  As such, it
                comes with ABSOLUTELY NO WARRANTY.  The user of the software
                assumes ALL RISKS associated with its use.

                Your rights to modify and/or distribute this software are
                outlined in the file SEND7221.DOC.

   Purpose: This modules provides the codes needed to communicate with the
            HP7221 plotter.
*/

#define HP_BLOCKSIZE   1024

/* 
   HP_INIT breaks down as follows:
        .(    Begin program mode
        .I1024;5;6;0:  
               Set handshake mode 2, requests will want 1024 bytes,
               handshake enable char is ENQ, handshake string is the
               ACK character followed by terminating NULL.
               Note: the number following the I must be the same as
               HP_BLOCKSIZE.
               The handshake enable character must be the same as
               HP_RTS.
*/
#define HP_INIT        ".(.I1024;5;6;0:"
#define HP_INIT_BYTES  17

/* 
   Note: The RTS character must be the same as the handshake enable character
   defined in HP_INIT.
*/
#define HP_RTS         "\005"
#define HP_RTS_BYTES   1

/*
   HP_ABORT breaks down as follows:
       .J  - abort device control instruction
       .K  - abort graphic instruction
       .)  - exit program mode
*/
#define HP_ABORT       ".J.K.)"
#define HP_ABORT_BYTES 9

#define HP_END         ".)"
#define HP_END_BYTES   3
