/* --- FONTDEMO.C -- Displays compiled Hershey Font files *.XSH ------------
 |	There is no documentation on the format of *.XSH files.
 |	Please read the code in this file for details.
 |	This program need a hardware/C compiler-dependent graphics routines.
 |	IBM PC CGA/EGA driver for MS C compiler is provided as CXYIBMPC.C.
 |	For other hardware/compiler write routines cxy_init(), cxy_close(),
 |	cxy_move(x,y,color), cxy_lineto(x,y,color).
 |
 |	Author:     Wayne C. Crawford. 7-8-88 Starting
 |	Modified by Izumi Ohzawa for standard graphics adapters. 7-15-88
 * ------------------------------------------------------------------------- */

#include <stdio.h>

#define XCMIN	2		/* minimum X coordinate */
#define YCMIN	5
#define YBUMP	33		/* line spacing */
#define XCMAXCG	290		/* maximum X for char's left side for CGA */
#define YCMAXCG	199
#define XCMAXEG	600		/* for EGA */
#define YCMAXEG 349
#define EGACOLOR  7
#define CGACOLOR  1

FILE *fpdatain;
unsigned int ptarray[128];
unsigned int fontarray[6000];
int xpen, ypen, corigx, corigy;
int pendowner;
char string[128];
int count = 1;  		/* position of array that we are presently in */
int ignore = 0;
char out_line[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ abcdefghijklmnopqrstuvwxyz\
0123456789.,;:'`~!@#$%^&*()-[]{}<>|?" ;

main(argc,argv)
int argc;
char *argv[];
{
register int i;

	if( argc != 2)
	{
		printf("Usage: FONTDEMO FONTNAME.XSH\n");
		exit(1);
	}

	for( i = 0; i < 128; i++)
		ptarray[i] = 0;	      /* Initialize pointer array */
	rd_fontfile(argv[1]);	      /* Read in compiled font file */
	printf("count = %d\n",count);
	cxy_init();		      /* Initialize graphics */
	show_the_font();	      /* Show the font on screen */
	getch();		      /* pause until key press */
	cxy_close();		      /* Close out graphics mode */
}	

cxy_init()
{
		cxy_videomode(5);
	/*	cxy_videomode(16); */
}

cxy_close()
{
	cxy_videomode(3);	/* reset to text screen */
}

/****************************************************************************/

/* ----- Read compiled font file ---------------------------------- */
rd_fontfile(readfile)
char *readfile;
{
int numread;
int *fontptr;

	fpdatain = fopen(readfile, "rb");
	if (fpdatain == NULL)
	{
		printf("Compiled font file: %s does not exist.\n",readfile);
		exit(2);
	}
	/* OK file found, first read the size of the font array*/
        numread = fread( (char *)&count, sizeof(unsigned), 1, fpdatain);
        numread = fread( (char *)ptarray, sizeof(unsigned), 128, fpdatain);
	numread = fread( (char *)fontarray, sizeof(unsigned), count+2, fpdatain);
	if( numread != (count+ 2))
	{
	    printf("Can't read font file fully.\n");
	}
	fclose(fpdatain);
}

/****************************************************************************/

show_the_font()
{
register int i;
char *character;
int arrayloc;

	corigy = YCMIN;
	corigx = XCMIN;		/* set starting point */
	i = -1;
	while (out_line[++i] != '\0')
	{
	    arrayloc = ptarray[(int)out_line[i]];
	    if (arrayloc == 0)
	    {
		printf("No existing character for that.\n");
	    }
	    while (fontarray[arrayloc] != 0x4000)
		strip_font(fontarray[arrayloc++]);
	    corigx = xpen;
	    corigy = ypen;
	    if(corigx > XCMAXCG )
	    {
		corigx = XCMIN;		/* carriage return */
		corigy += YBUMP;	/* line feed */
	    }
	}
	return(0);
}



strip_font(value)
int value;
{

	if (value & 0x2000)
	{
		pendowner = (value & 0x1000);
	}
	else
	{
		xpen = ( ((value >>6) & 0x3f)-20 ) +corigx;
		ypen = ( (value & 0x3f)-20) +corigy;
		if (pendowner)
			cxy_lineto(xpen, YCMAXCG-ypen, CGACOLOR);
		else
			cxy_move(xpen, YCMAXCG-ypen );
	}
	return(0);
}



