/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992  Pedro Mendes
*/

/*************************************/
/*                                   */
/*          GWTOP - Topology         */
/*        MS-WINDOWS front end       */
/*                                   */
/*       Initialization and some     */
/*           data structures         */
/*                                   */
/*           QuickC/WIN 1.0          */
/*                                   */
/*   (include here compilers that    */
/*   compiled GWSIM successfully)    */
/*                                   */
/*************************************/


struct kint {
		  		unsigned char nsub;
				unsigned char npro;
				unsigned char nmodf;
				unsigned char revers;
				int idx;
				LPSTR descr;
	   	    };

struct nodet{
             char item;
             unsigned char val;
             unsigned char left;
             unsigned char right;
            } ;

struct treet{
             struct nodet node[256];
             char id[64][10];
             float constant[32];
             int nnode,
                 nnum,
                 nid,
                 nsub,
                 npro,
                 nmodf,
                 nconst,
                 revers;
             char descr[64];
            } ;

extern GLOBALHANDLE hMetname;								/* handle to memory block w/ metname	*/
extern GLOBALHANDLE hStepname;								/* handle to memory block w/ metname	*/
extern GLOBALHANDLE hStoiu;									/* handle to memory block w/ metname	*/
extern GLOBALHANDLE hLoop;									/* handle to memory block w/ loop		*/
extern GLOBALHANDLE hKtype;									/* handle to memory block w/ ktype		*/
extern GLOBALHANDLE hRstr;									/* handle to memory block w/ rstr		*/
extern GLOBALHANDLE hPool;									/* handle to memory block w/ strings	*/
extern GLOBALHANDLE hTree;									/* handle to memory block w/ tree		*/

extern char (huge *metname)[NAME_L];						/* pointer to work with metname array	*/
extern char (huge *stepname)[NAME_L];						/* metabolite names						*/
extern char (huge *stepname)[NAME_L];						/* metabolite names						*/
extern int  huge *stoiu;									/* pointer to work with metname array	*/
extern unsigned char (huge *loop)[MAX_STEP][MAX_MET];		/* def. of modification loops			*/
extern int  (huge *rstr)[MAX_STEP][MAX_MOL];				/* reaction structure					*/
extern char	topname[256];									/* title for the topology				*/
extern int		kinetu[MAX_STEP];							/* type of kinetics (user numb.)		*/
extern int		kfl[MAX_STEP];								/* flags for input of user-def.kinetics */
extern unsigned char nmod[MAX_STEP];						/* number of assigned modfs of a react.	*/
extern int		intmet[MAX_MET];							/* 1 if internal metabolite				*/
extern unsigned char revers[MAX_STEP];						/* 1 if reaction is reversible			*/
extern double	xu[MAX_MET];								/* concentrations at time t user		*/
extern struct	kint huge *ktype;							/* ptr array of kinetic types & proprt	*/
extern double	endtime;									/* time value for last iteration		*/
extern double	hrcz;										/* highest rate considered zero			*/
extern double	dft_endtime;								/* time value for last iteration		*/
extern double	dft_hrcz;									/* highest rate considered zero			*/
extern float	ver_no;										/* .top and .sim version number			*/
extern int		totmet;										/* number of total metabolites			*/
extern int		nmetab;										/* number of internal metabolites		*/
extern int		nsteps;										/* number of steps                		*/
extern int		nloops;										/* number of modifier loops             */
extern int		nrateq;										/* number of kinetic types in the datab */
extern int		nudf;										/* number of user-defined kin. types	*/
extern int		newtree;									/* 1 if user added kinetic new types	*/
extern int		debugval;									/* debug mode							*/
extern int		dft_debugval;								/* debug mode							*/
extern int		options;									/* various options						*/
extern unsigned int pfo;									/* number of points for output			*/
extern unsigned int dft_pfo;								/* number of points for output			*/
extern struct	treet huge *tree;							/* function tree for rate equations		*/
extern struct	treet tr;									/* tree for the input					*/

