//******** Listing 7 ********************** ARRAY.CPP ****
// ARRAY.CPP : implementation of class dynamic_array
// (c) C Gazette. See Listing 1 for usage.
//********************************************************

#include "array.hpp"
#include <stdio.h>

void dynamic_array::error(char * msg) {
  fprintf(stderr, "dynamic_array error: %s\n", msg);
  exit(1);
}
dynamic_array::dynamic_array(size_t sz) {
  size = sz;
  // can still use malloc and calloc if you want!
  vec = (int*)calloc(sz, sizeof(int));  // cast required by C++
  if(vec == NULL) error("out of memory in create_array");
}

dynamic_array::~dynamic_array() {
  free(vec); // free memory used for vec
}
