/* _________________________________________________________

	C R U N C H E R   D E M O   v2.2

	Here is an example of how to call the CRUNCHER's
	libraries to perform any of the signal processing
	techniques discussed in CRUNCH22.DOC.

	Copyright 1992,1993 by Gene V. Wallenstein
	All rights reserved.
   ________________________________________________________ */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

float spectrum(float *,float *,int,float,int,int); /* Don't forget to declare the CRUNCHER routine. */

#define TRUE 1
#define ITPTS 1024

main()
     {
     FILE *fptr1;
     float infile[ITPTS],outfile[ITPTS],rate,freq;
     int i,j,flag,win;
     printf(" \n\n ---- CRUNCHER v2.2 DEMONSTRATION ----\n\n");   /* Blurb about the demo. */
     printf(" Copyright 1992,1993 by Gene V. Wallenstein\n\n");
     printf(" CRUNCHER v2.2 is a group of signal processing routines\n");
     printf(" written for C programmers. Some of the routines included are:\n\n");
     printf("  1) Fast Fourier Transform (FFT)  2) Digital Filtering of data\n");
     printf("  3) Wavelet Transform (Affine)    4) Coherence Analysis\n");
     printf("  5) Autocovariance                6) Crosscovariance\n");
     printf("  7) Linear Regression             8) Moments Analysis\n");
     printf("  9) Spectral Analysis            10) Cross Spectral Analysis\n");
     printf(" 11) Wigner-Ville Transform\n\n");
     printf(" This is a sample program which uses the SPECTRUM routine from\n");
     printf(" the CRUNCHER. It performs a spectral analysis on the test data\n");
     printf(" supplied with this kit and displays the power as a function of\n");
     printf(" frequency.\n\n");
     printf(" Hit the RETURN key to calculate the power spectrum\n");
     printf(" of the test data using a Hanning window.");
     getch();
     printf(" \n\nO.K., give me a minute while I compute this...");

     if((fptr1=fopen("test.dat","r"))==NULL)
       {printf("Sorry, I can't find the TEST.DAT file.");
       exit(TRUE);}
     for(i=0;i<=ITPTS-1;i++)  /* Initialize the arrays. */
     {infile[i]=0.0;
     outfile[i]=0.0;}
     fptr1=fopen("test.dat","r");
     i=1;
     while(fscanf(fptr1,"%f",&infile[i]) != EOF )  /* Read in data starting at i=1 !! */
       {i++;}

     flag = 0;     /* Power spectrum, not phase spectrum. */
     win  = 1;     /* Use the Hanning window. */
     rate = 64.0;  /* The sampling rate. */

     spectrum(infile,outfile,i-1,rate,flag,win);

     /* INFILE is a pointer to the infile array.
	OUTFILE is a pointer to the results array.
	i-1 is the number of points.
     */

     printf("\nHere are the results, I'll go slow since the file is small (40 pts.).\n\n\n\n\n");

     printf("\x1B[22;24f");  /* ANSI stuff */
     printf("Frequency");
     printf("\x1B[22;37f");
     printf("Power");
     freq=0.0;
     for(j=1;j<=i/2;j++)
	{printf("\x1B[24;24f");
	printf("%f",freq);
	printf("\x1B[24;37f");
	printf("%f",outfile[j]);
	delay(350);
	freq+=(rate/(float) i);}
     printf(" \nPlease hit the RETURN key to continue...");
     getch();
     printf(" \n\n You are free to modify this program and try other routines\n");
     printf(" that the CRUNCHER has to offer as long as the results are not used\n");
     printf(" for commercial purposes. Please consult the CRUNCH22.DOC for more\n");
     printf(" details regarding additional routines and their specifications.\n\n");
     printf(" If you feel these routines are useful, please register by sending\n");
     printf(" $25.00 to the address listed below. When you register you will receive:\n\n");
     printf(" 1) FREE UPDATES -    Register once and you only pay postage and\n");
     printf("                      handling for updates. NO EXTRA COSTS.\n\n");
     printf(" 2) SOURCE CODE  -    You also get the complete source code to CRUNCHER.\n\n");
     printf(" 3) ROYALTY FREE -    Registered users pay no royalties for commercial\n");
     printf("                      products which use CRUNCHER routines.\n\n");
     printf(" 4) MANUAL/TUTORIAL - Registered users will receive a laser printed\n");
     printf("                      manual/tutorial on the techniques used by the CRUNCHER.\n\n");
     printf(" Please hit the RETURN key to continue...");
     getch();
     printf(" \n\n If you have any questions concerning this product please don't\n");
     printf(" hesitate to ask. I hope to hear from you soon.");
     printf(" \n\n For further information or support contact:\n");
     printf(" Internet   - Wallenstein@Walt.ccs.fau.edu\n");
     printf(" Telephone  - (407) 750-3527\n");
     printf(" CompuServe - 75110,77\n\n");
     printf(" Gene V. Wallenstein\n");
     printf(" 5990 Pine Cone Court, #406d1\n");
     printf(" Lake Worth, FL. 33463 USA\n\n");
     printf("\n\n Thank you for your interest in the CRUNCHER.\n");
}
