/* evallt.c - parse/eval lite */
/* Parser/Evaluator Version 0.6 */
/* Copyright in May of 2000, by Massago, Sadao - DM/UFSCar - Brazil */
/* e-mail: sadao@dm.ufscar.br */
/* all right are reserved */
/* This is freeware and the source will by distributed frerly for non-comercial purpose */


/* 
#define _TEST_
*/

/* include main testing routine */



/*
#define _DEBUG_
*/
/* display stack information in parsing */


/*
#define _BRAZILIAN_
*/
/* ParseErrorMsg in brazilian */

/* #define _TURBO_C_ */
/* redefine the mathematical error handding function matherr() */

#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <ctype.h>
#include <errno.h>


/* debug purpose  */
#ifdef _DEBUG_
  #include <stdio.h>
#endif


/* for test purpose */
#ifdef _TEST_
  #include <stdio.h>
#endif

/* declaration of macros, types, variables and functions for interface */


/*-------< error status >---------*/

#define TRUE   1
#define FALSE  0

#define ON  1
#define OFF 0

#define SUCESS 0
#define ERROR  1

   int ErrorStatus = SUCESS;
   int ParseErrorPos = 0;

/*********************************/
/* External disponible functions */
/*********************************/

/*------< Shared variables >---------*/

   int RegisterSharedVar(char *name, double *var);
/* Share the internal C variable */

   int DeleteSharedVar(char *name);
/* delete the shared variables */

   int ClearSharedVars(void);
/* clear all internal variables */

/*---------< get the values of variables/constants >----------*/

   int SetValue(char* name, double value);
/* it set value of variable, but not create it */

   double GetValue(char* name);
/* For external use only. Not used by evaluator() */
/* Set ErrorStatus = VARNOTFOUNDERROR, if the name not exist */
/* Caution: It reset the error flags */

   int isNewName(char *name);
/* Name validation. */


/*--------------------------------------*/
/* miscelaneous table manipulation      */
/* function for external programmings   */
/*--------------------------------------*/
/* Get the table size and name by index */
/* obs.: not optimized. for tables      */
/* listing purpose                      */
/*--------------------------------------*/
#ifdef _TURBO_C_
   int matherr(struct exception *e);
/*   this matherr skip the error message and assignate the error code in
   errno returning HUGE_VAL, if mathematicaly error is ocurrented in
   math's functions.
*/
#endif

   double Eval(void);
/* Evaluate the parsed expression */

   int Parse(char *expression);
/* Parse the expression */

   char *ParseErrorMsg(void);
/* Check for error */


/*-----------*/
/* Evaluator */
/*-----------*/

/* Token definitions for Evaluator */

/* state of CodeToken List EvalStack */
#define EMPTY      0 /* last token marker */
#define VALUE      1 /* value stack    */
#define VARIABLE   2 /* variable stack */
#define FUNCTION1  3 /* internal C function with one parameters */
#define FUNCTION2  4 /* internal C function with two parameters */
#define FUNCTION   5 /* internal functions */


/*----------------------------------*/
/* parsed token record */

   typedef struct CODETOKENREC
   {
      int state;  /*  state of Token */
      int args; /* if state is function with indetermined number of
         parameters, need number of arguments to pop()
         the EvalStack */
      union
      {
         double value;     /* values */
         double *var;      /* variables */
         double (*cf1)(double);  /* internal C one parameter function */
         double (*op2)(double,double);  /* binary operator implemented as */
         	/* internal two parameter C function */
         double (*f)(int n);    /* internal functions */
      } x;
   } CODETOKENREC;


#define CODESTACKSIZE  100
   static CODETOKENREC CodeStack[CODESTACKSIZE+1] = {{EMPTY, 0}};

/* Stack to evaluate parsed token */
#define EVALSTACKSIZE  100

   static int EvalStackSize = 0;
   static double EvalStack[EVALSTACKSIZE+1];

/*-------------------------*/
/*         parser          */
/*-------------------------*/

/* Parsing token status */

#define UNDEF  1

/* level 2 */
#define MINUS  3 /* MINUS is special cases: will by unary and binary */
#define PLUS   4 /* PLUS  is special cases: will by unary and binary */

/* Level 3 */
#define TIMES  10
#define DIVIDE 11
#define MODULO 12

/* level 4 */
#define POWER  13

/* level 5 */
/* unary minus is same as binary MINUs and treated by parser */

/* level 6 */
#define NUMBER  20
#define CFUNC1  21
#define FUNC    22
#define VAR     23
#define UNKNOW  24

/* other states */
#define OPAREN    30
#define COMMA     31
#define SEMICOMMA 32
#define CPAREN    33

#define EOSTR     37 /* end of input */
#define BADNUM    38 /* number is bad */
#define BIGID     39 /* identifier is big */
#define INVALID   40 /* invalid character on token */

/*--------------< parser record >------*/

/* buffer size */
#define STRBUFFLEN 100 /* token buffer size */

#define PARSERSTACKSIZE 100

   typedef struct
   {
      int state;
      int args; /* number of parameters of functions */
      union
      {
         double value;
         void * ptr;
      /* char name[STRBUFFLEN+1]; */
      } x;
   } PARSERTOKENREC;

   static PARSERTOKENREC ParserStack[PARSERSTACKSIZE];
   static PARSERTOKENREC CurTok;
   static char *input = "";

   static int ParserStackSize = 0;

/* internal use only */
   static int CodeStackSize = 0; /* used onlu by parser */
      /* evaluator does not use */
   static CODETOKENREC CurCodeTok;

/* parser error status */

/*
#define NOERROR 50 / * sucess * /
*/

#define ENDEXPERROR       51 /* "imature expression terminated" */
#define NOEXPERROR        52 /* "expression expected" */
#define OPARENERROR       53 /* "\"(\" expected" */
#define CPARENERROR       54 /* "\")\" expected" */
#define UNKNOWNERROR      55 /* "unknown error" */
#define PARAMNOTMACHERROR 56 /* "inverid nuber of parameters" */
#define BADNUMERROR       57 /* "number bad or exceed limits" */
#define BIGIDERROR        58 /* "indent lenght exceeds limit" */
#define VARNOTFOUNDERROR  59 /* "variable not found" */
#define UNDEFINDENTERROR  60 /* "undefined identifier" */
#define NOSINGLEEXPERROR  61 /* "does not valid single expression" */
#define OUTMEMORYERROR    62 /* out memory */
#define INVALIDCHAR       63 /* invalid char on input */
/* #define VARNOCREATEERROR  64 */ /* "can not create variables" */

#ifdef _BRAZILIAN_

 static char *ParserMsg[] = {
   "sucesso",
   "expressao terminado imaturamente",
   "expressao esperado",
   "\"(\" esperado",
   "\")\" esperado",
   "erro desconhecido",
   "numero de parametros invarido",
   "numero invalido ou muito grande",
   "identificador muito grande",
   "variavel nao encontrado",
   "identificador nao definido",
   "expressao invalida",
   "nao ha memoria suficiente",
   "character invalido" /* ,
   "nao foi possivel criar o variavel" */
};

#else  /* not brazilian */

 static char *ParserMsg[] = {
   "sucess",
   "imature expression terminated",
   "expression expected",
   "\"(\" expected",
   "\")\" expected",
   "unknown error",
   "inverid nuber of parameters",
   "bad number or size exceed limits",
   "indent lenght exceed limits",
   "variable not found",
   "undefined identifier",
   "invalid expression",
   "out memory",
   "invalid character" /* , 
   "can not create variables" */

};

#endif

   char *ParseErrorMsg(void)
   /* Check for error */
   {
      if(ErrorStatus == SUCESS)
         return ParserMsg[0];
      else
         return ParserMsg[ErrorStatus-50];
   }


/*------------------------------------*/
/* one parameter internal C functions */
/*------------------------------------*/

/* Record for one parameter internal C functions */
   typedef struct
   {
      char *name;
      double  (*f)(); /* generic number of parameters */
   } CFuncRec;

/* new defined one parameter C internal functions */
/* will used outside of Parser/Evaluator */
   double deg(double);
   double fac(double);
   double rad(double);
   double round(double);
   double sqr(double);
   double trunc(double);

#define CFUNCTABLESIZE 50 /* maximum number of C internal functions */

/* One parameter internal C defined functions */
   static CFuncRec CFunc1[CFUNCTABLESIZE+1] =
   {
   /* name, funtion to call */
   { "abs",     fabs },
   { "acos",    acos },
   { "asin",    asin },
   { "atan",    atan },
   { "cos",     cos },
   { "cosh",    cosh },
   { "deg",     deg },   /* added */
   { "exp",     exp },
   { "fac",     fac },   /* added */
   { "log",     log },
   { "log10",   log10 },
   /* { "pow10",   pow10 } */
   { "rad",     rad },   /* aded */
   { "round",   round }, /* added */
   { "sin",     sin },
   { "sinh",    sinh },
   { "sqr",     sqr },
   { "sqrt",    sqrt },
   { "tan",     tan },
   { "tanh",    tanh },
   { "trunc",   trunc }, /* added */
   { "floor",   floor },
   { "ceil",    ceil },
   
   { NULL, NULL } /* NULL mark the end of table */
   };

/* operators was treated in Parsingr time, to check the
   operator level. unary operator is the function
   double op(double) and
   binary operator is function
   double op(double,double)

   unary:
   "+" -> none
   "-" -> unary_minus
   binary:
   "+" -> binary_plus
   "-" -> binary_minus
   "*" -> binary_times
   "/" -> binary_divide
   "^" -> binary_power
   "%" -> fmod (defined in math.h)
*/

/*--------------------*/
/* internal functions */
/*--------------------*/

/* Cell for internal Functions */
/* These functions evaluate using parameter on EvalStack */

   typedef struct
   {
      char *name;
      int args; /* UNDEFARGS or number of arguments required */
      double  (*f)();
   } FuncRec;


/* some defined internal functions */
/* see these examples to write your own one */
   static double p_sum(int);
   static double p_max(int);
   static double p_min(int);
   static double p_rand(int);
   static double p_med(int);


#define UNDEFARGS -1

/*  args mean:

    0: parameterless functions
    k>0: k parameter functions
    UNDEFARGS: function with flexible number of parameters.
*/

#define FUNCTABLESIZE 25
   static FuncRec Funcs[FUNCTABLESIZE+1] =
   { {"max", UNDEFARGS, p_max},
     {"med", UNDEFARGS, p_med},
     {"min", UNDEFARGS, p_min},
     {"rand",0,         p_rand},
     {"sum", UNDEFARGS, p_sum},
     
     
     {NULL, 0, NULL}};

/*-------------------------*/
/* constants and variables */
/*-------------------------*/

/* Shared variables record */

   typedef struct
   {
      char *name;
      double *var;
   } SharedVarRec;


/* constants record */

   typedef struct
   {
      char *name;
      double value;
   } Numeric;

/* constants */

#define CONSTTABLESIZE 25
   static Numeric Consts[CONSTTABLESIZE+1] =
   {
   /* name, value */
   { "pi",      M_PI },
   { "e",       M_E },
   
   { NULL, 0 } /* NULL mark the end of table */
   };


#define SHAREDVARTABLESIZE 100 /* Size of Shared Variables table */
/* Shared (with C internal) variables */
   static SharedVarRec SharedVars[SHAREDVARTABLESIZE+1] = {{NULL, NULL}};
/* last for end marker */


/*******************/
/* implementations */
/*******************/

/*----------------------------------------*/
/*  shared variables tables manipulations */
/*----------------------------------------*/


   int RegisterSharedVar(char *name, double *var)
   /* Share the internal C variable */
   {
      int i;
   
      for(i=0; (SharedVars[i].name != NULL) &&
         (strcmp(SharedVars[i].name, name) != 0);i++);
      if(SharedVars[i].name != NULL) { /* found! overwrite */
         SharedVars[i].var = var;
         return TRUE;
      }
      else if(!isNewName(name))
         return FALSE;
      else if(i > SHAREDVARTABLESIZE)
         return FALSE;
      else if((SharedVars[i].name = malloc(strlen(name)+1)) == NULL)
         return FALSE;
      else {
         strcpy(SharedVars[i].name, name);
         SharedVars[i].var = var;
         SharedVars[i+1].name = NULL; /* ending the table */
         return TRUE;
      }
   } /* RegisterSharedVar() */

   int DeleteSharedVar(char *name)
   /* delete the shared variables */
   {
      int i;
   
      for(i=0; (SharedVars[i].name != NULL)
         && (strcmp(SharedVars[i].name, name) != 0);i++);
      if(SharedVars[i].name == NULL) /* not found */
         return FALSE;
   
      free(SharedVars[i].name);
      for( ;SharedVars[i+1].name != NULL; i++) { /* shift the batle */
         SharedVars[i].name = SharedVars[i+1].name;
         SharedVars[i].var  = SharedVars[i+1].var;
      }
      SharedVars[i].name = NULL;  /* endding the table */
   
      return TRUE;
   } /* DeleteSharedVar() */

   int ClearSharedVars(void)
   /* clear all internal variables */
   {
      int i;
   
      for(i=0;SharedVars[i].name;i++) /* free the non-empty variables name */
         free(SharedVars[i].name);
      SharedVars[0].name = NULL; /* set as empty table */
   
   #ifdef _DEBUG_
    CodeStack[0].state = EMPTY;
   #endif
   
      return i; /* Numbers of variables erased */
   } /* ClearSharedVars */


/*---------< get the values of variables/constants >----------*/
/* These functions are for ilustration purpose. Since the variable */
/* are shared with C internal one, does not need theses one */

   int SetValue(char* name, double value)
   /* it set value of variable, but not create it */
   {
      int i;
   #ifdef _DEBUG_
    if(!(isalpha(name[0]) || (name[0] == '_'))) /* variables name need to start by alpha */
      return 0;
   #endif
   /* look up the shared variables */
      for(i=0;SharedVars[i].name && strcmp(name, SharedVars[i].name);i++);
      if(SharedVars[i].name != NULL) { /* if found */
         *SharedVars[i].var = value; /* Set value */
         return TRUE; /* found */
      }
   
      return FALSE;
   } /* SetValue */

   double GetValue(char* name)
   /* For external use only. Not used by evaluator() */
   /* Set ErrorStatus = VARNOTFOUNDERROR, if the name not exist */
   /* Caution: It reset the error flags */
   {
   
      int i;
   #ifdef _DEBUG_
    if(!isalpha(name[0])) { /* variables name need to start by alpha */
      ErrorStatus = VARNOTFOUNDERROR;
      return 0;
    }
   #endif
   
   /* look up the shared variables */
      for(i=0;SharedVars[i].name && strcmp(name, SharedVars[i].name);i++);
      if(SharedVars[i].name != NULL) { /* if found */
         ErrorStatus = SUCESS;
         return *SharedVars[i].var; /* return value */
      }
   /* look up the constants */
      for(i=0;Consts[i].name && strcmp(name, Consts[i].name);i++);
      if(Consts[i].name != NULL) { /* if found */
         ErrorStatus = SUCESS;
         return Consts[i].value; /* Get value */
      }
   
      ErrorStatus = VARNOTFOUNDERROR;
      return 0.0; /* default value is 0 */
   } /* GetValue */

/*--------------------------------------*/
/* getting the address of veraibles,    */
/* functions and consts. Used by parser */
/*--------------------------------------*/

   static double * GetConst(char *name)
   /* get pointer to const */
   {
      int i;
   /* look up the constants */
      for(i=0;Consts[i].name && strcmp(name, Consts[i].name);i++);
      if(Consts[i].name != NULL) /* if found */
         return &(Consts[i].value);
      else
         return NULL;
   }

   static double * GetSharedVar(char *name)
   /* get the Shared (with C internal) variables pointer.
   return NULL if not exist */
   {
      int i;
   /* look up the variables */
      for(i=0;SharedVars[i].name && strcmp(name, SharedVars[i].name);i++);
      if(SharedVars[i].name != NULL)
         return SharedVars[i].var; /* if found */
      else
         return NULL;
   }

   static void * GetCFunc1(char *name)
   /* is defined internal C functions */
   {
      int i;
   /* look up the functions */
      for(i=0;CFunc1[i].name && strcmp(name, CFunc1[i].name);i++);
      if(CFunc1[i].name != NULL) /* if found */
         return CFunc1[i].f;
      else
         return NULL;
   }

   static void * GetFunc(char *name)
   /* get pointer to internal functions */
   {
      int i;
   /* look up the internal functions */
      for(i=0;Funcs[i].name && strcmp(name, Funcs[i].name);i++);
      if(Funcs[i].name != NULL) /* if found */
         return Funcs[i].f;
      else
         return NULL;
   }


   static int GetFuncArgs(char *name)
   /* return number of arguments in internal functions
   if function not found, return UNDEFARGS */
   {
      int i;
   /* look up the functions */
      for(i=0;Funcs[i].name && strcmp(name, Funcs[i].name);i++);
      if(Funcs[i].name != NULL) /* if found */
         return Funcs[i].args;
      else
         return UNDEFARGS;
   }


   int isNewName(char *name)
   /* Name validation. */
   
   {
      int j;
   
      if(!isalpha((int)name[0]) && (name[0] != '_'))
         return FALSE;
   /* check for rest of characters */
      for(j=0; j<strlen(name); j++)
         if( !isalnum((int)name[j]) && (name[j] != '-'))
            return FALSE;
   
      return !(  GetCFunc1(name) || GetFunc(name)
              || GetSharedVar(name) || GetConst(name) );
   } /* isNewname() */


/***********************************************/
/*           redefining the matherr            */
/*---------------------------------------------*/
/* Caution:                                    */
/* this afect all math function error handings */
/*---------------------------------------------*/
/* now, matherr set the global variable        */
/* "errno" and return. does not abort          */
/***********************************************/

#ifdef _TURBO_C_

/* to implement matherr() calling in own implementation of mathematical
   functions. For the use, see the fac() functions */
   static struct exception calcerr;

/* matherr redefinition */
   int matherr(struct exception *e)
   /* this matherr skip the error message and assignate the error code in
   errno returning HUGE_VAL, if mathematicaly error is ocurrented in
   math's functions.
   */
   {
      errno = e->type;
      e->retval = HUGE_VAL;
      return(1);
   } /* matherr */
#endif /* #ifdef _TURBO_C_ */

/**************************************/
/* defining some C internal functions */
/**************************************/

   double fac(double x)
   /* Function return the factorial of integer belong to range 0..170. If
   n less then 0, return 1 */
   {
      double p;
      int n = x;
   
      if(n > 170) /* maximum admited where */
      {
       #ifdef _TURBO_C_
         calcerr.type = ERANGE;
         matherr(&calcerr);
         return(calcerr.retval);
       #else
         errno = ERANGE;
         return (+ERANGE);
       #endif
      }
      if(n < 0)
      {
        #ifdef _TURBO_C_
         calcerr.type = EDOM;
         matherr(&calcerr);
         return(calcerr.retval);
        #else
         errno = EDOM;
         return 0;
        #endif
      }
      else if(n < 2)
         return(1);
      else if(n == 2)
         return(2);
      p = 1;
      while(1 < n)
      {
         p = p*n;
         n--;
         p = p*n;
         n--;
      }
      return(p);
   } /* fac */


   double deg(double x)
   {
      return( x * 180.0 / M_PI);
   }

   double rad(double x)
   {
      return(x * M_PI / 180.0);
   }

   double sqr(double x)
   {
      return (x*x);
   }

   double trunc(double x)
   {
      return (int)x;
   }

   double round(double x)
   {
      return (int)(x+0.5);
   }


/*-----------------------*/
/* unary/binary operator */
/*-----------------------*/

/*-----< unary >----*/

   static double unary_minus(double x)
   {
      return -x;
   } /* unary_minus() */


/*----< binary operator >-----*/

   static double binary_plus(double x, double y)
   {
      return x + y;
   } /* binary_plus() */

   static double binary_minus(double x, double y)
   {
      return x - y;
   } /* binary_minus() */


   static double binary_times(double x, double y)
   {
      return x * y;
   } /* binary_timess() */

   static double binary_divide(double x, double y)
   {
   
      if (y == 0)
      {
        #ifdef _TURBO_C_
         calcerr.type = EDOM;
         matherr(&calcerr);
         return calcerr.retval;
        #else
         errno = EDOM;
         return HUGE_VAL;
        #endif
      }
      else
         return (x/y);
   } /* binary_divide() */

   static double binary_power(double x, double y)
   {
      return pow(x,y);
   } /* binary_power() */

/**********************************************/
/*             internal functions             */
/*--------------------------------------------*/
/* model to crate your own internal functions */
/**********************************************/
/*

  typical prototype is
  double myfunc(int n) where n is numbers of parameters passed

  Obs.: Parser functions puts the parameter in order as in
	PASCAL callings. Thus
     EvalStack[EvalStackSize-1] is last parameter (index 0),
     EvalStack[EvalStackSize-2] is seccond last parameter (index 1).
     EvalStack[EvalStackSize-k] is k-th last parameter (index (k-1) ).
     etc.
	After calls, the Evaluator pop() automatically the parameter to
     adjust stack. Thus do not push() values to stack in the sense to
     return the values.

   Ex. sum(x,y,7)
   take as
   Parameter(2) = EvalStack[EvalStackSize-3] = x
   Parameter(1) = EvalStack[EvalStacksize-2] = y
   Parameter(0) = EvalStack[EvalStacksize-1] = 7

   If your function is of fixed number of arguments, the Parser check
   the number of parameter passed.
*/

/*---------------------------------------------*/
/* macro to get the parameter on the stack     */
/* in reverse order                            */
/* Note that i-th parameter is Parameter(n-i)  */
/*---------------------------------------------*/

#define Parameter(i) EvalStack[EvalStackSize-(i)-1]

/* Obs.: The contage of parameter is i=0..(n-1) */
/* The above macor get parameter in reverse order:
   Parameter(0) = last
   Parameter(1) = pre last...
*/

/*--------------------------------------------*/

   static double p_rand(int n)
   /* rand() return value between [0,1] */
   {
   #ifdef _DEBUG_
    if(n != 0)
      ErrorStatus = UNKNOWNERROR;
   #endif
      return ((double)rand())/RAND_MAX;
   } /* p_rand() */


/*-----< begin:  two parameters p_max, p_min does not used >-----*/
/*

static double p_max(int n)
/ * max(a,b) * /
{
  #ifdef _DEBUG_
  if(EvalStackSize<2) { / * error will not occur if currect parsed * /
    ErrorStatus = ERROR;
    return 0;
  }
  #endif

  if(Parameter(0) > Parameter(1))
    return Parameter(0);
  else
    return Parameter(1);
} / * p_max * /

static double p_min(void)
/ * min(a,b) * /
{
  #ifdef _DEBUG_
  if(EvalStackSize<2) { / * error will not occur if currect parsed * /
    ErrorStatus = ERROR;
    return 0;
  }
  #endif

  if(Parameter(0) < Parameter(1))
    return Parameter(0);
  else
    return Parameter(1);
} / * p_min * /

*/
/*-----< end:  two parameters p_max, p_min does not used >-----*/


   static double p_max(int n)
   {
      int i;
      double maxval=0;
   
   #ifdef _DEBUG_
   if(n < 1) {
    ErrorStatus = ERROR;
    return 0;
   }
   #endif
      maxval = Parameter(0);
      for(i=1;i<n;i++) {
         if(Parameter(i) > maxval)
            maxval = Parameter(i);
      }
   
      return maxval;
   }

   static double p_min(int n)
   {
      int i;
      double minval=0;
   
   #ifdef _DEBUG_
   if(n < 1) {
    ErrorStatus = ERROR;
    return 0;
   }
   #endif
      minval = Parameter(0);
      for(i=1;i<n;i++) {
         if(Parameter(i) < minval)
            minval = Parameter(i);
      }
   
      return minval;
   }

   static double p_sum(int n)
   {
      int i;
      double val=0;
   
   #ifdef _DEBUG_
   if(n < 1) {
    ErrorStatus = TRUE;
    return 0;
   }
   #endif
      val = Parameter(0);
      for(i=1;i<n;i++)
         val += Parameter(i);
   
      return val;
   }

   static double p_med(int n)
   {
   #ifdef _DEBUG_
    if(n < 1) {
      ErrorStatus = TRUE;
      return 0;
    }
   #endif
      return p_sum(n)/n;
   }


/**************************************/
/*-----------< Evaluation >-----------*/
/**************************************/


/*------< main evaluator: internal use only >-----*/

   static int Evaluate(CODETOKENREC *ByteCode)
   /* Eval the parsed stack and return
   Caution: If add or delete the variables, Need new parse to
   Eval work correctly.
   Obs.: You will change code to get value of variable using
   GetValue(), but it make slower
   To check of errors: Before this calls, set errno variables to zero and after calls,
   check the value of errno for invarid function argument!
   */
   {
      int i;
      int numargs; /* used for function callings */
   /* errno = SUCESS; */ /* no errors */
   
      for(i=0;ByteCode[i].state != EMPTY; i++)
      {
         switch(ByteCode[i].state) {
            case VALUE    :
               if(EvalStackSize == EVALSTACKSIZE) {
                  ErrorStatus = OUTMEMORYERROR;
                  return ERROR;
               }
               EvalStack[EvalStackSize]=ByteCode[i].x.value;
               EvalStackSize++;
               break;
            case VARIABLE :
            /* get value of variable as value */
               EvalStack[EvalStackSize] = *ByteCode[i].x.var;
               EvalStackSize++;
               break;
            case FUNCTION1: /* Call the C internal functions with one parameter */
            #ifdef _DEBUG_
            if(EvalStackSize<1) /* error: It does not to occur if currect parsed. */
                   /* No value to evaluate function */
            return ERROR;
            #endif
               EvalStack[EvalStackSize-1]
                  = ByteCode[i].x.cf1(EvalStack[EvalStackSize-1]);
               break;
            case FUNCTION2 : /* Call the intern C function with two parameters */
            #ifdef _DEBUG_
            if(EvalStackSize < 2) /* error: It does not to occur if currect parsed. */
                   /* No value to evaluate function */
            return ERROR;
            #endif
               EvalStack[EvalStackSize-2]
                  = ByteCode[i].x.op2(EvalStack[EvalStackSize-2],EvalStack[EvalStackSize-1]);
               EvalStackSize--;
               break;
            case FUNCTION : /* Call the internal function */
            #ifdef _DEBUG_
            if((ByteCode[i].args == UNDEFARGS) && (EvalStackSize < 1) )
            return ERROR;
            /* EvalStackSize is size of Eval Stack */
            #endif
            
               numargs = ByteCode[i].args;
            #ifdef _DEBUG_
            if(numargs > EvalStackSize)
            return ERROR;
            #endif
            
               if((EvalStackSize-numargs) == EVALSTACKSIZE) {
                  ErrorStatus = OUTMEMORYERROR;
                  return ERROR;
               }
               EvalStack[EvalStackSize-numargs] = ByteCode[i].x.f(numargs);
               EvalStackSize -= (numargs - 1);
               break;
         
            default: /* invarid stack. It does not occur if currect parsed */
               return ERROR;
         }
      } /* for(i=0; ByteCode[i].state != EMPTY;i++); */
   #ifdef _DEBUG_
    if(EvalStackSize != 1)
      return ERROR; /* it need to 1 */
    else
      return SUCESS;
   #else
      return SUCESS;
   #endif
   } /* Evaluate */

/*-------< Evaluator for External use >-----*/

   double Eval(void)
   /* Evaluate the parsed expression */
   {
      EvalStackSize = 0; /* reset the Eval Stack */
   
      if(Evaluate(&CodeStack[0]) == SUCESS)
         return EvalStack[0];
      else { /* ErrorStatus arleady setted */
      #ifdef _DEBUG_
      ErrorStatus = ERROR;
      #endif
         return 0;
      }
   
   }

/***************************/
/*           Parser        */
/***************************/

/*--------< Stack and Token Operators >--------*/
   static char strbuff[STRBUFFLEN+1];

   int GetNumber(void)
   {
      int len, decimal;
   
   /* if number */
      if (!strchr("0123456789.", *input)) /* not a number */
         return FALSE;
   
   /* getting the number */
      len = 0;
      decimal = FALSE;
      while ((isdigit((int)input[len])) || ((input[len] == '.') &&
(!decimal))) {
         if (input[len] == '.')
            decimal = TRUE;
         len++;
      }
      if ((len == 1) && (input[0] == '.')) { /* is not a number */
         return FALSE;
      }
   /* if scientific notation */
      if (toupper(input[len]) == 'E') { /* cientific notation */
      /* decimal = TRUE */ /* to identify if integer or double */
         len++;
         if ((input[len] == '+') || (input[len] == '-')) {
            len++;
         }
         while(isdigit((int)input[len]))
            len++;
      }
   /* now, copy the token and conter to number */
   /* if decimal, is double. else is integer */
   
      strncpy(strbuff, input, len);
      strbuff[len] = 0; /* ending the string */
      input += len;
   
      CurTok.x.value = atof(strbuff);
      if ((len > STRBUFFLEN) || (errno == ERANGE))
         CurTok.state = BADNUM;
      else
         CurTok.state = NUMBER;
      return TRUE;
   } /* GetNumber */

   char *GetNameID(void)
   {
      int len;
   
      if (!isalpha((int)(*input)) && (*input != '_')) /* not a identifier
*/
         return NULL;
   
   /* identifier */
      len =0;
      while(isalnum((int)input[len]) || (input[len] == '_') )
         len++;
   
      strncpy(strbuff, input, len);
      strbuff[len] = 0; /* ending the string */
      input += len; /* advance the input */
   
      if(len > STRBUFFLEN) { /* identifier long */
         CurTok.state = BIGID;
      }
      return strbuff;
   } /* nameID() */


/* TOKENREC NextToken(char *str) */
   static int NextToken(void)
   /* Gets the next token from the input stream */
   {
      char *nameID;
   /* buff is used to identifier checkings */
   
   /*  if(str)
    input = str;
   */
   
      while (isspace((int)(*input)) )
         input++;
   
      if (*input == 0) {
         CurTok.state = EOSTR;
         return CurTok.state;
      }
   
      if(GetNumber())
         return CurTok.state;
      else if((nameID = GetNameID()) != NULL) { /* if identifier */
      /* checking the identifier type */
         if((CurTok.x.ptr = GetCFunc1(nameID)) != NULL) /* internal C functions */
            CurTok.state = CFUNC1;
         else if((CurTok.x.ptr=GetFunc(nameID)) != NULL) { /* internal functions */
            CurTok.args = GetFuncArgs(nameID);
            CurTok.state = FUNC;
         }
         
         else if((CurTok.x.ptr=GetSharedVar(nameID)) != NULL) /* shared variable */
            CurTok.state = VAR;
         else if(GetConst(nameID)) {  /* constant are treated as NUMBER */
            CurTok.state = NUMBER;
            CurTok.x.value = *GetConst(nameID);
         }
         else { /* new identifier */
            CurTok.state = UNKNOW;
            CurTok.x.ptr = NULL;
         }
      }
      else { /* will be operators or delimiters */
      
         switch(*(input++)) {
            case '+' : CurTok.state = PLUS;
               break;
            case '-' : CurTok.state = MINUS;
               break;
            case '*' : CurTok.state = TIMES;
               break;
            case '/' : CurTok.state = DIVIDE;
               break;
            case '%' : CurTok.state = MODULO;
               break;
            case '^' : CurTok.state = POWER;
               break;
            case ',' : CurTok.state = COMMA;
               break;
            case '(' : CurTok.state = OPAREN;
               break;
            case ')' : CurTok.state = CPAREN;
               break;
            default  : CurTok.state = INVALID;
         } /* switch */
      } /* else */
   
      return CurTok.state;
   } /* NextToken */


   static void push(PARSERTOKENREC *token)
   /* Pushes a new token onto the stack */
   {
      if (ParserStackSize == PARSERSTACKSIZE) /* no space on ParserStack */
         ErrorStatus = OUTMEMORYERROR;
      else
         ParserStack[ParserStackSize++] = *token;
   } /* push */

   static PARSERTOKENREC pop(void)
   /* Pops the top token off of the stack */
   {
   #ifdef _DEBUG_
   if(ParserStackSize)
   #endif
      return(ParserStack[--ParserStackSize]);
   } /* pop */

/**************************/
/* CodeStack operations */
/**************************/
#ifdef _DEBUG_
void PrintCodeStack(struct CODETOKENREC *token)
/* print the Code Stack status */
{
  int i;

  switch(token->state) {
    case EMPTY: printf("EMPTY\n");
      break;
	case VALUE:
	  printf("VALUE: %lf\n", token->x.value);
	  break;
	case VARIABLE:
	  printf("VARIABLE: ");
	    for(i=0; (SharedVars[i].name != NULL) && /* llok up the shared variables */
		   (SharedVars[i].var != token->x.var); i++);
	    if(SharedVars[i].name != NULL)
	      printf("%s\n", SharedVars[i].name);
	    else if((void *)unary_minus == (void *)token->x.var)
	      printf("unary MINUS\n");
	    else
	      printf("unknown\n");
	  break;
	case FUNCTION1:
	  printf("FUNCTION1: ");
	  for(i=0; (CFunc1[i].name != NULL) && /* llok up the intern C functions */
		   ((void *)CFunc1[i].f != (void *)token->x.var); i++);
	  if(CFunc1[i].name != NULL)
	    printf("%s\n", CFunc1[i].name);
	  else
	    printf("unknown\n");
	  break;
	case FUNCTION2:
	  printf("FUNCTION2 (binary operator): ");
	  if((void *)binary_plus == (void *)token->x.var)
	    printf("PLUS\n");
	  else if((void *)binary_minus == (void *)token->x.var)
	    printf("MINUS\n");
	  else if((void *)binary_times == (void *)token->x.var)
	    printf("TIMES\n");
	  else if((void *)binary_divide == (void *)token->x.var)
	    printf("DIVIDE\n");
	  else if((void *)binary_power == (void *)token->x.var)
	    printf("POWER\n");
	  else
	    printf("unknown\n");
	  break;
	case FUNCTION:
	  printf("FUNCTION: ");
	  for(i=0; (Funcs[i].name != NULL) && /* llok up the internal functions */
		   ((void *)Funcs[i].f != (void *)token->x.var); i++);
	  if(Funcs[i].name != NULL)
	    printf("%s\n", Funcs[i].name);
	  else
	    printf("unknown.\n");
	  break;
	default: printf("UNKNOWN\n");
    }

} /* PrintCodeStack */

#endif


   static void CodeStkPush(struct CODETOKENREC *token)
   /* Pushes a new token onto the parsed code stack */
   {
   #ifdef _DEBUG_
    printf("CodeStackPush(): ");
    PrintCodeStack(token);
    if (CodeStackSize == EVALSTACKSIZE) {
      printf("Eval Stack Overfull\n");
    }
   #endif
   
      if (CodeStackSize == EVALSTACKSIZE)
         ErrorStatus = OUTMEMORYERROR;
      else
         CodeStack[CodeStackSize++] = *token;
   } /* CodeStkPush */


   static void Level1(void);  /* assignment */
   static void Level2(void);  /* binary plus/minus */
   static void Level3(void);  /* timed, divide, modulo */
   static void Level4(void);  /* power */
   static void Level5(void);  /* unary minus */
   static void Level6(void);  /* atom: functions, variables, numbers...*/

   int Parse(char *expression)
   /* Parse the expression */
   {
      input = expression;
      ParserStackSize = 0;
      CodeStackSize = 0; /* reset the parsed stack */
      ErrorStatus = SUCESS;
   
      NextToken();
      Level1();
      CodeStack[CodeStackSize].state = EMPTY; /* endding the stack */
      CodeStackSize++;
   
      if(CurTok.state != EOSTR) /* if remain token */
         ErrorStatus = NOSINGLEEXPERROR;
   
      ParseErrorPos = (int)(input - expression);
      return ErrorStatus;
   }

   static void Level1(void)
   /* assignment: not used in Eval Lite  */
   {
      Level2();
   } /* level1() */

   static void Level2(void)
   /* level 2 operator: binary plus/minus */
   {
      int state;
   
      Level3();
   
      while(((state=CurTok.state) == PLUS) || (state == MINUS)) {
         NextToken();
         Level3();
      
      /* binary operator as internal functions */
         CurCodeTok.state = FUNCTION2;
         if(state == PLUS)
            CurCodeTok.x.op2 = binary_plus;
         else /* (state == MINUS) */
            CurCodeTok.x.op2 = binary_minus;
         CodeStkPush(&CurCodeTok);
      } /* while */
   } /* Level2() */


   static void Level3(void)
   /* level 3 operator: multiplication, division, modulo */
   
   {
      int state;
   
      Level4();
   
      while( ((state=CurTok.state) == TIMES) || (state == DIVIDE)
           || (state == MODULO) ) {
         NextToken();
         Level4();
      
      /* binary operator as internal functions */
         CurCodeTok.state = FUNCTION2;
         if(state == TIMES)
            CurCodeTok.x.op2 = binary_times;
         else if(state == DIVIDE)
            CurCodeTok.x.op2 = binary_divide;
         else /* (state == MODULO) */
            CurCodeTok.x.op2 = fmod;
         CodeStkPush(&CurCodeTok);
      }
   }

   static void Level4(void)
   /* level 4 operator: power */
   {
   
      Level5();
   
      if(CurTok.state == POWER) {
         NextToken();
         Level5();
      
         CurCodeTok.state = FUNCTION2;
         CurCodeTok.x.op2 = binary_power;
         CodeStkPush(&CurCodeTok);
         return;
      }
   }

   static void Level5(void)
   /* level 5 operator: unary plus/minus */
   {
      int state;
   
      if(((state=CurTok.state) == PLUS) || (state == MINUS))
         NextToken();
      Level6();
   
      if(state == MINUS) {
         CurCodeTok.state = FUNCTION1;
         CurCodeTok.x.cf1 = unary_minus;
         CodeStkPush(&CurCodeTok);
      }
   }


   static void Level6(void)
   /* level 6: literal numbers, variables and functions */
   {
      int  i;
   
   /* parentesis expression */
      if(CurTok.state == OPAREN) {
         NextToken();
         if(CurTok.state == CPAREN) {
            ErrorStatus = NOEXPERROR;
            return;
         }
         Level1();
      
         if(CurTok.state == CPAREN)
            NextToken();
         else
            ErrorStatus = CPARENERROR;/* ( E_UNBALAN ); */
      }
      
      /* Number */
      else if(CurTok.state == NUMBER) { /* numbers */
         CurCodeTok.state = VALUE;
         CurCodeTok.x.value = CurTok.x.value;
         CodeStkPush(&CurCodeTok);
         NextToken();
      }
      
      /* variables */
      else if(CurTok.state == VAR) { /* variables */
         CurCodeTok.state = VARIABLE;
         CurCodeTok.x.var = CurTok.x.ptr;
         CodeStkPush(&CurCodeTok);
         NextToken();
      }
      
      /* internal C function with one parameters */
      else if(CurTok.state == CFUNC1) { /* one parameter C functions */
         push(&CurTok);
         NextToken();
         if(CurTok.state != OPAREN) {
            ErrorStatus = OPARENERROR;
            return;
         }
         NextToken();
         if(CurTok.state == CPAREN) {
            ErrorStatus = NOEXPERROR;
            return;
         }
         Level1();
         if(CurTok.state != CPAREN) {
            ErrorStatus = CPARENERROR;
            return;
         }
         CurTok = pop();
         CurCodeTok.state = FUNCTION1;
         CurCodeTok.x.cf1 = CurTok.x.ptr;
         CodeStkPush(&CurCodeTok);
         NextToken();
      }
      
      /* internal functions */
      else if(CurTok.state == FUNC) { /* internal functions */
         push(&CurTok);
         NextToken();
         if(CurTok.state != OPAREN) {
            ErrorStatus = OPARENERROR;
            return;
         }
         NextToken();
         if(CurTok.state == CPAREN)
            i = 0;
         else { /* parameters exist */
            Level1();
         /* NextToken(); */ /* Leval1() call NextToken() */
            i = 1;
            while((!ErrorStatus) && (CurTok.state != EOSTR)
                 &&(CurTok.state != CPAREN)) {
               if(CurTok.state == COMMA) {
                  NextToken();
                  i++;
               }
               else {
                  ErrorStatus = UNKNOWNERROR;
                  return; /* UNKNOWN ERROR */
               }
               Level1();
            }
            if(CurTok.state != CPAREN) {
               ErrorStatus = CPARENERROR;
               return;
            }
         }
         CurTok = pop();
      
         if ((CurTok.args != UNDEFARGS) && (i != CurTok.args)) { /* i is current number of parameters */
         /* invalid number of parameters */
            ErrorStatus = PARAMNOTMACHERROR;
            return;
         }
      
      /* number of parameters is correct */
      /* now, put the function */
         CurCodeTok.state = FUNCTION;
      
         CurCodeTok.args = i;  /* i is number of arguments */
         CurCodeTok.x.f = CurTok.x.ptr;
         CodeStkPush(&CurCodeTok);
         NextToken();
      }
      
      /* End of buffer */
      else if (CurTok.state == EOSTR) {
         ErrorStatus = ENDEXPERROR;
      }
      else if (CurTok.state == UNKNOW) {
         ErrorStatus = UNDEFINDENTERROR;
      }
      else if (CurTok.state == BADNUM) {
         ErrorStatus = BADNUMERROR;
      }
      else { /* it not occur */
         ErrorStatus = UNKNOWNERROR; /* unknow */
      }
   
   } /* level6() */

#ifdef _TEST_

/* parser/eval tester */
#define STRBUFFSIZE 100

/* testing ... */
int main()
{
  /* for variable sharing/setting example */
  double x, y, z;  /* x, y are used to table example too */
  char *s;
  /* for table example */
  char expr[STRBUFFSIZE];
  int i, m;
  double a, b, h;

  printf("variable sharing/setting example\n");

  /* sharing with internal variables ... */
  if(RegisterSharedVar("a", &x))
    printf("\"a\" is shared with internal variable \"x\"\n");
  else
    printf("Error sharing \"a\" with internal variable \"x\"\n");
  x = 9;
  printf("internal variable \"x\" is set to %f\n",x);
  y = GetValue("a");
  if(ErrorStatus == SUCESS)
    printf("a=%f\n", y);
  else
    printf("\"a\" not exist\n");

  z=12;
  if(SetValue("a", z))
    printf("the value of \"a\" is set to %f\n", z);
  else
    printf("can not set the value of \"a\"\n");
  printf("x= %f\n", x);

  /* parse/eval test */
  printf("\nparse/eval expression example\n");
  s = "a+sin(pi/2)";
  printf("now parsing the expression %s\n", s);
  if(Parse(s) == SUCESS) {
    printf("evaluating...\n");
    z=Eval();
    printf("the result is %f\n", z);
  }
  else {
    printf("Parse Error\n");
    printf("Error: %s\n", ParseErrorMsg());
    printf(" %s\n", s);
    printf(" %*s^\n", ParseErrorPos-1, "" );
  }


  /* table making example */
  printf("\nfunction tabling example\n");
  ClearSharedVars();
  /* sharing with internal variables ... */
  if(!RegisterSharedVar("x", &x)) {
    printf("Error sharing \"x\" with internal variable x\n");
    return ERROR;
  }
  do {

    printf("Enter expression of x: ");

    /* Obs.: scanf() does not eliminate '\n' */
    do { /* use this loop, if using gets() after scanf() callings () */
      gets(expr); /* to read the expression, do not use scanf(), because
		   scanf() read only one words */
    } while(expr[0] == 0);


    printf("now parsing the expression %s\n", expr);
    if(Parse(expr) != SUCESS) {
      printf(" Error on parsing.\n");
      printf(" %s\n", ParseErrorMsg());
      printf(" %s\n", expr);
      printf(" %*s^\n", ParseErrorPos-1, "" );
    }
  } while(ErrorStatus != SUCESS);

  printf("a= "); scanf("%lf", &a);
  printf("b= "); scanf("%lf", &b);
  printf("m= "); scanf("%d", &m);


  h = (b-a)/m;
  x = a;
  printf("x        y\n");
  for(i=0; i<=m; i++) {
    y = Eval();
    printf("%f    %f\n", x, y);
    x = x + h;
  }


  return 0;
}


#endif /* _TEST_ */

/* end of eval.c */
