# makefile for Gnu C

# $Id: unixmak.dos 1.4 1995/11/22 10:53:50 ASR Exp $
# $Log: unixmak.dos $
# Revision 1.4  1995/11/22 10:53:50  ASR
# First version under RCS
#

CC      = gcc
CC_OPTS = -c -Wall -O -ansi

all: lingua lingdemo etftest

test:
	lingdemo
	lingdemo english
	lingdemo francais
	lingdemo deutsch
	lingdemo nl
	etftest english
	etftest francais
	etftest deutsch
	etftest nl

clean:
	del *.o
	del lingua lingdemo etftest
	del *.etf
	del ui_text.h

lingua: lingua.o
	$(CC) -o lingua lingua.o

lingdemo: lingdemo.o ui_text.o
	$(CC) -o lingdemo lingdemo.o ui_text.o

etftest: etftest.o ui_text.o
	$(CC) -o etftest etftest.o ui_text.o

lingua.o: lingua.c lingua.h

lingdemo.o: lingdemo.c ui_text.h

ui_text.o: ui_text.c lingua.h files.inc

etftest.o: etftest.c ui_text.h

ui_text.h: english.txt
	lingua english
	lingua francais
	lingua deutsch
	lingua nl

.c.o:
	$(CC) $(CC_OPTS) $<

