; written by Eric Matteson       acalc.asm  version 1.1
; This calculator program for DOS is a free program.
; This assembley language source code is required to be included in
; the internet zip file that contains the calculator acalc.com
;  Acalc is a 64-bit technoligy calculator. The carry flag and quadruple
; operands allow the 8086 16-bit CPU to perform 64-bit integer arithmetic.
; The purpose here is to prove that simple subroutines can be written to
; perform 64-bit integer arithmetic on a 16-bit real mode CPU. Already
; exsisting hard disks are already too large for EIDE. The first step
; of upgrading the BIOS ROMS is to develop 64-bit integer arithmetic
; in real mode. All BIOS ROM companies are urged to examine the 64-bit
; integer math routines  hsubtract64  hadd64  hmpy64  hiabs64  hposdiv64
; in this calculator program. The 64-bit math subroutines in here are
; also free and may be re-used in BIOS ROMS and hard disk drive drivers
; for FAT 64. FAT 64 requires 64-bit integer arithmetic.
; This calculator program is here to test
; those arithmetic subroutines . This is a reverse Polish notation
; calculator. Number enter   number enter  operation enter.
;    ericmatteson2001@yahoo.com
; ----------------------------------------------------------------
;  ericmatteson2001@yahoo.com   This  acalc.asm  makes acalc.com
    bits 16
    org 0100h
    mov sp,0fff4h
    xor di,di
    push ds
    push di
    sub sp,01ff0h
    mov bp,sp
    jmp calcmain
; begin Keyboard and screen I/O subroutines section ----
; rintshield(type,axi,cxi,dxi,bxi)
; RIntshield is used to save BX BP SI DI ES DS while in interrupt
; ES and DS are set to SS for dos interrupt because SS contains
; LOCAL DS value for DOS routines. DS ES restored afterwards.
; Carry flag setting during error is or CX,0008h If no dos
; error CX is set to 0000h. (carry flag itself is destroyed
; by ADD SP,000AH after returning from this !!!!!!!! )
; AX and DX are returned with values resulting from interrupt.
;  18 bxi       16 dxi       14 cxi
;  12 axi      10 type      0e retad      0c disave      0a sisave
;  08 bpsave      06 bxsave      04 dssave    02 essave    00 intvar
rintshield:  push di
      push si
      push bp
      push bx
      push ds
      push es
      xor di,di
      push di
      mov bp,sp
      mov si,ss
      mov ds,si
      mov es,si
      mov ax,[bp+012h]
      mov cx,[bp+014h]
      mov dx,[bp+016h]
      mov bx,[bp+018h]
      cmp word [bp+010h],010h
      jz iten
      cmp word [bp+010h],021h
      jz idos
      cmp word [bp+010h],033h
      jz imouse
unknownint:  pop di
      pop es
      pop ds
      pop bx
      pop bp
      pop si
      pop di
      ret
idos:  clc
      int 21h
      jnb xcxint
ierrorset:  or word [bp+00h],08h
xcxint:  mov cx,[bp+00h]
      jmp unknownint
iten:  int 10h
      jmp unknownint
imouse:  int 33h
         mov ax,bx
      jmp unknownint
rdosquit:  mov ax,04c00h
      push ax
      push ax
      push ax
      push ax
      mov ax,0021h
      push ax
      call rintshield
      add sp,0ah
      jmp rdosquit
; line 0074 end of rintshield
; keycline(*xyptr,width)
; bp+di+04c bp+22       bp+di+010h bp+04
; 22 width
; 20 *xyptr    1e retad    1c disave    1a sisave    18 bpsave    16 bxsave
; 14 dxsave    12 cxsave   10 axsave    0e xsave     0c  0a bsel    08 cstb
; 06 nzcst     04 xvalue     02 ctrc      00
keycline:    push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      mov cx,08h
      xor bx,bx
keypushtop:    push bx
      dec cx
      jnz keypushtop
      mov bp,sp
      mov ax,[bp+04h]
      mov [bp+0eh],ax
; ??????????????????????????????
      mov ax,[bp+0020h]
      sub ax,bp
      mov [bp+0ah],ax
      mov cx,[bp+022h]
      mov di,ax
keyclrline:  mov byte [bp+di+00h],020h
      inc di
      dec cx
      jnz keyclrline
keyupc:  xor cx,cx
      or cx,cx
      jnz keyupc
      mov word [bp+06h],0001h
keydc:   mov si,[bp+02h]
         cmp si,[bp+022h]
         jns donekeydc
         mov ax,si
         inc ax
         mov [bp+04h],ax
keydcr:  mov cx,0021h
         mov si,0000h
         mov ax,0100h
         push si
      push si
      push si
      push ax
      push cx
      call rintshield
      add sp,000ah
      and ax,00ffh
      mov cx,0001h
      cmp al,0ah
      jz keydcr
      cmp al,0dh
      jnz afterkeydc
      mov cx,000ah
      mov ax,0200h
      mov si,0000h
      push si
      push cx
      push si
      mov si,0021h
      push ax
      push si
      call rintshield
      add sp,000ah
      mov ax,000dh
      mov cx,0001h
afterkeydc:    dec cx
      jz regkeydc
      mov si,[bp+02h]
      cmp si,[bp+022h]
      jns donekeydc
      add si,[bp+0ah]
      mov byte [bp+si],020h
      inc word [bp+02h]
      jmp regkeydc
donekeydc:  mov ax,[bp+0eh]
            mov [bp+04h],ax
           add sp,010h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
regkeydc:  mov si,[bp+02h]
      cmp si,[bp+022h]
      jns donekeydc
      add si,[bp+0ah]
      and ax,007fh
      cmp ax,0020h
      js nonregkeyc
      mov [bp+si],al
      inc word [bp+02h]
      jmp keydc
nonregkeyc:    mov byte [bp+si],020h
      cmp al,08h
      jz bkspacec
      cmp al,0dh
      jz donekeydc
      inc word [bp+02h]
bkspacedone:   jmp keydc
bkspacec:  cmp word [bp+02h],01h
      js bkspacedone
      dec word [bp+02h]
      dec si
      mov byte [bp+si],020h
      jmp keydc
; ------- bottom of keycline(*xyptr,width)
; onescreen(character)
; 10 character   0e retad    0c disave   0a sisave    08 bpsave
; 06 bxsave      04 dxsave   02 cxsave   00 axsave
onescreen:  push di
            push si
      push bp
      push bx
      push dx
      push cx
      push ax
      mov bp,sp
      cmp word [bp+010h],0100h
      jns wendl
      cmp word [bp+010h],000dh
      jz wendl
      cmp word [bp+010h],0024h
      jz wendl
      mov cx,00h
      mov di,0021h
      mov dx,[bp+0010h]
      mov ax,0200h
      push cx
      push dx
      push cx
      push ax
      push di
      call rintshield
      add sp,000ah
onescreenb:  pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
wendl:  mov di,000dh
wendm:  mov si,0021h
      mov cx,0000h
      mov ax,0200h
      push cx
      push di
      push cx
      push ax
      push si
      call rintshield
      add sp,000ah
      cmp di,000ah
      jz onescreenb
      mov di,000ah
      jmp wendm
; end of onescreen
; jout(*ptr,len,delim)
; 14 delim     12 len      10 *ptr     0e retad     0c disave
; 0a sisave    08 bpsave   06 bxsave   04 dxsave    02 cxsave    00 axsave
jout:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      mov bp,sp
negbleno:   cmp word [bp+012h],0000h
      jz upperquito
      jns posbleno
      jmp negaleno
upperquito:  jmp bottomoj
posbleno:   mov cx,[bp+0012h]
      mov di,[bp+0010h]
      sub di,bp
posaleno:  dec cx
      jns keepjoutl
      mov ax,024h
      push ax
      call onescreen
      add sp,02h
delimro:   cmp word [bp+0012h],058h
      jns upperquito
      mov di,0000h
      sub di,[bp+0012h]
      mov [bp+0012h],di
      jmp negbleno
keepjoutl:  mov al,[bp+di+00h]
      and ax,00ffh
      push ax
      call onescreen
      add sp,02h
      inc di
      cmp al,[bp+0014h]
      jz delimro
      jmp posaleno
negaleno:   mov di,[bp+0010h]
      sub di,bp
      mov ax,0000h
      sub ax,[bp+0012h]
      mov cx,ax
      mov dx,0020h
negcleno:  dec cx
      cmp cx,0000h
      jns negdleno
      jmp upperquito
negdleno:  mov [bp+di+00h],dl
      inc di
      jmp negcleno
bottomoj:  pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; end of keyboard and screen I/O subroutines section ----
; Permission is granted to copy the source code for 64-bit integer
; arithmetic below into programs for BIOS ROMS to increase hard disk
; drive capacity in BIOS ROMS and into hard disk drive drivers.
; Modern hard disks exceed the 8gb capacity of EIDE. FAT 64 is already
; required on already exsisting hard disk drives !!!!
; The 16-bit 8086 includes a carry flag so four sets of 16-bit ordinals
; can be combined to enable real mode programming to perform 64-bit
; arithmetic in this newly discovered miricle of computer science.
; begin 64-bit integer math library.
; old version of 32-bit C++ pushes rightmost argument first
; before calling subroutine and returns 32-bit result in DX:AX
; on 16-bit systems. Upgrading to 64-bit integer math returns SI:BX:DX:AX
; CX is used by subtract to return flags. Bit 3 borrow   bit 2 sign
; bit 1 unequal.
; SP is down by 16 ( 0010h ) before calling subroutine because of
; 8 arguments.  BP is preserved and DI is still preserved by the math
; subroutines.
; Rightmost ( least significant ) 16-bit argument is still pushed first
; before calling math subroutines. Each 64 bit number uses up four 16-bit
; arguments ....
;----------------------------------
;  SI:BX:DX:AX = hsubtract64(L3124,L2316,L1508,L0700,R3124,R2316,R1508,R0700)
; also returns with cx = flags
; 14 R0700   12 R1508   10 R2316   0E R3124
; 0C L0700   0A L1508   08 L2316   06 L3124    04 retad   02 disave  00 bpsave
hsubtract64:  push di
      push bp
      mov bp,sp
      mov ax,[bp+0ch]
      mov dx,[bp+0ah]
      mov bx,[bp+08h]
      mov si,[bp+06h]
      clc
      sbb ax,[bp+014h]
      sbb dx,[bp+012h]
      sbb bx,[bp+010h]
      sbb si,[bp+00eh]
      jb zaresdone
      jnz zaresdone
     mov di,ax
      or di,dx
      or di,bx
      or di,si
      jz zaresdone
      or di,000fh
      and di,000fh
zaresdone:  jb zabparcond
            js zasparcond
            je zaeqcond
zagrcond:   mov cx,0002h
      jmp zacmpbot
zaeqcond:  xor cx,cx
      jmp zacmpbot
zasparcond:  mov cx,0006h
      jmp zacmpbot
zabparcond:  js zabscond
      je zabeqcond
zabgrcond:  mov cx,000ah
      jmp zacmpbot
zabeqcond:  mov cx,0008h
      mov di,ax
      or  di,dx
      or  di,bx
      or  di,si
      jnz zabgrcond
      jmp zacmpbot
zabscond:  mov cx,000eh
zacmpbot:  pop bp
           pop di
           ret
;------------------------------ end of hsubtract64
;--------------------------------------------------------------------------
;  SI:BX:DX:AX = hadd64(L3124,L2316,L1508,L0700,R3124,R2316,R1508,R0700)
; also returns with CX=flags   bit 3 carry    bit 2 sign    bit 1 unequal flag
; 14 R0700   12 R1508   10 R2316   0E R3124
; 0C L0700   0A L1508   08 L2316   06 L3124    04 retad   02 disave  00 bpsave
hadd64:  push di
         push bp
      mov bp,sp
      mov ax,[bp+0ch]
      mov dx,[bp+0ah]
      mov bx,[bp+08h]
      mov si,[bp+06h]
      clc
      adc ax,[bp+014h]
      adc dx,[bp+012h]
      adc bx,[bp+010h]
      adc si,[bp+00eh]
      jb aresdone
      jnz aresdone
     mov di,ax
      or di,dx
      or di,bx
      or di,si
      jz aresdone
      or di,000fh
      and di,000fh
aresdone:  jb abparcond
           js asparcond
           je aeqcond
agrcond:   mov cx,0002h
      jmp acmpbot
aeqcond:  xor cx,cx
      jmp acmpbot
asparcond:  mov cx,0006h
      jmp acmpbot
abparcond:  js abscond
      je abeqcond
abgrcond:  mov cx,000ah
      jmp acmpbot
abeqcond:  mov cx,0008h
      mov di,ax
      or  di,dx
      or  di,bx
      or  di,si
      jnz abgrcond
      jmp acmpbot
abscond:  mov cx,000eh
acmpbot:  pop bp
           pop di
           ret
;-------------------------  end of hadd64
;-----------------------------------------------------
; SI:BX:DX:AX = hmpy64(L3124,L2316,L1508,L0700,R3124,R2316,R1508,R0700)
; 16 r0700    14 r1508    12 r2316    10 r3124
; 0E L0700    0C L1508    0A L2316    08 L3124
; 06 RETAD    04 DISAVE   02 BPSAVE   00 CXSAVE
hmpy64:  push di
      push bp
      push cx
      mov bp,sp
      xor ax,ax
      xor dx,dx
      xor bx,bx
      xor si,si
hmpyfast64:  mov cx,0001h
      and cx,[bp+016h]
      jz hskipaddm
      push ax
      push dx
      push bx
      push si
      push word [bp+0eh]
      push word [bp+0ch]
      push word [bp+0ah]
      push word [bp+08h]
      call hadd64
      add sp,0010h
hskipaddm:  clc
      rcr word [bp+0010h],1
      rcr word [bp+0012h],1
      rcr word [bp+0014h],1
      rcr word [bp+0016h],1
      clc
      rcl word [bp+0eh],1
      rcl word [bp+0ch],1
      rcl word [bp+0ah],1
      rcl word [bp+08h],1
     mov cx,[bp+0010h]
      or cx,[bp+0012h]
      or cx,[bp+0014h]
      or cx,[bp+0016h]
      jz hmpyboty64
      jmp hmpyfast64
hmpyboty64:  pop cx
      pop bp
      pop di
      ret
;------------------------------------------------- end of hmpy64
; SI:BX:DX:AX = hiabs64(L3124,L2316,L1508,L0700)
; also returns with cx = 0 positive     cx != 0 for negative argument.
; 0e L0700    0c L1508    0a L2316    08 L3124
; 06 retad    04 disave   02 bpsave   00 cxsave
hiabs64:  push di
          push bp
          push cx
          mov bp,sp
      mov ax,[bp+0eh]
      mov dx,[bp+0ch]
      mov bx,[bp+0ah]
      mov si,[bp+08h]
      xor cx,cx
      mov [bp+00h],cx
      cmp si,cx
      jns hiabsbot
      mov word [bp+00h],000fh
      xor cx,cx
      push ax
      push dx
      push bx
      push si
      push cx
      push cx
      push cx
      push cx
      call hsubtract64
      add sp,0010h
hiabsbot:  pop cx
           pop bp
           pop di
           ret
; -------------------------------------end of hiabs64
; ------------------------------------------------------
; SI:BX:DX:AX = hposdiv64(t3124,t2316,t1508,t0700,R3124,R2316,R1508,R0700)
; 96 R0700     94 R1508     92 R2316     90 R3124
; 8E t0700     8C t1508     8A t2316     88 t3124
; 86 retad     84 disave    82 sisave    80 bpsave
; 7E bxsave    7C dxsave    7A cxsave    78 axsave
; 76 big3124   74 big2316   72 big1508   70 big0700
; 6E resu3124  6C resu2316  6A resu1508  68 resu0700
; 66 ctr       64 negctr    62           60
; 5E num3124   5C num2316   5A num1508   58 num0700
; 56 den3124   54 den2316   52 den1508   50 den0700
hposdiv64:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      xor di,di
      mov cx,000ah
hposzur64z:  push di
      dec cx
      jnz hposzur64z
      sub sp,0064h
      mov bp,sp
      push word [bp+096h]
      push word [bp+094h]
      push word [bp+092h]
      push word [bp+090h]
      call hiabs64
      add sp,0008h
      add [bp+064h],cx
      mov [bp+050h],ax
      mov [bp+052h],dx
      mov [bp+054h],bx
      mov [bp+056h],si
      push word [bp+008eh]
      push word [bp+008ch]
      push word [bp+008ah]
      push word [bp+0088h]
      call hiabs64
      add sp,0008h
      add [bp+064h],cx
      mov [bp+058h],ax
      mov [bp+05ah],dx
      mov [bp+05ch],bx
      mov [bp+05eh],si
hposdivloop:  clc
      rcl word [bp+058h],1
      rcl word [bp+05ah],1
      rcl word [bp+05ch],1
      rcl word [bp+05eh],1
      rcl word [bp+070h],1
      rcl word [bp+072h],1
      rcl word [bp+074h],1
      rcl word [bp+076h],1
      clc
      rcl word [bp+068h],1
      rcl word [bp+06ah],1
      rcl word [bp+06ch],1
      rcl word [bp+06eh],1
      push word [bp+050h]
      push word [bp+052h]
      push word [bp+054h]
      push word [bp+056h]
      push word [bp+070h]
      push word [bp+072h]
      push word [bp+074h]
      push word [bp+076h]
      call hsubtract64
      add sp,0010h
      and cx,0008h
      jnz hskipdiv
      mov [bp+070h],ax
      mov [bp+072h],dx
      mov [bp+074h],bx
      mov [bp+076h],si
      push word [bp+068h]
      push word [bp+06ah]
      push word [bp+06ch]
      push word [bp+06eh]
      mov cx,0001h
      mov di,0000h
      push cx
      push di
      push di
      push di
      call hadd64
      add sp,0010h
      mov [bp+0068h],ax
      mov [bp+006ah],dx
      mov [bp+006ch],bx
      mov [bp+006eh],si
hskipdiv:  inc word [bp+066h]
      cmp word [bp+066h],0040h
      jns hbotdiv
      jmp hposdivloop
hbotdiv:  mov cx,01h
      and cx,[bp+064h]
      jz hbotpos
      push word [bp+068h]
      push word [bp+06ah]
      push word [bp+06ch]
      push word [bp+06eh]
      mov cx,0000h
      push cx
      push cx
      push cx
      push cx
      call hsubtract64
      add sp,0010h
      mov [bp+068h],ax
      mov [bp+06ah],dx
      mov [bp+06ch],bx
      mov [bp+06eh],si
hbotpos:  add sp,0068h
      pop word [bp+078h]
      pop word [bp+07ch]
      pop word [bp+07eh]
      pop word [bp+082h]
      add sp,0008h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; --------------------------------------end of hposdiv64
; The functions above hsubtract64(b,t) hadd64(b,t) hmpy64(b,r) hiabs64(h)
; hposdiv64(t,d)  prove that 64-bit integer arithmetic is definitly possible
; even within 16-bit real mode. It is absoultley essential that future
; motherboards BIOS ROMS accomidate the FAT 64 hard disks that already
; exsist. Use the above five functions to increase hard disk usable area.
;  SI:BX:DX:AX = himage64(L3124,L2316,L1508,L0700,R3124,R2316,R1508,R0700)
; --------
; 16 R0700   14 R1508   12 R2316   10 R3124
; 0E L0700   0C L1508   0A L2316   08 L3124    06 retad   04 disave  02 bpsave
; 00 cxsave
himage64:  push di
         push bp
         push cx
      mov bp,sp
      push word [bp+0eh]
      push word [bp+0ch]
      push word [bp+0ah]
      push word [bp+08h]
      push word [bp+0eh]
      push word [bp+0ch]
      push word [bp+0ah]
      push word [bp+08h]
      call hadd64
      add sp,0010h
      push word [bp+016h]
      push word [bp+014h]
      push word [bp+012h]
      push word [bp+010h]
      push ax
      push dx
      push bx
      push si
      call hsubtract64
      add sp,0010h
      pop cx
      pop bp
      pop di
      ret
; end of 64-bit arithmetic section
;-----------------------------------------
; jload64(*dest,*src)
; 12 *src   10 *dest   0e retad   0c disave   0a sisave   08 bpsave
; 06 bxsave   04 dxsave   02 cxsave   00 axsave
jload64:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      mov bp,sp
      mov di,[bp+0010h]
      mov si,[bp+0012h]
      sub di,bp
      sub si,bp
      mov cx,0008h
jlopload64:  mov dl,[bp+si]
      mov [bp+di],dl
      inc di
      inc si
      dec cx
      jnz jlopload64
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; SI:BX:DX:AX = getdigit(charvalue)
; 08 charvalue   06 retad    04 disave    02 bpsave    00 cxsave
getdigit:  push di
      push bp
      push cx
      mov bp,sp
      mov di,[bp+08h]
      and di,00ffh
      mov ax,007fh
      cmp di,0030h
      js digfail
      cmp di,003ah
      jns uctry
      sub di,0030h
aasolve:  mov ax,di
      jmp digfail
uctry:  cmp di,0041h
      js digfail
      cmp di,0047h
      jns rctry
      sub di,0037h
      jmp aasolve
rctry:  cmp di,0061h
      js digfail
      cmp di,0067h
      jns digfail
      sub di,0057h
      jmp aasolve
digfail:  xor dx,dx
          xor bx,bx
      xor si,si
      pop cx
      pop bp
      pop di
      ret
; SI:BX:DX:AX = getnumber(*lineptr,start,width,base)
; 30 base     2e width    2c start    2a *lineptr
; 28 retad    26 disave   24 sisave   22 bpsave
; 20 bxsave   1e dxsave   1c cxsave   1a axsave
; 18 r3124    16 r2316    14 r1508    12 r0700
; 10 counter  0e          0c          0a       08
; 06 digitsave
getnumber:  push di
           push si
      push bp
      push bx
      push dx
      push cx
      push ax
      xor di,di
      mov cx,000dh
zurnumberlop:  push di
      dec cx
      jnz zurnumberlop
      mov bp,sp
waitnumber:  mov di,[bp+0010h]
      cmp di,[bp+002eh]
      js earlynumber
badnumber:  jmp numberfail
earlynumber:  add di,[bp+002ch]
      dec di
      add di,[bp+002ah]
      inc word [bp+0010h]
      sub di,bp
      mov al,[bp+di]
      push ax
      call getdigit
      add sp,0002h
      cmp ax,[bp+0030h]
      jns waitnumber
      dec word [bp+0010h]
digitnumber:  mov di,[bp+0010h]
      cmp di,[bp+002eh]
      jns badnumber
      add di,[bp+002ch]
      dec di
      add di,[bp+002ah]
      inc word [bp+0010h]
      sub di,bp
      mov al,[bp+di]
      push ax
      call getdigit
      add sp,0002h
      cmp ax,[bp+0030h]
      js keepnumber
      jmp numberfail
keepnumber:   mov [bp+06h],ax
      mov cx,0000h
      push word [bp+0030h]
      push cx
      push cx
      push cx
      push word [bp+0012h]
      push word [bp+0014h]
      push word [bp+0016h]
      push word [bp+0018h]
      call hmpy64
      add sp,0010h
      push ax
      push dx
      push bx
      push si
      xor cx,cx
      push word [bp+0006h]
      push cx
      push cx
      push cx
      call hadd64
      add sp,0010h
      mov [bp+0012h],ax
      mov [bp+0014h],dx
      mov [bp+0016h],bx
      mov [bp+0018h],si
      jmp digitnumber
numberfail:  add sp,0012h
      pop word [bp+001ah]
      pop word [bp+001eh]
      pop word [bp+0020h]
      pop word [bp+0024h]
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; putnumber(*dest,start,width,base,in3124,in2316,in1508,in0700)
; 4e in0700    4c in1508     4a in2316     48 in3124
; 46 base      44 width      42 start      40 *dest
; 3e retad     3c disave     3a sisave     38 bpsave
; 36 bxsave    34 dxsave     32 cxsave     30 axsave
; 2e           2c            2a            28
; 26 fr3124    24 fr2316     22 fr1508     20 fr0700
; 1e counter   1c digit      1a trackneg   18
putnumber:  push di
      push si
      push bp
      push bx
      push dx
      push cx
      push ax
      xor di,di
      mov cx,0018h
puloopber:  push di
      dec cx
      jnz puloopber
      mov bp,sp
      mov cx,[bp+044h]
      mov [bp+001eh],cx
      add cx,[bp+042h]
      dec cx
      add cx,[bp+040h]
      mov di,cx
      sub di,bp
      mov ax,000dh
      mov [bp+di],al
      mov ax,0024h
      mov [bp+di+01h],al
      cmp word [bp+048h],0000h
      jns putnuloop
      mov cx,[bp+046h]
      dec cx
      mov [bp+001ah],cx
      push word [bp+04eh]
      push word [bp+04ch]
      push word [bp+04ah]
      push word [bp+048h]
      mov cx,01h
      xor di,di
      push cx
      push di
      push di
      push di
      call hadd64
      add sp,0010h
      xor di,di
      push ax
      push dx
      push bx
      push si
      push di
      push di
      push di
      push di
      call hsubtract64
      add sp,0010h
      mov [bp+04eh],ax
      mov [bp+04ch],dx
      mov [bp+04ah],bx
      mov [bp+048h],si
putnuloop:  mov di,[bp+01eh]
      dec di
      jns putnukeep
      mov [bp+01eh],di
      jmp putnubot
putnukeep:  mov [bp+01eh],di
      add di,[bp+042h]
      dec di
      add di,[bp+040h]
      sub di,bp
      xor cx,cx
      push word [bp+046h]
      push cx
      push cx
      push cx
      push word [bp+04eh]
      push word [bp+04ch]
      push word [bp+04ah]
      push word [bp+048h]
      call hposdiv64
      add sp,0010h
      mov [bp+020h],ax
      mov [bp+022h],dx
      mov [bp+024h],bx
      mov [bp+026h],si
      xor cx,cx
      push word [bp+046h]
      push cx
      push cx
      push cx
      push ax
      push dx
      push bx
      push si
      call hmpy64
      add sp,0010h
      push ax
      push dx
      push bx
      push si
      push word [bp+04eh]
      push word [bp+04ch]
      push word [bp+04ah]
      push word [bp+048h]
      call hsubtract64
      add sp,0010h
      cmp word [bp+001ah],0000h
      jz nonminustwo
      mov dx,[bp+001ah]
      sub dx,ax
      mov ax,dx
nonminustwo:  mov [bp+01ch],ax
      mov ax,[bp+020h]
      mov dx,[bp+022h]
      mov bx,[bp+024h]
      mov si,[bp+026h]
      mov [bp+04eh],ax
      mov [bp+04ch],dx
      mov [bp+04ah],bx
      mov [bp+048h],si
      mov cx,[bp+01ch]
      cmp cx,000ah
      jns bigdigitout
      add cx,0030h
      jmp regdigitout
bigdigitout:  add cx,0037h
regdigitout:  mov ax,cx
      mov [bp+di],al
      jmp putnuloop
putnubot: add sp,0030h
      pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; jshift(*array,howmany)
; 12 hownany   10 array    0e retad    0c disave    0a sisave    08 bpsave
; 06 bxsave    04 dxsave   02 cxsave   00 axsave
jshift:  push di
         push si
      push bp
      push bx
      push dx
      push cx
      push ax
      mov bp,sp
jshiftjoop:  mov si,[bp+012h]
      dec si
      js jshiftbott
      mov [bp+012h],si
      add si,si
      add si,si
      add si,si
      add si,[bp+0010h]
      mov di,si
      add di,0008h
      push si
      push di
      call jload64
      add sp,04h
      jmp jshiftjoop
jshiftbott:  pop ax
      pop cx
      pop dx
      pop bx
      pop bp
      pop si
      pop di
      ret
; -------------------------- main
; bp+00h to 07ffh is array      0800h to 084fh is inline   0850 to 089f outline
; 0900 base     0902 width      0904 lzsctrone   0906 lzsctrtwo
calcmain:   lea si,[bp+0850h]
            xor cx,cx
            mov ax,0ffb0h
            push cx
            push ax
            push si
            call jout
            add sp,06h
            mov word [bp+0900h],000ah
            mov word [bp+0902h],0014h
      lea si,[startline]
      mov cx,0024h
      mov ax,0400h
      push cx
      push ax
      push si
      call jout
      add sp,06h
calcloop:  lea si,[bp+0800h]
      mov cx,[bp+0902h]
      push cx
      push si
      call keycline
      add sp,04h
      mov al,[bp+0800h]
      cmp al,02dh
      jnz notminus
      jmp loopminus
notminus:  cmp al,02bh
      jnz notplus
      jmp loopplus
notplus:  cmp al,02ah
      jnz notmpy
      jmp loopmpy
notmpy:  cmp al,02fh
      jnz notposdiv
      jmp loopposdiv
notposdiv:  cmp al,026h
      jnz notimage
      jmp loopimage
notimage:  cmp al,07eh
      jnz notchs
      jmp loopchsgn
notchs:  cmp al,02eh
      jnz check48
      add sp,01ff0h
      retf
check48:  cmp al,030h
      js nan
      cmp al,03ah
      jns nan
      mov cx,0001h
      push word [bp+0900h]
      push word [bp+0902h]
      push cx
      lea cx,[bp+0800h]
      push cx
      call getnumber
      add sp,0008h
numberfinish:  mov cx,05h
      push cx
      push bp
      call jshift
      add sp,0004h
onenumberbtt:  mov [bp+00h],ax
               mov [bp+02h],dx
               mov [bp+04h],bx
               mov [bp+06h],si
      jmp calcloop
nan:  jmp calcmain
loopimage:  xor cx,cx
      push word [bp+00h]
      push word [bp+02h]
      push word [bp+04h]
      push word [bp+06h]
      push word [bp+08h]
      push word [bp+0ah]
      push word [bp+0ch]
      push word [bp+0eh]
; type of command
      call himage64
      add sp,0010h
;  common calcresult for two operand operators
calcresult:  mov cx,[bp+0902h]
             push ax
      push dx
      push bx
      push si
      push word [bp+0900h]
      push cx
      mov cx,01h
      push cx
      lea cx,[bp+0850h]
      push cx
      call putnumber
      add sp,0010h
      mov word [bp+0904h],0000h
      mov word [bp+0906h],0000h
lzsloop:  mov cx,[bp+0904h]
      inc cx
      cmp cx,[bp+0902h]
      jns lzsdone
      mov di,[bp+0904h]
      cmp byte [bp+di+0850h],030h
      jnz lzsdone
      mov di,[bp+0904h]
      mov [bp+0906h],di
      inc word [bp+0904h]
      jmp lzsloop
lzsdone:   mov cx,0024h
      xor di,di
      push cx
      lea cx,[bp+0850h]
      add cx,[bp+0906h]
      push word [bp+0902h]
      push cx
      call jout
      add sp,06h
      jmp numberfinish
;     jmp numberfinish for two operand operators    onenumberbtt for one
loopposdiv: xor cx,cx
      push word [bp+00h]
      push word [bp+02h]
      push word [bp+04h]
      push word [bp+06h]
      push word [bp+08h]
      push word [bp+0ah]
      push word [bp+0ch]
      push word [bp+0eh]
      call hposdiv64
      add sp,0010h
      jmp calcresult
loopmpy: xor cx,cx
      push word [bp+00h]
      push word [bp+02h]
      push word [bp+04h]
      push word [bp+06h]
      push word [bp+08h]
      push word [bp+0ah]
      push word [bp+0ch]
      push word [bp+0eh]
      call hmpy64
      add sp,0010h
      jmp calcresult
loopplus:  xor cx,cx
      push word [bp+00h]
      push word [bp+02h]
      push word [bp+04h]
      push word [bp+06h]
      push word [bp+08h]
      push word [bp+0ah]
      push word [bp+0ch]
      push word [bp+0eh]
      call hadd64
      add sp,0010h
      jmp calcresult
loopminus:  xor cx,cx
      push word [bp+00h]
      push word [bp+02h]
      push word [bp+04h]
      push word [bp+06h]
      push word [bp+08h]
      push word [bp+0ah]
      push word [bp+0ch]
      push word [bp+0eh]
      call hsubtract64
      add sp,0010h
      jmp calcresult
loopchsgn:  xor cx,cx
      push word [bp+00h]
      push word [bp+02h]
      push word [bp+04h]
      push word [bp+06h]
      push cx
      push cx
      push cx
      push cx
      call hsubtract64
      add sp,0010h
;  common oncalcresult for one operand operators
oncalcresult:  mov cx,[bp+0902h]
             push ax
      push dx
      push bx
      push si
      push word [bp+0900h]
      push cx
      mov cx,01h
      push cx
      lea cx,[bp+0850h]
      push cx
      call putnumber
      add sp,0010h
      mov word [bp+0904h],0000h
      mov word [bp+0906h],0000h
onlzsloop:  mov cx,[bp+0904h]
      inc cx
      cmp cx,[bp+0902h]
      jns onlzsdone
      mov di,[bp+0904h]
      cmp byte [bp+di+0850h],030h
      jnz onlzsdone
      mov di,[bp+0904h]
      mov [bp+0906h],di
      inc word [bp+0904h]
      jmp onlzsloop
onlzsdone:   mov cx,0024h
      xor di,di
      push cx
      lea cx,[bp+0850h]
      add cx,[bp+0906h]
      push word [bp+0902h]
      push cx
      call jout
      add sp,06h
      jmp onenumberbtt
;     jmp onenumberbtt for one number operators that do not need shifting
; bottom of calculator main program
startline  db "free 64-bit reverse "
           db 0dh
           db "Polish notation     "
           db 0dh
           db " integer calculator "
           db 0dh
           db " program  acalc.com "
           db 0dh
           db "ericmatteson2001@yah"
           db 0dh
           db "oo.com  number enter"
           db 0dh
           db " number enter       "
           db 0dh
           db " operation enter    "
           db 0dh
           db " + add   - subtract "
           db 0dh
           db "* multiply  / divide"
           db 0dh
           db " ~ change sign      "
           db 0dh
           db " & image     . quit "
           db 0dh
           db "vote against the    "
           db 0dh
           db "U.S. military draft."
           db 024h
; written by Eric Matteson       acalc.asm  version 1.1
; This calculator program for DOS is a free program.
; This assembley language source code is required to be included in
; the internet zip file that contains the calculator acalc.com
;  Acalc is a 64-bit technoligy calculator. The carry flag and quadruple
; operands allow the 8086 16-bit CPU to perform 64-bit integer arithmetic.
; The purpose here is to prove that simple subroutines can be written to
; perform 64-bit integer arithmetic on a 16-bit real mode CPU. Already
; exsisting hard disks are already too large for EIDE. The first step
; of upgrading the BIOS ROMS is to develop 64-bit integer arithmetic
; in real mode. All BIOS ROM companies are urged to examine the 64-bit
; integer math routines  hsubtract64  hadd64  hmpy64  hiabs64  hposdiv64
; in this calculator program. The 64-bit math subroutines in here are
; also free and may be re-used in BIOS ROMS and hard disk drive drivers
; for FAT 64. FAT 64 requires 64-bit integer arithmetic.
; This calculator program is here to test
; those arithmetic subroutines . This is a reverse Polish notation
; calculator. Number enter   number enter  operation enter.
;    ericmatteson2001@yahoo.com
; ----------------------------------------------------------------
;  ericmatteson2001@yahoo.com   This  acalc.asm  makes acalc.com
