
/*============================================================================

	BIOSDRIV.H
	BIOS supported drive related stuff. Prototypes of BIOSDRIV.ASM.
  This file is part of the

  PseudoCD package (version 02)
  Copyright (C) C.Kulms, 1997

  This is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This software is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this software; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

============================================================================*/

#ifndef _BIOSDRIV_H_
#define _BIOSDRIV_H_

#define BIOS_READ		0x02	/* BIOS int 13h 'read sectors' */
#define BIOS_WRITE	0x03	/* BIOS int 13h 'write sectors (with verify)' */
#define BOOTID	0xAA55		/* id of a boot-record */

typedef struct s_PARTITION	/* partition table entry */
{
	unsigned char	ucBootFlag;	/* either 0x80=active partition or 0 */
	unsigned char	ucFHead;		/* head of start-sector */
	unsigned char	ucFSec;			/* bit9.8 of first track | sector of start-sector */
	unsigned char	ucFTrack;		/* bit7...0 of start-track */
	unsigned char	ucOsId;			/* OS-Id / file system */
	unsigned char	ucLHead;		/* head of last sector */
	unsigned char	ucLSec;			/* bit9.8 of last track | sector of last sector */
	unsigned char	ucLTrack;		/* bit7...0 of last track */
	unsigned long	ulFirstSector;	/* number of first sector */
	unsigned long	ulNumSectors;		/* number of sectors in partition */
}	t_PARTITION;

typedef struct s_MPR	/* Master Partition Record (or MatserBootRecord) */
{
	unsigned char	ucBootCode[0x01BE];	/* code or whatever */
	t_PARTITION		tPartition[4];			/* partition table */
	unsigned			uBootId;						/* must be BOOTID */
}	t_MPR;

typedef struct s_HDDATA	/* HDD parameters */
{
	unsigned char		ucBiosDriveNo;	/* BIOS' drive number */
	unsigned 				uTracks;				/* number of tracks */
	unsigned char		ucHeads;				/* numebr of heads */
	unsigned char		ucSectors;			/* number of sectors per head 'n track */
	unsigned				uHSPT;					/* heads * sectors_per_head/track */
	t_PARTITION			tPartition[4];	/* partition table */
}	t_HDDATA;

typedef struct s_DISK	/* disk/partition parameter */
{
	int							iDrive;					/* drive it is on (counted from 0) */
	unsigned				uPartitionNo;		/* partition entry (>0x0E0 for extended) */
	unsigned long		ulFirstSector;	/* first sector of partition */
	unsigned long		ulNumSectors;		/* partition size in sectors */
}	t_DISK;

/*
	lower functions; see file 'BIOSDRIV.ASM'
*/
BIOS_GetDriveType( int iDrive );
BIOS_GetDriveData( int iDrive, unsigned far *fpuTracks, unsigned char far *fpuHeads, unsigned char far *fpuSecs );
int BIOS_RWSectors( int iCmd, void far *fpBuffer, int iDrive, unsigned uTrack, int iHead, int iSec, int iCount );

#endif /* ndef _BIOSDRIV_H_ */

