Version 1.00
BEGIN Form frmMolarMass
	AutoRedraw   = -1
	BackColor    = QBColor(7)
	BorderStyle  = 2
	Caption      = "Molar Mass"
	ControlBox   = -1
	Enabled      = -1
	ForeColor    = QBColor(0)
	Height       = Char(18)
	Left         = Char(13)
	MaxButton    = -1
	MinButton    = -1
	MousePointer = 0
	Tag          = ""
	Top          = Char(2)
	Visible      = -1
	Width        = Char(67)
	WindowState  = 0
	BEGIN TextBox txtNumber
		BackColor    = QBColor(3)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 0
		Left         = Char(6)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 7
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(2)
		Visible      = -1
		Width        = Char(11)
	END
	BEGIN TextBox txtNumber
		BackColor    = QBColor(3)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 1
		Left         = Char(6)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 9
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(4)
		Visible      = -1
		Width        = Char(11)
	END
	BEGIN TextBox txtNumber
		BackColor    = QBColor(3)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 2
		Left         = Char(6)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 11
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(6)
		Visible      = -1
		Width        = Char(11)
	END
	BEGIN TextBox txtNumber
		BackColor    = QBColor(3)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 3
		Left         = Char(6)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 13
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(8)
		Visible      = -1
		Width        = Char(11)
	END
	BEGIN TextBox txtNumber
		BackColor    = QBColor(3)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 4
		Left         = Char(6)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 15
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(10)
		Visible      = -1
		Width        = Char(11)
	END
	BEGIN TextBox txtNumber
		BackColor    = QBColor(3)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 5
		Left         = Char(6)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 17
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(12)
		Visible      = -1
		Width        = Char(11)
	END
	BEGIN TextBox txtNumber
		BackColor    = QBColor(3)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 6
		Left         = Char(6)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 19
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(14)
		Visible      = -1
		Width        = Char(11)
	END
	BEGIN TextBox txtNumber
		BackColor    = QBColor(3)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 7
		Left         = Char(6)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 21
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(16)
		Visible      = -1
		Width        = Char(11)
	END
	BEGIN TextBox txtNumber
		BackColor    = QBColor(3)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 8
		Left         = Char(6)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 23
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(18)
		Visible      = -1
		Width        = Char(11)
	END
	BEGIN TextBox txtNumber
		BackColor    = QBColor(3)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 9
		Left         = Char(6)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 25
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(20)
		Visible      = -1
		Width        = Char(11)
	END
	BEGIN TextBox txtElement
		BackColor    = QBColor(11)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 1
		Left         = Char(1)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 8
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(4)
		Visible      = -1
		Width        = Char(4)
	END
	BEGIN TextBox txtElement
		BackColor    = QBColor(11)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 2
		Left         = Char(1)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 10
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(6)
		Visible      = -1
		Width        = Char(4)
	END
	BEGIN TextBox txtElement
		BackColor    = QBColor(11)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 3
		Left         = Char(1)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 12
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(8)
		Visible      = -1
		Width        = Char(4)
	END
	BEGIN TextBox txtElement
		BackColor    = QBColor(11)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 4
		Left         = Char(1)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 14
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(10)
		Visible      = -1
		Width        = Char(4)
	END
	BEGIN TextBox txtElement
		BackColor    = QBColor(11)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 5
		Left         = Char(1)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 16
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(12)
		Visible      = -1
		Width        = Char(4)
	END
	BEGIN TextBox txtElement
		BackColor    = QBColor(11)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 6
		Left         = Char(1)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 18
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(14)
		Visible      = -1
		Width        = Char(4)
	END
	BEGIN TextBox txtElement
		BackColor    = QBColor(11)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 7
		Left         = Char(1)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 20
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(16)
		Visible      = -1
		Width        = Char(4)
	END
	BEGIN TextBox txtElement
		BackColor    = QBColor(11)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 8
		Left         = Char(1)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 22
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(18)
		Visible      = -1
		Width        = Char(4)
	END
	BEGIN TextBox txtElement
		BackColor    = QBColor(11)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 9
		Left         = Char(1)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 24
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(20)
		Visible      = -1
		Width        = Char(4)
	END
	BEGIN TextBox txtElement
		BackColor    = QBColor(14)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 0
		Left         = Char(1)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 6
		TabStop      = -1
		Tag          = ""
		Text         = ""
		Top          = Char(2)
		Visible      = -1
		Width        = Char(4)
	END
	BEGIN CommandButton cmdClear
		BackColor    = QBColor(7)
		Cancel       = 0
		Caption      = "&Clear"
		Default      = 0
		DragMode     = 0
		Enabled      = -1
		Height       = Char(3)
		Left         = Char(53)
		MousePointer = 0
		TabIndex     = 3
		TabStop      = -1
		Tag          = ""
		Top          = Char(11)
		Visible      = -1
		Width        = Char(12)
	END
	BEGIN Label lblMolarMass
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = "Molar Mass:"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Left         = Char(15)
		MousePointer = 0
		TabIndex     = 4
		Tag          = ""
		Top          = Char(21)
		Visible      = -1
		Width        = Char(11)
	END
	BEGIN CommandButton cmdCustom
		BackColor    = QBColor(7)
		Cancel       = 0
		Caption      = "C&ustom..."
		Default      = 0
		DragMode     = 0
		Enabled      = -1
		Height       = Char(3)
		Left         = Char(53)
		MousePointer = 0
		TabIndex     = 0
		TabStop      = -1
		Tag          = ""
		Top          = Char(5)
		Visible      = -1
		Width        = Char(12)
	END
	BEGIN CommandButton cmdMore
		BackColor    = QBColor(7)
		Cancel       = 0
		Caption      = "M&ore"
		Default      = 0
		DragMode     = 0
		Enabled      = -1
		Height       = Char(3)
		Left         = Char(53)
		MousePointer = 0
		TabIndex     = 2
		TabStop      = -1
		Tag          = ""
		Top          = Char(8)
		Visible      = -1
		Width        = Char(12)
	END
	BEGIN CommandButton cmdPrint
		BackColor    = QBColor(7)
		Cancel       = 0
		Caption      = "Print"
		Default      = 0
		DragMode     = 0
		Enabled      = -1
		Height       = Char(3)
		Left         = Char(19)
		MousePointer = 0
		TabIndex     = 1
		TabStop      = 0
		Tag          = ""
		Top          = Char(2)
		Visible      = 0
		Width        = Char(12)
	END
	BEGIN Label lblHeading
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = "&Symbol   Number      Percent      Elemental Molar Mass"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Left         = Char(0)
		MousePointer = 0
		TabIndex     = 5
		Tag          = ""
		Top          = Char(1)
		Visible      = -1
		Width        = Char(54)
	END
END
' Updated:  October, 1996 by Christopher King
'
' ------------------------------------------------------------------------
'               Copyright (C) 1996 by Christopher King
'
' You have a royalty-free right to use, modify, reproduce and distribute
' the OneOhOne Files (and/or any modified version) in any way you find
' useful, provided that you agree that Christopher King has no warranty,
' obligations or liability for any OneOhOne Files.
' ------------------------------------------------------------------------
DECLARE FUNCTION sGetFormula () AS STRING
'$FORM frmHelp
DECLARE SUB ScreenSizeChange (BYVAL nvSize%)
DECLARE SUB NumberFormat (BYVAL dNumber AS DOUBLE, BYVAL dStdDev AS DOUBLE, BYVAL TabStop%, srMsg AS STRING, rPrintX AS INTEGER)
DECLARE SUB txtNumber_GotFocus (Index AS INTEGER)
DECLARE SUB txtElement_KeyPress (Index AS INTEGER, KeyAscii AS INTEGER)
DECLARE SUB txtNumber_LostFocus (Index AS INTEGER)
DECLARE SUB GeneralNumberFormat (BYVAL dNumber AS DOUBLE, BYVAL dStdDev AS DOUBLE, BYVAL TabStop%, srMsg AS STRING, rPrintX AS INTEGER)
DECLARE SUB RowRemove (BYVAL Index%)
DECLARE SUB RowInsert (BYVAL Index%)
DECLARE SUB ParenthesesFactor ()
DECLARE SUB txtElement_LostFocus (Index AS INTEGER)
DECLARE SUB ParenthesesEvaluate ()
'$FORM frmCustom
'$FORM frmMdi
DECLARE SUB cmdClear_Click ()
DECLARE SUB txtElement_GotFocus (Index AS INTEGER)
DECLARE SUB txtElement_DragOver (Index AS INTEGER, Source AS CONTROL, X AS SINGLE, Y AS SINGLE, State AS INTEGER)
DECLARE SUB cmdMore_Click ()
DECLARE SUB Initialize_Form ()
DECLARE SUB Calculate ()
DECLARE SUB PeriodicTable (sSymbol AS STRING, AtomicMass AS DOUBLE, Uncertainty AS SINGLE)
OPTION EXPLICIT
DEFINT A-Z

'$INCLUDE: 'common.bi'

DIM SHARED msSymbol() AS STRING * 3    ' Symbol of each atom
DIM SHARED dMassElement() AS DOUBLE
DIM SHARED fStdDevElement() AS SINGLE
DIM SHARED mfNumberOfAtoms() AS SINGLE
DIM SHARED Variance() AS SINGLE   ' These two are only used in Calculate,
DIM SHARED dMassOfAtoms() AS DOUBLE  ' but for compatability with VB for Windows, arrays are placed in the main module.
DIM SHARED mfParenthesisFactor() AS SINGLE ' Parenthesis coefficients multiplier.
DIM SHARED mbParenthesisGood()    ' Indicates unmatched parentheses.
DIM SHARED mParenthesisType()         ' Type of parenthesis.
DIM SHARED mParenthesisRange()
DIM SHARED mbKeyPressDeletesPreviousEntry
DIM SHARED mMolarMassPositionY
DIM SHARED mMaxIndex
DIM SHARED gsOriginalText AS STRING
DIM SHARED msIntDecimal AS STRING * 1
DIM SHARED msIntComma AS STRING * 1
TYPE Brace
   Type AS INTEGER      ' Type of parenthesis
   Actual AS INTEGER    ' Actual index number of this parenthesis
END TYPE
DIM SHARED mBrace() AS Brace
DIM SHARED mbUnmatchedParenthesis

CONST YELLOW = 14
CONST CYAN = 3
CONST BRIGHT_CYAN = 11

CONST KEY_RETURN = 13           ' Enter key
CONST KEY_ESCAPE = 27
CONST KEY_UP = 38
CONST KEY_DOWN = 40
CONST KEY_BACK = 8
CONST KEY_DELETE = 127          ' Delete key returns 46 in Visual Basic for Windows.

CONST enter = 0
CONST LEAVE = 1

' Calculates % Comp., molar mass, and displays results by calling
' NumberFormat.
SUB Calculate ()

DIM dMolarMass AS DOUBLE
DIM dInvMolarMass AS DOUBLE
DIM N AS INTEGER
DIM fStdDev AS SINGLE
DIM dVarianceTotal AS DOUBLE
DIM dPercent AS DOUBLE
DIM fStdDevPercent AS SINGLE
DIM Decimal
DIM bNonZero
DIM sMsg AS STRING
DIM PrintX
DIM Index

   ON LOCAL ERROR GOTO OverFlowError
   FOR N = 0 TO mMaxIndex
      IF msSymbol(N) <> "   " AND mfNumberOfAtoms(N) > 0 AND mfParenthesisFactor(N) <> 0 THEN
         dMassOfAtoms(N) = dMassElement(N) * mfNumberOfAtoms(N) * mfParenthesisFactor(N)
         Variance(N) = fStdDevElement(N) * fStdDevElement(N) * mfNumberOfAtoms(N) * mfNumberOfAtoms(N) * mfParenthesisFactor(N) * mfParenthesisFactor(N)
         dMolarMass = dMassOfAtoms(N) + dMolarMass
         dVarianceTotal = dVarianceTotal + Variance(N)
         bNonZero = TRUE   ' If all entries are "" or 0 then don't calculate.
      END IF
   NEXT N
   ' **************************** Output *************************************
   CLS
   IF bNonZero = TRUE THEN
      ' Go ahead and print to screen.
      dInvMolarMass = 1 / dMolarMass
      FOR N = 0 TO mMaxIndex
         IF msSymbol(N) <> "   " AND mfNumberOfAtoms(N) > 0 THEN

            ' Set print position.
            IF mMaxIndex > 10 THEN
               CurrentY = 2 + N + N \ 5
            ELSE
               CurrentY = 2 + 2 * N
            END IF

            ' ***************** Percent ********************
            dPercent = dMassOfAtoms(N) / dMolarMass  ' Multiply by 100 when print.
               ' Can't use dInvMolarMass in above line; x/x doesn't always give 1.
            IF mfParenthesisFactor(N) = 0 THEN
               ' This before next ELSEIF to handle H*H).  Second H would print as 100 otherwise.
               PrintX = 23
               sMsg = "()?"
            ELSEIF dPercent = 1& THEN
               PrintX = 23
               sMsg = "100"
            ELSE
               fStdDevPercent = dInvMolarMass * SQR((1 - 2 * dPercent) * Variance(N) + dPercent * dPercent * dVarianceTotal) * 100
               IF fStdDevPercent = 0 THEN
                  ' Needed for compound "H1 H 1e-12".
                  PrintX = 21
                  sMsg = "Near " + FORMAT$(dPercent * 100, "0")
               ELSE
                  NumberFormat dPercent * 100, fStdDevPercent, 21, sMsg, PrintX
               END IF
            END IF
            CurrentX = PrintX
            PRINT sMsg;

            ' ***************** Atomic Mass *********************
            NumberFormat dMassElement(N), fStdDevElement(N), 39, sMsg, PrintX
            CurrentX = PrintX
            PRINT sMsg;
         END IF
      NEXT N

      ' **************  Molar mass ******************
      IF dVarianceTotal = 0 THEN
         PrintX = 31

         sMsg = "Near" + STR$(dMolarMass)
      ELSE
         NumberFormat dMolarMass, SQR(dVarianceTotal), 39, sMsg, PrintX
      END IF
      CurrentX = PrintX
      CurrentY = mMolarMassPositionY
      IF mbUnmatchedParenthesis THEN
         cmdPrint.Tag = ""
      ELSE
         cmdPrint.Tag = sMsg  ' Save value so other forms can access it.
      END IF
      PRINT sMsg;
   ELSE
      ' All entries are "" or 0.
      cmdPrint.Tag = ""  ' Save value so other forms can access it.
      FOR N = 0 TO mMaxIndex
         IF msSymbol(N) <> "   " AND mfNumberOfAtoms(N) > 0 THEN
            ' Set print position.
            IF mMaxIndex > 10 THEN
               CurrentY = 2 + N + N \ 5
            ELSE
               CurrentY = 2 + 2 * N
            END IF
            ' ***************** Percent ********************
            IF mfParenthesisFactor(N) = 0 THEN
               CurrentX = 23
               PRINT "()?";
            END IF
         END IF
      NEXT N
   END IF

EXIT SUB

OverFlowError:
   IF ERR = 6 THEN   ' overflow
      sMsg = "The number you entered is too large to handle."
   ELSE
      sMsg = "Error number" + STR$(ERR) + CHR$(10) + ERROR$ + CHR$(10)
      sMsg = sMsg + "If you can reproduce this, the author would like to know about it."
   END IF
   MSGBOX sMsg, 0, "Number Entry"

   Index = VAL(frmMolarMass.Tag)
   IF Index >= 0 THEN
      txtElement(Index).Text = gsOriginalText
      txtElement(Index).SETFOCUS
   ELSE
      txtNumber(-Index - 1).Text = gsOriginalText
      txtNumber(-Index - 1).SETFOCUS
   END IF

   EXIT SUB
END SUB

SUB cmdClear_Click ()
   CLS
   Initialize_Form
   txtElement(0).SETFOCUS
END SUB

SUB cmdCustom_Click ()
   DIM Index
   frmCustom.SHOW 1
   Index = VAL(frmMolarMass.Tag)
   IF Index >= 0 THEN
      txtElement(Index).SETFOCUS
   ELSE
      txtNumber(-Index - 1).SETFOCUS
   END IF
END SUB

' Changes from 25 to 43 lines on the screen, and back.
SUB cmdMore_Click ()
   DIM N
   DIM saveElement AS STRING
   DIM saveNumber AS STRING
   DIM Index
   DIM BlankLine, nPreviousWindowState
   frmMdi.HIDE ' Which hides all forms on it.
   frmMolarMass.HIDE
   Index = VAL(frmMolarMass.Tag)
   IF cmdMore.Caption = "M&ore" THEN
      ON LOCAL ERROR GOTO ManyLinesError
      WIDTH 80, 43
      ON LOCAL ERROR GOTO 0
      cmdMore.Caption = "&Less"
      frmMdi.mnuWindowLines.Caption = "Fewer &Lines"
      saveElement = txtElement(0).Text
      txtElement(0).Text = ""
      txtElement(0).BackColor = BRIGHT_CYAN
      saveNumber = txtNumber(0).Text
      txtNumber(0).Text = "1"
      txtNumber(0).BackColor = CYAN
      FOR N = 1 TO 9
         BlankLine = N \ 5
         txtElement(N).Top = N + 2 + BlankLine
         txtNumber(N).Top = N + 2 + BlankLine
      NEXT N
      FOR N = 10 TO 29
         BlankLine = N \ 5
         LOAD txtElement(N)
         txtElement(N).Top = N + 2 + BlankLine
         txtElement(N).Visible = TRUE

         LOAD txtNumber(N)
         txtNumber(N).Top = N + 2 + BlankLine
         txtNumber(N).Visible = TRUE
         'txtNumber(N).Text = "1"

         ' Initialize arrays.
         msSymbol(N) = ""
         mfNumberOfAtoms(N) = 1
         mfParenthesisFactor(N) = 1
         mParenthesisType(N) = 0

      NEXT N
      txtElement(0).Text = saveElement
      txtNumber(0).Text = saveNumber
      mMaxIndex = 29
      mMolarMassPositionY = 38
      lblMolarMass.Top = mMolarMassPositionY
      cmdCustom.Top = 3
      cmdMore.Top = 6
      cmdClear.Top = 9
      ScreenSizeChange 1   ' Changes sizes of "visible" forms.
      frmMolarMass.CLS
      frmMolarMass.HIDE
      frmMdi.SHOW
      nPreviousWindowState = WindowState     ' Save previous window state.
      ' Can't change height of minimized or maximized form,
      ' so temporarily change state while form is hidden.
      WindowState = 0
      'END IF
      frmMolarMass.Height = 41
      WindowState = nPreviousWindowState     ' Restore previous window state.
      frmMolarMass.SHOW
      IF Index >= 0 THEN
         txtElement(Index).SETFOCUS
      ELSE
         txtNumber(-Index - 1).SETFOCUS
      END IF
   ELSE
      cmdMore.Caption = "M&ore"
      frmMdi.mnuWindowLines.Caption = "More &Lines"
      FOR N = 10 TO 29
         UNLOAD txtElement(N)
         UNLOAD txtNumber(N)
      NEXT N
      WIDTH 80, 25
      FOR N = 1 TO 9
         txtElement(N).Top = 2 * N + 2
         txtNumber(N).Top = 2 * N + 2
      NEXT N
      mMaxIndex = 9
      mMolarMassPositionY = 21
      lblMolarMass.Top = mMolarMassPositionY
      cmdCustom.Top = 5
      cmdMore.Top = 8
      cmdClear.Top = 11
      ScreenSizeChange 0   ' Changes sizes of "visible" forms.
      frmMolarMass.HIDE    ' These HIDE's reduce flicker during SHOW's.
      frmMolarMass.CLS

      ' Can't change height of minimized or maximized form,
      ' so temporarily change state while form is hidden.
      nPreviousWindowState = WindowState     ' Save previous window state.
      WindowState = 0
      frmMolarMass.Top = 0 ' In case user moved it below line 25.
      frmMolarMass.Height = 24
      WindowState = nPreviousWindowState     ' Restore previous window state.

      frmMdi.SHOW
      frmMolarMass.SHOW
      IF Index < 10 AND Index > -11 THEN
         IF Index >= 0 THEN
            txtElement(Index).SETFOCUS
         ELSE
            txtNumber(-Index - 1).SETFOCUS
         END IF
      ELSE
         txtElement(0).SETFOCUS
      END IF
   END IF
   Calculate   ' Can't print to form that's not showing.
   EXIT SUB

ManyLinesError:
   WIDTH 80, 25
   cmdMore.Visible = FALSE
   frmMdi.mnuWindowLines.Visible = FALSE
   frmMdi.mnuWindowSeparator.Visible = FALSE
   frmMdi.SHOW
   frmMolarMass.SHOW
   txtElement(0).SETFOCUS
   MSGBOX "Your computer does not support 43 lines on the screen.", 0, "More Button"
   EXIT SUB

END SUB

' Prints the results showing on the screen, if any.  Calls NumberFormat
SUB cmdPrint_Click ()

DIM dMolarMass AS DOUBLE
DIM dInvMolarMass AS DOUBLE
DIM N
DIM dVarianceTotal AS DOUBLE
DIM dPercent AS DOUBLE
DIM fStdDevPercent AS SINGLE
DIM bNonZero
DIM sMsg AS STRING
DIM PrintX
DIM sFormula AS STRING, nFormulaLen

ON LOCAL ERROR GOTO PrinterError
   FOR N = 0 TO mMaxIndex
      IF msSymbol(N) <> "   " AND mfNumberOfAtoms(N) > 0 AND mfParenthesisFactor(N) THEN
         dMassOfAtoms(N) = dMassElement(N) * mfNumberOfAtoms(N) * mfParenthesisFactor(N)
         Variance(N) = fStdDevElement(N) * fStdDevElement(N) * mfNumberOfAtoms(N) * mfNumberOfAtoms(N) * mfParenthesisFactor(N) * mfParenthesisFactor(N)
         dMolarMass = dMassOfAtoms(N) + dMolarMass
         dVarianceTotal = dVarianceTotal + Variance(N)
         bNonZero = TRUE   ' If all entries are "" or 0 then don't calculate.
      END IF
   NEXT N
   ' **************************** Output *************************************

   IF bNonZero = TRUE THEN
      dInvMolarMass = 1 / dMolarMass
      Printer.PRINT "Symbol     Number      % Composition    Elemental Molar Mass"
      Printer.PRINT "______  ____________  _______________   ____________________"
      FOR N = 0 TO mMaxIndex
         IF msSymbol(N) <> "   " AND mfNumberOfAtoms(N) > 0 THEN
            Printer.PRINT "  "; msSymbol(N); TAB(8); mfNumberOfAtoms(N) * mfParenthesisFactor(N);

            ' ***************** Percent ********************
            dPercent = dMassOfAtoms(N) * dInvMolarMass   ' Multiply by 100 when print.
            IF dPercent = 1 THEN
               PrintX = 26
               sMsg = "100"
            ELSE
               fStdDevPercent = dInvMolarMass * SQR((1 - 2 * dPercent) * Variance(N) + dPercent * dPercent * dVarianceTotal) * 100
               IF fStdDevPercent = 0 THEN
                  ' Needed for compound "H1 H 1e-12".
                  PrintX = 23
                  sMsg = "Near 100"
               ELSE
                  NumberFormat dPercent * 100, fStdDevPercent, 25, sMsg, PrintX
               END IF
            END IF
            Printer.PRINT TAB(PrintX); sMsg;

            ' ***************** Atomic Mass *********************
            NumberFormat dMassElement(N), fStdDevElement(N), 44, sMsg, PrintX
            Printer.PRINT TAB(PrintX); sMsg
         END IF

      NEXT N

      ' **************  Molar mass ******************
      Printer.PRINT
      Printer.PRINT TAB(20); "Molar Mass:";
      IF dVarianceTotal = 0 THEN
         PrintX = 36
         sMsg = "Near" + STR$(dMolarMass)
      ELSE
         NumberFormat dMolarMass, SQR(dVarianceTotal), 44, sMsg, PrintX
      END IF
      Printer.PRINT TAB(PrintX); sMsg

      sFormula = sGetFormula
      nFormulaLen = LEN(sFormula)
      IF nFormulaLen > 80 THEN
         Printer.PRINT LEFT$(sFormula, 80)
         N = 80
         DO
            Printer.PRINT MID$(sFormula, N + 1, 80)
            N = N + 80
         LOOP WHILE N < nFormulaLen
      ELSE
         Printer.PRINT sFormula
      END IF
      Printer.PRINT
   END IF
EXIT SUB

PrinterError:
   MSGBOX "There was a problem printing to your printer:" + CHR$(13) + """" + ERROR$(ERR) + """", 0, "Printing"
   frmMdi.mnuFilePrint.Tag = "1"
   EXIT SUB

END SUB

SUB Form_Load ()
REDIM msSymbol(29) AS STRING * 3    ' Symbol of each atom
REDIM dMassElement(29)  AS DOUBLE
REDIM fStdDevElement(29)  AS SINGLE
REDIM mfNumberOfAtoms(29)  AS SINGLE
REDIM Variance(29)  AS SINGLE   ' These two are only used in Calculate,
REDIM dMassOfAtoms(29)  AS DOUBLE  ' but for compatability with VB for Windows, arrays are placed in the main module.
REDIM mfParenthesisFactor(29)  AS SINGLE ' Parenthesis coefficients multiplier.
REDIM mbParenthesisGood(29)     ' Indicates unmatched parentheses.
REDIM mParenthesisType(29)          ' Type of parenthesis.
REDIM mParenthesisRange(29)
REDIM mBrace(30) AS Brace

   DIM sTemp AS STRING
   sTemp = FORMAT$(1234.5, "0,000.0")
   gsIntComma = MID$(sTemp, 2)
   gsIntDecimal = MID$(sTemp, 6)
   DEF SEG = 0
   IF PEEK(&H417) AND &H40 THEN
      ' Caps Lock is on.
      ' Set Caps Lock off (turn off bit 7 of &H0417).
      POKE &H417, PEEK(&H417) AND &HBF
      ' On my machine, this turns Caps Lock off,
      ' but doesn't turn off the light on the keyboard
      ' until a key is pressed.
   END IF
   DEF SEG

   frmMolarMass.MOVE 5, 0, Screen.Width - 12, Screen.Height - 1
   mMolarMassPositionY = 21
   mMaxIndex = 9
   Initialize_Form
   IF Screen.Height >= 43 THEN cmdMore_Click
   SHOW   ' Because can't set focus to hidden control.
   txtElement(0).SETFOCUS
   frmMdi.mnuWindowForm(0).Checked = TRUE
END SUB

SUB Form_Unload (Cancel AS INTEGER)
   frmMdi.mnuWindowForm(0).Checked = FALSE
END SUB

' Displays introductory information on the form, and initializes some arrays.
SUB Initialize_Form ()
   DIM N
   IF mMaxIndex = 9 THEN
      ' Display some directions.
      CurrentY = 2
      PRINT TAB(20); "The field changes automatically.  Try typing"
      PRINT TAB(25); """h2o2"", then press Enter.  (The last 2"
      PRINT TAB(25); "doesn't register until Enter is pressed.)"
      'CurrentY = 5
      PRINT TAB(20); "To move around:"
      PRINT TAB(20); "Enter            next symbol"
      PRINT TAB(20); "Tab              next field"
      PRINT TAB(20); "Shift-Tab        previous field"
      PRINT TAB(20); "Up/Down-Arrow    up/down one field"
      PRINT TAB(20); "Alt-S            first symbol"
      PRINT TAB(20); "Ctrl-I/D         Insert/Delete row"
      PRINT
      PRINT TAB(20); "Rearrange formulas by dragging"
      PRINT TAB(20); "     units with the mouse, or use the move"
      PRINT TAB(20); "     menu.  All modules, except this one and"
      PRINT TAB(20); "     the reactions module, can be rearranged."
      PRINT TAB(20); "Connect modules by dragging the result of one"
      PRINT TAB(20); "     formula onto another.  (Drag the units,"
      PRINT TAB(20); "     not the number, or use the move menu.)"
   END IF
   FOR N = 0 TO mMaxIndex
      txtElement(N).Text = ""
      txtNumber(N).Text = "1"
      msSymbol(N) = ""
      mfNumberOfAtoms(N) = 1
      mfParenthesisFactor(N) = 1
      mParenthesisType(N) = 0
   NEXT N
   mbUnmatchedParenthesis = FALSE
   cmdPrint.Tag = ""
END SUB

SUB lblMolarMass_Change ()
SELECT CASE lblMolarMass.Caption
   CASE "Molar Mass"
   CASE "Get formula"
      lblMolarMass.Tag = sGetFormula
      lblMolarMass.Caption = "Molar Mass"
END SELECT
END SUB

' Determines which parentheses (or braces or brackets) go together.  Sets
' the close parenthesis value of mParenthesisFactor(Index) equal to the
' index of the open parenthesis + 1.  Incomplete parentheses pairs are
' handled:  unpaired ( cause following elements  up to a * to not be
' calculated; unpaired ) cause preceeding elements after * to not be
' calculated.
SUB ParenthesesEvaluate ()
' Logic:
' (()())*)(   ' Find first open bracket followed by close bracket.
'
'   x
' (()())*)(   ' They go together.  Remove them.
' (())*)(     ' Backup to preceeding bracket.
'
'  x
' (())*)(     ' Find next open bracket followed by close bracket.
'
'   x
' (())*)(     ' They go together.  Remove them.
' ()*)(       ' Backup to preceeding bracket.
'
'  x
' ()*)(       ' Find next open bracket followed by close bracket.
' ()*)(       ' They go together.  Remove them.
' *)(         ' Backup to preceeding bracket (or first position).
'
' x
' *)(         ' Find next open bracket followed by close bracket (aren't any).
              ' mbParenthsisGood is used to indicate unmatched brackets.

DIM N, M
DIM LastPositionInBrace
DIM OpenBracePosition
DIM StartingOpenBracePosition
DIM nStartDotRegion, nStopDotRegion
DIM nStartBadBraceRange
DIM nIndex

' ************* Put bracket type and position in mBrace *******************
LastPositionInBrace = -1
FOR N = 0 TO mMaxIndex
   IF mParenthesisType(N) <> 0 THEN
      LastPositionInBrace = LastPositionInBrace + 1
      mBrace(LastPositionInBrace).Type = mParenthesisType(N)
      mBrace(LastPositionInBrace).Actual = N
   END IF
NEXT N

' ************************* Evaluate brackets ******************************
StartingOpenBracePosition = 0

DO
   ' Find the next remaining open brace.  (Ignore open brace in last position)
   OpenBracePosition = -1
   FOR N = StartingOpenBracePosition TO LastPositionInBrace - 1
      IF mBrace(N).Type < 0 THEN
         OpenBracePosition = N
         EXIT FOR
      END IF
   NEXT N

   ' If no more open braces then finished evaluating brackets.
   IF OpenBracePosition = -1 THEN EXIT DO

   ' Determine if the following brace is the complimentary close brace.
   ' Open brace types are -3, -2, and -1.
   ' Close brace types are +3, +2, and +1.
   ' The * type is +4.  No brace type -4 can be entered by user.
   IF mBrace(OpenBracePosition + 1).Type = -mBrace(OpenBracePosition).Type THEN
      ' A pair of braces has been found.

      ' Indicate both braces are good and assign a range to closed brace.
      nIndex = mBrace(OpenBracePosition).Actual    ' Open brace.
      mbParenthesisGood(nIndex) = 1
      nIndex = mBrace(OpenBracePosition + 1).Actual   ' Closed brace.
      mbParenthesisGood(nIndex) = 1
               ' The Range is position of ( plus 1.
      mParenthesisRange(nIndex) = mBrace(OpenBracePosition).Actual + 1

               ' Remove this pair of braces from mBrace.
      FOR N = (OpenBracePosition + 2) TO LastPositionInBrace
         mBrace(N - 2) = mBrace(N)
      NEXT N
      LastPositionInBrace = LastPositionInBrace - 2

               ' Move back one position for next run through.
      IF OpenBracePosition > 1 THEN
         StartingOpenBracePosition = OpenBracePosition - 1
      ELSE
         ' If no previous position, start at beginning.
         StartingOpenBracePosition = 0
      END IF

   ELSE
      ' Open brace not followed by closed; search for another open brace.
      StartingOpenBracePosition = StartingOpenBracePosition + 1
   END IF
LOOP WHILE StartingOpenBracePosition < LastPositionInBrace

' ********************** Handle unpaired braces ***************************

' Only run if LastPositionInBrace indicates Brace is not empty.
mbUnmatchedParenthesis = FALSE   ' Initialize.  Used for cmdPrint.Tag, which is read by other forms.
IF LastPositionInBrace > -1 THEN
   ' Pretend an asterisk ends things.  This ensures inner loop runs at least once.
   mBrace(LastPositionInBrace + 1).Type = 4
   mBrace(LastPositionInBrace + 1).Actual = mMaxIndex + 1
   ' mBrace has 30 members to handle 29 ('s plus the ending *.
   nStartDotRegion = 0
   nStartBadBraceRange = 0
   FOR N = 0 TO LastPositionInBrace + 1
      IF mBrace(N).Type = 4 THEN
         ' (4 is asterisk, which doesn't use mbParenthesisGood.)
         ' Handle unmatched braces in regions separated by *'s.
         nStopDotRegion = N - 1
         FOR M = nStartDotRegion TO nStopDotRegion    ' Could be 0 TO 0.
            ' Now that asterisk is found (always at least one),
            ' handle unpaired stuff preceeding it.
            nIndex = mBrace(M).Actual
            mbUnmatchedParenthesis = TRUE
            mbParenthesisGood(N) = FALSE
            IF mBrace(M).Type < 0 THEN
               ' Unmatched open parenthesis.
               mParenthesisRange(nIndex) = mBrace(nStopDotRegion + 1).Actual
            ELSE
               ' Handle closed parenthesis.
               mParenthesisRange(nIndex) = nStartBadBraceRange
            END IF
         NEXT M
         nStartBadBraceRange = mBrace(nStartDotRegion).Actual + 1
         nStartDotRegion = N + 1 ' Only incremented when * found.
      END IF
   NEXT N
END IF

ParenthesesFactor

END SUB

' Sets values for each mfParenthesisFactor().
' The number of each atom in the compound is number of atoms times
' this parenthesis factor.
SUB ParenthesesFactor ()
DIM N, M
DIM Temp
DIM LastParenthesisPosition
DIM fFactor AS SINGLE
DIM sMsg AS STRING
DIM Index

' Overflow errors here are usually handled by the error handler in CALCULATE.
' But when called from txtElement_KeyPress, it uses its own error handler.
ON LOCAL ERROR GOTO ParenthesisError
   ' Initialize mfParenthesisFactor() to 1.
   FOR N = 0 TO mMaxIndex
      mfParenthesisFactor(N) = 1
   NEXT N

   ' Starting at the end, multiply all parenthesisfactors in the range
   ' by parenthesis coefficient, if it is good.

   FOR N = mMaxIndex TO 0 STEP -1
      Temp = mParenthesisType(N)
      IF Temp < 0 AND mbParenthesisGood(N) = 0 THEN
         ' Handle unpaired open parenthesis.
         ' (Paired open parenthesis don't require any action.)
         FOR M = N + 1 TO mParenthesisRange(N)
            mfParenthesisFactor(M) = 0
         NEXT M
      ELSEIF Temp > 0 AND Temp < 4 THEN
         ' Handle close parenthesis (paired & unpaired).
         fFactor = mbParenthesisGood(N) * mfNumberOfAtoms(N)
         FOR M = mParenthesisRange(N) TO N - 1
            mfParenthesisFactor(M) = mfParenthesisFactor(M) * fFactor
         NEXT M
      ELSEIF Temp = 4 THEN
         ' Handle *.
         fFactor = mfNumberOfAtoms(N)
         FOR M = N + 1 TO mMaxIndex
            mfParenthesisFactor(M) = mfParenthesisFactor(M) * fFactor
         NEXT M
      END IF
   NEXT N

   Calculate
EXIT SUB

ParenthesisError:
   ' Only one error is expected to land here:  User has entered, say,
   ' Ag(()H)1e30)1e30.  Then the ) before the H is deleted.
   IF ERR = 6 THEN   ' overflow
             sMsg = "The parentheses coefficients are too large." + CHR$(10)
      sMsg = sMsg + "Make them smaller before deleting this entry."
   ELSE
      sMsg = "Error number" + STR$(ERR) + CHR$(10) + ERROR$ + CHR$(10)
      sMsg = sMsg + "If you can reproduce this, the author would like to know about it."
   END IF
   MSGBOX sMsg, 0, "Number Entry"

   txtElement_KeyPress VAL(frmMolarMass.Tag), KEY_ESCAPE

EXIT SUB


END SUB

DEFSNG A-Z
'
'  Input:
'     sSymbol     The symbol, such as "Li" of interest
'  Output:
'     AtomicMass  Average atomic mass of element, group, or amino acid sSymbol
'     Uncertainty Uncertainty in atomic mass
'
SUB PeriodicTable (sSymbol AS STRING, AtomicMass AS DOUBLE, Uncertainty AS SINGLE)
SELECT CASE sSymbol
   CASE gsCustomName
       AtomicMass = glCustomMass
       Uncertainty = gfCustomUncertainty
   CASE "H  "
       AtomicMass = 1.00794#
       Uncertainty = .00007
   CASE "He "
       AtomicMass = 4.002602#
       Uncertainty = .000002
   CASE "Li "
       AtomicMass = 6.941#
       Uncertainty = .002
   CASE "Be "
       AtomicMass = 9.012182#
       Uncertainty = .000003
   CASE "B  "
       AtomicMass = 10.811#
       Uncertainty = .005
   CASE "C  "
       AtomicMass = 12.011#
       Uncertainty = .001
   CASE "N  "
       AtomicMass = 14.00674#
       Uncertainty = .00007
   CASE "O  "
       AtomicMass = 15.9994#
       Uncertainty = .0003
   CASE "F  "
       AtomicMass = 18.9984032#
       Uncertainty = .0000009
   CASE "Ne "
       AtomicMass = 20.1797#
       Uncertainty = .0006
   CASE "Na "
       AtomicMass = 22.989768#
       Uncertainty = .000006
   CASE "Mg "
       AtomicMass = 24.305#
       Uncertainty = .0006
   CASE "Al "
       AtomicMass = 26.981539#
       Uncertainty = .000005
   CASE "Si "
       AtomicMass = 28.0855#
       Uncertainty = .0003
   CASE "P  "
       AtomicMass = 30.973762#
       Uncertainty = .000004
   CASE "S  "
       AtomicMass = 32.066#
       Uncertainty = .006
   CASE "Cl "
       AtomicMass = 35.4527#
       Uncertainty = .0009
   CASE "Ar "
       AtomicMass = 39.948#
       Uncertainty = .001
   CASE "K  "
       AtomicMass = 39.0983#
       Uncertainty = .0001
   CASE "Ca "
       AtomicMass = 40.078#
       Uncertainty = .004
   CASE "Sc "
       AtomicMass = 44.95591#
       Uncertainty = .000009
   CASE "Ti "
       AtomicMass = 47.867#
       Uncertainty = .001
   CASE "V  "
       AtomicMass = 50.9415#
       Uncertainty = .0001
   CASE "Cr "
       AtomicMass = 51.9961#
       Uncertainty = .0006
   CASE "Mn "
       AtomicMass = 54.93805#
       Uncertainty = .00001
   CASE "Fe "
       AtomicMass = 55.845#
       Uncertainty = .002
   CASE "Co "
       AtomicMass = 58.9332#
       Uncertainty = .00001
   CASE "Ni "
       AtomicMass = 58.6934#
       Uncertainty = .0002
   CASE "Cu "
       AtomicMass = 63.546#
       Uncertainty = .003
   CASE "Zn "
       AtomicMass = 65.39#
       Uncertainty = .02
   CASE "Ga "
       AtomicMass = 69.723#
       Uncertainty = .001
   CASE "Ge "
       AtomicMass = 72.61#
       Uncertainty = .02
   CASE "As "
       AtomicMass = 74.92159#
       Uncertainty = .00002
   CASE "Se "
       AtomicMass = 78.96#
       Uncertainty = .03
   CASE "Br "
       AtomicMass = 79.904#
       Uncertainty = .001
   CASE "Kr "
       AtomicMass = 83.8#
       Uncertainty = .01
   CASE "Rb "
       AtomicMass = 85.4678#
       Uncertainty = .0003
   CASE "Sr "
       AtomicMass = 87.62#
       Uncertainty = .01
   CASE "Y  "
       AtomicMass = 88.90585#
       Uncertainty = .00002
   CASE "Zr "
       AtomicMass = 91.224#
       Uncertainty = .002
   CASE "Nb "
       AtomicMass = 92.90638#
       Uncertainty = .00002
   CASE "Mo "
       AtomicMass = 95.94#
       Uncertainty = .01
   CASE "Tc "
       AtomicMass = 98#
       Uncertainty = 1
   CASE "Ru "
       AtomicMass = 101.07#
       Uncertainty = .02
   CASE "Rh "
       AtomicMass = 102.9055#
       Uncertainty = .00003
   CASE "Pd "
       AtomicMass = 106.42#
       Uncertainty = .01
   CASE "Ag "
       AtomicMass = 107.8682#
       Uncertainty = .0002
   CASE "Cd "
       AtomicMass = 112.411#
       Uncertainty = .008
   CASE "In "
       AtomicMass = 114.818#
       Uncertainty = .003
   CASE "Sn "
       AtomicMass = 118.71#
       Uncertainty = .007
   CASE "Sb "
       AtomicMass = 121.76#
       Uncertainty = .001
   CASE "Te "
       AtomicMass = 127.6#
       Uncertainty = .03
   CASE "I  "
       AtomicMass = 126.90447#
       Uncertainty = .00003
   CASE "Xe "
       AtomicMass = 131.29#
       Uncertainty = .02
   CASE "Cs "
       AtomicMass = 132.90543#
       Uncertainty = .00005
   CASE "Ba "
       AtomicMass = 137.327#
       Uncertainty = .007
   CASE "La "
       AtomicMass = 138.9055#
       Uncertainty = .0002
   CASE "Ce "
       AtomicMass = 140.115#
       Uncertainty = .004
   CASE "Pr "
       AtomicMass = 140.90765#
       Uncertainty = .00003
   CASE "Nd "
       AtomicMass = 144.24#
       Uncertainty = .03
   CASE "Pm "
       AtomicMass = 145#
       Uncertainty = 1
   CASE "Sm "
       AtomicMass = 150.36#
       Uncertainty = .03
   CASE "Eu "
       AtomicMass = 151.965#
       Uncertainty = .009
   CASE "Gd "
       AtomicMass = 157.25#
       Uncertainty = .03
   CASE "Tb "
       AtomicMass = 158.92534#
       Uncertainty = .00003
   CASE "Dy "
       AtomicMass = 162.5#
       Uncertainty = .03
   CASE "Ho "
       AtomicMass = 164.93032#
       Uncertainty = .00003
   CASE "Er "
       AtomicMass = 167.26#
       Uncertainty = .03
   CASE "Tm "
       AtomicMass = 168.93421#
       Uncertainty = .00003
   CASE "Yb "
       AtomicMass = 173.04#
       Uncertainty = .03
   CASE "Lu "
       AtomicMass = 174.967#
       Uncertainty = .001
   CASE "Hf "
       AtomicMass = 178.49#
       Uncertainty = .02
   CASE "Ta "
       AtomicMass = 180.9479#
       Uncertainty = .0001
   CASE "W  "
       AtomicMass = 183.84#
       Uncertainty = .01
   CASE "Re "
       AtomicMass = 186.207#
       Uncertainty = .001
   CASE "Os "
       AtomicMass = 190.23#
       Uncertainty = .03
   CASE "Ir "
       AtomicMass = 192.217#
       Uncertainty = .003
   CASE "Pt "
       AtomicMass = 195.08#
       Uncertainty = .03
   CASE "Au "
       AtomicMass = 196.96654#
       Uncertainty = .00003
   CASE "Hg "
       AtomicMass = 200.59#
       Uncertainty = .02
   CASE "Tl "
       AtomicMass = 204.3833#
       Uncertainty = .0002
   CASE "Pb "
       AtomicMass = 207.2#
       Uncertainty = .1
   CASE "Bi "
       AtomicMass = 208.98037#
       Uncertainty = .00003
   CASE "Po "
       AtomicMass = 209#
       Uncertainty = 1
   CASE "At "
       AtomicMass = 210#
       Uncertainty = 1
   CASE "Rn "
       AtomicMass = 222#
       Uncertainty = 1
   CASE "Fr "
       AtomicMass = 223#
       Uncertainty = 1
   CASE "Ra "
       AtomicMass = 226.0254#
       Uncertainty = .0001
   CASE "Ac "
       AtomicMass = 227.02775#
       Uncertainty = .00001
   CASE "Th "
       AtomicMass = 232.0381#
       Uncertainty = .0001
   CASE "Pa "
       AtomicMass = 231.03588#
       Uncertainty = .00002
   CASE "U  "
       AtomicMass = 238.0289#
       Uncertainty = .0001
   CASE "Np "
       AtomicMass = 237#
       Uncertainty = 1
   CASE "Pu "
       AtomicMass = 244#
       Uncertainty = 1
   CASE "Am "
       AtomicMass = 243#
       Uncertainty = 1
   CASE "Cm "
       AtomicMass = 247#
       Uncertainty = 1
   CASE "Bk "
       AtomicMass = 247#
       Uncertainty = 1
   CASE "Cf "
       AtomicMass = 251#
       Uncertainty = 1
   CASE "Es "
       AtomicMass = 252#
       Uncertainty = 1
   CASE "Fm "
       AtomicMass = 257#
       Uncertainty = 1
   CASE "Md "
       AtomicMass = 258#
       Uncertainty = 1
   CASE "No "
       AtomicMass = 259#
       Uncertainty = 1
   CASE "Lr "
       AtomicMass = 260#
       Uncertainty = 1
   ' ***************************** Common Radicals *************************
   CASE "Ph "   ' Phenyl, C6H5
       AtomicMass = 77.106#
       Uncertainty = .006
   CASE "Me "   ' Methyl, CH3
       AtomicMass = 15.035#
       Uncertainty = .001
   CASE "Et "   ' Ethyl, CH3CH2
       AtomicMass = 29.062#
       Uncertainty = .002
   CASE "Cp "   ' cyclopentadienyl, C5H5
       AtomicMass = 69.095#
       Uncertainty = .005
   CASE "Bu "   ' butyl, C4H9
       AtomicMass = 57.115#
       Uncertainty = .004
   CASE "Pn "   ' pentyl, C5H11
       AtomicMass = 71.142#
       Uncertainty = .005
   CASE "Hx "   ' hexyl, C6H13
       AtomicMass = 85.169#
       Uncertainty = .006
   CASE "Ch "   ' cyclohexyl, C6H11
       AtomicMass = 83.153#
       Uncertainty = .006
   CASE "Aq "   ' water, H2O
       AtomicMass = 18.01528#
       Uncertainty = .0003
   CASE "Ala"   ' alanine, C3H5NO
       AtomicMass = 71.079#
       Uncertainty = .003
   CASE "Arg"   ' arginine, C6H12N4O  (Unprotonated)
       AtomicMass = 156.188#
       Uncertainty = .006
   CASE "Asn"   ' asparagine, C4H6N2O
       AtomicMass = 98.105#
       Uncertainty = .004
   CASE "Asp"   ' aspartic acid, C4H5NO3  (undissociated)
       AtomicMass = 115.089#
       Uncertainty = .004
   CASE "Cys"   ' cystine, C3H5NOS  (no disulfide link)
       AtomicMass = 103.145#
       Uncertainty = .007
   CASE "Gln"   ' glutamine, C5H8N2O2
       AtomicMass = 128.131#
       Uncertainty = .005
   CASE "Glu"   ' glutamic acid, C5H7NO3  (undissociated)
       AtomicMass = 129.116#
       Uncertainty = .005
   CASE "Gly"   ' glycine, C2H3NO
       AtomicMass = 57.052#
       Uncertainty = .002
   CASE "His"   ' histidine, C6H7N3O   (unprotonated)
       AtomicMass = 137.141#
       Uncertainty = .006
   CASE "Ile", "Leu"  ' isoleucine or leucine, C6H11NO
       AtomicMass = 113.159#
       Uncertainty = .006
   CASE "Lys"   ' lysine, C6H12N2O
       AtomicMass = 128.174#
       Uncertainty = .006
   CASE "Met"   ' methionine, C5H9NOS
       AtomicMass = 131.199#
       Uncertainty = .008
   CASE "Phe"   ' phenyalanine, C9H9NO
       AtomicMass = 147.177#
       Uncertainty = .009
   CASE "Pro"   ' proline, C5H7NO
       AtomicMass = 97.117#
       Uncertainty = .005
   CASE "Ser"   ' serine, C3H5NO2
       AtomicMass = 87.078#
       Uncertainty = .003
   CASE "Thr"   ' threonine, C4H7NO2
       AtomicMass = 101.105#
       Uncertainty = .004
   CASE "Trp"   ' tryptophan, C11H10N2O
       AtomicMass = 186.21#
       Uncertainty = .01
   CASE "Tyr"   ' tyrosine, C9H9NO2
       AtomicMass = 163.176#
       Uncertainty = .009
   CASE "Val"   ' valine, C5H9NO
       AtomicMass = 99.133#
       Uncertainty = .005
   CASE "   "
       AtomicMass = 0#  ' Indicates last element
   CASE ELSE
       AtomicMass = -1# ' Indicates unrecognized Symbol
END SELECT

END SUB

DEFINT A-Z
' Inserts a blank row at the current position.  Called by txtElement_KeyPress
' and txtNumber_KeyPress when Ctrl-I is pressed.
SUB RowInsert (BYVAL Index)
DIM nFormerIndex
DIM N, M
DIM nLastBlank
DIM nStepDirection
   ' Insert a blank line.  Move a blank line to the present line.  If all
   ' lines are in use, beep, and do nothing.
   ' Blank lines are searched for in the following order:
   '     1)  in the last rows
   '     2)  after the present row, but before the last used row
   '     3)  before the present row

   ' Find the first blank line after the last used line.
   nLastBlank = -1
   nStepDirection = -1
   FOR N = mMaxIndex TO Index + 1 STEP -1
      IF txtElement(N).Text = "" THEN
         nLastBlank = N
      ELSE
         ' Found the last used line; exit loop
         EXIT FOR
      END IF
   NEXT N
   IF nLastBlank = -1 THEN
      ' No blank lines at the end, so find the first blank line before the
      ' last used line.
      FOR M = N - 1 TO Index + 1 STEP -1
         IF txtElement(M).Text = "" THEN
            nLastBlank = M
            EXIT FOR
         END IF
      NEXT M
      IF nLastBlank = -1 THEN
         ' No blank lines after present line.  Find the first preceeding
         ' blank line.
         FOR N = Index - 1 TO 0 STEP -1
            IF txtElement(N).Text = "" THEN
               nLastBlank = N
               nStepDirection = 1
               EXIT FOR
            END IF
         NEXT N
      END IF
   END IF
   IF nLastBlank = -1 THEN
      ' No blank lines; all are used.
      BEEP
   ELSE
      FOR N = nLastBlank TO Index - nStepDirection STEP nStepDirection
         nFormerIndex = N + nStepDirection
         txtElement(N).Text = txtElement(nFormerIndex).Text
         msSymbol(N) = msSymbol(nFormerIndex)
         txtNumber(N).Text = txtNumber(nFormerIndex).Text
         mfNumberOfAtoms(N) = mfNumberOfAtoms(nFormerIndex)
         mParenthesisType(N) = mParenthesisType(nFormerIndex)
         mfParenthesisFactor(N) = mfParenthesisFactor(nFormerIndex)
         dMassElement(N) = dMassElement(nFormerIndex)
         fStdDevElement(N) = fStdDevElement(nFormerIndex)
      NEXT N
      txtElement(Index).Text = ""
      msSymbol(Index) = ""
      txtNumber(Index).Text = "1"
      mfNumberOfAtoms(Index) = 1
      mParenthesisType(Index) = 0
   END IF
END SUB

' Removes a row by moving following rows up.
SUB RowRemove (BYVAL Index)
DIM nNextIndex, N
FOR N = Index TO mMaxIndex - 1
   nNextIndex = N + 1
   txtElement(N).Text = txtElement(nNextIndex).Text
   msSymbol(N) = msSymbol(nNextIndex)
   txtNumber(N).Text = txtNumber(nNextIndex).Text
   mfNumberOfAtoms(N) = mfNumberOfAtoms(nNextIndex)
   mParenthesisType(N) = mParenthesisType(nNextIndex)
   mfParenthesisFactor(N) = mfParenthesisFactor(nNextIndex)
   dMassElement(N) = dMassElement(nNextIndex)
   fStdDevElement(N) = fStdDevElement(nNextIndex)
NEXT N

' Reset the bottom row.
txtElement(mMaxIndex).Text = ""
msSymbol(mMaxIndex) = ""
txtNumber(mMaxIndex).Text = "1"
mfNumberOfAtoms(mMaxIndex) = 1
mParenthesisType(mMaxIndex) = 0

END SUB

FUNCTION sGetFormula () AS STRING
DIM sFormula AS STRING, sTemp AS STRING, N
FOR N = 0 TO mMaxIndex
   IF msSymbol(N) <> "   " AND mfNumberOfAtoms(N) > 0 THEN
      sFormula = sFormula + RTRIM$(msSymbol(N))
      IF mfNumberOfAtoms(N) <> 1 THEN
         sFormula = sFormula + FORMAT$(mfNumberOfAtoms(N))
      END IF
   ELSE
      IF mParenthesisType(N) < 0 THEN
         sTemp = txtElement(N).Text
      ELSEIF mParenthesisType(N) = 4 THEN
         sTemp = "*"
         IF mfNumberOfAtoms(N) <> 1 THEN
            sTemp = sTemp + txtNumber(N).Text
         END IF
      ELSEIF mParenthesisType(N) > 0 THEN
         sTemp = txtElement(N).Text
         IF mfNumberOfAtoms(N) <> 1 THEN
            sTemp = sTemp + txtNumber(N).Text
         END IF
      ELSE
         sTemp = ""
      END IF
      sFormula = sFormula + sTemp
   END IF
NEXT N
sGetFormula = sFormula
END FUNCTION

SUB txtElement_GotFocus (Index AS INTEGER)
   ' NonContinuedLine indicates whether or not the selection is to be
   ' deleted by the first key pressed.
   txtElement(Index).BackColor = YELLOW
   txtElement(Index).SelStart = -(NOT mbKeyPressDeletesPreviousEntry)
   txtElement(Index).SelLength = -3 * mbKeyPressDeletesPreviousEntry
   mbKeyPressDeletesPreviousEntry = TRUE
   ' Save original text; recall with escape key.
   frmMolarMass.Tag = STR$(Index)
   gsOriginalText = txtElement(Index).Text
END SUB

SUB txtElement_KeyPress (Index AS INTEGER, KeyAscii AS INTEGER)
DIM nParenthesisType
DIM sTemp AS STRING
DIM N

IF KeyAscii = KEY_RETURN THEN
   ' Go to next Element.
   KeyAscii = 0
   txtElement((Index + 1) MOD (mMaxIndex + 1)).SETFOCUS
ELSEIF (KeyAscii > 47 AND KeyAscii < 58) OR KeyAscii = 46 THEN
   ' Numbers 0 - 9 or decimal; go to txtNumber.

   txtNumber(Index).SETFOCUS
   ' Needed for entering number in blank element field.
   N = DOEVENTS()
   mbKeyPressDeletesPreviousEntry = FALSE
   txtNumber_GotFocus (Index)
   txtNumber(Index).Text = CHR$(KeyAscii)
   KeyAscii = 0
   txtNumber(Index).SelStart = 1

ELSEIF KeyAscii = 40 OR KeyAscii = 91 OR KeyAscii = 123 THEN
   ' ( or [ or { entered.
   SELECT CASE KeyAscii
      CASE 40
         nParenthesisType = -1
      CASE 91
         nParenthesisType = -2
      CASE 123
         nParenthesisType = -3
   END SELECT
   IF mbKeyPressDeletesPreviousEntry = FALSE AND txtElement(Index).Text <> "" THEN
      ' Something like ag( entered.  Place ( on next txtElement, and
      ' go to following txtElement.
      mParenthesisType((Index + 1) MOD (mMaxIndex + 1)) = nParenthesisType
      txtElement((Index + 1) MOD (mMaxIndex + 1)).Text = CHR$(KeyAscii)
      msSymbol((Index + 1) MOD (mMaxIndex + 1)) = "   "   ' Calculate sub will ignore this line.
      ' Evaluate the "ag" part of ag(.  Requires that KeyPressDeletePrev=false
      KeyAscii = 0
      txtElement_LostFocus (Index)
      mbKeyPressDeletesPreviousEntry = TRUE
      txtElement(Index + 2).SETFOCUS
   ELSE
      ' Something like ( was first character entered after getting
      ' focus.  Enter ( and go to next txtElement.
      mParenthesisType(Index) = nParenthesisType
      txtElement(Index).Text = CHR$(KeyAscii)
      msSymbol(Index) = "   "    ' Calculate sub will ignore this line.
      KeyAscii = 0
      mbKeyPressDeletesPreviousEntry = TRUE
      txtElement((Index + 1) MOD (mMaxIndex + 1)).SETFOCUS
   END IF
   ParenthesesEvaluate
ELSEIF KeyAscii = 41 OR KeyAscii = 42 OR KeyAscii = 93 OR KeyAscii = 125 THEN
   ' ) or * or ] or } entered.
   SELECT CASE KeyAscii
      CASE 41  ' )
         nParenthesisType = 1
      CASE 42  ' *
         nParenthesisType = 4
      CASE 93  ' ]
         nParenthesisType = 2
      CASE 125 ' }
         nParenthesisType = 3
   END SELECT
   IF mbKeyPressDeletesPreviousEntry = FALSE AND txtElement(Index).Text <> "" THEN
      ' Something like Ag) entered.  Place ) on next txtElement, and
      ' go to following txtNumber.
      mParenthesisType((Index + 1) MOD (mMaxIndex + 1)) = nParenthesisType
      txtElement((Index + 1) MOD (mMaxIndex + 1)).Text = CHR$(KeyAscii)
      msSymbol((Index + 1) MOD (mMaxIndex + 1)) = "   "   ' Calculate sub will ignore this line.
      ' Evaluate the "ag" part.  Requires that KeyPressDeletePrev=false
      KeyAscii = 0
      txtElement_LostFocus (Index)
      mbKeyPressDeletesPreviousEntry = TRUE
      ' Go to the number entry.
      txtNumber((Index + 1) MOD (mMaxIndex + 1)).SETFOCUS
   ELSE
      ' Something like ) was first character entered after getting
      ' focus.  Enter ) and go to next txtNumber.
      mParenthesisType(Index) = nParenthesisType
      txtElement(Index).Text = CHR$(KeyAscii)
      msSymbol(Index) = "   "    ' Calculate sub will ignore this line.
      KeyAscii = 0
      mbKeyPressDeletesPreviousEntry = TRUE
      txtNumber(Index).SETFOCUS
   END IF
   ParenthesesEvaluate
ELSEIF KeyAscii = KEY_ESCAPE THEN
   KeyAscii = 0
   N = INSTR(gsOriginalText, "~")
   IF N THEN                                       ' Have to undelete a row.
      RowInsert Index                              ' Insert a row.
      mParenthesisType(Index) = VAL(LEFT$(gsOriginalText, 2))  ' Original parenthesis type.
      txtNumber(Index).Text = MID$(gsOriginalText, N + 1)    ' Original number.
      txtElement(Index).Text = MID$(gsOriginalText, 3, N - 3) ' Original element.
      IF mParenthesisType(Index) = 0 THEN
         ' Element
         mbKeyPressDeletesPreviousEntry = FALSE    ' Makes next command works.
         txtElement_LostFocus (Index)              ' Process the new element.
      ELSE
         ' Parenthesis or *
         msSymbol(Index) = "   "       ' Calculate sub will ignore this line.
         ParenthesesEvaluate
      END IF
      txtNumber_LostFocus (Index)                  ' Process the new number.
      'mbKeyPressDeletesPreviousEntry = TRUE        ' So next command works.
   ELSE
      txtElement(Index).Text = gsOriginalText
   END IF
   ' Can't just call txtElement_GotFocus here.  May end up here by error
   ' handler in ParenthesesFactor, which got called by txtLostFocus, which
   ' sets the color to cyan.  The following overrides that.
   txtElement(Index).SETFOCUS                      ' Set color, etc.
   ' Above does nothing if already there, so still need this.
   txtElement_GotFocus (Index)
ELSEIF KeyAscii = 4 THEN   ' Ctrl + "d" or "D"
   ' Remove a row by moving following rows up.
   ' But first save row contents for recovery by escape key,
   ' or in case of error.
   ' The text saved for recovery is:
   '   parenthesis type (2 characters) + original text + ~ + original number

   ' To guard against two back-to-back row deletions, the original text
   ' is checked for that squiggle.
   
   N = INSTR(gsOriginalText, "~")
   IF N THEN gsOriginalText = MID$(gsOriginalText, 3, N - 3)
   gsOriginalText = STR$(mParenthesisType(Index)) + gsOriginalText + "~" + txtNumber(Index).Text
   RowRemove (Index)
   KeyAscii = 0
   ParenthesesEvaluate
ELSEIF KeyAscii = 9 THEN   ' Ctrl + "i" or "I"
   ' Insert a blank line.  Move a blank line to the present line.  If all
   RowInsert Index
   Calculate
   KeyAscii = 0
ELSEIF KeyAscii = KEY_BACK OR KeyAscii = KEY_DELETE THEN
   ' Backspace or delete entered.
   mbKeyPressDeletesPreviousEntry = FALSE
ELSEIF KeyAscii < 65 OR (KeyAscii > 90 AND KeyAscii < 97) OR KeyAscii > 122 THEN
   ' No letter entered.
   KeyAscii = 0
   BEEP
ELSE
   ' A letter was entered     ', or backspace, or delete.
   ' If three letters have already been entered, place the next letter on
   ' the next txtElement, provided that:
   '     the three letters are a recognized symbol
   '     the fourth letter entered is at the end of the string
   '     no letters are selected (the 4th will replace selected letters)
   mbKeyPressDeletesPreviousEntry = FALSE
   IF txtElement(Index).SelLength = 0 THEN
      ' No letters selected for replacement.
      IF txtElement(Index).SelStart = 3 OR (txtElement(Index).SelStart > 0 AND KeyAscii > 64 AND KeyAscii < 91) THEN
         ' Save the fourth character, or an uppercase character after
         ' the first letter, for the next txtElement.
         sTemp = CHR$(KeyAscii)
         KeyAscii = 0
         ' If previous characters are good, enter last one on next Row.
         txtElement((Index + 1) MOD (mMaxIndex + 1)).SETFOCUS
         N = DOEVENTS() ' Give time to move to next row.
         IF frmMolarMass.Tag <> STR$(Index) THEN
            ' Still on next row, so previous symbols recognized.
            txtElement((Index + 1) MOD (mMaxIndex + 1)).Text = sTemp
            txtElement((Index + 1) MOD (mMaxIndex + 1)).SelStart = 1
            mbKeyPressDeletesPreviousEntry = FALSE    ' Set true by GotFocus.
         END IF
      END IF
   END IF
END IF

END SUB

SUB txtElement_KeyUp (Index AS INTEGER, KeyCode AS INTEGER, Shift AS INTEGER)
DIM Number
IF Shift = 0 THEN
   IF KeyCode = KEY_DOWN THEN
      ' Down arrow.
      txtElement((Index + 1) MOD (mMaxIndex + 1)).SETFOCUS
   ELSEIF KeyCode = KEY_UP THEN
      ' Up arrow.
      IF Index = 0 THEN
         Number = mMaxIndex
      ELSE
         Number = Index - 1
      END IF
      txtElement(Number).SETFOCUS
   END IF
END IF

END SUB

' The element symbol is blank unless a valid symbol is entered.
SUB txtElement_LostFocus (Index AS INTEGER)
   DIM NewElement AS STRING * 3
   DIM sSecondLetters AS STRING * 2
   DIM dAtomicMass AS DOUBLE, fStdDev AS SINGLE
   DIM sOriginalElement AS STRING * 3
   
   ' mbKeyPressDeletesPreviousEntry is set TRUE after entering parenthesis.
   ' This is needed to keep DownArrow from running this sub.
   IF NOT mbKeyPressDeletesPreviousEntry THEN
      sOriginalElement = msSymbol(Index)
      NewElement = UCASE$(LTRIM$(txtElement(Index).Text))
         'Make second & third letters lower case
      sSecondLetters = MID$(NewElement, 2)
      MID$(NewElement, 2) = LCASE$(sSecondLetters)
      CALL PeriodicTable(NewElement, dAtomicMass, fStdDev)
      IF dAtomicMass = -1 THEN
         ' Unrecognized Symbol
         BEEP
         txtElement(Index).Text = msSymbol(Index)  ' Restore previous symbol.
         msSymbol(Index) = ""
         txtElement(Index).SETFOCUS
         EXIT SUB
      ELSEIF dAtomicMass = 0 THEN
         ' User wants it blank.
         txtElement(Index).Text = ""
         msSymbol(Index) = ""
         ' If delete entry, then click another entry with mouse,
         ' want all that entry selected, which is done by the following.
         mbKeyPressDeletesPreviousEntry = TRUE
      ELSE
         msSymbol(Index) = NewElement
         txtElement(Index).Text = NewElement
         dMassElement(Index) = dAtomicMass
         fStdDevElement(Index) = fStdDev
      END IF
      IF mParenthesisType(Index) <> 0 THEN
         ' If originally a parenthesis, change to not parenthesis & evaluate.
         mParenthesisType(Index) = 0
         ParenthesesEvaluate  ' which calls Calculate.
      ELSE
         ' Don't calculate if it is blank and was previously blank.
         IF txtNumber(Index).Text <> "" AND sOriginalElement <> msSymbol(Index) THEN
            Calculate
         END IF
      END IF
   END IF
   txtElement(Index).BackColor = BRIGHT_CYAN

END SUB

SUB txtNumber_GotFocus (Index AS INTEGER)
   ' NonContinuedLine indicates whether or not the selection is to be
   ' deleted by the first key pressed.
   txtNumber(Index).BackColor = YELLOW
   txtNumber(Index).SelStart = -(NOT mbKeyPressDeletesPreviousEntry)
   txtNumber(Index).SelLength = -10 * mbKeyPressDeletesPreviousEntry
   mbKeyPressDeletesPreviousEntry = TRUE
   frmMolarMass.Tag = STR$(-Index - 1)
   gsOriginalText = txtNumber(Index).Text ' Save original text; recall with escape key.
END SUB

SUB txtNumber_KeyPress (Index AS INTEGER, KeyAscii AS INTEGER)
DIM N, nParenthesisType
DIM sTemp AS STRING

IF KeyAscii = KEY_RETURN THEN
   ' Return key pressed.
   KeyAscii = 0
   txtElement((Index + 1) MOD (mMaxIndex + 1)).SETFOCUS
ELSEIF (KeyAscii > 64 AND KeyAscii < 91) OR (KeyAscii > 96 AND KeyAscii < 123) THEN
   ' Letter pressed.
   txtElement((Index + 1) MOD (mMaxIndex + 1)).SETFOCUS
   N = DOEVENTS() ' txtElement_GotFocus sets mbKeyPressDeletesPreviousEntry = true.
   mbKeyPressDeletesPreviousEntry = FALSE
   ' Next follows the above set focus so the original text is saved, not the new text.
   txtElement((Index + 1) MOD (mMaxIndex + 1)).Text = CHR$(KeyAscii)
   KeyAscii = 0
   txtElement(Index + 1).SelStart = 1
ELSEIF KeyAscii = KEY_ESCAPE THEN
   ' Escape key pressed.
   ' Since row delete always goes to txtElement, never have to undelete a row.
   KeyAscii = 0
   txtNumber(Index).Text = gsOriginalText
ELSEIF KeyAscii = 40 OR KeyAscii = 91 OR KeyAscii = 123 THEN
   ' ( or [ or { entered.
   SELECT CASE KeyAscii
      CASE 40
         nParenthesisType = -1
      CASE 91
         nParenthesisType = -2
      CASE 123
         nParenthesisType = -3
   END SELECT
   ' Something like 2( entered.  Place ( on next txtElement, and
   ' go to following txtElement.
   mParenthesisType((Index + 1) MOD (mMaxIndex + 1)) = nParenthesisType
   txtElement((Index + 1) MOD (mMaxIndex + 1)).Text = CHR$(KeyAscii)
   msSymbol((Index + 1) MOD (mMaxIndex + 1)) = "   "   ' Calculate sub will ignore this line.
   ' Evaluate the "2" part of 2(.  Requires that KeyPressDeletePrev=false
   KeyAscii = 0
   txtElement_LostFocus (Index)
   mbKeyPressDeletesPreviousEntry = TRUE
   txtElement(Index + 2).SETFOCUS
   ParenthesesEvaluate
ELSEIF KeyAscii = 41 OR KeyAscii = 42 OR KeyAscii = 93 OR KeyAscii = 125 THEN
   ' ) or * or ] or } entered.
   SELECT CASE KeyAscii
      CASE 41  ' )
         nParenthesisType = 1
      CASE 42  ' *
         nParenthesisType = 4
      CASE 93  ' ]
         nParenthesisType = 2
      CASE 125 ' }
         nParenthesisType = 3
   END SELECT
   ' Something like 2) entered.  Place ) on next txtElement, and
   ' go to following txtNumber.
   mParenthesisType((Index + 1) MOD (mMaxIndex + 1)) = nParenthesisType
   txtElement((Index + 1) MOD (mMaxIndex + 1)).Text = CHR$(KeyAscii)
   msSymbol((Index + 1) MOD (mMaxIndex + 1)) = "   "   ' Calculate sub will ignore this line.
   ' Evaluate the "2" part.  Requires that KeyPressDeletePrev=false
   KeyAscii = 0
   txtElement_LostFocus (Index)
   mbKeyPressDeletesPreviousEntry = TRUE
   ' Go to the number entry.
   txtNumber((Index + 1) MOD (mMaxIndex + 1)).SETFOCUS
   ParenthesesEvaluate
ELSEIF KeyAscii = 4 THEN   ' Ctrl + "d" or "D" or "tab"
   ' Delete Row.
   ' But first save row contents for recovery by escape key,
   ' or in case of error.
   gsOriginalText = STR$(mParenthesisType(Index)) + txtElement(Index).Text + "~" + gsOriginalText
   sTemp = gsOriginalText
   RowRemove (Index)
   KeyAscii = 0
   txtElement(Index).SETFOCUS
   N = DOEVENTS()             ' Time for SetFocus to change msOriginalText.
   gsOriginalText = sTemp
   ParenthesesEvaluate
ELSEIF KeyAscii = 9 THEN      ' Ctrl + "i" or "I"
   ' Insert a blank line.  Move a blank line to the present line.  If all
   RowInsert Index
   Calculate
   KeyAscii = 0
ELSEIF (KeyAscii < 48 OR KeyAscii > 57) AND KeyAscii <> 46 AND KeyAscii <> KEY_BACK AND KeyAscii <> KEY_DELETE THEN
   ' Key pressed is not number, decimal, backspace or delete.
   KeyAscii = 0
   BEEP
END IF
END SUB

SUB txtNumber_KeyUp (Index AS INTEGER, KeyCode AS INTEGER, Shift AS INTEGER)
' Originally this code was in the KeyDown event.  It doesn't work well there.
' If the down arrow was held down, not all of the text boxes changed colors
' properly.  For some reason, I don't have that problem with the code here.
DIM Number
IF Shift = 0 THEN
   IF KeyCode = KEY_DOWN THEN
      ' Down arrow.
      KeyCode = 0    ' Needed???
      txtNumber((Index + 1) MOD (mMaxIndex + 1)).SETFOCUS
   ELSEIF KeyCode = KEY_UP THEN
      ' Up arrow.
      KeyCode = 0
      IF Index = 0 THEN
         Number = mMaxIndex
      ELSE
         Number = Index - 1
      END IF
      txtNumber(Number).SETFOCUS
   END IF
END IF

END SUB

' mfNumberOfAtoms should be "" or else a valid number.
' Processes the input, calls calculate.
SUB txtNumber_LostFocus (Index AS INTEGER)
   DIM f_NumberOfAtoms AS SINGLE
   DIM fOriginalNumber AS SINGLE

   fOriginalNumber = mfNumberOfAtoms(Index)
   ON LOCAL ERROR GOTO OverFlow
   f_NumberOfAtoms = VAL(txtNumber(Index).Text)
   ON LOCAL ERROR GOTO 0
   IF f_NumberOfAtoms > 0 THEN
      txtNumber(Index).Text = FORMAT$(f_NumberOfAtoms)
      mfNumberOfAtoms(Index) = f_NumberOfAtoms
   ELSE
      ' Beep if negative number or (zero           and    something really entired)    and    text not meant to be zero.
      IF f_NumberOfAtoms < 0 OR (f_NumberOfAtoms = 0 AND LEN(txtNumber(Index).Text) > 0) AND txtNumber(Index).Text <> "0" THEN BEEP
      txtNumber(Index).Text = ""
      mfNumberOfAtoms(Index) = 0
   END IF
   IF txtElement(Index).Text <> "" AND fOriginalNumber <> mfNumberOfAtoms(Index) THEN
      IF mParenthesisType(Index) THEN
         ParenthesesFactor
      ELSE
         Calculate
      END IF
   END IF
   txtNumber(Index).BackColor = CYAN
   EXIT SUB

OverFlow:
   MSGBOX "The number you entered," + CHR$(13) + txtNumber(Index).Text + CHR$(13) + "is too large to handle.", 0, "Number Entry"
   txtNumber(Index).Text = LEFT$(gsOriginalText, 10)
   txtNumber(Index).SETFOCUS
   RESUME

END SUB

