//---------------------------------------------------
//  DEMOMOUS.PRG
//  Program to demonstrate mouse functions in CLMOUS10.LIB.
//  Author: Gregory Thacker
//  compile = CLIPPER DEMOMOUS /N
//  link    = RTLINK FI DEMOMOUS LIB CLMOUS10
//----------------------------------------------------

FUNCTION MAIN()
   LOCAL mousError,cOldcolor,button,charRL,xposi,yposi
   PUBLIC cBackground,cPopup,cPush,cBar,Xcoord,Ycoord,XXcoord,YYcoord

   cBackground:="N/W"                 // define some colors
   cPopup:="RG+/R"
   cPush:="W+/B"
   cBar:="W+/R"
   Xcoord:=10                         // define some screen coordinates
   Ycoord:=20
   XXcoord:=14
   YYcoord:=55

   mousError:=MOUSTART()              // simple error checking
   if mousError != -1      
      ? "mouse not installed"
      QUIT
   endif

   SET CURS OFF
   cOldcolor:=SETCOLOR(cBackground)
   CLS
   SETCOLOR(cBackground)
   @ 1,2 SAY "NO BUTTONS PRESSED"
   SETCOLOR(cBar)
   @ 24,0 SAY SPACE(80)
   @ 24,29 SAY "PRESS HERE TO EXIT"
   POP()                             // screen write procedure
   SETCOLOR(cBackground)

   MOUSHOW()                         // show mouse cursor

DO WHILE .T.
   button:=MOUSWAIT()                // wait for button press
   xposi:=MOUSX()                    // locate position
   yposi:=MOUSY()

   charRL:=IIF(button=1," Left ","Right ")
   @ 1,2 SAY charRL+"button was pressed at"  // Updating screen info without
   @ 2,8 SAY "   row "+STR(xposi,2,0)        // first hiding cursor will cause
   @ 3,8 SAY "column "+STR(yposi,2,0)        // some problems in this region.

   DO CASE
                // check button and location status

      CASE button=1 .AND. xposi>=Xcoord .AND. xposi<=XXcoord;
           .AND. yposi>=Ycoord .AND. yposi<=YYcoord

         MOUSHIDE()              // hide mouse before screen write
         PUSH()                  // screen write procedure
         MOUSHOW()               // show mouse
         DO WHILE MOUS_LB()=1    // this loops until left button is released
         ENDDO

         MOUSHIDE()              // hide mouse before screen write
         POP()                   // screen write procedure
         MOUSHOW()               // show mouse

      CASE button=1 .AND. xposi=24 .OR. button=2 .AND. xposi=24
           SETCOLOR(cOldcolor)
           @ 24,0 SAY SPACE(80)
           @ 24,29 SAY "PRESS HERE TO EXIT"
           EXIT
   ENDCASE
ENDDO

 MOUSEND()            // must be called before quitting
 CLS
 ? ""
 ? ""
 ? "Normal shutdown"
 QUIT

//-------------------------//  END of MAIN  //-------------------------------//

******************************************
PROCEDURE POP()
//----------------------------------------
LOCAL oldc
oldc:=SETCOLOR("X")
@ Xcoord+1,Ycoord+1 CLEA TO XXcoord+1,YYcoord+1
SETCOLOR(cPopup)
@ Xcoord,Ycoord CLEA TO XXcoord,YYcoord
@ Xcoord,Ycoord TO XXcoord,YYcoord DOUB
@ Xcoord+2,27 SAY "HOLD LEFT BUTTON HERE" 
SETCOLOR(oldc)
RETURN
//----------------------------------------

******************************************
PROCEDURE PUSH()
//----------------------------------------
LOCAL oldc
oldc:=SETCOLOR(cBackground)
@ Xcoord,Ycoord CLEA TO XXcoord+1,YYcoord+1
SETCOLOR(cPush)
@ Xcoord+1,Ycoord+1 CLEA TO XXcoord+1,YYcoord+1
@ Xcoord+1,Ycoord+1 TO XXcoord+1,YYcoord+1
@ Xcoord+3,28 SAY "YOU ARE PRESSING HERE" 
SETCOLOR(oldc)
RETURN
//-----------------------------------------
