;---------------------------------------------------------------------------
; <MODEL.H> -- This file is the memory model header file used with
;  assembly models that interface to 'C' programs. To select the
;  model required, set the equates as follows:
;
;   model:		    equates:
;
; {small}		    _LDATA = NO    _LCODE = NO
; {medium}		    _LDATA = NO    _LCODE = YES
; {compact}		    _LDATA = YES   _LCODE = NO
; {large}		    _LDATA = YES   _LCODE = YES
;
;---------------------------------------------------------------------------
;
;---------------------------------------------------------------------------
;  Memory Model selector for Microsoft C v3.0, ASM files.
;---------------------------------------------------------------------------
;
;_LDATA  equ	NO		   ; data area size
;_LCODE  equ	NO		   ; code pointers far.
;
;---------------------------------------------------------------------------
;  Argument Base address on stack:
;---------------------------------------------------------------------------
;
if	_LCODE
@ab	=	6
else
@ab	=	4		  ;..if near call
endif
;
;---------------------------------------------------------------------------
;  _LCODE and _LDATA are defined above.
;
;  The DSEG and PSEG macros are defined to generate the appropriate GROUP
;  and SEGMENT statements for the compiler and memory model in use.
;  In addition, ENDDS and ENDPS are used to end these segments.
;---------------------------------------------------------------------------
;
if (not _LCODE)

pseg	macro
_TEXT segment byte public 'CODE'
assume cs:_TEXT
	endm

endps	macro
_TEXT	ends
	endm
 endif		; end if not _LCODE


 if _LCODE
pseg	macro x
x&_TEXT segment byte public 'CODE'
assume cs:x&_TEXT
	endm

endps	macro x
x&_TEXT ends
	endm
 endif		; end if _LCODE

dseg	macro
DGROUP	group	_DATA
_DATA	segment word public 'DATA'
	assume ds:DGROUP
	endm

endds	macro
_DATA	ends
	endm

