#ifndef misc_h
#define	misc_h

#include <string.h>


#define	STDIN		0
#define	STDOUT		1
#define	STDERR		2
#define	FROM_PC		0	/* from STDIN */
#define	TO_PC		1	/* to STDOUT */

#define	NO_RETURN	-100000000L
#define	max(a,b)	((a)>(b)?(a):(b))
#define	min(a,b)	((a)>(b)?(b):(a))


typedef	unsigned char uchar;


#define	MAX_SIGNED_INT		10000

#define	HighByte(num)	((num) >> 8)
#define	LowByte(num)	((num) & 0xFF)

#define	UnsignedHighByte(num)	(((num) + MAX_SIGNED_INT) >> 8)
#define	UnsignedLowByte(num)	(((num) + MAX_SIGNED_INT) & 0xFF)



/*
 *  Function convertion short-hand
 */
#define	Fatal(s)	Error(NO_RETURN, __FILE__, __LINE__, (char *)s)
#define	Warning(s)	(void) Error(0L, __FILE__, __LINE__, (char *)s)
#define	Safe(a,b)	\
	((a)==(b)) &&		\
	Error(b, __FILE__, __LINE__, "Unsafe")

/* Signal error if `a' != `b' */
#define	Match(a,b)	\
	((a)!=(b)) &&	\
	Error(NO_RETURN, __FILE__, __LINE__, "LHS != RHS (Match fail)")

/* Signal error if `a' == `b' */
#define	Check(a,b)	\
	((a)==(b)) &&	\
	Error(NO_RETURN, __FILE__, __LINE__, "LHS == RHS (Check fail)")




/*
 *  Export functions
 */
#if defined(__STDC__)
void	Inform(char *msg);
long	Error(long rval, char *file, int line, char *msg);
int	Perr(char *msg);
#else
void	Inform();
long	Error();
int	Perr();
#endif


#endif
