   10 REM WIRES.R.Marlow.01.03.1995.
   20 REM BBC to PC Transfer program.
   30 REM Ascii Codes & constants:-
   40 SOH=1:ETX=3:EOT=4:ENQ=5:ACK=6
   50 LF=10:DC1=17:DC2=18:ETB=23:FS=28
   60 F=0:T=1:PSTAT=T:STATUS=1:X=0
   70 DIM W$(300)
   90 TIMEOUT=24000
   93                               REM
   97                               REM
  100 ON ERROR PROC_HANDLER
  110 PRINT
  120 PRINT "           WIRES"    
  130 PRINT
  140 PRINT "      BBC --> PC XFER" 
  150 PRINT
  160 PRINT " V0.0 Copyright R.Marlow.1995"     
  170 PRINT
  180 PRINT"      Initialising ..."
  190 PRINT
  200 PROC_INIT
  210 IF PSTAT=F THEN PROC_HANDLER  
  225 REM WHILE X<>EOT,BUT DON'T MAKE UNTIL/NEXT TARGET OF GOTO!!
  230    PROC_GETBYTE
  240    IF PSTAT=F THEN PROC_HANDLER
  250    IF X=EOT THEN PRINT                     "Finishing off .":PROC_TIDY_UP
  260    REM IF X=ENQ THEN ...
  270    IF X<>ENQ THEN GOTO 450
  280      PROC_GETBYTE 
  290      IF PSTAT=F THEN PROC_HANDLER
  295      REM IF X='F' THEN
  300      IF X<>70 THEN GOTO 350
  310        PROC_SEND_FILE 
  320        IF PSTAT=F THEN                         PROC_HANDLER   
  330        GOTO 450   
  340      REM ELSE IF X='*'
  350      IF X<>42 THEN GOTO 450 
  360          PROC_GETBYTE 
  370          IF PSTAT=F THEN                         PROC_HANDLER   
  375          REM IF X='F' THEN ..
  380          IF X<>70 THEN GOTO 450 
  390            PROC_SEND_ALL_FILES  
  400            IF PSTAT=F THEN                         PROC_HANDLER   
  402          REM ENDIF X='F'
  403      REM ENDIF X='F'/'*' IF
  405    REM ENDIF ! X=ENQ
  450 GOTO 230
  470 END
 1000                              REM
 1500                              REM
 1600 REM    BACKTOME
 1700                              REM
 1800                              REM
 2010 DEF PROC_BACKTOME
 2025 TIME=0
 2030 PROC_RX:PROC_TX  
 2033 REM
 2035 REM        Wait for Tx/Rx to settle..
 2037 REM
 2040 IF RX=0 AND TX=0 THEN GOTO 2080
 2045 IF TIME<TIMEOUT THEN GOTO 2030 
 2050 PRINT "Cannot switch back in unstable state"
 2060 PSTAT=F
 2070 ENDPROC
 2073 REM
 2075 REM        Now change direction to BBC Sending
 2077 REM        i.e.swap logicals
 2078 REM
 2080 SENDING=T
 2090 RECEIVING=F
 2100 ENDPROC
 3000                              REM
 3300                              REM
 3500 REM        Clear the Reception flag,i.e.
 3600 REM        signal "Ready"
 3700                              REM
 3800                              REM
 4010 DEF PROC_CLEAR_RX
 4020 IF RECEIVING=T THEN GOTO 4050
 4030 PSTAT=F:STATUS=6
 4040 ENDPROC
 4050 ?&FE60=?&FE60 AND 127
 4060 ENDPROC
 5000                              REM
 5300                              REM
 5500 REM        Clear the Transmission flag,i.e.
 5600 REM        signal "Not Sending"/"Acknowledge"
 5700                              REM
 5800                              REM
 6010 DEF PROC_CLEAR_TX
 6020 IF SENDING=T THEN GOTO 6050  
 6030 PSTAT=F:STATUS=6
 6040 ENDPROC
 6050 ?&FE60=?&FE60 AND 127
 6060 ENDPROC
 7000                              REM
 7300                              REM
 7500 REM        Calculate the Parity bit.If X has odd
 7600 REM        parity,return a 1 to be added to give Even
 7650 REM        Parity.Otherwise,return zero.
 7700                              REM
 7800                              REM
 8010 DEF FNEVEN_PARITY(X)
 8020 Z=X:Y=0
 8030 FOR I=1 TO 8
 8040    Y=(Z AND 1)+Y
 8050    Z=Z/2
 8060 NEXT I
 8070 =Y AND 1
 9000                              REM
 9300                              REM
 9400 REM
 9500 REM        Get a byte from the PC.Receive in 3 slices,
 9510 REM        checking the parity bit for the last slice,
 9520 REM        hence 9 bits altogether.Each slice has
 9530 REM        the same protocol:-
 9540 REM                     
 9550 REM        Tell the PC we're ready(Clear Rx)                      
 9560 REM        Wait for the PC to send something(Tx=1?)               
 9570 REM        Acknowledge the data(Set Rx)                            
 9580 REM        Wait for our Acknowledgement to be acknowledged(Tx=0?)
 9590 REM                                                              
 9600 REM        Then,after the last slice is sent,
 9610 REM        tell the PC we're done(Rx=0)
 9620 REM                                                              
 9700                              REM
 9800                              REM
10010 DEF PROC_GETBYTE
10020 IF RECEIVING=T THEN GOTO 10050
10030 PSTAT=F:STATUS=6
10040 ENDPROC
10043 REM
10045 REM     Tell PC we're ready...(1)
10047 REM
10050 PROC_CLEAR_RX    
10060 IF PSTAT=T THEN GOTO 10080
10070 ENDPROC
10080 TIME=0
10083 REM
10085 REM     Wait for PC to send...(1)
10087 REM
10090 PROC_TX:IF TX=1 THEN GOTO 10130
10100 IF TIME<TIMEOUT THEN GOTO 10090
10110 PSTAT=F:STATUS=10
10120 ENDPROC
10123 REM
10125 REM     Acknowledge the PC...(1)
10127 REM
10130 PROC_SET_RX
10140 IF PSTAT=T THEN GOTO 10160
10150 ENDPROC
10153 REM
10155 REM     Load lower 3 bits:
10157 REM
10160 X=?&FE60 AND 7    
10170 TIME=0
10173 REM
10175 REM     Wait for PC to confirm our acknowledge..(1)
10177 REM
10180 PROC_TX
10190 IF TX=0 THEN GOTO 10230
10200 IF TIME<TIMEOUT THEN GOTO 10180
10210 PSTAT=F:STATUS=10
10220 ENDPROC
10223 REM
10225 REM     Tell PC we're ready...(2)
10227 REM
10230 PROC_CLEAR_RX
10240 IF PSTAT=T THEN GOTO 10260
10250 ENDPROC
10260 TIME=0
10263 REM
10265 REM     Wait for PC to send...(2)
10267 REM
10270 PROC_TX:IF TX=1 THEN GOTO 10310
10280 IF TIME<TIMEOUT THEN GOTO 10270
10290 PSTAT=F:STATUS=10
10300 ENDPROC
10303 REM
10305 REM     Acknowledge the PC...(2)
10307 REM
10310 PROC_SET_RX
10320 IF PSTAT=T THEN GOTO 10340
10330 ENDPROC
10333 REM
10335 REM     Load Middle 3 bits:
10337 REM
10340 X=X OR ((?&FE60 AND 7) * 8)   
10350 TIME=0
10353 REM
10355 REM     Wait for PC to confirm our acknowledge..(2)
10357 REM
10360 PROC_TX:IF TX=0 THEN GOTO 10400
10370 IF TIME<TIMEOUT THEN GOTO 10360
10380 PSTAT=F:STATUS=10
10390 ENDPROC
10393 REM
10395 REM     Tell PC we're ready...(3)
10397 REM
10400 PROC_CLEAR_RX
10410 IF PSTAT=T THEN GOTO 10430
10420 ENDPROC
10430 TIME=0
10433 REM
10435 REM     Wait for PC to send...(3)
10437 REM
10440 PROC_TX:IF TX=1 THEN GOTO 10480 
10450 IF TIME<TIMEOUT THEN GOTO 10440
10460 PSTAT=F:STATUS=10 
10470 ENDPROC
10473 REM
10475 REM     Load top 2 bits:
10477 REM
10480 X=X OR ((?&FE60 AND 3) * 64)
10483 REM
10485 REM     Validate the Parity bit..
10487 REM
10490 IF FNEVEN_PARITY(X) = (?&FE60 AND 4)/4 THEN GOTO 10520    
10500 PSTAT=F:STATUS=20  
10510 ENDPROC   
10513 REM
10515 REM     Acknowledge the PC...(3)
10517 REM
10520 PROC_SET_RX   
10530 IF PSTAT=T THEN GOTO 10550
10540 ENDPROC
10550 TIME=0
10553 REM
10555 REM     Wait for PC to confirm our acknowledge..(3)
10557 REM
10560 PROC_TX:IF TX=0 THEN GOTO 10600
10570 IF TIME<TIMEOUT THEN GOTO 10560
10580 PSTAT=F:STATUS=10 
10590 ENDPROC
10593 REM
10595 REM     Tell PC we're finished..           
10597 REM
10600 PROC_CLEAR_RX
10610 ENDPROC
11000                               REM
11300                               REM
11500 REM       ERROR HANDLER
11600                               REM
11700                               REM
12010 DEF PROC_HANDLER  
12020 ON ERROR OFF
12030 IF STATUS<>T PRINT
12040 IF STATUS<>T PRINT "  *HANDLER* WIRES Error .." 
12050 IF STATUS<>T PRINT  
12060 IF STATUS=10 PRINT "Timeout"
12070 IF STATUS=20 PRINT "Parity error"
12080 IF STATUS=6  PRINT "Wrong Tx/Rx mode"
12090 PRINT
12093 REM
12095 REM Only report BBC error if no 'WIRES' error,otherwise
12097 REM you see a previous BBC error,which will be misleading:
12098 REM
12100 IF STATUS<>T PROC_TIDY_UP    
12110 PRINT 
12120 PRINT "  *HANDLER* BBC Error ";ERR
12130 PRINT
12140 PRINT "              At Line ";ERL
12150 PRINT '
12160 PROC_TIDY_UP
12170 ENDPROC
13000                               REM
13300                               REM
13500 REM       Initialisation,Tx/Rx testing;
13600                               REM
13700                               REM
14010 DEF PROC_INIT
14013 REM
14015 REM Store initial Port values for later reset:
14017 REM
14030 INIT_DATA=?&FE60
14040 INIT_CONTROL=?&FE62
14050 INPUT "Press RET when PC requests attention>" X$ 
14060  ?&FE62=&F0:?&FE60=&FF 
14070 PRINT "Waiting for PC ..."
14080 SENDING=F:RECEIVING=T
14090 PROC_CLEAR_RX
14100 IF PSTAT=T THEN GOTO 14120
14110 ENDPROC
14113 REM
14115 REM Should now get ENQ,SOH,then 0,1,2,....128,ETX
14117 REM
14120 PROC_GETBYTE
14130 IF PSTAT=T THEN GOTO 14150
14140 ENDPROC
14150 IF X=ENQ THEN GOTO 14180   
14160 PRINT "Received ";X;" instead of ENQ"
14170 ENDPROC
14180 PRINT "Acknowledging PC ..":PROC_GETBYTE
14190 IF PSTAT=T THEN GOTO 14210
14200 ENDPROC
14210 IF X=SOH THEN GOTO 14240
14220 PRINT "Received ";X;" instead of SOH"
14230 ENDPROC
14240 PROC_GETBYTE
14250 IF X=0 THEN GOTO 14280
14260 PRINT "Received ";X;" instead of 0"
14270 ENDPROC
14280 PRINT "Testing reception ....":FOR INIT_I = 0 TO 7     
14290    PROC_GETBYTE  
14300    IF PSTAT=F THEN GOTO 14330
14310    IF X=2^INIT_I THEN GOTO 14340  
14320    PRINT "Received ";X;" instead of ";2^INIT_I
14330    ENDPROC
14340 @%=&00000303:PRINT X;",";:@%=10
14350 NEXT INIT_I
14360 PROC_GETBYTE
14370 IF PSTAT=T THEN GOTO 14390
14380 ENDPROC
14390 IF X=ETX THEN GOTO 14420
14400 PRINT "Received ";X;" instead of  ETX"
14410 ENDPROC
14420 PROC_GETBYTE
14430 IF PSTAT=T THEN GOTO 14450
14440 ENDPROC  
14450 IF X=DC1 THEN GOTO 14480
14460 PRINT "Received ";X;" instead of  DC1"
14470 ENDPROC
14473 REM
14475 REM Now send back 0,1,2,....128,ACK
14477 REM
14480 PROC_BACKTOME
14490 IF PSTAT=T THEN GOTO 14510
14500 ENDPROC
14510 PRINT '"Sending back to PC ..."
14520 X=0:PROC_SENDBYTE
14530 IF PSTAT=T THEN GOTO 14550
14540 ENDPROC
14550 FOR INIT_I=0 TO 7    
14560    X=2^INIT_I
14570    PROC_SENDBYTE
14580    IF PSTAT=T THEN GOTO 14600
14590    ENDPROC
14600    @%=&00000303:PRINT X;",";:@%=10
14610 NEXT INIT_I
14620 X=ACK
14630 PROC_SENDBYTE
14640 IF PSTAT=T THEN GOTO 14660
14650 ENDPROC
14660 PROC_OVERTOYOU
14670 PRINT '"Test successful"
14680 ENDPROC
15000                               REM
15300                               REM
15500 REM       Overtoyou,i.e.Swap direction back to
15600 REM       PC sending:
15700                               REM
15800                               REM
16010 DEF PROC_OVERTOYOU
16020 X=DC2:PROC_SENDBYTE:IF PSTAT=T THEN GOTO 16030
16025 ENDPROC
16030 TIME=0
16031 REM
16032 REM Wait for Rx/Tx to settle...
16033 REM
16035 PROC_RX:PROC_TX      
16040 IF RX=0 AND TX=0 THEN GOTO 16090
16050 IF TIME<TIMEOUT THEN GOTO 16035
16060 PRINT "Cannot switch over in unstable state" 
16070 PSTAT=F 
16080 ENDPROC 
16083 REM
16085 REM Switch direction to PC sending...
16087 REM
16090 SENDING=F   
16100 RECEIVING=T
16110 ENDPROC    
17000                               REM
17300                               REM
17500 REM       Check Value of Reception flag;
17700                               REM
17900                               REM
18010 DEF PROC_RX
18020 IF RECEIVING=T THEN GOTO 18050
18030 RX=(?&FE60 AND 8)/8    
18040 ENDPROC
18050 RX=(?&FE60 AND 128)/128    
18060 ENDPROC
21000                               REM
21300                               REM
21500 REM       Send an "EDITOR93" file to PC:
21700                               REM
21800                               REM
22010 DEF PROC_SEND_FILE
22020 F$="":I22=0
22023 REM
22025 REM Get the required File Name..
22027 REM
22030 REPEAT
22040    PROC_GETBYTE
22050    IF PSTAT=T THEN GOTO 22070
22060    ENDPROC
22070    IF X=ETX THEN GOTO 22100 ELSE           F$=LEFT$(F$,I22)+CHR$(X)  
22080    I22=I22+1
22090 UNTIL X=ETX
22100 PROC_GETBYTE
22110 IF PSTAT=T THEN GOTO 22130
22120 ENDPROC
22130 IF X=DC1 THEN GOTO 22160
22140 PSTAT=F:PRINT "No 'Over' byte from PC" 
22150 ENDPROC
22160 PROC_BACKTOME
22170 IF PSTAT=T THEN GOTO 22210
22180 PRINT "Failed to switch to BBC transmit"
22190 PSTAT=F
22200 ENDPROC
22210 PRINT "Searching for ";F$;" ..."
22212 REM
22213 REM Load file into memory,then send.This is done for
22214 REM A cassette system,because sending is too slow.
22215 REM
22216 REM Divert the error handler: Carry on if the error is a
22217 REM tape read error,so at least some of the file is sent:
22218 REM
22219 HEADER=0:ON ERROR GOTO 22250    
22220 FP=OPENIN(F$)
22225 HEADER=1
22230 PRINT "Loading into memory..."
22243 INPUT #FP,L
22247 GOTO 22258
22250 IF ERR > 215      AND ERR < 224 THEN GOTO 22255
22253 PROC_HANDLER   
22255 PRINT "I/O error ";ERR;" On Header or reading 1st line - Abandoning.."
22257 L=0:IF HEADER=0 THEN GOTO 22300 ELSE GOTO 22290
22258 ON ERROR GOTO 22282   
22260 FOR I22=0 TO L
22270    INPUT #FP,W$(I22)
22280 NEXT I22
22281 GOTO 22290
22282 IF ERR > 215 AND ERR < 224 THEN         GOTO 22287  
22285 PROC_HANDLER
22287 PRINT "I/O error ";ERR;" On             reading line ";I22;" Continuing."
22288 W$(I22)="\\\\\\\\\\\":I22=I22+1:*MOTOR 1:GOTO 22270
22290 CLOSE #FP
22300 PRINT "Transmitting ..."
22310 ON ERROR PROC_HANDLER
22320 FOR I22=0 TO L
22330    FOR J22=1 TO LEN(W$(I22))
22340       X=ASC(MID$(W$(I22),J22,1))
22350       IF X=-1 THEN X=LF  
22360       PROC_SENDBYTE
22370       IF PSTAT=T THEN GOTO 22385
22380       ENDPROC
22385    REM
22390    NEXT J22
22393    X=LF:PROC_SENDBYTE
22395    IF PSTAT=T THEN GOTO 22398
22397    ENDPROC
22398 REM
22400 NEXT I22
22410 X=ACK:PROC_SENDBYTE   
22420 IF PSTAT=T THEN GOTO 22440  
22430 ENDPROC   
22440 PRINT L;" Lines were transmitted"
22450 PROC_OVERTOYOU
22460 IF PSTAT=T THEN GOTO 22480   
22470 PRINT "Failed to switch back to PC"
22480 ENDPROC  
23000                               REM
23300                               REM
23400 REM
23500 REM       Send a byte to the PC:
23510 REM       Send in 3 slices,setting up a parity bit
23520 REM       for the last slice,hence 9 bits altogether.Each slice has the
23530 REM       same protocol:-
23540 REM       Is PC ready ? (Wait for Rx=0)
23550 REM       Load the Data port,and send (Set_Tx)
23560 REM       Has PC acknowledged? (Wait for Rx=1)
23570 REM       Confirm the Acknowledge (Clear_Tx)
23580 REM       Then,after the last slice is sent,there is a final wait for
23590 REM       the PC to settle(Rx=0).
23595 REM
23600                               REM
23700                               REM
24010 DEF PROC_SENDBYTE
24020 IF SENDING=T THEN GOTO 24050
24030 PSTAT=F:STATUS=6  
24040 ENDPROC
24050 TIME=0
24053 REM
24055 REM     Wait for PC ready...(1)
24057 REM
24060 PROC_RX:IF RX=0 THEN GOTO 24100
24070 IF TIME<TIMEOUT THEN GOTO 24060
24080 PSTAT=F:STATUS=10
24090 ENDPROC
24093 REM
24095 REM     Send lower 3 bits:
24097 REM
24100 ?&FE60=(?&FE60 AND 143) OR ((X AND 7)*16)
24103 REM
24105 REM     Tell PC we're sending...(1)
24107 REM
24110 PROC_SET_TX
24120 IF PSTAT=T THEN GOTO 24140
24130 ENDPROC
24140 TIME=0
24143 REM
24145 REM     Wait for acknowledgement..(1)
24147 REM
24150 PROC_RX
24160 IF RX=1 THEN GOTO 24200
24170 IF TIME<TIMEOUT THEN GOTO 24150
24180 PSTAT=F:STATUS=10  
24190 ENDPROC
24193 REM
24195 REM     Confirm the acknowledgement..(1)
24197 REM
24200 PROC_CLEAR_TX
24210 IF PSTAT=T THEN GOTO 24230
24220 ENDPROC
24230 TIME=0
24233 REM
24235 REM     Wait for PC ready...(2)
24237 REM
24240 PROC_RX:IF RX=0 THEN GOTO 24280
24250 IF TIME<TIMEOUT THEN GOTO 24240
24260 PSTAT=F:STATUS=10
24270 ENDPROC
24273 REM
24275 REM     Send middle 3 bits:
24277 REM
24280 ?&FE60=(?&FE60 AND 143) OR ((X AND 56)*2)
24283 REM
24285 REM     Tell PC we're sending...(2)
24287 REM
24290 PROC_SET_TX
24300 IF PSTAT=T THEN GOTO 24320
24310 ENDPROC
24320 TIME=0
24323 REM
24325 REM     Wait for acknowledgement..(2)
24327 REM
24330 PROC_RX
24340 IF RX=1 THEN GOTO 24380
24350 IF TIME<TIMEOUT THEN GOTO 24330
24360 PSTAT=F:STATUS=10  
24370 ENDPROC
24373 REM
24375 REM     Confirm the acknowledgement..(2)
24377 REM
24380 PROC_CLEAR_TX
24390 IF PSTAT=T THEN GOTO 24410
24400 ENDPROC
24410 TIME=0
24413 REM
24415 REM     Wait for PC ready...(3)
24417 REM
24420 PROC_RX:IF RX=0 THEN GOTO 24460
24430 IF TIME<TIMEOUT THEN GOTO 24420
24440 PSTAT=F:STATUS=10 
24450 ENDPROC
24453 REM
24455 REM     Send top 2 bits + Parity bit:-
24457 REM
24460 ?&FE60=(?&FE60 AND 143) OR ((X AND 192)/4)
24470 PARITY=FNEVEN_PARITY(X)
24480 ?&FE60=((?&FE60) AND 191) OR (PARITY*64)    
24483 REM
24485 REM     Tell PC we're sending...(3)
24487 REM
24490 PROC_SET_TX
24500 IF PSTAT=T THEN GOTO 24520
24510 ENDPROC
24520 TIME=0
24523 REM
24525 REM     Wait for acknowledgement..(3)
24527 REM
24530 PROC_RX
24540 IF RX=1 THEN GOTO 24580
24550 IF TIME<TIMEOUT THEN GOTO 24530
24560 PSTAT=F:STATUS=10   
24570 ENDPROC
24573 REM
24575 REM     Confirm the acknowledgement..(3)
24577 REM
24580 PROC_CLEAR_TX
24590 IF PSTAT=T THEN GOTO 24610
24600 ENDPROC
24610 TIME=0
24613 REM
24615 REM     Wait for PC to settle before returning:
24617 REM
24620 PROC_RX:IF RX=0 THEN GOTO 24650 
24630 IF TIME<TIMEOUT THEN GOTO 24620
24640 PSTAT=F:STATUS=10  
24650 ENDPROC  
25000                               REM
25300                               REM
25400 REM
25500 REM       Set the Reception flag,
25570 REM       i.e.Signal "Busy"/"Acknowledge":
25595 REM
25700                               REM
25800                               REM
26010 DEF PROC_SET_RX
26020 IF RECEIVING=T THEN GOTO 26050
26030 PSTAT=F:STATUS=6
26040 ENDPROC
26050 ?&FE60=?&FE60 OR 128
26060 ENDPROC
27000                               REM
27300                               REM
27400 REM
27500 REM       Set the Transmission flag,
27570 REM       i.e.Signal "Sending"
27595 REM
27700                               REM
27800                               REM
28010 DEF PROC_SET_TX
28020 IF SENDING=T THEN GOTO 28050  
28030 PSTAT=F:STATUS=6
28040 ENDPROC
28050 ?&FE60=?&FE60 OR 128
28060 ENDPROC
29000                               REM
29300                               REM
29400 REM
29500 REM       Tidy up.Restore Ports to
29570 REM       their original values,then exit.
29595 REM
29700                               REM
29800                               REM
30010 DEF PROC_TIDY_UP
30020 ?&FE60=INIT_DATA
30030 ?&FE62=INIT_CONTROL
30040 PRINT "Breaking link to PC .. "
30050 END
30060 ENDPROC
31000                               REM
31300                               REM
31400 REM
31500 REM       Get value of Transmission flag.
31595 REM
31700                               REM
31800                               REM
32010 DEF PROC_TX
32020 IF SENDING=T THEN GOTO 32050   
32030 TX=(?&FE60 AND 8)/8
32040 ENDPROC
32050 TX=(?&FE60 AND 128)/128    
32060 ENDPROC
