/***********************************************************************/
/*
        WIRES.H    Constants and Macros for Wires. 07.02.1995.
 */
/*
        Prototypes:-
 */
        void tidy_up(),getsyst(unsigned long *);
        logical download(),upload(),getfile(),getfiles(), \
                over2you(),back2me(),;
        byte getbyte(byte *);
        byte sendbyte(byte);
        byte Rx();
        byte Tx();
        byte Clear_Rx();
        byte Clear_Tx();
        byte Set_Rx();
        byte Set_Tx();
        byte evenprty(byte);
        byte in8(unsigned int);
        byte out8(unsigned int,byte);
        extern int atoi();
/*
        ASCII codes:-
 */
        #define SOH 1
        #define ETX 3
        #define EOT 4
        #define ENQ 5
        #define ACK 6
        #define DC1 17
        #define DC2 18
        #define ETB 23
        #define FS  28
/*
        Ports:-
 */
        #define PORT_OUT 956
        #define PORT_IN 957
        #define PORT_CONTROL 958
/*
        Other constants:-
 */
        int BBC_ID=0;
        unsigned long Timeout=16380;     /* Assumes clock tick is 18.2/second */
/*
        Tx/Rx Logicals:-
 */
        logical SENDING,RECEIVING;
/*
        Port initial values:-
 */
        byte INIT_DATA,INIT_STATUS,INIT_CONTROL;
/*
        Masks:-
 */
        byte DMASK[4],SMASK[4],NULLMASK[4]={0,1,2,3};
/*
        Mask and status macros:-
 */                      
        #define mask_(x,shr,shl) (byte) (    (  (x)>>(shr)  ) & 1    ) << (shl)
        #define mask(x,shr0,shr1,shr2,shr3,shl0,shl1,shl2,shl3) (byte) \
        mask_((x),(shr0),(shl0)) | \
        mask_((x),(shr1),(shl1)) | \
        mask_((x),(shr2),(shl2)) | \
        mask_((x),(shr3),(shl3))
        #define Rmask(x) mask( (x), \
        SMASK[0],SMASK[1],SMASK[2],SMASK[3], \
        NULLMASK[0],NULLMASK[1],NULLMASK[2],NULLMASK[3] )
        #define Tmask(x) mask( (x), \
        NULLMASK[0],NULLMASK[1],NULLMASK[2],NULLMASK[3], \
        DMASK[0],DMASK[1],DMASK[2],DMASK[3] )
        #define Umask(x) mask( (x), \
        DMASK[0],DMASK[1],DMASK[2],DMASK[3], \
        NULLMASK[0],NULLMASK[1],NULLMASK[2],NULLMASK[3] )
        #define status(ios) switch ((ios)) \
                            {   case 0: \
                                puts("General Error"); \
                                exit(0); \
                                case 6: \
                                puts("Wrong Rx/Tx mode"); \
                                exit(0); \
                                case 10: \
                                puts("Timeout"); \
                                exit(0); \
                                case 20: \
                                puts("Parity Error"); \
                                exit(0); \
                                default: \
                                break; \
                            }
        #define get_stat(x) status(getbyte((x)))
        #define send_stat(x) status(sendbyte((x)))
/*
        End of WIRES.H
 */
 /***********************************************************************/
