#include "axes2.h"

Axes2::Axes2()
    {
    horiz_axe = vert_axe = horiz_axe_2 = vert_axe_2 = NULL;
    }
//////////////////////////
void Axes2::set_axe(int which, int l, double start, double end,
	    int tick_no, int* t, int s_tick_no, int* s, char** lab,
	    int text_direction)
    {
    HV_Axes* axe = new HV_Axes(l, start, end, tick_no, t, s_tick_no,
			       s, lab);

    switch(which)
	{
	case HORIZ1: delete horiz_axe; horiz_axe = axe;
	    axe->set_type(NORMAL_AXE, HORIZ_AXE, text_direction); break;
	case VERT1: delete vert_axe; vert_axe = axe;
	    axe->set_type(NORMAL_AXE, VERT_AXE, text_direction); break;
	case HORIZ2: delete horiz_axe_2; horiz_axe_2 = axe;
	    axe->set_type(REVERSE_AXE, HORIZ_AXE, text_direction); break;
	case VERT2: delete vert_axe_2; vert_axe_2 = axe;
	    axe->set_type(REVERSE_AXE, VERT_AXE, text_direction); break;
	}
    }
////////////////////////////
void Axes2::show(loc lt, int ax_col, int lab_col)
    {
    if(horiz_axe != NULL)
	horiz_axe->draw_axe(loc(lt.X, lt.Y + vert_axe->len_scr),
			     ax_col, lab_col);
    if(vert_axe != NULL)
	vert_axe->draw_axe(lt, ax_col, lab_col);
    if(horiz_axe_2 != NULL)
	horiz_axe_2->draw_axe(lt, ax_col, lab_col);
    if(vert_axe_2 != NULL)
	vert_axe_2->draw_axe(loc(lt.X + horiz_axe->len_scr, lt.Y),
			      ax_col, lab_col);
    }
/////////////////////////
void Axes2::cross(rect coord, loc zero)
    {
    drawTool->setlinestyle(SOLID_LINE, 1, 3);
    drawTool->line(zero.X, coord.origin.Y, zero.X, coord.corner.Y);
    drawTool->line(coord.origin.X, zero.Y, coord.corner.X, zero.Y);
    }
/*
void main()
    {
    int gdriver = DETECT, gmode;
    initgraph(&gdriver, &gmode, "");

    drawTool = new KH_Paint();   // See KHPAINT.H

    Axes2* a = new Axes2();
    a->set_axe(HORIZ1, 300, -20, 80);
    a->set_axe(HORIZ2, 300, -20, 80);
    a->set_axe(VERT1, 300, -20, 80);
    a->set_axe(VERT2, 300, -20, 80);

    a->show(loc(40, 20), LIGHTBLUE, YELLOW);

    delete a;
    delete drawTool;   // See KHPAINT.H

    closegraph();
    }
*/