#include <graphics.h>
#include <alloc.h>

#include <mem.h>
#include "image_p.h"
#include "simple.h"
#include "khbgi.h"

void bar(rect r, int col, int bak, uchar* pattern)
    {
    bar(r.origin.X, r.origin.Y, r.corner.X, r.corner.Y,
         col, bak, pattern);
    }
///////////////////////
void bar(int left, int top, int right, int bottom,
         int col, int bak, uchar* pattern)
    {
    int len;

    imageP image = (imageP)malloc((len = (right - left + 1 + 7) >> 3) << 2
                                  + sizeof(imageP));
    image->xmax = right - left;
    image->ymax = 0;

    int len1 = len * 2;
    int len2 = len * 3;

    uchar c[32];
    uchar col1, col2, col3, col4;
    uchar bak1, bak2, bak3, bak4;
    int p = 0;
    for(int k = 0; k < 32; k += 4, p++)
        {
        col1 = (col & 8) ? 255 : 0;
        col2 = (col & 4) ? 255 : 0;
        col3 = (col & 2) ? 255 : 0;
        col4 = (col & 1) ? 255 : 0;

        bak1 = (bak & 8) ? 255 : 0;
        bak2 = (bak & 4) ? 255 : 0;
        bak3 = (bak & 2) ? 255 : 0;
        bak4 = (bak & 1) ? 255 : 0;

        uchar color1 = col1 & pattern[p];
        uchar color2 = col2 & pattern[p];
        uchar color3 = col3 & pattern[p];
        uchar color4 = col4 & pattern[p];

        uchar mask = pattern[p] ^ 255;

        uchar background1 = mask & bak1;
        uchar background2 = mask & bak2;
        uchar background3 = mask & bak3;
        uchar background4 = mask & bak4;

        c[k] = color1 | background1;
	c[k + 1] = color2 | background2;
	c[k + 2] = color3 | background3;
	c[k + 3] = color4 | background4;
	}

    for(int i = 0; i < bottom - top + 1; i++)
        {
        int sh = (i % 8) * 4;
        memset(image->data, c[sh], len);
        memset(image->data + len, c[sh + 1], len);
        memset(image->data + len1, c[sh + 2], len);
        memset(image->data + len2, c[sh + 3], len);
        putimage(left, top + i, image, COPY_PUT);
        }
    delete image;
    }

/*
void main()
    {
    int gdriver = DETECT, gmode;
    initgraph(&gdriver, &gmode, "");

    uchar pattern[] = { 170, 85, 170, 85, 170, 85, 170, 85 };
    bar(10, 20, 100, 200, BLACK, BLUE, pattern);

    closegraph();
    }
*/