/****************************************************************************
*
*						  Techniques Class Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:     $RCSfile: slist.cpp $
* Version:      $Revision: 1.1 $
*
* Language:		C++ 3.0
* Environment:	any
*
* Description:	Member functions for the list class, a class designed to
*				link a series of objects together into a singly linked
*				list. All items placed in the list MUST be derived from
*				the class TCListNode.
*
* $Id: slist.cpp 1.1 1995/09/16 11:16:08 kjb release $
*
****************************************************************************/

#include "tcl\list.hpp"

/*--------------------------- Member functions ----------------------------*/

TCSimpleGenList::~TCSimpleGenList()
/****************************************************************************
*
* Function:		TCSimpleGenList::~TCSimpleGenList
*
* Description:	Destructor for the SimpleList class. All we do here is ask
* 				the SimpleList to empty itself.
*
****************************************************************************/
{
	empty();
}

void TCSimpleGenList::empty(void)
/****************************************************************************
*
* Function:		TCSimpleGenList::empty
*
* Description:	Empties the SimpleList of all elements. We do this by
*				stepping through the SimpleList deleting all the elements
*				as we go.
*
****************************************************************************/
{
	TCListNode *temp;

	while (head != NULL) {
		temp = head;
		head = head->next;
		delete temp;
		}
}

ulong TCSimpleGenList::numberOfItems(void) const
/****************************************************************************
*
* Function:		TCSimpleGenList::numberOfItems
* Returns:		Number of items in the list.
*
* Description:	Since we do not maintain a count for the list, we simply
*				whiz through the list counting the number of items in it.
*
****************************************************************************/
{
	ulong	count = 0;

	for (TCSimpleGenListIterator i(*this); i; i++)
		count++;

	return count;
}
