#include <string.h>
#include <malloc.h>
#include "utype.h"
#include "umem.h"
#include "data.h"
#include "section.h"
#include "lines.h"

extern BOOL prm_debug;
extern SECTION *SectionPtr;

FILENAME *linelist = 0;
FILENAME *nametable[NUMLINEFILES];

static int linefilecount;
static int modulecount;

void LineInit(void)
{
}
void LineRundown(void)
{
	FILENAME *p = linelist;
	while (p) {
		FILENAME *q = p->link;
		DeallocateMemory(p->name);
		DeallocateMemory(p);
		p = q;
	}
}
void LineModuleRundown(int mode)
{
	int i;
	for (i=0; i < NUMLINEFILES; i++) {
		nametable[i] = 0;
	}
	modulecount = 0;
}
void EnterLineFile(char *name)
{
	if (prm_debug) {
		FILENAME *p = linelist,**q = &linelist;
		while (p) {
			if (!strcmp(p->name,name)) {
				nametable[modulecount++] = p;
				break;
			}
			q = &p->link;
			p = p->link;
		}
		if (!p) {
			FILENAME *l = AllocateMemory(sizeof(FILENAME));
			*q = nametable[modulecount++] =l;
			l->link = 0;
			l->name = AllocateMemory(strlen(name)+1);
			strcpy(l->name,name);
			l->id = linefilecount++;
		}
	}
}
void FixLines(void)
{
	if (prm_debug && !strcmp(SectionPtr->name,"??LINE")) {
		int i;
		for (i= 0; i < SectionPtr->size; i+=7) {
			char *pos = PtrToEMSMem(SectionPtr->parent->buffer,i+SectionPtr->base);
			pos[0] = nametable[pos[0]]->id;
		}
	}
}