/* remind.c: Make an entry in the dates file for reminder.
 *   Programmed by Ken Van Camp, ARDEC, October 1987.
 */

/*      11-18-89        RjR     Port to MS C.  Uses ".\dates".
 */

#define MSC
#define DATEFILE ".\\dates"

#ifdef CHECKCZ
#include <fcntl.h>
int fd;
#else
	#ifdef MSC
	#include <fcntl.h>
	#include <stdio.h>
	FILE *fd;
	#else
	FILE *fd, *fopen();
	#endif
#endif

void getdata();

main(argc,argv)
int argc;
char *argv[];
{
        char    line[256],
                event[128],
                person[128],
                tim[20],
                dat[30],
                ndays[10];
#ifdef CHECKCZ
        int     i;
        char    c;

        if (argc > 1){
                if ((fd = open (argv[1], O_RDWR|O_CREAT)) < 0){
                        fprintf(stderr,"Error: Can't open file '%s'\n",
                                argv[1]);
                        exit(1);
                }
        }else{
                if ((fd = open (DATEFILE, O_RDWR|O_CREAT)) < 0){
                        fprintf(stderr,"Error: Can't open file '%s'\n",
                                DATEFILE);
                        exit(1);
                }
        }
#else
        if (argc > 1){
                if ((fd = fopen (argv[1], "a")) == NULL){
                        fprintf(stderr,"Error: Can't open file '%s'\n",
                                argv[1]);
                        exit(1);
                }
        }else{
                if ((fd = fopen (DATEFILE, "a")) == NULL){
                        fprintf(stderr,"Error: Can't open file '%s'\n",
                                DATEFILE);
                        exit(1);
                }
        }
#endif

#ifdef CHECKCZ
        /* Read forward in file til EOF (either CTRL-Z or no more data) */
        i = 1;
        while (i > 0){
                i = read (fd, &c, 1);
#ifdef DEBUG
                putchar(c);
#endif
                if (c == '\032'){       /* CTRL-Z is End of file marker */
                        /* Stop the read here and backup one byte for
                           subsequent writes */
#ifdef DEBUG
                        printf("Read EOF\n");
#endif
                        i = 0;
                        lseek (fd, -1, 1);
                }
        }
#ifdef DEBUG
        printf("No more chars to read\n");
#endif
#endif
        getdata ("Event for reminder file", event);
        getdata ("Person", person);
        getdata ("Time (e.g. 1300)", tim);
        getdata ("Date (mm/dd/yy or mm/dd or dd or ddd)", dat);
        getdata ("Number of days notice", ndays);

#ifdef CHECKCZ
        sprintf(line,"%s:%s:%s %s:%s:N\n", dat, ndays, tim, event, person);
        write (fd, line, strlen(line));
        close(fd);
#else
        fprintf(fd,"%s:%s:%s %s:%s:N\n", dat, ndays, tim, event, person);
        fclose(fd);
#endif
}

/* getdata: Get another data item for the reminder file */
void getdata (prompt, vbl)
char    *prompt, *vbl;
{
        int ok=0;
        char *c, *strchr();

        while (!ok){
                printf ("%s: ", prompt);
                gets(vbl);
                c = strchr(vbl,':');
                /* This should modified to check for a preceding backslash */
                if (*c != NULL)
                        printf ("Error: Can't use a colon; please retype.\n");
                else
                        ok = 1;
        }
}
  