// clean all free data clusters on the disk
void cln_free(void)
	{
	uint	ch;     		// temp area
	ulong	spp;            // sectors per partition
	ulong	tspp;           // total sectors per partition
	ulong	i;              // index variable
	uint	num_clusters;   // number of clusters in the partition & fat table
	ulong	fat_sector;
	uint	fat_offset;
	ulong	first_sector;
	ulong	last_sector;
	ulong	current_sector;
	uint	ifat_sectors;
	ulong	lfat_sectors;
	uint	value;
	uchar	*fat_sec_buf;

	fat_sec_buf = (uchar *)calloc(hdb.bytes_sector, sizeof(uchar));
	if( fat_sec_buf == NULL )
		{
		cprintf("\n\rFailed to allocate fat_sec_buf in cln_free");
		getch();
		exit(0);
		}

	// first check if there are a small number of sectors/partition
	spp = (ulong)hdb.short_number_sectors_partition;
	if ( spp == 0L )  // if not, then use the long number of sectors/partition
		spp = hdb.number_sectors_partition;

	tspp = 	spp  // start with the total sectors in the partition
			// then subtract the reserved sectors
			- (ulong)hdb.reserved_sectors
			// then subtract the number of sectors in the fats
			- (ulong)hdb.sectors_fat * (ulong)hdb.number_fats
			// then subtract the number of sectors in the root directory
			- (((ulong)hdb.number_entries_root_dir * 32L)/(ulong)hdb.bytes_sector);

	// find the number of clusters in the partition
	// +2 because dos adds 2 unused clusters at the beginning of the fat table
	num_clusters = (uint)(tspp/(ulong)hdb.sectors_cluster) + 2;

	// calculate the ulong number of sectors in the fat
	lfat_sectors = ((ulong)(num_clusters)*2L)/(ulong)hdb.bytes_sector;

	// see if there is any residue
	if( ((ulong)(num_clusters)*2L)%(ulong)hdb.bytes_sector )
		lfat_sectors += 1L; // if so, then add 1 sector
	ifat_sectors = (uint)lfat_sectors;  // get the uint (short) number of sectors in the fat
	cprintf("\n\rTotal Sectors in the partition = %lu", spp );
	cprintf("\n\rTotal sectors in the data area = %lu", tspp );
	cprintf("\n\rTotal number of cluster entries = %u", num_clusters);
	cprintf("\n\rTotal number of fat sectors     = %u", ifat_sectors);
	cprintf("\n\rCluster range = 2 to %u", num_clusters-1);
	cprintf("\n\rNow cleaning");

	current_sector = 0L;
	i = 2L;
	while( i < (ulong)num_clusters )
		{
		// calculate the sector and offset of the cluster location in the fat
		fat_sector =  (i * 2L)/(ulong)hdb.bytes_sector
				// use the first fat so add in the reserved sectors
				+ (ulong)hdb.reserved_sectors;
		fat_offset = (uint)((i * 2L) % (ulong)hdb.bytes_sector);
		if( fat_sector != current_sector )
			{
			if( kbhit() )
				{
				get_key();
				cprintf("\n\rQuit? Y or N");
				ch = getch();
				if( (ch == 'Y') || (ch == 'y') )
					exit(0);
				}
			read_sec((uchar far*)fat_sec_buf, fat_sector,1);  // read the fat sector
			current_sector = fat_sector;
			}
		value = *(uint*)&fat_sec_buf[(uint)fat_offset];
		if ( value == 0 )
			{
			calc_cluster_sectors( (uint)i, &first_sector, &last_sector );
			wt_multi( (uchar far*)big_bufzero,first_sector, 1, hdb.sectors_cluster);
			wt_multi( (uchar far*)big_bufaa,first_sector, 1, hdb.sectors_cluster);
			wt_multi( (uchar far*)big_buf55,first_sector, 1, hdb.sectors_cluster);
			wt_multi( (uchar far*)big_bufzero,first_sector, 1, hdb.sectors_cluster);
			cprintf("\n\r%lu %lu %lu",i,first_sector,last_sector);
			}
		i++;
		}
	free(fat_sec_buf);
	}


