/*
 * Author:	Kou1 Ma2da (matsuda@ccs.mt.nec.co.jp)
 * Modified By:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, 1992, William Cheng.
 * 
 * Permission limited to the use, copy, modify, and distribute this software
 * and its documentation for any purpose is hereby granted by the Author without
 * fee, provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the Author not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.  All other
 * rights are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /amnt/kona/tangram/u/william/X11/TGIF2/RCS/copypaste.c,v 2.30.1.2 1992/10/16 05:07:26 william Exp $";
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "auxtext.e"
#include "box.e"
#include "choice.e"
#include "cmd.e"
#include "color.e"
#include "cursor.e"
#include "dup.e"
#include "file.e"
#include "font.e"
#include "move.e"
#include "obj.e"
#include "pattern.e"
#include "select.e"
#include "setup.e"
#include "special.e"
#include "text.e"

#define TGIF_HEADER 0x80

extern char * mktemp();

int	copyingToCutBuffer = FALSE;

static char * cutBuffer = NULL;

void CopyToCutBuffer ()
{
   FILE				* fp;
   register struct SelRec 	* sel_ptr;
   struct ObjRec		* obj_ptr, * top_obj, * bot_obj;
   char 			tmpfile[MAXSTRING], msg[MAXSTRING];
   struct stat 			stat;
   unsigned char 		header = TGIF_HEADER;
    
   if (topSel == NULL)
   {
      Msg ("No object selected for the COPY operation.");
      return;
   }
   sprintf (tmpfile, "%sTgifXXXXXX", TMP_DIR);
   mktemp (tmpfile);
   if ((fp = fopen (tmpfile, "w+")) == NULL)
   {
      sprintf (msg, "Can not open %s.", tmpfile);
      Msg (msg);
      return;
   }

   write (fileno(fp), &header, 1);

   top_obj = bot_obj = NULL;
   for (sel_ptr = botSel; sel_ptr != NULL; sel_ptr = sel_ptr->prev)
   {
      obj_ptr = DupObj (sel_ptr->obj);

      obj_ptr->prev = NULL;
      obj_ptr->next = top_obj;

      if (top_obj == NULL)
         bot_obj = obj_ptr;
      else
         top_obj->prev = obj_ptr;
      top_obj = obj_ptr;
   }
   Save (fp, bot_obj, 0);

   fflush (fp);
   if (fstat (fileno(fp), &stat) < 0)
   {
      fclose (fp);
      unlink (tmpfile);
      sprintf (msg, "FSTAT error in %s.  Copy aborted!", tmpfile);
      Msg (msg);
      return;
   }

   if (cutBuffer != NULL) free (cutBuffer);
   cutBuffer = (char *) calloc (stat.st_size+1, sizeof(char));

   rewind(fp);
   if (read (fileno(fp), cutBuffer, stat.st_size) < stat.st_size)
   {
      sprintf (msg, "READ error in %s.  Copy aborted!", tmpfile);
      Msg (msg);
   }
   else
   {
      int	copy_failed = FALSE;

      copyingToCutBuffer = TRUE;
      XStoreBytes (mainDisplay, cutBuffer, stat.st_size);
      XSync (mainDisplay, False);
      if (copyingToCutBuffer == INVALID)
      {
         sprintf (msg, "%s  %s", "Copy to cut buffer fails.",
               "Selected object(s) may be too big.");
         copy_failed = TRUE;
      }
      else
         sprintf (msg, "Copy buffer updated.");
      copyingToCutBuffer = FALSE;
      Msg (msg);
      if (copy_failed)
      {
         *cutBuffer = '\0';
         XStoreBytes (mainDisplay, cutBuffer, 1);
      }
   }
   fclose (fp);
   unlink (tmpfile);
}

static
void PasteString (CutBuffer)
   char	* CutBuffer;
{
   register char	* c_ptr, * dest_c_ptr;
   int			x, y, w, num_lines, char_count, max_len = 0;
   int			root_x, root_y, grid_x, grid_y;
   unsigned int		status;
   char			msg[MAXSTRING];
   struct StrRec	* first_str, * last_str, *str_ptr;
   struct ObjRec	* obj_ptr;
   struct TextRec	* text_ptr;
   Window		root_win, child_win;

   if (*CutBuffer == '\0') { Msg ("Cut buffer is empty"); return; }

   TieLooseEnds ();
   SetCurChoice (NOTHING);
   if (topSel!=NULL) { HighLightReverse (); RemoveAllSel (); }

   Msg ("Paste from a non-tgif tool.");

   XQueryPointer (mainDisplay, drawWindow, &root_win, &child_win,
         &root_x, &root_y, &x, &y, &status);
   GridXY (x, y, &grid_x, &grid_y);

   text_ptr = (struct TextRec *) calloc (1, sizeof(struct TextRec));
   text_ptr->font = curFont;
   text_ptr->dpi = curFontDPI;
   text_ptr->style = curStyle;
   text_ptr->attr = NULL;
   text_ptr->size = curSize;
   text_ptr->just = textJust;
   text_ptr->v_space = textVSpace;
   text_ptr->rotate = curRotate;
   text_ptr->pen = penPat;
   text_ptr->fill = objFill;
   text_ptr->asc = canvasFontAsc;
   text_ptr->des = canvasFontDes;

   first_str = last_str = NULL;
   for (c_ptr = CutBuffer, num_lines = 0; *c_ptr != '\0'; num_lines++)
   {
      str_ptr = (struct StrRec *) calloc (1, sizeof(struct StrRec));

      char_count = 0;
      dest_c_ptr = str_ptr->s;
      while (*c_ptr != '\0' && *c_ptr != '\n' && *c_ptr != '\r')
      {
         *dest_c_ptr++ = *c_ptr++;
         if (++char_count == MAXSTRING)
         {
            sprintf (msg, "String length exceeds $1d.  String truncated.",
                  MAXSTRING);
            Msg (msg);
            while (*c_ptr != '\0' && *c_ptr != '\n' && *c_ptr != '\r') c_ptr++;
            break;
         }
      }
      *dest_c_ptr = '\0';

      str_ptr->prev = last_str;
      str_ptr->next = NULL;
      if (last_str == NULL)
         first_str = str_ptr;
      else
         last_str->next = str_ptr;
      last_str = str_ptr;

      w = XTextWidth (canvasFontPtr, str_ptr->s, strlen (str_ptr->s));
      if (w > max_len) max_len = w;

      if (*c_ptr == '\n' || *c_ptr == '\r') c_ptr++;
   }

   text_ptr->lines = num_lines;
   text_ptr->first = first_str;
   text_ptr->last = last_str;

   obj_ptr = (struct ObjRec *) calloc (1, sizeof(struct ObjRec));
   obj_ptr->x = grid_x;
   obj_ptr->y = grid_y;
   obj_ptr->type = OBJ_TEXT;
   obj_ptr->color = colorIndex;
   obj_ptr->id = objId++;;
   obj_ptr->dirty = FALSE;
   obj_ptr->rotation = 0;
   obj_ptr->detail.t = text_ptr;
   obj_ptr->fattr = obj_ptr->lattr = NULL;

   SetTextBBox (obj_ptr, textJust, max_len,
         num_lines*textCursorH+(num_lines-1)*textVSpace, curRotate);
   AdjObjBBox (obj_ptr);
   PlaceTopObj (obj_ptr);

   AddObj (NULL, topObj, obj_ptr);
   SelectTopObj ();
   RecordNewObjCmd ();
   SetFileModified (TRUE);
   justDupped = FALSE;
}

static
struct ObjRec * CreateTmpBoxObj (LtX, LtY, RbX, RbY)
   int	LtX, LtY, RbX, RbY;
{
   register struct BoxRec	* box_ptr;
   register struct ObjRec	* obj_ptr;

   box_ptr = (struct BoxRec *) calloc (1, sizeof(struct BoxRec));
   box_ptr->fill = NONEPAT;
   box_ptr->width = 0;
   box_ptr->pen = NONEPAT;
   box_ptr->dash = 0;

   obj_ptr = (struct ObjRec *) calloc (1, sizeof(struct ObjRec));

   obj_ptr->bbox.ltx = obj_ptr->obbox.ltx = obj_ptr->x = LtX;
   obj_ptr->bbox.lty = obj_ptr->obbox.lty = obj_ptr->y = LtY;
   obj_ptr->bbox.rbx = obj_ptr->obbox.rbx = RbX;
   obj_ptr->bbox.rby = obj_ptr->obbox.rby = RbY;
   obj_ptr->type = OBJ_BOX;
   obj_ptr->color = colorIndex;
   obj_ptr->id = 0;
   obj_ptr->dirty = FALSE;
   obj_ptr->rotation = 0;
   obj_ptr->detail.b = box_ptr;
   obj_ptr->fattr = obj_ptr->lattr = NULL;
   return (obj_ptr);
}

void PasteFromCutBuffer ()
{
   FILE 		* fp;
   int 			len, ltx, lty, rbx, rby, dx, dy, read_status;
   char 		tmpfile[MAXSTRING], * cut_buffer, msg[MAXSTRING];
   unsigned char 	header = TGIF_HEADER;
   struct ObjRec	* obj_ptr, * saved_top_obj, * saved_bot_obj, * tmp_obj;
   struct ObjRec	* tmp_top_obj, * tmp_bot_obj;

   cut_buffer = (char *) XFetchBytes (mainDisplay, &len);
   if (len == 0)
   {
      Msg ("Cut buffer is empty");
      return;
   }
   if (((unsigned char)(*cut_buffer)) != header)
   {
      PasteString (cut_buffer);
      return;
   }
   cut_buffer++;
   len--;

   sprintf (tmpfile, "%sTgifXXXXXX", TMP_DIR);
   mktemp (tmpfile);
   if ((fp = fopen (tmpfile, "w+")) == NULL)
   {
      sprintf (msg, "Can not open %s for write.", tmpfile);
      Msg (msg);
      return;
   }
   if (write (fileno(fp), cut_buffer, len) < len)
   {
      fclose (fp);
      unlink (tmpfile);
      sprintf (msg, "FWRITE error in writing to %s.  Paste aborted!",
            tmpfile);
      Msg (msg);
      return;
   }
   fflush (fp);
   rewind (fp);

   SetWatchCursor (drawWindow);
   SetWatchCursor (mainWindow);

   TieLooseEnds ();
   SetCurChoice (NOTHING);
   if (topSel!=NULL) { HighLightReverse (); RemoveAllSel (); }

   saved_top_obj = topObj;
   saved_bot_obj = botObj;
   topObj = botObj = NULL;
    
   importingFile = TRUE;
   while ((read_status = ReadObj (fp, &obj_ptr)) == TRUE)
      if (obj_ptr != NULL)
      {
         AdjForOldVersion (obj_ptr);
         UnlockAnObj (obj_ptr);
         AddObj (NULL, topObj, obj_ptr);
      }

   fclose (fp);
   importingFile = FALSE;
   unlink (tmpfile);
   SetDefaultCursor (mainWindow);
   SetDefaultCursor (drawWindow);

   if (read_status == INVALID)
   {
      sprintf (msg, "File version too large (=%1d).  Paste aborted!",
            fileVersion);
      Msg (msg);
      return;
   }
    
   if (topObj != NULL) SetFileModified (TRUE);

   ltx = topObj->obbox.ltx;
   lty = topObj->obbox.lty;
   rbx = topObj->obbox.rbx;
   rby = topObj->obbox.rby;
   for (obj_ptr = topObj->next; obj_ptr != NULL; obj_ptr = obj_ptr->next)
   {
      if (obj_ptr->obbox.ltx < ltx) ltx = obj_ptr->obbox.ltx;
      if (obj_ptr->obbox.lty < lty) lty = obj_ptr->obbox.lty;
      if (obj_ptr->obbox.rbx > rbx) rbx = obj_ptr->obbox.rbx;
      if (obj_ptr->obbox.rby > rby) rby = obj_ptr->obbox.rby;
   }
   tmp_obj = CreateTmpBoxObj (ltx, lty, rbx, rby);

   tmp_top_obj = topObj;
   tmp_bot_obj = botObj;
   topObj = botObj = NULL;
   PlaceTopObj (tmp_obj);
   topObj = tmp_top_obj;
   botObj = tmp_bot_obj;

   dx = tmp_obj->obbox.ltx - ltx;
   dy = tmp_obj->obbox.lty - lty;
   FreeBoxObj (tmp_obj);

   for (obj_ptr = topObj; obj_ptr != NULL; obj_ptr = obj_ptr->next)
      MoveObj (obj_ptr, dx, dy);
    
   SelAllObj (FALSE);
    
   if (botObj != NULL)
      botObj->next = saved_top_obj;
   else
      topObj = saved_top_obj;

   if (saved_top_obj != NULL)
   {
      saved_top_obj->prev = botObj;
      botObj = saved_bot_obj;
   }
   RedrawDrawWindow (botObj);
   PrepareToRecord (CMD_NEW, NULL, NULL, 0);
   RecordCmd (CMD_NEW, NULL, topSel, botSel, numObjSelected);
   HighLightForward();

   Msg ("Objects pasted from tgif.");
}        

void CleanUpCutBuffer ()
{
   if (cutBuffer != NULL)
   {
      *cutBuffer = '\0';
      free (cutBuffer);
      cutBuffer = NULL;
   }
   copyingToCutBuffer = FALSE;
}
