.\"@(#)$Header: /amnt/kona/tangram/u/william/X11/TGIF2/RCS/tgif.man,v 2.124 1992/10/26 06:23:36 william Exp $
.TH TGIF n "Version 2.12-p12 and Above" "Tgif"
.SH NAME
\fItgif\fR \- Xlib based interactive 2-D drawing facility under X11.
Supports hierarchical construction of drawings and easy navigation between
sets of drawings.
.SH SYNOPSIS
.B tgif
[\fB-display\fR displayname]
[\fB-fg\fR <color>]
[\fB-bg\fR <color>]
[\fB-bd\fR <color>]
[\fB-rv\fR]
[\fB-nv\fR]
[\fB-bw\fR]
[\fB-geometry\fR <geom>]
[\fB=<geom>\fR]
[\fI<file>\fR[.\fIobj\fR]]
.PP
or
.PP
.B tgif
\fB-print\fR
[\fB-eps\fR]
[\fB-p\fR]
[\fB-ps\fR]
[\fB-f\fR]
[\fB-gray\fR]
[\fB-adobe\fR]
[\fB-o\fRdir]
[\fIfile1\fR \fIfile2\fR ...]
.SH DESCRIPTION
\fITgif\fR is an interactive drawing tool that allows the user to draw and
manipulate objects in the X Window System.  Tgif runs interactively in
the first form.  In the second form, tgif just prints files without
opening windows or fonts, and it is compatible with
the obsoleted \fIprtgif\fR.
.PP
In the first form, the command line arguments
\fI-fg\fR, \fI-bg\fR, and \fI-bd\fR specify
the foreground, background, and border colors, respectively.
The command line argument \fIfile\fR
specifies a file of objects to be initially edited by tgif.
If \fI-rv\fR (or \fI-nv\fR) is specified, tgif will come up
in reverse-video (or normal-video) mode.
If \fI-bw\fR is specified, tgif will come up in the black and white mode.
Tgif is purely based on \fIXlib\fR.
It is tested under X11-R4, and
it requires a 3 button mouse.
.PP
In the second form, tgif prints \fIfile1.obj\fR, \fIfile2.obj\fR,
etc.  (generated by \fItgif\fR)
into PostScript(TM) page description files
and pipes them to \fIlpr\fR if none of the
\fB-eps\fR, \fB-p\fR, \fB-ps\fR, or \fB-f\fR options are not specified;
in this case, any other command line options are sent to \fIlpr\fR.
A symbol file (see descriptions below) can also be printed by
specifying the \fI.sym\fR extension explicitly.
.PP
In the second form,
if the \fB-eps\fR or the \fB-p\fR option is specified,
tgif generates an encapsulated PostScript file in \fIfile.eps\fR;
this file is supposed to be included in a LaTeX file through the
\\psfig, \\epsf, or \\psfile construct (see the LATEX FIGURE FORMATS section
below).
If the \fB-ps\fR or the \fB-f\fR option is specified,
it generates a PostScript file in \fIfile.ps\fR;
this file can be printed to a PostScript printer with lpr.
(Note that if any of the \fB-eps\fR, \fB-p\fR, \fB-ps\fR, or \fB-f\fR
options are specified,
any other command line options are ignored.)
Using the \fI-gray\fR option has the same effect as setting the
Tgif*UseGrayScale X default for tgif (see the X DEFAULTS section below).
Using the \fI-adobe\fR option has the same effect as setting the
Tgif*UsePsAdobeString X default for tgif (see the X DEFAULTS section below).
If the \fI-o\fR option is not specified, the output file (eps or ps)
goes into the same directory as the input file.  If \fI-o\fRdir
is specified, the output file goes into the directory specified
by \fIdir\fR.
.PP
Please note that only running tgif interactively can generate X11 bitmap
or X11 pixmap files.
.SH BASIC FUNCTIONALITIES
Primitive objects supported by tgif
are rectangles, ovals, rounded-corner rectangles, arcs,
polylines, polygons, open-splines, closed-splines, text, X11 bitmaps,
some specific forms of X11 pixmaps, and Encapsulated PostScript(TM).
Objects can be grouped together to form a \fIgrouped\fR object.
A primitive or a grouped object can be made into an \fIicon\fR object or a
\fIsymbol\fR object through user commands.
.PP
Tgif objects are stored in two types of files.  A file with a
.I \.obj
extension (referred to as an \fIobject\fR file)
is a file of objects, and a file with a
.I \.sym
extension (referred to as a \fIsymbol\fR file)
specifies a ``building-block'' object.
A \fIteleport\fR mechanism is provided to \fItravel\fR among the .obj files.
A building-block object consists of the
\fIrepresentation\fR part and the \fIdefinition\fR
part (which can be empty) of the object.
Tgif supports the ``bottom-up'' construction of hierarchical
drawings by providing the capability to ``instantiate'' a
building-block object in a drawing.  Tgif also supports the ``top-down''
specification of drawings by allowing the user to make any
object a \fIrepresentation\fR
of an un-specified subsystem.
Both types of files are stored in the
form of Prolog facts.  Prolog code can be written to interpret
the drawings!  (It is left to the user to produce the code.
See the PROLOG/C TESTDRIVE section for more details.)
Prolog engines will be referred to as
\fIdrivers\fR in the sections to follow.  (Other types of drivers
are also allowed, e.g., written in C.)
.PP
Text based \fIattributes\fR can be attached to any non-text object.
Attributes specified in the representation part of a
building-block object are non-detachable when such an object is instantiated.
See ATTRIBUTES section for details.
.PP
Tgif can generate output in four different formats.
By default, the output is in the PostScript(TM) format (color PostScript
is supported), and it is generated into a file named
/tmp/Tgifa* (produced by mktemp() calls) where * is a number;
this file is piped to lpr.  This takes place when the
laser-printer icon is displayed in the Choice Window (see below
for the naming of tgif windows).
This output can be redirected to a file with a
.I \.ps
extension.  This takes place when the \fIPS\fR icon is displayed.
When the \fILaTeX\fR icon is displayed, the output generated into a file with a
.I \.eps
extension.  This file is in
the encapsulated PostScript format;
it can be included in a LaTeX document with the
\fI\\psfig\fR or the \fI\\epsf\fR construct; this will be discussed later.
When the \fIx11bm\fR (X11 bitmap) icon is displayed in the
Choice Window and color output is \fInot\fR selected,
tgif generates the output with the
.I \.xbm
extension; the output is in the X11 bitmap format.
However, if the x11bm icon is displayed in the
Choice Window and color output \fIis\fR selected (through the ^#k
keyboard command -- ^ denotes the <Control> and # denotes the <Meta> key),
then tgif generates the output with the
.I \.xpm
extension, and the output is in the X11 pixmap format
(the version of this XPM format depends on the settings of the
XPmOutputVersion X default).
X11 bitmap files, certain forms of X11 pixmap files
(such as the one generated by tgif; see the section on X11 PIXMAP
for details), and Encapsulated PostScript (EPS) files
can be \fIimported\fR into tgif and be represented
as tgif primitive objects.
.PP
Tgif drawings are supposed to be printed on letter size paper (8.5in by 11in).
Both landscape and portrait page styles are supported by tgif.
Reduction (or magnification) can be controlled by the #% keyboard
command to set the reduction/magnification.  If the compiler
flag -DA4PAPER is defined (in Imakefile or Makefile.noimake),
then the output is supposed to be printed on A4 papers (which
has approximate dimensions of 8.25in by 11.7in).
.SH GRAPHICAL OBJECTS
An object in an \fIobject\fR (\fI.obj\fR) file can be a primitive object,
a grouped object, or an \fIicon\fR object.
A \fIsymbol\fR (\fI.sym\fR) file can have any number of objects allowed in an
object file and exactly one \fIsymbol\fR object.
(Recall that a symbol file specifies a building-block
object.)  The symbol object in a symbol file is the representation
part of the building-block object, and the rest of the
symbol file is the definition
part of the building-block object.  The symbol object is highlighted
with a dashed outline to distinguish it from the rest of
the objects.  When a building-block object is instantiated,
the symbol part of the file is copied into the graphics editor, and it becomes
the icon for the building-block object.
.PP
All objects in tgif can be moved, duplicated, deleted, rotated, 
and flipped.  (However, flipping text objects horizontally will
cause the text justification to change, and flipping text objects
vertically will usually cause the text object to move.)
All objects, except text and rigid icon objects, can be stretched
(scaled).  (See the TGIF SUBWINDOWS section for the definition of rigid
icon objects.)
.PP
Tgif supports 32 fill patterns, 32 pen patterns, 7 default line widths, 4 line
styles (plain, head arrow, tail arrow, double arrows) for
polylines and open-splines, 9 dash patterns,
3 types of text justifications, 4 text
styles (roman, italic, bold, bold-italic), 11 text sizes
(8, 10, 12, 14, 18, and 24 for the 75dpi fonts and
11, 14, 17, 20, 25, and 34 for the 100dpi fonts), 5 fonts (Times, Courier,
Helvetica, New-Century-Schoolbook, Symbol), and 11 default colors (magenta,
red, green, blue, yellow, pink, cyan, cadet-blue, white, black,
dark-slate-gray).
Only right-angle rotations are supported.
.PP
Most commands in tgif can either be activated by a
popup menu or by typing an appropriate
non-alphanumeric key.  All operations that change any object can be undone
and the redone.  Commands such as zoom, scroll, change fonts while no
text objects are selected, etc. are not undoable.  The undo/redo
history buffer size can be set using the Tgif*HistoryDepth X default.
.SH TGIF SUBWINDOWS
The tgif windows are described below.
.TP
.I Top Window
Displays the current domain and the
name of the file tgif is looking at.  Mouse clicks
and key presses have no effect.
.TP
.I Message Window
This is right under the top window on the left.
It displays tgif messages.  Clicking the left mouse button
in this window scrolls
the messages towards the bottom, clicking the right mouse
button scrolls towards
the top, and clicking or dragging the middle mouse button scrolls
to the location in the
message history depending on where the mouse is clicked.
.TP
.I Panel (Choice) Window
This is the window to the right of the message window, and it
contains a collection of icons (not to be confused with the tgif icon objects)
reflecting the current state of tgif.
In top/bottom, left/right order, it
displays the current drawing mode, the
page mode (portrait/landscape), edit (see below),
print mode, zoom factor, constrained/unconstrained move (and stretch) mode,
radius for rounded-corner rectangles,
text rotation, horizontal alignment (L C R S -),
vertical alignment (T M B S -),
font, text size, vertical spacing between lines of text within
the same text object, text justification, dash pattern,
line style, polyline or spline, line width, fill pattern, pen pattern,
color, and special (see below).
Key presses have no effect in this window.
.PP
.RS
In addition to displaying the current state of tgif, the icons in the
Choice Window can also be used to change the current state.
Each icon is associated with a particular state variable of tgif.
Clicking the left mouse button on top of an icon cycles the
state variable associated with the icon forward; clicking the right mouse
button cycles the state variable backwards.  Dragging the middle mouse button
on top of an icon usually generates a popup menu which corresponds to
an entry in the main menu for the Canvas Window below.
(The ``edit'' and ``special'' icons mentioned above are dummy icons
that allow the ``edit'' and ``special'' menus to be
accessed in the Choice Window.  They do not responds to left and right
mouse clicks.)
The response to the dragging of the middle mouse button is different for
the zoom, radius, and vertical spacing icons.  Dragging the mouse
left or up increases the zoom or decreases the radius or vertical spacing;
dragging the mouse right or down has the opposite effect.
.PP
If there are objects selected in the
canvas window, then the action of the mouse will cause the selected
objects to change to the newly selected mode; note that in this
case, the current choice won't change if the middle mouse button
is used.
.PP
The settings of the horizontal and vertical
alignments determine how objects (or vertices) align with
each other when the ^l keyboard command is issued,
how each individual object (or vertex) aligns with the grids
when the ^t keyboard command is issued,
how objects or vertices distribute spatially with respect to each other when
the #l keyboard command is issued,
and how each icon replaces the old icon when the ^#u
keyboard command is issued.  The horizontal
alignments are left (L), center (C), right (R), space (S), and ignore (-).
The vertical alignments are top (T), middle (M), bottom (B), space (S), and
ignore (-).  In aligning operations, the space (S) and the ignore (-)
settings have the same effect.  The space settings are used to distribute
objects such that the gaps between any two neighboring objects are equal.
In vertex mode, any non-ignore setting will cause the selected vertices
to be spaced out evenly.
The best way to understand them is to try them out.
.PP
The text vertical spacing determines the vertical distance to advance
when a carriage return is pressed during text editing.  If the user
tries to set the
value too negative, such that the next line is exactly at
the same position as the current line, such a setting will not be
allowed (this distance depends on the current font and point size).
.RE
.TP
.I Canvas Window
This is the drawing area.  The effects of the actions of the mouse is
determined by the current drawing mode.  Normally, dragging the right mouse
button will generate the ModeMenu.  The drawing modes are (in order,
as they appear in the ModeMenu) select, text, rectangle,
oval, polyline (open-spline), polygon (closed-spline),
arc, rounded-corner rectangle, freehand polyline (open-spline),
and select vertices.
.PP
.RS
In the select mode, left mouse button selects, moves, stretches,
and reshapes objects (double-click will ``de-select'' all selected objects
in vertex mode).
Holding down the shift key and clicking the left mouse
on an object which is not currently selected will add the
object to the list of already selected objects.  The same
action applied to an object which is already selected will cause
it to be de-selected.
When stretching objects (not reshaping poly-type objects),
holding down the shift key \fIafter\fR stretching is initiated results in
proportional stretching being activated (basically, a scale operation
is being performed).
Text and rigid icon objects can not be stretched or scaled.
(Rigid icon objects are icons that do not have an inherited
attribute whose name is empty and whose value is the string "not_rigid".
Rigid icon objects inside a non-rigid icon object is considered non-rigid.)
Clicking the middle mouse button
while the shift key is held down will activate
the \fIteleport\fR (or \fItravel\fR) mechanism.  See the section on
TELEPORT for details.
The arrow keys can also be used to move selected objects.  However,
if no objects
are selected, using the arrow keys will scroll the drawing area by a small
amount, and using the arrow keys when <Control> key is held down will
scroll a screen full.
.PP
In the select vertices mode, left mouse button selects and moves
vertices.  Only the top-level polyline/open-spline and polygon/closed-spline
objects which are selected when the vertex mode is activated
are eligible for vertex operations.  In this mode, all
eligible objects have their vertices highlighted with squares.
When a vertex is selected (using similar mechanism as selecting
objects described above), it is doubly highlighted with a '+' sign.
Operations available to these doubly highlighted vertices are move, delete,
align (with each other), distribute (space them equally), and align to grid.
The arrow keys can also be used to move selected vertices.
.PP
Objects can be locked (through the #< command).  Locked object are shown
with gray handles, and they can not be moved, stretched, flipped,
or rotated.  When objects are grouped, the resulting grouped object
will also be locked if any one of it's constituents is locked.
Locked objects can have their properties, such as color, font, pen, etc.,
changed; furthermore, they can be deleted.
.PP
If the current move/stretch mode is of the constrained type (activated
and deactivated by the #@ command), top-level polylines will have the
following behavior.  In a move operation, if both endpoints of a
polyline lie inside the objects being moved, then the whole polyline
is moved; otherwise, if only one endpoint falls inside the objects
being moved, then that endpoint is moved.  The vertex that is the
neighbor of the moved endpoint may also be moved either horizontally
or vertically.  If the last line segment is horizontal or vertical,
then the neighbor vertex may be moved so that the direction of the last
line segment is maintained.
In a stretch (not reshape)
operation, if an endpoint of a polyline lies inside the objects being moved,
that endpoint will be moved.  The vertex that is the neighbor of
the moved endpoint will also be moved in the same manner as described above.
.PP
When the drawing mode is set to
text (a vertical-bar cursor is shown),
clicking the left mouse button causes selected text to go into edit mode.
Clicking the left mouse button while the shift key is held down highlights
sub-strings of the text.
In edit mode,
key presses are treated as text strings being
inputed, and arrow keys are used to move the current input
position.  If a key press is preceded by an <ESC> key,
then the character's bit 7 is turned on.  This allows
non-ASCII characters to be entered.  There are some characters
that are supported by X11 but not by PostScript; these characters
are not accepted by tgif.
If the text being edited is an attribute of a object, <Meta><Tab>
will move the cursor to the next visible attribute and <Shift><Tab> will
move the cursor to the previous visible attribute.
.PP
If the drawing mode is set to draw polygons (not closed-splines) and
if the shift key is held down, the rubber-banded polygon will be self-closing.
.PP
The freehand drawing mode can be used to draw polylines and open splines.
All intermediate points are specified by moving the mouse (as opposed to
clicking the mouse buttons as in the polyline mode).  The
second end point is specified by releaseing the mouse button.
.PP
Middle mouse button always generates the main
tgif popup menu.  Holding down the shift key and clicking the right
mouse button will change the drawing mode to \fIselect\fR.
Key presses with the <Control> or <Meta> key held down
(referred to as \fInon-alphanumeric\fR key presses since
they can also generate control characters)
are treated as commands, and their
bindings are summarized in the next section.  Users can also
define single key commands to emulate the functions of the
non-alphanumeric key commands.
The SHORTCUTS section will describe the details.
.RE
.TP
.I Scrollbars
Clicking the left mouse button in the vertical/horizontal scrollbar causes the
canvas window to scroll down/right by a small distance; clicking the
right mouse button has the reverse effect.  (The scrollbars in the popup
windows for selecting filenames and domain names behave similarly.)
Clicking with the shift key held down will scroll a window full.
Clicking or dragging the middle button will cause the page to scroll
to the location which corresponds to the gray area in the scrollbars.
(Tgif insists that the left top corner of the Canvas Window is at
a distance that is a nonnegative multiple of some internal units
from the left top corner of the actual page.)
.TP
.I Rulers
.br
They track the mouse location.
Mouse clicks and key presses have no effect.
When the page reduction/magnification is set at 100%,
the markings in the rulers correspond to centimeters when the metric
grid system is used, and they correspond to inches when the English
grid system is used.  When the page reduction/magnification is not
set at 100%, the markings do not correspond to the above mentioned
units any more.
.TP
.I Popup Menus
.br
When a menu is poped up by a mouse drag, the menu can be \fIpinned\fR
if it is dragged far enough horizontally
(the distance is determined by the
setting of the Tgif*MainMenuPinDistance X default).
Clicking the right mouse
button in a pinned menu will cause it to disappear.  Dragging
the left mouse button in a pinned menu will reposition the menu.
Clicking the middle mouse button in it will activate the clicked item.
.SH NON-ALPHANUMERIC KEY BINDINGS
Most operations that can be performed in tgif can be activated
through non-alphanumeric keys (a few operations can only be
activated through popup menus or shortcut keys).
This section summarizes the operations that can be activated
by a key stroke with the <Control> and/or the <Meta> key held down.
``^'' denotes the <Control> key and ``#'' denotes the <Meta> key
in the following description.  (The ``\fIkeys.obj\fR'' file, distributed
with tgif, also summarizes the same information, but it is organized
differently.  This file can be viewed with tgif, and if installed properly,
it can be found in the same directory as the ``tgificon.obj'' file,
mentioned in the FILES section of this document.)
.PP
.DS
  ^a	select all
  ^b	send selected objects to the back
  ^c	change domain
  ^d	duplicate selected objects
  ^e	save/restore drawing mode
  ^f	send selected objects to the front
  ^g	group selected objects (the grouped object will be brought to the front)
  ^i	instantiate a building-block object
  ^k	pop back to (or return to) a higher level and close the symbol file
(reverse of ^v)
  ^l	align selected objects according to the current alignment settings
  ^n	open a new un-named object file
  ^o	open an object file to edit
  ^p	print the current page (or export in xbm, xpm, eps, or ps formats)
  ^q	quit tgif
  ^r	redraw the page
  ^s	save the current object/symbol file
  ^t	align selected objects to the grid according to the current alignment
  ^u	ungroup selected objects
  ^v	push into (or edit) the definition part of a building-block (icon)
object
  ^w	change the drawing mode to text
  ^x	delete all selected objects
  ^y	copy selected objects into the cut buffer
  ^z	escape to driver
  ^,	scroll left
  ^.	scroll right
  ^-	print the current page with a specified command

  #a	attach selected text objects to a selected non-text object as attributes
  #b	escape to driver
  #c	rotate selected objects counter-clockwise
  #d	decrement the grid size
  #e	send a token on a selected polyline
  #f	flash a selected polyline
  #g	show/un-show grid points
  #h	flip the selected objects horizontally
  #i	increment the grid size
  #j	hide the attribute names of the selected objects
  #k	change the drawing mode to select
  #l	distribute selected objects according to the current alignment
  #m	move/justify an attribute of a selected object
  #n	show all the attribute names of the selected objects
  #o	zoom out
  #p	import a .obj file into the current file
  #q	change the drawing mode to polyline/open-spline
  #r	change the drawing mode to rectangle
  #s	escape to driver
  #t	detach all the attributes of the selected objects
  #u	undo
  #v	flip the selected objects vertically
  #w	rotate the selected objects clockwise
  #x	escape to driver
  #y	escape to driver
  #z	zoom in
  #9	create a user-specified arc (12 o'clock position is 0 degree)
  #0	update the selected objects according to current settings
  #,	scroll up
  #.	scroll down
  #-	show all the attributes of the selected objects
  #[	align the left sides of objects
  #=	align the horizontal centers of objects
  #]	align the right sides of objects
  #{	align the top sides of objects
  #+	align the vertical centers of objects
  #}	align the bottom sides of objects
  #"	make the selected polygon regular (fit the original bounding box)
  #%	set the percent print reduction (if < 100%) or magnification (if > 100%)
  #:	go to default zoom
  #`	zoom out all the way so that the whole page is visible
  #~	saved selected objects in a new file
  #;	cut and/or magnify a selected bitmap/pixmap object
  #_	abut selected objects horizontally
  #|	abut selected objects vertically
  ##	break up text objects into single character text objects
  #^	scroll to the origin set by SaveOrigin()
  #@	toggle between constrained and unconstrained move (stretch) modes
  #$	change the drawing mode to select vertices
  #&	align selected objects to the paper according to the current alignment
  #*	redo
  #(	import an encapsulated PostScript file
  #)	scale selected objects by specifying X and Y scaling factors
  #<	lock the selected objects (can't be moved, stretched, flipped, or
rotated)
  #>	unlock the selected objects

 ^#a	add points to the selected poly or spline
 ^#b	change the text style to bold
 ^#c	change to center justified text
 ^#d	delete points from the selected poly or spline
 ^#e	change the drawing mode to rounded-corner rectangles
 ^#f	reverse-video the selected bitmap objects
 ^#g	toggle snapping to the grid points
 ^#h	hide all attributes of the selected objects
 ^#i	make the selected object iconic
 ^#j	make the selected icon object a grouped object
 ^#k	select color or black-and-white output
 ^#l	change to left justified text
 ^#m	make the selected object symbolic
 ^#n	make the selected symbol object a grouped object
 ^#o	change the text style to roman
 ^#p	change the text style to bold-italic
 ^#q	change the drawing mode to polygon/closed-spline
 ^#r	change to right justified text
 ^#s	save the file under a new name
 ^#t	change the text style to italic
 ^#u	update iconic representations of selected objects
 ^#v	change the drawing mode to oval
 ^#w	toggle between poly and spline
 ^#x	cycle among the various output file formats
 ^#y	paste from the cut buffer
 ^#z	change the drawing mode to arcs
 ^#.	import an X11 bitmap file
 ^#,	import an X11 pixmap file
 ^#-	toggle between English and Metric grid systems
.DE
.br
.SH SHORTCUTS
The user can define single character \fIshortcut\fR keys to emulate
the function of
the non-alphanumeric key presses to activate commands.
This is done through the use of the Tgif*ShortCuts X default.
(Please note that these shortcut keys are only active when
the drawing mode is \fInot\fR set to the text mode.)
The Tgif*ShortCuts consists of a list of items, each of which
specifies the bindings between
a key (may be case sensitive) and a command.  The items are
separated by blanks, and each item is interpreted as
follows.  It consists of two parts, KEY and COMMAND, which
are concatenated together with a ':' character.
The format of the KEY part is one of
\fI:<Key>x\fR, \fI!<Key>x\fR, or \fI<Key>x\fR (here the
character 'x' is used as an example; furthermore, the substring
\fI<Key>\fR must be spelled exactly the way it appears here).
The first 2 formats are
equivalent, they specify the \fIlower case\fR x; the 3rd
format specifies both the characters 'x' and 'X'.
The COMMAND part is a string that matches strings in tgif's popup menus
(exceptions are noted below).  This is illustrated by
the following example.  In the Edit menu, two of the entries are,
.PP
.DS
   "Delete	^x"
.br
   "SelectAll	^a"
.DE
.PP
which means that <Control>x activates and Delete() command,
and <Control>a activates the SelectAll() command.
Therefore, both Delete() and SelectAll() are valid names for the COMMAND part of
a shortcut specification.  To complete the example,
the following line can be used to bind the lower case 'x' to
Delete() and 'a' or 'A' to SelectAll():
.PP
.DS
   Tgif*ShortCuts:	!<Key>x:Delete() \\n\\
.br
   				<Key>a:SelectAll()
.DE
.PP
For more examples, please
see the sample X defaults file, tgif.Xdefaults, included in the tgif
distribution.
.PP
Here is a list of exceptions where the COMMAND does not match
a command name in a menu entry.  The left entry is a proper
COMMAND name, and the right is a list of strings that's shown
in popup menus which the COMMAND would correspond to.
.PP
.DS
   CyclePrintFormat()	Printer, LaTeXFig, RawPSFile, XBitmap
   ToggleBW/ColorPS()	BlkWhtPS, ColorPS
   ToggleGridSystem()	EnglishGrid, MetricGrid
   ToggleMapShown()	ShowBit/Pixmap, HideBit/Pixmap
   ToggleUseGrayScale()	UseGrayScale, NoGrayScale
   ToggleMoveMode()	ConstMove, UnConstMove

   ToggleLineType()	(toggles between straight and curved shapes)
   ScrollPageUp()	(scroll up a window full)
   ScrollPageDown()	(scroll down a window full)
   ScrollPageLeft()	(scroll left a window full)
   ScrollPageRight()	(scroll right a window full)
   FreeHandMode()	(change the drawing mode to freehand poly/open-spline)
.DE
.br
.PP
In addition to the above list, the following are
also valid COMMAND names (having the obvious meaning):
ScrollLeft(), ScrollRight(), ScrollUp(), ScrollDown(),
SelectMode(), DrawText(), DrawBox(), DrawOval(), DrawPoly(),
DrawPolygon(), DrawRCBox(), DrawArc(), and SelectVertexMode().
.SH ATTRIBUTES
Attributes are text strings of the form \fIname=value\fR or \fIvalue\fR
which are attached to any non-text objects.
Attributes can be attached and detached from these objects
except in the following case:
.IP
Attributes appearing in the symbol object
in a building-block object file can not
be detached when the building-block object is instantiated.
These attributes are considered to be the ``inherited'' attributes
of the icon object.  (If it is really necessary to detach inherited
attributes of an icon object, the icon object
can be ``de-iconified'' by using UnMakeIconic() in the SpecialMenu
to make it a grouped object; then the attributes can be detached.)
.PP
The user has control over which part of an attribute is displayed.
An entire attribute can be made invisible, or only its name
can be made invisible (accomplished through the commands under the
special menu, such as #m, #n, #j, #-, and ^#h).
.SH TELEPORT
Tgif provides the mechanism to travel between .obj files.
If the middle mouse button is clicked on an object with the
shift key held down, tgif
looks for an attribute named \fIwarp_to\fR (by default) of
that object.  If such an attribute is found, the value part of
the attribute is interpreted as the name of a .obj file to
\fItravel\fR to.  If the current file is modified, the user
is prompted to save the file before traveling to the next file.
If there are multiple \fIwarp_to\fR attributes on the object,
but are in different colors, tgif will use the one that has
the same color as the color appearing in the Choice Window.
If the value part of the \fIwarp_to\fR attribute starts with the '/'
character, the value is treated as an absolute file name;
otherwise, it is treated as a relative file name.
.SH LOCKING OBJECTS
Objects can be locked and unlocked using #< and #> keyboard commands.
When a selected object is locked, it is shown with gray handles.
A locked object can be moved, stretched, flipped, or rotated;
however, its properties, such as fill pattern, width, etc., can
be changed.  Locked objects can also be deleted.  When a locked
object is grouped with other objects, the resulting grouped object
is also locked.  A locked object can be used as an anchor to
align other objects; however, DistributeObjs() command will fail
if any objects are locked.  Locked objects do not participate
in any operations in the select vertex mode.
.SH UNDO/REDO
Most operations can be undone and redone.  The Tgif*HistoryDepth
X default controls the size of the undo buffer.  If it is set
to -1, then the undo buffer's size is infinite.  The undo buffer
is flushed when the New() or Open() commands are executed (from
the FileMenu), when the FlushUndoBuffer() command is executed
from the EditMenu, or when Pop() is executed from a .sym file.
If a private colormap is used (automatically done when new colors
can not be allocated from the default colormap), executing FlushUndoBuffer()
will attempt to reset the colormap (if the -DDONT_FREE_COLORMAP
compile option is not used).
.SH DOMAINS
A \fIdomain\fR is a collection of library symbols suitable for
instantiations.  A library is implemented as a directory of .sym files,
and therefore, a domain is implemented as a search path.
If there are symbols with the same file name which reside
in different directories specified in the search path, then
the one closer to the front of the search path will be made
available for the user to instantiate.
.PP
The number of domains is specified by the MaxDomains X default,
and the names of the domains are specified by the Domain# X default.
The library search paths are specified by csh environment variables.
See the section on X DEFAULTS and ENVIRONMENT VARIABLES
for more details.
.SH SELECTING A NAME FROM A POPUP WINDOW
When selecting a file name, a symbol name, or a domain name,
tgif pops up a window with appropriate names for the user to
choose from.  The user can use mouse clicks to select an entry.
Key strokes can also be used to specify the desired name; however,
tgif attempts to match the key strokes with names in the selection
on the fly.  If a match can not be found, the key strokes are
ignored.  ^n, ^j, or the DownArrow key advances the selection
down by 1 entry; ^p, ^k, or the UpArrow key
advances the selection up by 1 entry.  ^f, ^d, or the DownArrow
key with <Control> key held down advances the
selection down by 10 entries; ^b, ^u, or the UpArrow
key with <Control> key held down advances the selection up by
10 entries.  '$' will select the last entry, while '^' will
select the first entry.  ^w or ^y un-select the selected entry.
If the selected entry is a directory, hitting <CR> will change
directory; if not, hitting <CR> finishes the selection process
and the selected entry is returned.
.PP
In selecting file names to open or import,
typing '/' is interpreted as going to the root directory.
At this point, the automatic matching of key strokes is
temporarily disabled until either a <TAB> or a <CR> is pressed.
.PP
The current selection is displayed near the top of the popup
window.  Back-space should be used with caution because it might
change the current directory to the parent directory.
.SH IMPORTING EPS FILES
Encapsulated PostScript (EPS) files can be imported using the #(
keyboard command.  If the EPS file has a preview bitmap
(can be generated using the \fIpstoepsi\fR tool), tgif will
display it (HideBit/Pixmap from the LayoutMenu can be used to
disable the displaying of bitmap/pixmaps).  When the EPS object
is saved in a .obj or .sym file, neither the preview bitmap, nor
the PostScript content of the EPS file is saved.  Therefore,
when printing such a file (either from tgif or using prtgif),
the EPS file must be present at the same place from which it was
originally imported.
.SH HOW TO MAKE A BUILDING-BLOCK OBJECT (SYMBOL FILE)
Here are the steps for defining a building-block object, to be used
in a hierarchical design.
.IP 1)
Draw the representation part of the building-block object.  Group everything
together.  Select this grouped object.
.IP 2)
Popup the main menu with the right mouse button; select ``Special''.
Select ``MakeSymbolic'' from the next popup menu.
The selected object becomes a symbol and gets a dashed boundary.
.IP 3)
Type in attributes as individual text strings.  Select the
symbol object and all the
text strings to be attached to the symbol.  Type #a (for \fIAttach\fR)
to attach attributes to the symbol.
.IP 4)
(This step is optional.)  Build
the definition part of the building-block object.  Look at the
``flip-flop.sym'' file for an example.  To look at that file, first,
instantiate a ``flip-flop'' by typing ^i (for \fIInstantiate\fR).
Select the flip-flop from
the popup window; place the flip-flop; select the flip-flop and
type ^v (for \fIPush\fR) to see the symbol file.
.IP 5)
Save and name the file.  If the current library path contains the
current directory (or '.'), the symbol just built should be
instantiatable by typing ^i.
.SH X11 PIXMAP (XPM) FORMATS
Tgif can only import X11 pixmaps that satisfy the constraints
described here.  The format of the X11 pixmap must be either 1 (XPM1)
or 3 (XPM3).  Only a subset of the XPM3 format is supported, namely,
the \fIkey\fR field for the color specification must be 'c' (for
color visuals).
Tools that generate XPM1 format files are
(they might have been upgraded to support XPM3), \fIpbmplus\fR, which is
a set of bitmap and pixmap conversion freeware (together with
\fIxv\fR, the colors for pixmap objects can be manipulated),
and \fIxgrabsc\fR, another freeware; also, \fIxloadimage\fR
can display XPM1 files.
Tools that can generate XPM3 format files are, for example,
\fIxsnap\fR and \fIsxpm\fR.
For each color specified in the color string, a color cell
is allocated.  If the allocation fails,
the current color will be used for that color string.
If the first color character is a back-quote (`) or a space, then
the corresponding color is substituted with the \fIbackground\fR
color of the tgif window if the Tgif*GuessXPmBgColor X default is
set to ``true''.  (This design choice is made because the pixmap will then
look ``right'' on both regular and reverse video.)
The following is an example of a very small pixmap file (in XPM1
format).
.PP
.DS
.RS
#define arrow_format 1
.br
#define arrow_width 5
.br
#define arrow_height 3
.br
#define arrow_ncolors 3
.br
#define arrow_chars_per_pixel 1
.br
static char *arrow_colors[] = {
.br
   "`", "Black",
   "a", "red",
   "b", "yellow"
.br
};
.br
static char *arrow_pixels[] = {
.br
"`a```",
.br
"aabbb",
.br
"`a```"
.br
};
.br
.RE
.DE
.SH LATEX FIGURE FORMATS
Here we show how to make a figure for a LaTeX file, first with
the \fI\\psfig\fR (or \fI\\epsf\fR) special construct, then with the
\fIpsfile\fR special construct.  (The author does not recommend
the \fIpsfile\fR construct.)  An example of both can be found
in ``example.tex'' which is included with the tgif distribution.
.PP
To print a tgif file to be included in a LaTeX document with
the \fI\\psfig\fR or \fI\\epsf\fR special construct
(files generated will be in the
\fIencapsulated PostScript\fR format), first
select LaTeX format in the panel window (click the left mouse
button on the laser printer icon), then type ^p to generate
the encapsulated PostScript file.
If the file name is ``an-sr-flip-flop.obj'',
then the LaTeX figure file generated will be named
``an-sr-flip-flop.eps''.  This file can be included in a LaTeX
document as follows,
.PP
.DS
.RS
\\input{psfig}
.br
\\begin{figure*}[htb]
.br
\\centerline{\\psfig{figure=an-sr-flip-flop.eps}}
.br
\\caption{An SR flip-flop.  \\label{fig:an-sr-flip-flop}}
.br
\\end{figure*}
.br
.RE
.DE
.br
.PP
An alternative way is to use the \fI\\epsf\fR construct as follows,
.PP
.DS
.RS
\\input{epsf}
.br
\\begin{figure*}[htb]
.br
\\centerline{\\epsffile{an-sr-flip-flop.eps}}
.br
\\caption{An SR flip-flop.  \\label{fig:an-sr-flip-flop}}
.br
\\end{figure*}
.br
.RE
.DE
.br
.PP
The \\centerline command above centers the picture.
If you have multiple tgif figures in your LaTeX document,
you only have to include the psfig macro (\\input{psfig} or \\input{epsf})
once, right after the \\begin{document} statement.
.PP
If encapsulated PostScript is not available, the \fIpsfile\fR
special construct can be used as described here.
In this case, since LaTeX doesn't not know where the bounding
box of the drawing is, it takes some practice to get this just right.
Here is something that seems to work.
First, center the picture
on the page (e.g., the width of a portrait style page is 8.5 inch, so the
center of the page is at the 4.25 inch mark),
and make the top object in the picture about 1/4 inch away from
the top of the page.
Select the LaTeX format in the panel window,
then print in the LaTeX format.
As with the \fIpsfig\fR construct, a file with the \fI.eps\fR
extension will be generated.
This file can be included in a LaTeX document as follows,
.PP
.DS
.RS
\\begin{figure*}[htb]
.br
\\special{psfile="an-sr-flip-flop.eps" hoffset=-40}
.br
\\rule{0in}{1.1in}
.br
\\caption{An SR flip-flop.  \\label{fig:an-sr-flip-flop}}
.br
\\end{figure*}
.br
.RE
.DE
.br
.PP
The \\rule{0in}{1.1in} above specifies an invisible box of 1.1 inches
high, which is the total height of the picture in an-sr-flip-flop.
.SH X DEFAULTS
.TP
.I Tgif*Geometry: WIDTHxHEIGHT+X+Y
.TP
.I Tgif*IconGeometry: +X+Y
.TP
.I Tgif*Foreground: COLORSTRING
.TP
.I Tgif*Background: COLORSTRING
.TP
.I Tgif*BorderColor: COLORSTRING
If not specified, the foreground color will be used.
.TP
.I Tgif*ReverseVideo: [on,off]
For black and white terminal, reverse video ``on'' means the background
is black.  For color terminal, reverse video ``on'' means the background
is specified by the Tgif*Foreground color.
.TP
.I Tgif*InitialFont: [Times,Courier,Helvetica,NewCentury,Symbol]
This specifies the initial font.
The default is Courier.
.TP
.I Tgif*InitialFontStyle: [Roman,Bold,Italic,BoldItalic]
This specifies the initial font style.
The default is Roman.
.TP
.I Tgif*InitialFontJust: [Left,Center,Right]
This specifies the initial font justification.
The default is Left.
.TP
.I Tgif*InitialFontDPI: [75,100]
This specifies the initial font DPI (dots-per-inch).
The default is 75.
.TP
.I Tgif*InitialFontSizeIndex: [0,1,2,3,4,5]
This specifies the initial size \fIindex\fR of the start-up font.
For the 75dpi font, the indices correspond to point sizes
8, 10, 12, 14, 18, and 24.
For the 100dpi font, the indices correspond to point sizes
11, 14, 17, 20, 25, 34.
The default is 4 (18 points) for the 75dpi font and 2 (17 points)
for the 100dpi font.
.TP
.I Tgif*MsgFontSizeIndex: [0,1,2,3,4,5]
This specifies the size \fIindex\fR of the font used for
messages and popup windows.  The meaning of the indices
is the same as for Tgif*InitialFontSizeIndex.
The default is 4 (18 points) for the 75dpi font and 2 (17 points)
for the 100dpi font.
.TP
.I Tgif*DefaultCursor: [x_cursor,arrow,...]
This specifies the select cursor.  Entries in <X11/cursorfont.h>
(without the XC_ prefix) are valid names of the cursor.
The default is arrow.
.TP
.I Tgif*DrawCursor: [x_cursor,arrow,...]
This specifies the cursor used when drawing objects.
Entries in <X11/cursorfont.h>
(without the XC_ prefix) are valid names of the cursor.
The default is the same as Tgif*DefaultCursor.
.TP
.I Tgif*DragCursor: [x_cursor,arrow,...]
This specifies the cursor used when dragging.
Entries in <X11/cursorfont.h>
(without the XC_ prefix) are valid names of the cursor.
The default is hand2.
.TP
.I Tgif*VertexCursor: [x_cursor,arrow,...]
This specifies the cursor used in the select vertices mode.
Entries in <X11/cursorfont.h>
(without the XC_ prefix) are valid names of the cursor.
The default is plus.
.TP
.I Tgif*RubberBandColor: COLORSTRING
This specifies color used for rubber-banding (XORing).
The default color is the same as the foreground color.
.TP
.I Tgif*PrintCommand: COMMAND
This specifies the print command used for printing the PostScript file.
The default is \fIlpr\fR.  An example would be
\fIlpr -h -Pprintername\fR.
.TP
.I Tgif*WhereToPrint: [Printer,EPS,PS,Bitmap]
This specifies the initial print destination/format.
The default is EPS.
.TP
.I Tgif*PrintDirectory: PATH
This specifies the print directory when the output destination
is not the printer.
The default is a null string, which means that the output goes
into the directory in which the current file resides.
.TP
.I Tgif*NoTgifIcon: [true,false]
If set to ``true'', tgif will not use its own icon window.
The default is false.
.TP
.I Tgif*DontShowVersion: [true,false]
If set to ``true'', the tgif version will not be displayed on top of the
tgif window.
The default is false.
.TP
.I Tgif*XBmReverseVideo: [true,false]
If set to ``true'', an invert bitmap operation will be performed
when importing an X Bitmap file.
The default is false.
.TP
.I Tgif*AskForXBmSpec: [true,false]
If set to ``true'', the user will be asked to specify
magnification and geometry for an X Bitmap file being imported.
Format of the specification is \fIMAG=WxH+X+Y\fR, where
MAG is the magnification, W and H specifies the width and height,
and the location specification can be +X+Y, +X-Y, -X+Y, and -X-Y.
The '=' is mandatory if any of the geometry information is
specified.
The default is false.
.TP
.I Tgif*AskForXPmSpec: [true,false]
If set to ``true'', the user will be asked to specify
magnification and geometry for an X Pixmap file being imported.
The format of the specification is the same as for AskForXBmSpec.
The default is false.
.TP
.I Tgif*StripEPSComments: [true,false]
If set to ``true'', lines that start with '%' in an encapsulated
PostScript file will be stripped when the file is imported (except
the first line of the file).
The default is true.
.TP
.I Tgif*GuessXPmBgColor: [true,false]
If set to ``true'', then when tgif imports an X Pixmap file
with the first color string being ' ' (the space character) or '`'
(the back quote character), it will treat the first color
as a \fIbackground\fR color.  This means that
the specified color in the X Pixmap file will be changed to
the current background color.
The default is false.  (Please note that this default was \fItrue\fR
before patch 2 of tgif-2.7.  This X default is there for compatibility
reasons; it should be considered obsolete.)
.TP
.I Tgif*XPmOutputVersion: NUMBER
This specifies the XPM version number when outputting in the X11 pixmap
format.  NUMBER can take on values 1 or 3.  The default is 1.
.TP
.I Tgif*XPmInXGrabSCFormat: [true,false]
If Tgif*XpmOutputVersion is set to 1, setting this to ``true'' will
force the X11 pixmap output to resemble what xgrabsc generates.
The default is false.
.TP
.I Tgif*UseGrayScale: [true,false]
If set to ``true'', gray scales will be used for tiling patterns
to speed up printing.
The default is false.
.TP
.I Tgif*AutoPanInEditText: [true,false]
If set to ``true'', auto panning will be used such that the text cursor
is always visible in text edit mode (except when the cursor is to the
left or on top of the paper).
This should probably be turned off on slow servers.
The default is true.
.TP
.I Tgif*PercentPrintReduction: NUMBER
The specifies the initial percent print reduction/magnification.
The default is 100.
.TP
.I Tgif*ConstrainedMove: [true,false]
This specifies the initial move mode.
When set to ``true'', moving or stretching an object will cause the
endpoints of all
polylines or open-splines, whose endpoints fall within the object,
and may be the neighboring vertices, to be moved.  Please see the
IDIOSYNCRASIES section for more details.
The default value is false.
.TP
.I Tgif*DoubleQuoteDoubleQuote: [true,false]
When set to ``true'', output of the double-quote character will be preceded
by a double-quote character; when set to false, output of the double-quote
character will be preceded by a back-slash character.
The default value is false.
.TP
.I Tgif*GridSystem: [English,Metric]
This sets the initial grid system.  The default is English.
.TP
.I Tgif*InitialGrid: NUMBER
This specifies the initial grid size.
For the English grid system, NUMBER can be -2, -1, 0, +1, or +2 for grid
sizes of 1/32, 1/16, 1/8, 1/4, and 1/2 inch.
For the Metric grid system, NUMBER can be -1, 0, +1, or +2 for grid
sizes of 1mm, 2mm, 5mm, and 1cm.
The default value is 0.
.TP
.I Tgif*DropObsIconAttrWhenUpdate: [true,false]
If set to ``true'', obsolete icon attributes will be dropped without
confirmation when the UpdateSymbols command is executed.  If set to ``false'',
a popup window will prompt the user to specify what to do
with the obsoleted icon attributes.
The default is false.
.TP
.I Tgif*UseRecentDupDistance: [true,false]
If set to ``true'', the most recent change in position produced by a combination
of a duplicate and a move command will be used for the new duplicate command.
Otherwise, some default distance will be used to position the duplicate.
The default is true.
.TP
.I Tgif*SplineTolerance: NUMBER
This specifies the tolerance of spline drawing.
The smaller the number, the smoother the spline.
The default is 9 (min is 3 and max is 13).
.TP
.I Tgif*SplineRubberband: [true,false]
If set to ``true'', spline rubberbands will be used
in drawing, moving, and stretching open and closed splines.
(This might not be desirable if the spline contains too many vertices.)
The default is true.
.TP
.I Tgif*Synchronize: [on,off]
XSynchronize is called if this default is set to ``on''.  The default is off.
.TP
.I Tgif*DoubleClickUnIconify: [true,false]
If set to ``true'', double mouse clicks are used to de-iconify
the icon window (in this mode, the icon window ignores single
mouse clicks and drags).
The default is false.
.TP
.I Tgif*MainMenuPinDistance: NUMBER
This specifies the horizontal distance (in pixels) the user needs to
drag a popup menu before the popup menu is to be pinned down.
The default is 80.  (If pinned popup menus are not desired, then this should
be set to a value greater than the screen width.)
Dragging the left mouse button can be used to move the pinned popup menu;
clicking the right button in the popup menu will remove it.
.TP
.I Tgif*DoubleClickInterval: NUMBER
This specifies the maximum interval (in milliseconds)
between two mouse clicked to be recognized as one double-click.
The default is 300.
.TP
.I Tgif*HandleSize: NUMBER
This specifies (half) the size of the handle used to highlight objects.
Its allowable value is between 2 and 6.
The default is 2.
.TP
.I Tgif*HistoryDepth: NUMBER
This specifies the size of the undo/redo buffer; negative values
mean that the buffer is unbounded.
The default is -1.
.TP
.I Tgif*SaveTmpOnReturn: [true,false]
If set to ``true'', a tmpmodel file will be saved automatically before
returning to the driver.  Otherwise, no files will be
saved automatically.
The default is true.
.TP
.I Tgif*ImportFromLibrary: [true,false]
If set to ``true'', the library directories specified by the
current domain are searched for .obj, xbitmap/xpixmap, and EPS files to
import.  Otherwise, the current directory will be used as the starting point.
The default is false.
.TP
.I Tgif*WarpToWinCenter: [true,false]
If set to ``true'', the pointer is warped to the center of popup
windows.  Otherwise, the pointer is not warped.
The default is true.
.TP
.I Tgif*SaveCommentsInSaveNew: [true,false]
If set to ``true'', "%%" type comments in the file will be stored in the
newly created file.
The default is true.
.TP
.I Tgif*CanvasWindowOnly: [true,false]
If set to ``true'', only the canvas window will be displayed (this is
kind of the ``demo'' mode).
The default is false.
.TP
.I Tgif*UsePsAdobeString: [true,false]
If set to ``true'', the first line in the PS or EPS file will be
"%!PS-Adobe-2.0 EPSF-1.2".  Otherwise, it is just "%!".
The default is false.  The PS-Adobe string might confuse Transcript,
but it is needed to work with groff.
.TP
.I Tgif*HalfToneBitmap: [true,false]
If set to ``true'', the Floyd-Steinberg half-tone method will be used
when printing in X11 bitmap format.  This is useful when the drawing
contains X11 pixmap objects.
The default is false.
.TP
.I Tgif*ThresholdBitmap: [true,false]
If set to ``true'', a simple thresholding method will be used to decide whether
a bit is turned on or off when printing in X11 bitmap format.
If Tgif*HalfToneBitmap is set to true, this X default is ignored.
The default is false.
.TP
.I Tgif*BitmapThreshold: NUMBER
This specifies the threshold value used in either the Floyd-Steinberg half-tone
algorithm or the simple thresholding algorithm.  NUMBER must be between 0 and 1.
This X default is only active
when either the Tgif*HalfToneBitmap or the Tgif*ThresholdBitmap
X default is set to true.
The default value is 0.5 if Tgif*HalfToneBitmap is true, and is 1.0
if Tgif*ThresholdBitmap is true
(basically, anything that is not white will be black).
.TP
.I Tgif*GroupedTextEditable: [true,false]
If set to ``false'', only top level text objects and attributes of top
level objects can be edited when the drawing mode is set to the text mode.
If set to ``true'', text objects and attributes everywhere can be edited.
The default is false.
.TP
.I Tgif*MaxColors: NUMBER
This specifies the maximum number of colors.  Color0 through ColorMax,
where Max is NUMBER-1, must all exist in X defaults.
.TP
.I Tgif*Color#: COLORSTRING
This specifies the correspondence between a color number and a color.
.TP
.I Tgif*DefaultColorIndex: NUMBER
This specifies the default color index if a certain color can not be found.
The default is 0.
.TP
.I Tgif*ShortCuts: ITEM1 ITEM2 ...
The ITEM specifies the correspondence between a key (may be case
sensitive) and a non-alphanumeric key command.  Please read
the SHORTCUTS section for details.
.TP
.I Tgif*MaxLineWidths: NUMBER
This specifies the maximum number of line widths.  LineWidth0 through
LineWidthMax, ArrowWidth0 through ArrowWidthMax, and ArrowHeight0
through ArrowHeightMax, where Max is NUMBER-1, all must exist in X defaults.
Some default values will be used for those that are
not specified in the X defaults.
The default is 7.
.TP
.I Tgif*DefaultLineWidth: NUMBER
This specifies the initial line width \fIindex\fR.
The default is 0.
.TP
.I Tgif*LineWidth#: NUMBER
This specifies a line width.
The default line widths are 1, 2, 3, 4, 5, 6, and 7.
.TP
.I Tgif*ArrowWidth#: NUMBER
This specifies the width (when the arrow is pointing horizontally)
of the arrow head for arc and open-spline objects.
The default arrow widths are 8, 10, 12, 14, 18, 20, and 22.
.TP
.I Tgif*ArrowHeight#: NUMBER
This specifies \fIhalf\fR the height (when the arrow is also pointing
horizontally) of the arrow head for arc and open-spline objects.
The default arrow heights are 3, 4, 5, 6, 7, 8, and 9.
.TP
.I Tgif*MaxDomains: NUMBER
This specifies the maximum number of domains.  Domain0 through DomainMax,
where Max is NUMBER-1, all must exist in X defaults.
.TP
.I Tgif*Domain#: DOMAINSTRING
This specifies the correspondence between a domain number and a domain name.
See the ENVIRONMENT VARIABLE
section to see how to specify a path associated
with a domain.
.TP
.I Tgif*DefaultDomain: NUMBER
This specifies the default domain when tgif starts up.
The default is 0.
.SH ENVIRONMENT VARIABLE
.TP
.I TGIFPATH
This environment variable should be set such that the files, mentioned in the
FILES section below, can be found.
.TP
.I TGIFICON
This environment variable should be set to the name of the object
file to be displayed when tgif is iconified.  By default, it is
set to ``tgificon''.
If it starts with a / character, absolute path is used; otherwise,
the icon file is assumed to be $TGIFPATH/$TGIFICON.
.TP
.I TGIF_[Domain]
For each \fIDomain\fR name defined in the X defaults, \fITGIF_Domain\fR
specifies a search path for the symbol files.  Each search path
should have the same format as the \fIPATH\fR csh environment variable.
(There is one exception.  If the Domain name is \fIExamples\fR, then
the environment variable \fITGIF_Examples\fR does not have to be set.
In this case, the compile flag TGIF_PATH will be used to take on
the value of TGIF_Examples.)
For example, to specify the symbol path for domain \fIDEFAULT\fR
to look for symbol files in the library directory /tmp/tgif/symbols,
the following csh command should be executed in the current directory.
.PP
.DS
.RS
.RS
setenv TGIF_DEFAULT /tmp/tgif/symbols:.
.br
.RE
.RE
.DE
.br
.SH FILES
$TGIFPATH/tgificon.obj contains the default tgif icon.
.br
.PP
$TGIFPATH/keys.obj contains a summary of the non-alphanumeric key
bindings.
.br
.SH PROLOG/C TESTDRIVE
In the tgif distribution, there are three Prolog files which illustrate
a simple Prolog driver.  \fItgif.pl\fR contains predicates for parsing
tgif files (both .obj and .sym).  \fIfrontend.pl\fR contains predicates
for talking to Prolog engines, such as that of Quintus and SISCtus,
through the foreign function interface.  To use frontend.pl,
\fIfrontend11.o\fR needs to be built (which requires the
\fIfrontend11.o\fR entry to be uncommented from the makefiles).
Finally, \fItestdrive.pl\fR contains a program which will print
out the ID files of all objects in the current drawing, if tgif
is escaped with the Solve() (or #s) command.  This is also
a good way of finding out the structure of a tgif file (especially
because the structure is not documented due to the complexity
introduced to keep tgif compatible with files created by older versions).
.PP
A very simple C driver, \fItestdrive.c\fR, is also provided with
the tgif distribution which
perform the same function as the Prolog driver.  The extra code present
in this file (and not present in tgif.c) is used to illustrate how
the in-memory objects and attributes can be traversed.
.SH SEE ALSO
\fBlatex\fR(1L), \fBlpr\fR(1), \fBenv\fR(1), \fBX\fR(1),
\fBdvips\fR(1), \fBcsh\fR(1), \fBpbmplus\fR(1), \fBbitmap\fR(1), \fBXPM\fR(1),
\fBxgrabsc\fR(1), \fBxloadimage\fR(1),
\fBxsnap\fR(1), \fBsxpm\fR(1), \fBxv\fR(1), \fBpstoepsi\fR(1)
.SH IDIOSYNCRASIES
When any of the ``escape to driver'' commands are (accidentally)
executed, the current content of the drawing is saved into
``tmpmodel.obj'' if the drawing indicates that it is a .obj file;
then tgif escapes to the driver and returns right away.
If the drawing indicates that it is a .sym file, then the content
is saved into ``tmpmodel.sym'', but tgif does not return to the driver.
.PP
The paste operation works on a cut buffer generated by tgif or by non-tgif
tools (such as \fIxterm\fR).
If the cut buffer is \fInot\fR generated by tgif, its content is treated as
a collection of
ASCII character strings, which is inserted into the current drawing
as a text object (current settings for text objects are used
to create the text object).
If the cut buffer \fIis\fR generated by tgif, then all the current
settings are ignored.
.PP
The font sizes are the \fIscreen\fR font sizes (which correspond to
the X fonts that are used to draw the text on the screen).
They appear smaller on the printout.
When a 24 point text is printed, it would correspond to about a 13.5 point
PostScript text.  This is because tgif treats 128 pixels as an inch, and
PostScript treats 72 points as an inch.
.PP
Because characters supported by X11 and PostScript are different,
not all the characters, especially in the range 128 to 255 (or \\200 to \\377),
which are supported by X11, but are not accepted
by tgif.  Furthermore, in order to print the supported subset
or these characters, character codes must be re-encoded.
Therefore, if one would like to hack tgif to support other personalized fonts,
one should be careful about the re-encoding mechanism.
.PP
The grids are not absolute; they are specified as screen
pixels, and they scale with the current zoom.  For example,
if the grid is set at 16 pixels at maximum zoom, and if the
user zooms out once, objects can be drawn, moved, or stretched
at 16 screen pixel increments, but this corresponds to 32 pixels in the real
coordinate system.
.PP
If the vertical text spacing is set to negative values, highlighted
text will look a little strange due to XOR operations.
If the vertical text spacing is set to be greater than 100 or less
than -100, the panel window will not be cleared properly; to clear
the panel window, the user may have to close the tgif window and then
open it again.
.PP
As described in the TGIF SUBWINDOWS section,
in constrained move mode, if both endpoints of a not-selected polyline
lie inside the object being moved, then the whole polyline is moved.
This may look strange sometimes because,
for example, if you start with a line segment pointing to an object,
just moving the object will caused the line segment to be ``stretched'';
however, if you eventually move the object so that the other endpoint
is also inside the object, any future movement of the object will cause
the whole line segment to move (instead of just moving the original
endpoint).  The moving of the vertex which is the neighbor of
a moved endpoint may also look strange at times.
At this point, one should switch to the unconstrained move mode.
.PP
Another idiosyncrasy with respect to the
constrained move is that right after duplicating
an object, the constrained move is disabled temporarily because it is
assumed that at this point the user would want to move the
new object to a desirable position, and only after this new object is
``settled down'', the constrained move will be re-enabled.  Settling
down is signified by doing something other than moving the new
object.
.PP
Locked objects can be deleted.
.SH BUGS
There seems to be a problem with printing Courier fonts with
a non-solid pen on the Apple LaserWriter.  (Printing single
character does seem to work fine.)
As pointed out by the PostScript reference
manual, Courier is a ``stroked font'', and it is usually ``difficult'' to
construct character paths for such types of fonts.
However, Courier fonts work fine with ghostscript and dxpsview.
It's not clear how this problem can be fixed.  The author
recommends avoiding Courier fonts when printing in color
if a non-solid pen is desired.
.PP
Arcs with arrow tips don't look very sharp (the tip is not pointed
as in open-splines with arrow tips).
.PP
At high magnifications, \fIstretching\fR arcs may cause anomalous
behavior due to round off errors.
.PP
Copying/pasting large objects might not work because tgif does
not use the ``selection'' mechanism (yet).
.PP
If and when tgif crashes, it will try to save the
current content of the drawing in a file called
``EmergencySave.obj'' (or ``EmergencySave.sym'' if the current
drawing specifies a symbol object).
Often, the drawing can be restored by loading the ``EmergencySave.obj'' file.
Nevertheless, if the cause of
the crash is that some objects are corrupted (due to programming
bugs), then the ``EmergencySave.obj'' file may also be corrupted.
.SH COPYRIGHT
Please see the ``Copyright'' file for details on the copyrights.
.PP
\fIPostScript\fR is a trademark of Adobe Systems Incorporated.
.SH AUTHOR
William Chia-Wei Cheng (william@cs.UCLA.edu)
