/* include file defining constants/macros for PM files.  Used by xvpm.c 
 */

/*
 * Copyright 1989, 1990, 1991 by the University of Pennsylvania
 *
 * Permission to use, copy, and distribute for non-commercial purposes,
 * is hereby granted without fee, providing that the above copyright
 * notice appear in all copies and that both the copyright notice and this
 * permission notice appear in supporting documentation.
 *
 * The software may be modified for your own purposes, but modified versions
 * may not be distributed.
 *
 * This software is provided "as is" without any express or implied warranty.
 */

#define	PM_MAGICNO	0x56494557		/* Hex for VIEW */
#define PM_MAXNELM	1024
#define PM_MAXNBAND	1024
#define PM_NOSHIFT	0
#define PM_SHIFT	1

#define	PM_A		0x8000
#define	PM_C		0x8001
#define	PM_S		0x8002
#define	PM_I		0x8004
#define PM_F		0xc004

#define PM_RED 0xff
#define PM_GREEN 0xff00
#define PM_BLUE 0xff0000
#define PM_ALPHA 0xff000000
#define PM_BW 0

#define	PM_CMAX		0xff
#define PM_SMAX		0x7fff
#define	PM_IMAX		0x7fffffff
#define PM_FMAX		1.7E38

#define PM_IOHDR_SIZE	(sizeof(pmpic)-(2*sizeof(char*)))

#define	pm_max(pm)	((pm)->pm_form == PM_C ? PM_CMAX :		  \
				(pm)->pm_form == PM_S ? PM_SMAX :	  \
					(pm)->pm_form == PM_I ? PM_IMAX : \
						 PM_FMAX)

#define pm_index(fm)	(((fm)&0xff)-(((fm)>>14)&01))
#define	pm_sel(fm,fn)	(*((fn)[pm_index(fm)]))
#define pm_iindex(a,nc,cr,cc)	((a)+((cr)*(nc))+(cc))
 
#define pm_nelm(p)	((p)->pm_ncol * (p)->pm_nrow)
#define pm_nbelm(p)	(pm_nelm(p) * (p)->pm_nband)
#define pm_psize(p)	(pm_nbelm(p) * (((p)->pm_form)&0xff))
#define pm_isize(p)	((p)->pm_np * pm_psize(p))
#define pm_npix(p)      (pm_nbelm(p) * (p)->pm_np)

#include <sys/types.h>

typedef struct {
	int	pm_id;		/* Magic number for pm format files.	*/
	int	pm_np;		/* Number of planes. Normally 1.	*/
	int	pm_nrow;	/* Number of rows. 1 - MAXNELM.		*/
	int	pm_ncol;	/* Number of columns. 1 - MAXNELM.	*/
	int	pm_nband;	/* Number of bands.			*/
	int	pm_form;	/* Pixel format.			*/
	int	pm_cmtsize;	/* Number comment bytes. Includes NULL. */
	char	*pm_image;	/* The image itself.			*/
	char	*pm_cmt;	/* Transforms performed.		*/
} pmpic;

typedef	struct {
	int	pm_x;		/* X Position. */
	int	pm_y;		/* Y Position. */
	int	pm_z;		/* Z Position. */
	float	pm_ux;		/* Uncertainty in x. */
	float	pm_uy;		/* Uncertainty in y. */
	float	pm_uz;		/* Uncertainty in z. */
} pmxyz;

#define	PM_EBASE	100
#define PM_EMALLOC	101
#define PM_EBADPARAM	102
#define PM_EBADPIC	103
#define PM_EBADFORM	104
#define PM_EBADMAGIC	105
#define PM_ENULLPIC	106    /* picture given was NULL */
#define PM_EBADPLANES   107  /* invalid # of planes chosen for format */
#define PM_EBADBANDS 	108 /* invalid # of bands chosen for format */
#define PM_EBADSIZE 	109 /* # of rows/cols and x offsets, y offsets
			   too big for ikonas */
#define PM_EBADCOLORS 	110 /* invalid number of colors chosen for format */
#define PM_EBADCOLORPLANE 111 /* invalid color plane entered */


#define PM_NERROR	12
#define PM_ERROR(e)	(((e) < PM_EBASE || (e) > (PM_EBASE + PM_NERROR)) ? \
				0 : (e) - PM_EBASE)
extern char	*pm_errmsg[];

pmpic	*pm_add();
pmpic	*pm_addcmt();
pmpic	*pm_alloc();
pmpic	*pm_and();
pmpic	*pm_bthresh();
pmpic	*pm_cast();
char	*pm_cmt();
pmpic	*pm_conv();
pmpic	*pm_ebadform();
int	pm_getcmt();
pmpic	*pm_ikrd();
pmpic	*pm_ikwr();
pmpic	*pm_neg();
pmpic	*pm_or();
pmpic	*pm_prep();
pmpic	*pm_rdhdr();
pmpic	*pm_read();
pmpic	*pm_scale();
pmpic	*pm_sub();
pmpic	*pm_thresh();
pmpic	*pm_write();

pmxyz	*pm_centroid();

