#include "pt.h"
#include "conio.h"

/* return 1 only if you see both buttons simultaneously down */
int pascal
/* XTAG:select */
select(w, cp, anchorRow, anchorCol, evhead)
	register struct window *w;
	long cp;
	int anchorRow, anchorCol, evhead;
{
	extern unsigned char msgBuffer[];
	extern unsigned char textBuffer[];
	extern struct window *selWindow;
	extern long selBegin, selEnd;
	extern int selMode;
	extern struct window *pendWindow;
	extern unsigned char scrMapReset;
	extern int debug;
	extern int scrRows;
	extern int doubleClickDelay;

	static int buttonDownTime = 0;
	int n, row1, row2, col1, col2, minRow, maxRow;
	long cpLine, cp2, cp3, sb, limit;

	/* determine the proper selection mode */
	if( selBegin<=cp && cp<=selEnd && evhead!=-1 && w==selWindow ) {
		row1 = n = GetTime();
		if( n < buttonDownTime )
			buttonDownTime -= 6000;
		n -= buttonDownTime;
		if( n < doubleClickDelay )
			selMode = (selMode+1) & 0x3;
		else
			selMode = SELCHAR;
		buttonDownTime = row1;
	} else {
		selMode = SELCHAR;
		/* remember the time the button went down */
		buttonDownTime = GetTime();
	}


	/* first erase the current selection */
	if( w != selWindow )
		eraseSelection();

	/* set the screen map for the visible parts of this window */
	setMap(w->row1, w->col1, w->row2, w->col2, 1, w->textColor);
	maskTop(w);

	/* for now do not reset the screenMap when you write a char */
	/* this avoids frequent recomputation of the screenMap */
	scrMapReset = 1;

	/* erase the selection if any part of it is in this window */
	/* otherwise it was erased by `eraseSelection()' above */
	if( w == selWindow 
	 && selBegin <= w->posBotline
	 && selEnd >= w->posTopline ) {
		sb = selBegin;
		selBegin = selEnd + 1;
		row1 = w->row1 + 1;
		col1 = w->col1 + 1;
		col2 = w->col2 - 1;
		if( selEnd <= w->posBotline )
			limit = selEnd + 1;
		else
			limit = w->posBotline;
		cp2 = w->posTopline;
		minRow = maxRow = -1;
		while( cp2 < limit ) {
			n = 1;
			cp3 = nextLine(w->fileId, cp2, &n);
			if( sb <= cp3 ) {
				cp3 = fillLine(w, cp2, row1, col1, col2);
				if( minRow == -1 )
					minRow = row1;
				maxRow = row1;
			}
			cp2 = cp3;
			++row1;
			if( row1 >= w->row2 || cp3 == -1 )
				break;
		}
		/* remember which rows on the screen to update */
		row1 = minRow;
		row2 = maxRow;
	} else {
		/* set these so no extra rows will be updated */
		row1 = scrRows;
		row2 = -1;
	}

	n = -1;
	cpLine = prevLine(w->fileId, cp, &n);

/* disable selecting the whole file for now */
if( selMode == SELALL )
	selMode = SELCHAR;

	/* Extend the selection as the selection mode requires */
	selWindow = w;
	modeExtend(w, cp, &selBegin, &selEnd);

	/* update the display */
	fillLine(w, cpLine, anchorRow, w->col1+1, w->col2-1);
	if( anchorRow < row1 || anchorRow > row2 )
		updateScreen( anchorRow, anchorRow);
	if( row1 <= row2 )
		updateScreen(row1, row2);

	/* as long as the button is down, follow the selection */
	if( evhead != -1 ) {	/* only "follow" for regular selections */
		n = followSelection(w, anchorRow, anchorCol, evhead, 0);
	}

	/* selecting the end of line should include both CR and LF */
	if( readChar(w->fileId, selBegin) == '\n' ) {
		if( readChar(w->fileId, --selBegin) != '\r' )
			++selBegin;
	}

	/* restore the correct screen map reset value  */
	scrMapReset = 0;
	return n;
}

void pascal
/* XTAG:eraseSelection */
eraseSelection()
{
	extern unsigned char msgBuffer[];
	extern struct window *selWindow;
	extern long selBegin, selEnd;

	int row1, col1, row2, col2, n;
	int minRow, maxRow;
	long sEnd, cp, cp2;

	/* remember selection and then nullify it */
	sEnd = selEnd;
	selEnd = selBegin - 1;

	if( selWindow == NULL )
		return;

	/* set up the screen mask for the selection window */
	row1 = selWindow->row1 + 1;
	col1 = selWindow->col1 + 1;
	row2 = selWindow->row2 - 1;
	col2 = selWindow->col2 - 1;
	setMap(row1, col1, row2, col2, 1, 0x07);
	maskTop(selWindow);

	cp = selWindow->posTopline;
	minRow = maxRow = -1;
	while( row1 <= row2 ) {
		if( cp > sEnd )
			break;
		n = 1;
		cp2 = nextLine(selWindow->fileId, cp, &n);
		if( selBegin <= cp2 ) {
			cp2 = fillLine(selWindow, cp, row1, col1, col2);
			if( minRow == -1 )
				minRow = row1;
			maxRow = row1;
		}
		if( cp2 == -1 )
			break;
		cp = cp2;
		++row1;
	}
	if( maxRow != -1 )
		updateScreen(minRow, maxRow);
	selEnd = sEnd;
}
