#include "pt.h"
#include "string.h"
#include "direct.h"

#define PATTERNSIZE 64

static unsigned char *endPattern;
static unsigned char *beginPattern;
static unsigned char filePatterns[PATTERNSIZE];
static unsigned char retFilename[PATTERNSIZE];
static int savedAttribute;
static int dirNameSize;

unsigned char * pascal
/* XTAG:findFirstPatternFile */
findFirstPatternFile(patterns, attribute, dta)
	unsigned char *patterns;
	int attribute;
	unsigned char *dta;
{
	unsigned char *fileName;
	unsigned char *endPrefix;
	int i;

	/* save patterns for later use in findNextPatternFile */
	strncpy(filePatterns, patterns, PATTERNSIZE);
	savedAttribute = attribute;
	beginPattern = filePatterns;

	/* see if this pattern has at least two components */
	endPattern = strchr(beginPattern, '|');
	
	/* find the path prefix and isolate the final pathname component */
	/* NOTE: this fails for full pathnames (starting with "\") */
	/* start looking at the end of the pathname */
	if( endPattern != NULL ) {
		*endPattern = '\0';
		endPrefix = endPattern - 1;
	} else
		endPrefix = beginPattern + strlen(filePatterns) - 1;

	/* look until you see a "\" or a ":" */
	for(  ; endPrefix >= beginPattern; --endPrefix)
		if( *endPrefix == ':' || *endPrefix == '\\' )
			break;
	dirNameSize = endPrefix - beginPattern + 1;

	/* start looking for matching file names */
	fileName = findFirstFile(beginPattern, savedAttribute, dta);
	
	/* skip "." */
	if( fileName == NULL || strcmp(&fileName[30], ".") == 0 )
		return findNextPatternFile(dta);

	/* else contruct the filename */
	for(i = 0; i < dirNameSize; ++i)
		retFilename[i] = beginPattern[i];
	retFilename[i] = '\0';
	strcat(retFilename, &fileName[30]);
	return retFilename;
}
	
unsigned char * pascal
/* XTAG:findNextPatternFile */
findNextPatternFile(dta)
	unsigned char *dta;
{
	unsigned char *fileName;
	unsigned char *endPrefix;
	register int i;

	/* find the next matching file name */
	fileName = findNextFile(dta);
	if( fileName != NULL )
		goto ret;

tryMorePatterns:
	/* see if this pattern has two or more components left */
	if( endPattern != NULL )
		*endPattern++ = '|';	/* restore pattern as it was */
	else	/* no more file patterns to expand */
		return NULL;

	/* next pattern begin where the last one ends */
	beginPattern = endPattern;
	endPattern = strchr(beginPattern, '|');
	if( endPattern != NULL ) {
		*endPattern = '\0';
		endPrefix = endPattern - 1;
	} else
		endPrefix = beginPattern + strlen(beginPattern) - 1;

	for(  ; endPrefix >= beginPattern; --endPrefix)
		if( *endPrefix == ':' || *endPrefix == '\\' )
			break;
	dirNameSize = endPrefix - beginPattern + 1;

	/* start looking for matching file names */
	fileName = findFirstFile(beginPattern, savedAttribute, dta);
	if( fileName == NULL )
		goto tryMorePatterns;

ret:
	/* else contruct the filename */
	for(i = 0; i < dirNameSize; ++i)
		retFilename[i] = beginPattern[i];
	retFilename[i] = '\0';
	strcat(retFilename, &fileName[30]);
	return retFilename;
}


unsigned char * pascal
/* XTAG:makeFullPathname */
makeFullPathname(origName)
	unsigned char *origName;
{
	extern unsigned char msgBuffer[];
	extern unsigned char scratchFileName[];

	int offset, n;
	register unsigned char *p;
	unsigned char *fromPtr, *toPtr, ch;

	/* figure out the complete pathname for the file */
	offset = 0;	/* offset into origName */

	/* first figure out what we have to do */
	if( origName[1] == ':' ) {
		if( origName[2] != '\\' && origName[2] != '/' ) {
			/* get the current directory on that drive */
			n = getDefaultDrive();	/* save default drive */
			(void)setDefaultDrive(toupper(origName[0])-'A');

			/* get the current directory on that drive */
			(void)getcwd(&msgBuffer[0], MSGBUFFERSIZE);

			/* restore the orignal defualt drive */
			(void)setDefaultDrive(n);

			/* skip the drive spec since getcwd gets it */
			offset = 2;
			goto fixDirectoryName;

		} else	/* name begins A:\ or something like it so */
			/* just use the string typed in */
			scratchFileName[0] = '\0';

	} else if( origName[0] == '\\' || origName[0] == '/' ) {
		/* add a drive identifier to the string typed in */
		scratchFileName[0] = (unsigned char)'A' + getDefaultDrive();
		scratchFileName[1] = ':';
		scratchFileName[2] = '\0';

	} else {	/* must prepend the current drive and directory */
		(void)getcwd(&msgBuffer[0], MSGBUFFERSIZE);
	fixDirectoryName:
		strcpy(scratchFileName, msgBuffer);
		n = strlen(scratchFileName);
		if( scratchFileName[n-1] != '\\' ) {
			scratchFileName[n++] = '\\';
			scratchFileName[n] = '\0';
		}
	}
	strncat(scratchFileName, &(origName[offset]), FILENAMESIZE);
	
	/* now eliminate any ".." components */
	p = &scratchFileName[0];
	while( *p != '\0' ) {
		/* look for a "\..\" */
		if( *p == '.' && *(p+1) == '.'
			&& *(p-1) == '\\' && *(p+2) == '\\' ) {
			/* find the previous path component */
			n = 2;
			while( 1 ) {
				if( (p-n) < &scratchFileName[0] )
					/* string is "component\..\ ..." */
					break;
				ch = *(p-n);
				if( ch == '\\' || ch == ':' )
					break;
				++n;
			}
			/* eliminate the "component\..\" by copying the */
			/* rest of the  string up n character positions */
			fromPtr = p + 3;
			/* *(p-n) is the last character to keep so: */
			toPtr = p - n + 1;
			/* move p to continue the scan at the beginning */
			/* of the moved part of the string */
			p = toPtr;
			while( 1 ) {
				*toPtr = *fromPtr++;
				if( *toPtr++ == '\0' )
					break;
			}
		} else
			++p;
	}

	return &scratchFileName[0];
}


struct window * pascal
/* XTAG:findFilenameWindow */
findFilenameWindow(filename)
	unsigned char *filename;
{
	extern struct window *windowList;
	extern struct openFile *files;

	register struct window *w;

	w = windowList;
	while( w != NULL ) {
		if( stricmp(files[w->fileId].origName, filename) == 0 )
			return w;
		w = w->nextWindow;
	}
	return NULL;
}


unsigned char * pascal
/* XTAG:findFirstFile */
findFirstFile(pattern, attribute, dta)
	unsigned char *pattern;
	int attribute;
	unsigned char *dta;
{
	extern union REGS rin, rout;

	/* set the disk tranfer address */
	rin.h.ah = 0x1A;
	rin.x.dx = (int)dta;
	intdos(&rin, &rout);
	
	/* start looking for matching file names */
	rin.h.ah = 0x4E;
	rin.x.cx = attribute;	/* search attribute */
	rin.x.dx = (int)pattern;
	intdos(&rin, &rout);

	if( (rout.x.cflag & 1) == 1 )
		return NULL;
	else
		return dta;
}

unsigned char * pascal
/* XTAG:findNextFile */
findNextFile(dta)
	unsigned char *dta;
{
	extern union REGS rin, rout;

	/* set the disk tranfer address */
	rin.h.ah = 0x1A;
	rin.x.dx = (int)dta;
	intdos(&rin, &rout);

	/* find the next matching file name */
	rin.h.ah = 0x4F;
	intdos(&rin, &rout);

	if( (rout.x.cflag & 1) == 1 )
		return NULL;
	else
		return dta;
}


int pascal
/* XTAG:findTag */
findTag(fn)
	int fn;
{
	extern struct window *selWindow;
	extern long selBegin, selEnd;
	extern int selMode;
	extern unsigned char msgBuffer[];
	extern unsigned char textBuffer[];
	extern unsigned char tagPattern[];
	extern unsigned char tagMarker[];
	extern unsigned char lastTag[STRINGSIZE];
	extern unsigned char tagDTA[64];
	extern long tagLastCp;
	extern int tagLastLine;
	extern int scrRows, scrCols;
	extern int menuLine;
	extern int ignoreCase;

	struct window *w;
	register unsigned char  *p;
	unsigned char tagString[STRINGSIZE], *filename, ch;
	int fileId, linesPassed, markerLength;
	long cp, fSize, startCp;
	int row1, row2, col1, col2;
	int ret, saveIgnoreCase, totalLinesPassed;

	/* get the string to search for */
	if( fn == FTAGSEL || fn == FCTAGSEL ) {
		getSelection(tagString);
	} else {	/* fn = FTAG || fn == FCTAG */
		filename = getInput("Tag name: ", lastTag, 0);
		if( filename == NULL ) {
			msg("Find tag cancelled", 1);
			ret = 2;
			goto doReturn;
		}
		strncpy(tagString, filename, STRINGSIZE);
	}

	/* adjust for ignoring case by forcing all lower case */
	if( ignoreCase != 0 ) {
		p = tagString;
		while( *p != '\0' ) {
			if( isupper(*p) )
				*p = tolower(*p);
			++p;
		}
	}

	saveIgnoreCase = ignoreCase;
	if( fn == FCTAG || fn == FCTAGSEL ) {
		fileId = getFileId("ptctags.lst");
		cp = searchSpans(fileId, 0L, fileSize(fileId), tagString,
			strlen(tagString), &linesPassed);
		cp += strlen(tagString) + 1;	/* +1 for the ':' */
		p = textBuffer;
		ch = 0;
		while( ch != '\r' ) {
			ch = readChar(fileId, cp++);
			if( ignoreCase && isupper(ch) )
				ch = tolower(ch);
			*p++ = ch;
		}
		*--p = '\0';	/* -- to backspace to the newline ('\r') */
		filename = textBuffer;
sprintf(msgBuffer, "name=<%s>", filename);
msg(msgBuffer, 1); incon();
		goto ctagsEntry;
	}

	/* search for XTAG is faster if it is case sensitive */
	ignoreCase = 0;
	ret = 1;
	if( strcmp(lastTag, tagString) == 0 ) {
		/* continue the last search */
	} else {
		/* new string, start searching again */
		tagLastCp = -1;
		strcpy(lastTag, tagString);
	}
	markerLength = strlen(tagMarker);

/* are we starting a new search? */
if( tagLastCp == -1 ) {
	filename = findFirstPatternFile( tagPattern, 0x1, tagDTA );
} else
	filename = retFilename;
while( filename != NULL ) {
	fileId = getFileId(filename);
	if( fileId == -1 ) {
		sprintf(msgBuffer, "Error in tag search: file %s not found",
			filename);
		msg(msgBuffer, 3);
		ret = 5;
		goto doReturn;
	}
	if( tagLastCp == -1 ) {
		startCp = 0L;
		totalLinesPassed = 0;
	} else {
		startCp = tagLastCp;
		totalLinesPassed = tagLastLine;
	}
	fSize = fileSize(fileId);
	sprintf(msgBuffer, "Searching %s for tag \"%s\"", filename,
								tagString);
	msg(msgBuffer, 1);
findNextMarker:
	cp = searchSpans(fileId, startCp, fSize, tagMarker, markerLength,
							&linesPassed);
	/* we found the tag marker, now is it the right tag? */
	if( cp != -1 ) {
		totalLinesPassed += linesPassed;
		cp += markerLength;
		startCp = cp;
		p = tagString;
		while( *p != '\0' ) {
			ch = readChar(fileId, cp++);
			if( saveIgnoreCase && isupper(ch) )
				ch = tolower(ch);
			if( *p++ != ch ) {
				startCp = cp;
				goto findNextMarker;
			}
		}
	}
ctagsEntry:
	closeFile(fileId, 2);
	if( cp != -1L ) {
		p = makeFullPathname(filename);
		w = findFilenameWindow(p);
		if( w != NULL ) {
			doTopWindow(w, 0);
		} else {
			if( 1 ) {
				row1 = row2 = (menuLine > 0 ? 1 : 0);
				col1 = col2 = 0;
			} else if(getBox(0, 0, &row1, &col1, &row2, &col2, 0)
					== 2 ) {
				msg("Tag window cancelled", 1);
				ret = 3;
				goto doReturn;
			}
	
			if( row1 == row2 && col1 == col2 ) {
				row2 = scrRows-1;
				if( menuLine < 0 )
					--row2;
				col2 = scrCols-1;
			}
			/* do not allow very small windows */
			if( row2 < row1+2 || col2 < col1+10 ) {
				msg("Size too small, no window created", 1);
				ret = 4;
				goto doReturn;
			}
			w = createWindow(filename, row1, col1, row2, col2,
				CRTOP, 0);
		}

		/* make the string we found the selection */
		if( selWindow != w ) {
			eraseSelection();
			selWindow = w;
		}
		selBegin = startCp;
		selEnd = cp - 1;
		selMode = SELCHAR;

		doGoto(w, totalLinesPassed);
		ret = 0;
		tagLastCp = cp;
		tagLastLine = totalLinesPassed;
		break;
	} else
		tagLastCp = -1;
	filename = findNextPatternFile(tagDTA);
}

	if( ret == 1 ) {
		sprintf(msgBuffer, "Tag \"%s\" not found in \"%s\" files",
			tagString, tagPattern);
		msg(msgBuffer, 1);
		tagLastCp = -1;
	}
doReturn:
	ignoreCase = saveIgnoreCase;
	return ret;
}


int pascal
/* XTAG:findKeyword */
findKeyword(fn)
	int fn;
{
	extern struct window *selWindow;
	extern long selBegin, selEnd;
	extern int selMode;
	extern unsigned char msgBuffer[];
	extern unsigned char tagPattern[];
	extern unsigned char lastKeyword[STRINGSIZE];
	extern unsigned char keywordDTA[64];
	extern long keywordLastCp;
	extern int keywordLastLine;
	extern int scrRows, scrCols;
	extern int menuLine;
	extern int ignoreCase;

	struct window *w;
	unsigned char keywordString[STRINGSIZE], *filename, *p;
	int fileId, linesPassed, keywordLength;
	long cp, fSize, startCp;
	int row1, row2, col1, col2;
	int ret, totalLinesPassed;

	/* get the string to search for */
	if( fn == FKEYWORDSEL) {
		getSelection(keywordString);
	} else {	/* fn = FTAG */
		filename = getInput("Keyword: ", lastKeyword, 0);
		if( filename == NULL ) {
			msg("Find keyword cancelled", 1);
			ret = 2;
			goto doReturn;
		}
		strncpy(keywordString, filename, STRINGSIZE);
	}

	/* adjust for ignoring case by forcing all lower case */
	if( ignoreCase != 0 ) {
		p = keywordString;
		while( *p != '\0' ) {
			if( isupper(*p) )
				*p = tolower(*p);
			++p;
		}
	}

	ret = 1;
	if( strcmp(lastKeyword, keywordString) == 0 ) {
		/* continue the last search */
	} else {
		/* new string, start searching again */
		keywordLastCp = -1;
		strcpy(lastKeyword, keywordString);
	}
	keywordLength = strlen(keywordString);

/* are we starting a new search? */
if( keywordLastCp == -1 ) {
	filename = findFirstPatternFile( tagPattern, 0x1, keywordDTA );
} else
	filename = retFilename;
while( filename != NULL ) {
	fileId = getFileId(filename);
	if( fileId == -1 ) {
		sprintf(msgBuffer,
			"Error in keyword search: file %s not found",
			filename);
		msg(msgBuffer, 3);
		ret = 5;
		goto doReturn;
	}
	if( keywordLastCp == -1 ) {
		startCp = 0L;
		totalLinesPassed = 0;
	} else {
		startCp = keywordLastCp;
		totalLinesPassed = keywordLastLine;
	}
	fSize = fileSize(fileId);
	sprintf(msgBuffer, "Searching %s for keyword \"%s\"", filename,
							keywordString);
	msg(msgBuffer, 1);
	cp = searchSpans(fileId, startCp, fSize, keywordString, keywordLength,
							&linesPassed);
	/* we found the keyword string */
	if( cp != -1 ) {
		totalLinesPassed += linesPassed;
		startCp = cp;
		cp += keywordLength;
	}
	closeFile(fileId, 2);
	if( cp != -1L ) {
		p = makeFullPathname(filename);
		w = findFilenameWindow(p);
		if( w != NULL ) {
			doTopWindow(w, 0);
		} else {
			if( 1 ) {
				row1 = row2 = (menuLine > 0 ? 1 : 0);
				col1 = col2 = 0;
			} else if(getBox(0, 0, &row1, &col1, &row2, &col2, 0)
					== 2 ) {
				msg("Keyword window cancelled", 1);
				ret = 3;
				goto doReturn;
			}
	
			if( row1 == row2 && col1 == col2 ) {
				row2 = scrRows-1;
				if( menuLine < 0 )
					--row2;
				col2 = scrCols-1;
			}
			/* do not allow very small windows */
			if( row2 < row1+2 || col2 < col1+10 ) {
				msg("Size too small, no window created", 1);
				ret = 4;
				goto doReturn;
			}
			w = createWindow(filename, row1, col1, row2, col2,
				CRTOP, 0);
		}

		/* make the string we found the selection */
		if( selWindow != w ) {
			eraseSelection();
			selWindow = w;
		}
		selBegin = startCp;
		selEnd = cp - 1;
		selMode = SELCHAR;

		doGoto(w, totalLinesPassed);
		ret = 0;
		keywordLastCp = cp;
		keywordLastLine = totalLinesPassed;
		break;
	} else
		keywordLastCp = -1;
	filename = findNextPatternFile(keywordDTA);
}

	if( ret == 1 ) {
		sprintf(msgBuffer, "Keyword \"%s\" not found in \"%s\" files",
			keywordString, tagPattern);
		msg(msgBuffer, 1);
		keywordLastCp = -1;
	}
doReturn:
	return ret;
}

void pascal
/* XTAG:justifyLines */
justifyLines()
{
	/* external declarations */
	extern struct window *selWindow;
	extern long selBegin, selEnd;
	extern int selMode;
	extern int rightMargin;
	extern int tabWidth;
	extern int debug;

	long cp, selFirst, selLast;
	int fileId, n, col;
	unsigned char ch, lastCh;

	selMode = SELCHAR;
	fileId = selWindow->fileId;
	n = -1;
	selFirst = prevLine(fileId, selBegin, &n);
	selBegin = selFirst;
	n = 1;
	selLast = nextLine(fileId, selEnd, &n);
	col = 0;
	lastCh = 0;
	while( 1 ) {
		ch = readChar(fileId, selBegin);
		if( ch == '\r' ) {
			ch = readChar(fileId, selBegin + 1);
			if( ch == '\n' ) {
				/* replace the CRLF with a space */
				selEnd = selBegin + 1;
				deleteChars(fileId, 0, 0);
				insertChar(' ');
				/* point selBegin to the new ' ' */
				--selBegin;
				--selLast;
				ch = ' ';
			} else
				ch = '\r';
		}
		if( col >= rightMargin ) {
			cp = selBegin;
			while( ch != ' ' && ch != '\n' && ch != '\t' )
				ch = readChar(fileId, --cp);
			if( ch == ' ' || ch == '\t' ) {
				selEnd = selBegin = cp;
				deleteChars(fileId, 0, 0);
				insertChar('\r');
				insertChar('\n');
				/* selLast -1 (for ' ') +2 (for CRLF) */
				++selLast;
			}
			/* else NL is already in place */
			col = 0;
			lastCh = '\n';
		} else {
			if( ch == '\t' ) {
				if( (n = (col % tabWidth)) == 0 )
					n = tabWidth;
				col += n;
			} else
				++col;
			++selBegin;
			lastCh = ch;
		}
		if( selBegin >= selLast )
			break;
	}
	/* see how many spaces and tabs are at the end */
	/* selEnd remembers the end of the string of spaces and tabs */
	selEnd = --selBegin;
	/* loop through the spaces and tabs */
	while( 1 ) {
		ch = readChar(fileId, selBegin);
		if( ch != ' ' && ch != '\t' )
			break;
		--selBegin;
	}
	/* (selBegin went one too far) */
	/* if we found some spaces, then delete them */
	if( ++selBegin <= selEnd ) {
		selLast -= (selEnd - selBegin + 1);
		deleteChars(fileId, 0, 0);
	}
	if( lastCh != '\n' ) {
		insertChar('\r');
		insertChar('\n');
		selLast += 2;
	}
	selBegin = selFirst;
	selEnd = selLast - 1;
	redrawBox(selWindow->row1, selWindow->col1,
		selWindow->row2, selWindow->col2);
	updateScreen(selWindow->row1, selWindow->row2);
}
